package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

import com.liveperson.infra.log.LPLog;

/**
 * Created by shayl on 7/22/2015.
 */
public class MessagesTable implements BaseTable {

    private static final String TAG = "MessagesTable";

    //Messages table name
    public static final String MESSAGES_TABLE = "messages";

    //Messages table columns
    public static final String KEY_SERVER_SEQUENCE = "serverSequence";
    public static final String KEY_TEXT = "text";
    public static final String KEY_METADATA = "metadata";
    public static final String KEY_CONTENT_TYPE = "contentType";
    public static final String KEY_STATUS = "status";
    public static final String KEY_DIALOG_ID = "dialogId";
    public static final String KEY_MESSAGE_TYPE = "type";
    public static final String KEY_TIMESTAMP = "timeStamp";
    public static final String KEY_ORIGINATOR_ID = "originatorId";
    public static final String KEY_EVENT_ID = "eventId";
    public static final String KEY_ENCRYPTION_VERSION = "encryptVer";
    public static final String ENCRYPTION_VERSION_CURSOR_AS_VALUE = "message_encryptVer";

	@Override
	public String getName() {
		return TAG;
	}

	@Override
	public String getTableName() {
		return MESSAGES_TABLE;
	}

	@Override
    public String getCreateCommand() {
		return "create table " + MESSAGES_TABLE + "(" +
				KEY_ID + " integer primary key autoincrement," +
				KEY_EVENT_ID + " text UNIQUE," +
				KEY_SERVER_SEQUENCE + " integer," +
				KEY_DIALOG_ID + " text," +
				KEY_TEXT + " text not null," +
				KEY_CONTENT_TYPE + " text not null," +
				KEY_MESSAGE_TYPE + " integer not null," +
				KEY_STATUS + " integer not null," +
				KEY_ORIGINATOR_ID + " text," +
				KEY_TIMESTAMP + " big int not null," +
				KEY_ENCRYPTION_VERSION + " integer not null," +
				KEY_METADATA + " text" +
				");";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		if (oldVersion < 6) {
			long startTime = System.currentTimeMillis();
			String tempTableName = "messagesOld";
			//rename exists table to <tempTableName>
			db.execSQL("ALTER TABLE " + MESSAGES_TABLE + " RENAME TO " + tempTableName);
			//create msg table
			db.execSQL(getCreateCommand());

			//copy from old to new
			db.execSQL("insert into " + MESSAGES_TABLE +
					" (" + KEY_EVENT_ID +
					", " + KEY_SERVER_SEQUENCE +
					", " + KEY_DIALOG_ID +
					", " + KEY_TEXT +
					", " + KEY_CONTENT_TYPE +
					", " + KEY_MESSAGE_TYPE +
					", " + KEY_STATUS +
					", " + KEY_ORIGINATOR_ID +
					", " + KEY_TIMESTAMP +
					", " + KEY_ENCRYPTION_VERSION +
					") " +
					"select cast(" + KEY_ID + " as text) " +
					", " + KEY_SERVER_SEQUENCE +
					", convID" +
					", " + KEY_TEXT +
					", " + KEY_CONTENT_TYPE +
					", " + KEY_MESSAGE_TYPE +
					", " + KEY_STATUS +
					", " + KEY_ORIGINATOR_ID +
					", " + KEY_TIMESTAMP +
					", " + KEY_ENCRYPTION_VERSION +
					" from " + tempTableName);

			//remove old
			db.execSQL("DROP TABLE " + tempTableName);

			LPLog.INSTANCE.d(TAG, "Finished upgrading Messages table total time = " + (System.currentTimeMillis() - startTime));
		}

		if (oldVersion < 7) {
			db.execSQL("alter table " + MESSAGES_TABLE +
					" add " + KEY_METADATA +
					" text");
		}
	}
}
