package com.liveperson.infra.utils

import java.io.PrintWriter
import java.io.StringWriter

/**
 * Utility class containing methods that assist in dealing with Exceptions.
 */
object ExceptionUtils {

	/**
	 * Gets a String containing the Message and all lines of a Stack Trace from an
	 * Exception.
	 * @param exception The Exception containing a stack trace you want printed.
	 * @return A String printout of the stack trace information.
	 */
	fun getStringStackTrace(exception: Throwable): String {
		val traceWriter = StringWriter()
		traceWriter.write("\n")
		exception.printStackTrace(PrintWriter(traceWriter))
		return traceWriter.toString()
	}
}
