/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.liveperson.infra.utils.picasso.Picasso;
import com.liveperson.infra.utils.picasso.Request;
import com.liveperson.infra.utils.picasso.RequestHandler;
import com.liveperson.infra.utils.picasso.Utils;
import java.io.IOException;

class ResourceRequestHandler
extends RequestHandler {
    private final Context context;

    ResourceRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request data) {
        if (data.resourceId != 0) {
            return true;
        }
        return "android.resource".equals(data.uri.getScheme());
    }

    @Override
    public RequestHandler.Result load(Request request, int networkPolicy) throws IOException {
        Resources res = Utils.getResources(this.context, request);
        int id = Utils.getResourceId(res, request);
        return new RequestHandler.Result(ResourceRequestHandler.decodeResource(res, id, request), Picasso.LoadedFrom.DISK);
    }

    private static Bitmap decodeResource(Resources resources, int id, Request data) {
        BitmapFactory.Options options = ResourceRequestHandler.createBitmapOptions(data);
        if (ResourceRequestHandler.requiresInSampleSize(options)) {
            BitmapFactory.decodeResource((Resources)resources, (int)id, (BitmapFactory.Options)options);
            ResourceRequestHandler.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)id, (BitmapFactory.Options)options);
    }
}

