package com.liveperson.infra.log

import android.util.Log

/**
 * Implementation of a Logger that posts everything to the Android System Logs.
 * Default implementation that should be used in all production use-cases.
 * Cannot be used in unit tests.
 */
class AndroidLoggingDelegate : LoggingDelegate {

	override fun v(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			Log.v(tag, message, exception)
		} else {
			Log.v(tag, message)
		}
	}

	override fun d(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			Log.d(tag, message, exception)
		} else {
			Log.d(tag, message)
		}
	}

	override fun i(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			Log.i(tag, message, exception)
		} else {
			Log.i(tag, message)
		}
	}

	override fun w(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			Log.w(tag, message, exception)
		} else {
			Log.w(tag, message)
		}
	}

	override fun e(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			Log.e(tag, message, exception)
		} else {
			Log.e(tag, message)
		}
	}

	override fun wtf(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			Log.wtf(tag, message, exception)
		} else {
			Log.wtf(tag, message)
		}
	}
}
