/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.utils.ClockUtils;

public class PushMessage
implements Parcelable {
    private String mBrandId;
    private String mMessage;
    private String mFrom;
    private String mConversationId;
    private String mBackendService;
    private String mCollapseKey;
    private int mCurrentUnreadMessagesCounter = -1;
    private String id;
    private Long lookBackPeriod = -1L;
    private Long timeCreated;
    private String agentPid;
    private String transactionId;
    private CampaignInfo campaignInfo;
    public static final Parcelable.Creator<PushMessage> CREATOR = new Parcelable.Creator<PushMessage>(){

        public PushMessage createFromParcel(Parcel in) {
            return new PushMessage(in);
        }

        public PushMessage[] newArray(int size) {
            return new PushMessage[size];
        }
    };

    public PushMessage(String brandId, String from, String message) {
        this.mBrandId = brandId;
        this.mFrom = from;
        this.mMessage = message;
        this.timeCreated = System.currentTimeMillis();
        this.id = String.valueOf(this.timeCreated);
    }

    private PushMessage(Parcel in) {
        this.mBrandId = in.readString();
        this.mFrom = in.readString();
        this.mMessage = in.readString();
        this.id = in.readString();
        this.timeCreated = in.readLong();
        this.lookBackPeriod = in.readLong();
        this.campaignInfo = (CampaignInfo)in.readParcelable(CampaignInfo.class.getClassLoader());
    }

    public String getFrom() {
        return this.mFrom;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public String getBrandId() {
        return this.mBrandId;
    }

    public String getConversationId() {
        return this.mConversationId;
    }

    public void setConversationId(String mConversationId) {
        this.mConversationId = mConversationId;
    }

    public String getBackendService() {
        return this.mBackendService;
    }

    public void setBackendService(String mBackendService) {
        this.mBackendService = mBackendService;
    }

    public String getCollapseKey() {
        return this.mCollapseKey;
    }

    public void setCollapseKey(String mCollapseKey) {
        this.mCollapseKey = mCollapseKey;
    }

    public void setCampaignInfo(CampaignInfo campaignInfo) {
        this.campaignInfo = campaignInfo;
    }

    public String getPushMessageId() {
        return this.id;
    }

    public void setPushMessageId(String msgId) {
        this.id = msgId;
    }

    public void setTimeCreated(Long time) {
        this.timeCreated = time;
    }

    public Long getTimeCreated() {
        return this.timeCreated;
    }

    public void setLookBackPeriod(Long period) {
        this.lookBackPeriod = period;
    }

    public Long getLookBackPeriod() {
        return this.lookBackPeriod;
    }

    public String getAgentPid() {
        return this.agentPid;
    }

    public void setAgentPid(String agentPid) {
        this.agentPid = agentPid;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public CampaignInfo getCampaignInfo() {
        return this.campaignInfo;
    }

    public boolean isExpired() {
        if (this.lookBackPeriod == -1L) {
            return false;
        }
        return ClockUtils.getSyncedTimestamp() - this.timeCreated > this.lookBackPeriod;
    }

    public String toString() {
        return "mBrandId: " + this.mBrandId + " from: " + this.mFrom + " Message: " + this.mMessage + " convId: " + this.mConversationId + " mCollapseKey: " + this.mCollapseKey + " mBackendService: " + this.mBackendService;
    }

    public int getCurrentUnreadMessagesCounter() {
        return this.mCurrentUnreadMessagesCounter;
    }

    public void setCurrentUnreadMessagesCounter(int currentUnreadMessagesCounter) {
        this.mCurrentUnreadMessagesCounter = currentUnreadMessagesCounter;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mBrandId);
        dest.writeString(this.mFrom);
        dest.writeString(this.mMessage);
        dest.writeString(this.id);
        dest.writeLong(this.timeCreated.longValue());
        dest.writeLong(this.lookBackPeriod.longValue());
        dest.writeParcelable((Parcelable)this.campaignInfo, flags);
    }
}

