/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.PushMessage;
import com.liveperson.infra.utils.EncryptionVersion;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u001aJ\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0016\u0010 \u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004J \u0010\"\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0010\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0018\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0018\u0010*\u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\b\u0010+\u001a\u0004\u0018\u00010\u0004J\b\u0010,\u001a\u0004\u0018\u00010\u0004J\u0006\u0010-\u001a\u00020\u0004J\u001a\u0010.\u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u00105\u001a\u00020)J\u0018\u00106\u001a\u00020\u001a2\b\u00107\u001a\u0004\u0018\u00010\u00042\u0006\u00108\u001a\u000203J\u000e\u00109\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u0004J\u0010\u0010;\u001a\u00020\u001a2\b\u0010<\u001a\u0004\u0018\u00010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/liveperson/infra/preferences/PushMessagePreferences;", "", "()V", "KEY_AGENT_NAME", "", "KEY_AGENT_PID", "KEY_ALL_IDS", "KEY_BACKEND_SERVICE", "KEY_CLICKED_NOTIFICATION_ID", "KEY_COLLAPSE_KEY", "KEY_CONVERSATION_ID", "KEY_ID", "KEY_IS_OUTBOUND_CAMPAIGN", "KEY_IS_PUSH_NOTIFICATION_CLICKED", "KEY_LE_CAMPAIGN_ID", "KEY_LE_ENGAGEMENT_ID", "KEY_LOOK_BACK_PERIOD", "KEY_MESSAGE", "KEY_PUSH_TYPE", "KEY_TIME_CREATED", "KEY_TRANSACTION_ID", "LP_PUSH_MESSAGE_SHARED_PREF_FILENAME", "TAG", "preferences", "Landroid/content/SharedPreferences;", "addIdToSet", "", "id", "brandId", "cleanUp", "clearAll", "clearExpiredPushMessages", "clearPushMessage", "messageId", "generateKey", "msgId", "key", "getAllIds", "", "getBackendService", "getCachedPushMessage", "Lcom/liveperson/infra/model/PushMessage;", "getCachedPushWelcomeMessage", "getClickedNotificationId", "getLatestNotificationId", "getPushPlatform", "getTransactionId", "init", "applicationContext", "Landroid/content/Context;", "isPushNotificationClicked", "", "setCachedPushMessage", "pushMessage", "setPushMessageClicked", "pushMessageId", "isClicked", "setPushPlatform", "pushType", "setSharedPreferencesDelegate", "preferencesDelegate", "infra_release"})
public final class PushMessagePreferences {
    private static final String TAG = "PushMessagePreferences";
    private static final String KEY_ID = "id";
    private static final String KEY_ALL_IDS = "all_ids";
    private static final String KEY_TIME_CREATED = "time_created";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_AGENT_NAME = "agentName";
    private static final String KEY_BACKEND_SERVICE = "backendService";
    private static final String KEY_COLLAPSE_KEY = "collapse_key";
    private static final String KEY_CONVERSATION_ID = "conversationId";
    private static final String KEY_LE_ENGAGEMENT_ID = "leEngagementId";
    private static final String KEY_LE_CAMPAIGN_ID = "leCampaignId";
    private static final String KEY_IS_OUTBOUND_CAMPAIGN = "isOutboundCampaign";
    private static final String KEY_LOOK_BACK_PERIOD = "lookBackPeriod";
    private static final String KEY_AGENT_PID = "agentPid";
    private static final String KEY_TRANSACTION_ID = "transactionId";
    private static final String LP_PUSH_MESSAGE_SHARED_PREF_FILENAME = "lp_push_message_shared_pref";
    private static final String KEY_IS_PUSH_NOTIFICATION_CLICKED = "is_push_notification_clicked";
    private static final String KEY_CLICKED_NOTIFICATION_ID = "clicked_notification_id";
    private static final String KEY_PUSH_TYPE = "key_push_type";
    private static SharedPreferences preferences;
    public static final PushMessagePreferences INSTANCE;

    public final void init(@NotNull Context applicationContext) {
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        if (preferences == null) {
            preferences = applicationContext.getSharedPreferences(LP_PUSH_MESSAGE_SHARED_PREF_FILENAME, 0);
        }
    }

    public final void setCachedPushMessage(@NotNull String brandId, @NotNull PushMessage pushMessage) {
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        Intrinsics.checkParameterIsNotNull((Object)pushMessage, (String)"pushMessage");
        if (preferences == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000151, "setCachedPushMessage: PushMessage preferences is not initialized");
            return;
        }
        SharedPreferences sharedPreferences = preferences;
        SharedPreferences.Editor editor = sharedPreferences != null ? sharedPreferences.edit() : null;
        String messageId = pushMessage.getPushMessageId();
        SharedPreferences.Editor editor2 = editor;
        if (editor2 != null) {
            String string2 = messageId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"messageId");
            editor2.putString(this.generateKey(brandId, string2, KEY_ID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, messageId));
        }
        SharedPreferences.Editor editor3 = editor;
        if (editor3 != null) {
            String string3 = messageId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"messageId");
            String string4 = this.generateKey(brandId, string3, KEY_TIME_CREATED);
            Long l = pushMessage.getTimeCreated();
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"pushMessage.timeCreated");
            editor3.putLong(string4, l.longValue());
        }
        SharedPreferences.Editor editor4 = editor;
        if (editor4 != null) {
            String string5 = messageId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"messageId");
            editor4.putString(this.generateKey(brandId, string5, KEY_COLLAPSE_KEY), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getCollapseKey()));
        }
        SharedPreferences.Editor editor5 = editor;
        if (editor5 != null) {
            String string6 = messageId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"messageId");
            editor5.putString(this.generateKey(brandId, string6, KEY_CONVERSATION_ID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getConversationId()));
        }
        SharedPreferences.Editor editor6 = editor;
        if (editor6 != null) {
            String string7 = messageId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"messageId");
            editor6.putString(this.generateKey(brandId, string7, KEY_MESSAGE), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getMessage()));
        }
        SharedPreferences.Editor editor7 = editor;
        if (editor7 != null) {
            String string8 = messageId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"messageId");
            editor7.putString(this.generateKey(brandId, string8, KEY_BACKEND_SERVICE), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getBackendService()));
        }
        SharedPreferences.Editor editor8 = editor;
        if (editor8 != null) {
            String string9 = messageId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"messageId");
            editor8.putString(this.generateKey(brandId, string9, KEY_AGENT_NAME), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getFrom()));
        }
        SharedPreferences.Editor editor9 = editor;
        if (editor9 != null) {
            String string10 = messageId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"messageId");
            editor9.putString(this.generateKey(brandId, string10, KEY_AGENT_PID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getAgentPid()));
        }
        SharedPreferences.Editor editor10 = editor;
        if (editor10 != null) {
            String string11 = messageId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"messageId");
            editor10.putString(this.generateKey(brandId, string11, KEY_TRANSACTION_ID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getTransactionId()));
        }
        if (pushMessage.getCampaignInfo() != null) {
            SharedPreferences.Editor editor11 = editor;
            if (editor11 != null) {
                String string12 = messageId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"messageId");
                String string13 = this.generateKey(brandId, string12, KEY_LE_ENGAGEMENT_ID);
                CampaignInfo campaignInfo = pushMessage.getCampaignInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)campaignInfo, (String)"pushMessage.campaignInfo");
                editor11.putString(string13, DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, String.valueOf(campaignInfo.getEngagementId())));
            }
            SharedPreferences.Editor editor12 = editor;
            if (editor12 != null) {
                String string14 = messageId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"messageId");
                String string15 = this.generateKey(brandId, string14, KEY_LE_CAMPAIGN_ID);
                CampaignInfo campaignInfo = pushMessage.getCampaignInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)campaignInfo, (String)"pushMessage.campaignInfo");
                editor12.putString(string15, DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, String.valueOf(campaignInfo.getCampaignId())));
            }
            SharedPreferences.Editor editor13 = editor;
            if (editor13 != null) {
                String string16 = messageId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"messageId");
                String string17 = this.generateKey(brandId, string16, KEY_IS_OUTBOUND_CAMPAIGN);
                CampaignInfo campaignInfo = pushMessage.getCampaignInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)campaignInfo, (String)"pushMessage.campaignInfo");
                editor13.putBoolean(string17, campaignInfo.isOutboundCampaign());
            }
            SharedPreferences.Editor editor14 = editor;
            if (editor14 != null) {
                String string18 = messageId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"messageId");
                String string19 = this.generateKey(brandId, string18, KEY_LOOK_BACK_PERIOD);
                Long l = pushMessage.getLookBackPeriod();
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"pushMessage.lookBackPeriod");
                editor14.putLong(string19, l.longValue());
            }
        }
        SharedPreferences.Editor editor15 = editor;
        if (editor15 != null) {
            editor15.apply();
        }
        String string20 = messageId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string20, (String)"messageId");
        this.addIdToSet(string20, brandId);
    }

    @Nullable
    public final PushMessage getCachedPushMessage(@NotNull String messageId, @NotNull String brandId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        if (preferences == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000151, "getCachedPushMessage: PushMessage preferences is not initialized");
            return null;
        }
        PushMessage pushMessage = null;
        SharedPreferences sharedPreferences = preferences;
        String message = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences != null ? sharedPreferences.getString(this.generateKey(brandId, messageId, KEY_MESSAGE), "") : null);
        CharSequence charSequence = message;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            SharedPreferences sharedPreferences2 = preferences;
            String agentName = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences2 != null ? sharedPreferences2.getString(this.generateKey(brandId, messageId, KEY_AGENT_NAME), "") : null);
            pushMessage = new PushMessage(brandId, agentName, message);
            SharedPreferences sharedPreferences3 = preferences;
            pushMessage.setBackendService(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences3 != null ? sharedPreferences3.getString(this.generateKey(brandId, messageId, KEY_BACKEND_SERVICE), "") : null));
            SharedPreferences sharedPreferences4 = preferences;
            pushMessage.setPushMessageId(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences4 != null ? sharedPreferences4.getString(this.generateKey(brandId, messageId, KEY_ID), "") : null));
            SharedPreferences sharedPreferences5 = preferences;
            pushMessage.setTimeCreated(sharedPreferences5 != null ? Long.valueOf(sharedPreferences5.getLong(this.generateKey(brandId, messageId, KEY_TIME_CREATED), 0L)) : null);
            SharedPreferences sharedPreferences6 = preferences;
            pushMessage.setCollapseKey(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences6 != null ? sharedPreferences6.getString(this.generateKey(brandId, messageId, KEY_COLLAPSE_KEY), "") : null));
            SharedPreferences sharedPreferences7 = preferences;
            pushMessage.setConversationId(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences7 != null ? sharedPreferences7.getString(this.generateKey(brandId, messageId, KEY_CONVERSATION_ID), "") : null));
            SharedPreferences sharedPreferences8 = preferences;
            pushMessage.setLookBackPeriod(sharedPreferences8 != null ? Long.valueOf(sharedPreferences8.getLong(this.generateKey(brandId, messageId, KEY_LOOK_BACK_PERIOD), -1L)) : null);
            SharedPreferences sharedPreferences9 = preferences;
            pushMessage.setAgentPid(sharedPreferences9 != null ? sharedPreferences9.getString(this.generateKey(brandId, messageId, KEY_AGENT_PID), "") : null);
            SharedPreferences sharedPreferences10 = preferences;
            pushMessage.setTransactionId(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences10 != null ? sharedPreferences10.getString(this.generateKey(brandId, messageId, KEY_TRANSACTION_ID), "") : null));
            SharedPreferences sharedPreferences11 = preferences;
            String campaignId = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences11 != null ? sharedPreferences11.getString(this.generateKey(brandId, messageId, KEY_LE_CAMPAIGN_ID), "") : null);
            SharedPreferences sharedPreferences12 = preferences;
            String engagementId = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences12 != null ? sharedPreferences12.getString(this.generateKey(brandId, messageId, KEY_LE_ENGAGEMENT_ID), "") : null);
            SharedPreferences sharedPreferences13 = preferences;
            Boolean bl3 = sharedPreferences13 != null ? Boolean.valueOf(sharedPreferences13.getBoolean(this.generateKey(brandId, messageId, KEY_IS_OUTBOUND_CAMPAIGN), false)) : null;
            if (bl3 == null) {
                Intrinsics.throwNpe();
            }
            boolean isOutboundCampaign = bl3;
            String string2 = campaignId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"campaignId");
            String string3 = string2;
            PushMessage pushMessage2 = pushMessage;
            boolean bl4 = false;
            long l = Long.parseLong(string3);
            Long l2 = l;
            String string4 = engagementId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"engagementId");
            string3 = string4;
            Long l3 = l2;
            bl4 = false;
            long l4 = Long.parseLong(string3);
            boolean bl5 = isOutboundCampaign;
            Long l5 = l4;
            Long l6 = l3;
            pushMessage2.setCampaignInfo(new CampaignInfo(l6, l5, bl5));
        }
        return pushMessage;
    }

    @NotNull
    public final String getCachedPushWelcomeMessage(@Nullable String messageId, @NotNull String brandId) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        EncryptionVersion encryptionVersion = EncryptionVersion.VERSION_1;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences != null) {
            String string3;
            String string4 = messageId;
            if (string4 != null) {
                String string5 = string4;
                SharedPreferences sharedPreferences2 = sharedPreferences;
                EncryptionVersion encryptionVersion2 = encryptionVersion;
                boolean bl = false;
                boolean bl2 = false;
                String it = string5;
                boolean bl3 = false;
                String string6 = INSTANCE.generateKey(brandId, it, KEY_MESSAGE);
                encryptionVersion = encryptionVersion2;
                sharedPreferences = sharedPreferences2;
                string3 = string6;
            } else {
                string3 = null;
            }
            string2 = sharedPreferences.getString(string3, "");
        } else {
            string2 = null;
        }
        String string7 = DBEncryptionHelper.decrypt(encryptionVersion, string2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"DBEncryptionHelper.decry\u2026 it, KEY_MESSAGE) }, \"\"))");
        return string7;
    }

    public final void setPushMessageClicked(@Nullable String pushMessageId, boolean isClicked) {
        block4: {
            SharedPreferences.Editor editor;
            if (preferences == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000151, "setPushMessageClicked: PushMessage preferences is not initialized");
                return;
            }
            SharedPreferences sharedPreferences = preferences;
            SharedPreferences.Editor editor2 = editor = sharedPreferences != null ? sharedPreferences.edit() : null;
            if (editor2 != null) {
                editor2.putBoolean(KEY_IS_PUSH_NOTIFICATION_CLICKED, isClicked);
            }
            CharSequence charSequence = pushMessageId;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                SharedPreferences.Editor editor3 = editor;
                if (editor3 != null) {
                    editor3.putString(KEY_CLICKED_NOTIFICATION_ID, pushMessageId);
                }
            }
            SharedPreferences.Editor editor4 = editor;
            if (editor4 == null) break block4;
            editor4.apply();
        }
    }

    public final boolean isPushNotificationClicked() {
        SharedPreferences sharedPreferences = preferences;
        return sharedPreferences != null ? sharedPreferences.getBoolean(KEY_IS_PUSH_NOTIFICATION_CLICKED, false) : false;
    }

    @Nullable
    public final String getClickedNotificationId() {
        Object object = preferences;
        if (object == null || (object = object.getString(KEY_CLICKED_NOTIFICATION_ID, "")) == null) {
            object = "";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"preferences?.getString(K\u2026OTIFICATION_ID, \"\") ?: \"\"");
        Object id = object;
        LPLog.INSTANCE.d(TAG, "getClickedNotificationId: Clicked notification id: " + LPLog.INSTANCE.mask(id));
        return id;
    }

    @Nullable
    public final String getLatestNotificationId() {
        Set<String> allIds;
        Set<String> set = allIds = this.getAllIds();
        return set != null ? (String)((Object)CollectionsKt.max((Iterable)set)) : null;
    }

    public final void setPushPlatform(@NotNull String pushType) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)pushType, (String)"pushType");
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.putString(KEY_PUSH_TYPE, pushType)) == null) break block0;
            sharedPreferences.apply();
        }
    }

    @NotNull
    public final String getPushPlatform() {
        Object object = preferences;
        if (object == null || (object = object.getString(KEY_PUSH_TYPE, "")) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public final String getBackendService(@Nullable String messageId, @NotNull String brandId) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        EncryptionVersion encryptionVersion = EncryptionVersion.VERSION_1;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences != null) {
            String string3;
            String string4 = messageId;
            if (string4 != null) {
                String string5 = string4;
                SharedPreferences sharedPreferences2 = sharedPreferences;
                EncryptionVersion encryptionVersion2 = encryptionVersion;
                boolean bl = false;
                boolean bl2 = false;
                String it = string5;
                boolean bl3 = false;
                String string6 = INSTANCE.generateKey(brandId, it, KEY_BACKEND_SERVICE);
                encryptionVersion = encryptionVersion2;
                sharedPreferences = sharedPreferences2;
                string3 = string6;
            } else {
                string3 = null;
            }
            string2 = sharedPreferences.getString(string3, null);
        } else {
            string2 = null;
        }
        return DBEncryptionHelper.decrypt(encryptionVersion, string2);
    }

    @Nullable
    public final String getTransactionId(@Nullable String messageId, @NotNull String brandId) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        EncryptionVersion encryptionVersion = EncryptionVersion.VERSION_1;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences != null) {
            String string3;
            String string4 = messageId;
            if (string4 != null) {
                String string5 = string4;
                SharedPreferences sharedPreferences2 = sharedPreferences;
                EncryptionVersion encryptionVersion2 = encryptionVersion;
                boolean bl = false;
                boolean bl2 = false;
                String it = string5;
                boolean bl3 = false;
                String string6 = INSTANCE.generateKey(brandId, it, KEY_TRANSACTION_ID);
                encryptionVersion = encryptionVersion2;
                sharedPreferences = sharedPreferences2;
                string3 = string6;
            } else {
                string3 = null;
            }
            string2 = sharedPreferences.getString(string3, null);
        } else {
            string2 = null;
        }
        return DBEncryptionHelper.decrypt(encryptionVersion, string2);
    }

    private final void addIdToSet(String id, String brandId) {
        block1: {
            Set ids;
            block0: {
                SharedPreferences sharedPreferences = preferences;
                ids = sharedPreferences != null ? sharedPreferences.getStringSet(KEY_ALL_IDS, null) : null;
                LPLog.INSTANCE.d(TAG, "addIdToSet: Adding notification id: " + LPLog.INSTANCE.mask(id) + " into the list.");
                Collection collection = ids;
                boolean bl = false;
                boolean bl2 = false;
                if (!(collection == null || collection.isEmpty())) break block0;
                HashSet<String> newSet = new HashSet<String>();
                newSet.add(id);
                SharedPreferences sharedPreferences2 = preferences;
                if (sharedPreferences2 == null || (sharedPreferences2 = sharedPreferences2.edit()) == null || (sharedPreferences2 = sharedPreferences2.putStringSet(KEY_ALL_IDS, (Set)newSet)) == null) break block1;
                sharedPreferences2.apply();
                break block1;
            }
            ids.add(id);
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.putStringSet(KEY_ALL_IDS, ids)) == null) break block1;
            sharedPreferences.apply();
        }
    }

    private final Set<String> getAllIds() {
        SharedPreferences sharedPreferences = preferences;
        return sharedPreferences != null ? sharedPreferences.getStringSet(KEY_ALL_IDS, null) : null;
    }

    private final String generateKey(String brandId, String msgId, String key) {
        return key + "::" + msgId + "::" + brandId;
    }

    public final void clearPushMessage(@NotNull String brandId, @NotNull String messageId) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
            Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
            LPLog.INSTANCE.d(TAG, "clearPushMessage: Clearing PushMessage with id: " + messageId + " from preferences");
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_ID))) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_TIME_CREATED))) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_COLLAPSE_KEY))) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_CONVERSATION_ID))) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_MESSAGE))) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_BACKEND_SERVICE))) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_LE_ENGAGEMENT_ID))) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_LE_CAMPAIGN_ID))) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_IS_OUTBOUND_CAMPAIGN))) == null || (sharedPreferences = sharedPreferences.remove(this.generateKey(brandId, messageId, KEY_LOOK_BACK_PERIOD))) == null) break block0;
            sharedPreferences.apply();
        }
    }

    private final void clearExpiredPushMessages(String brandId) {
        block3: {
            Set<String> allIds = this.getAllIds();
            SharedPreferences sharedPreferences = preferences;
            SharedPreferences.Editor editor = sharedPreferences != null ? sharedPreferences.edit() : null;
            LPLog.INSTANCE.d(TAG, "Stored Push Message Ids: " + LPLog.INSTANCE.mask(allIds));
            if (allIds == null) break block3;
            Iterator<String> iterator = allIds.iterator();
            while (iterator.hasNext()) {
                PushMessage pushMessage;
                String id = iterator.next();
                PushMessage pushMessage2 = pushMessage = this.getCachedPushMessage(id, brandId);
                if (pushMessage2 == null) continue;
                if (!pushMessage2.isExpired()) continue;
                LPLog.INSTANCE.d(TAG, "clearExpiredPushMessages: Found expired push message in prefs. id: " + LPLog.INSTANCE.mask(id) + ". Removing related data.");
                this.clearPushMessage(brandId, id);
                iterator.remove();
            }
            SharedPreferences.Editor editor2 = editor;
            if (editor2 != null && (editor2 = editor2.putStringSet(KEY_ALL_IDS, allIds)) != null) {
                editor2.apply();
            }
            SharedPreferences.Editor editor3 = editor;
            if (editor3 != null) {
                editor3.apply();
            }
        }
    }

    public final void cleanUp(@NotNull String brandId) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
            LPLog.INSTANCE.d(TAG, "cleanUp: Cleaning up PushMessage preferences.");
            this.clearExpiredPushMessages(brandId);
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.remove(KEY_IS_PUSH_NOTIFICATION_CLICKED)) == null || (sharedPreferences = sharedPreferences.remove(KEY_CLICKED_NOTIFICATION_ID)) == null) break block0;
            sharedPreferences.apply();
        }
    }

    public final void clearAll() {
        block0: {
            LPLog.INSTANCE.d(TAG, "clearAll: Clearing all data of PushMessage preferences");
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.clear()) == null) break block0;
            sharedPreferences.apply();
        }
    }

    public final void setSharedPreferencesDelegate(@Nullable SharedPreferences preferencesDelegate) {
        preferences = preferencesDelegate;
    }

    private PushMessagePreferences() {
    }

    static {
        PushMessagePreferences pushMessagePreferences;
        INSTANCE = pushMessagePreferences = new PushMessagePreferences();
    }
}

