/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.ParcelFileDescriptor;
import androidx.annotation.Nullable;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    private static final String TAG = "FileUtils";
    private static final String DELETE_COMMAND = "rm -rf";
    private static final String[] FILE_DIRS = new String[]{"/images", "/voice", "/documents"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileContent(Context context, File privateDirectory, Uri publicDirectory) {
        FileInputStream inputStream = null;
        ParcelFileDescriptor parcelFileDescriptor = null;
        FileOutputStream fileOutputStream = null;
        try {
            int len;
            inputStream = new FileInputStream(privateDirectory);
            parcelFileDescriptor = context.getContentResolver().openFileDescriptor(publicDirectory, "w");
            fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            byte[] b = new byte[5120];
            while ((len = inputStream.read(b)) > 0) {
                fileOutputStream.write(b, 0, len);
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000012, "Failed to copy file from privateDir to publicDir. ", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (parcelFileDescriptor != null) {
                    parcelFileDescriptor.close();
                }
            }
            catch (IOException exception) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000013, "Failed to close fileOutputStream/parcelFileDescriptor ", exception);
            }
        }
        return true;
    }

    @Nullable
    public static File getFilePath(Context context, String path, String filename) {
        File privateDir = new File(context.getApplicationContext().getFilesDir() + path);
        File filePath = new File(privateDir, filename);
        if (!privateDir.exists() && !privateDir.mkdirs()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000014, "getFilePath: folder could not be created");
            return null;
        }
        return filePath;
    }

    public static void deleteAllSharedFiles(Context context) {
        LPLog.INSTANCE.d(TAG, "deleting all shared files with agent");
        String basePath = context.getFilesDir().getPath();
        new DeleteFileAsyncTask(basePath).execute(new Void[0]);
    }

    private static class DeleteFileAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private String basePath;

        public DeleteFileAsyncTask(String path) {
            this.basePath = path;
        }

        protected Void doInBackground(Void ... voids) {
            try {
                StringBuilder command = new StringBuilder(FileUtils.DELETE_COMMAND);
                for (String fileDir : FILE_DIRS) {
                    String fullPath = this.basePath + fileDir;
                    command.append(" ").append(fullPath);
                }
                LPLog.INSTANCE.d(FileUtils.TAG, "deleting command: " + command.toString());
                Runtime.getRuntime().exec(command.toString());
            }
            catch (IOException e) {
                LPLog.INSTANCE.e(FileUtils.TAG, ErrorCode.ERR_00000142, "Failed to delete files using command line.", e);
                for (String fileDir : FILE_DIRS) {
                    String fullPath = this.basePath + fileDir;
                    this.deleteRecursively(new File(fullPath));
                }
            }
            return null;
        }

        private void deleteRecursively(File fileOrDirectory) {
            if (fileOrDirectory == null) {
                LPLog.INSTANCE.e(FileUtils.TAG, ErrorCode.ERR_00000143, "file path is null");
                return;
            }
            if (fileOrDirectory.isDirectory()) {
                LPLog.INSTANCE.d(FileUtils.TAG, "deleteRecursive: deleting directory: " + fileOrDirectory.getAbsolutePath());
                File[] listFiles = fileOrDirectory.listFiles();
                if (listFiles == null) {
                    LPLog.INSTANCE.e(FileUtils.TAG, ErrorCode.ERR_00000144, "File list is null");
                    return;
                }
                for (File child : fileOrDirectory.listFiles()) {
                    LPLog.INSTANCE.d(FileUtils.TAG, "deleteRecursive: deleting file: " + child.getAbsolutePath());
                    this.deleteRecursively(child);
                }
            }
            fileOrDirectory.delete();
        }
    }
}

