@file:Suppress("EnumEntryName", "KDocUnresolvedReference")
// The error codes don't conform to an enum standard that we don't need to worry about here.
// We've used KDoc syntax to highlight some proper class names, but KDoc generated from this
// file will be unable to resolve most of the class references due to dependency issues.

package com.liveperson.infra.errors

/**
 * These error codes and corresponding descriptions help LP Support find the exact location of
 * problems within the Mobile SDK.
 * 
 * Devs, please update these descriptions as you research issues and find new details; if there are
 * easy troubleshooting steps, include them. Try to give the Support teams as much clue as possible
 *
 * Feel free to add new codes as necessary; we have 65,536 possible error codes without changing
 * format, and will probably never use them all. Even if we do, using the Enum system means you can
 * add new code sets with more left-padding digits to represent the 65,537th.
 */
enum class ErrorCode {
	// 8-Digit Hexadecimal values.

	/**
	 * Indicates no real error; used for Unit Tests when calling LPLog methods.
	 * If you encounter this error in production, from a client app, notify R&D.
	 */
	ERR_00000000,

	/**
	 * A call was made to [MonitoringParamsCache.updateCsdsDomains] with an empty HashMap;
	 * this may be due to a bad result payload from CSDS or corrupted data within the SDK.
	 */
	ERR_00000001,

	/**
	 * An unexpected Exception was caught while executing [DispatchQueue.sendMessage]; an
	 * internal resource object (Handler) was not ready when it was supposed to be.
	 * R&D issue research required.
	 */
	ERR_00000002,

	/**
	 * An unexpected Exception was caught while executing [DispatchQueue.postRunnable]; an
	 * internal resource object (Handler) was not ready when it was supposed to be.
	 * R&D issue research required.
	 */
	ERR_00000003,

	/**
	 * An unexpected Exception was caught while executing [DispatchQueue.removeRunnable]; an
	 * internal resource object (Handler) was not ready when it was supposed to be.
	 * R&D issue research required.
	 */
	ERR_00000004,

	/**
	 * An unexpected Exception was caught while executing [DispatchQueue.removeMessage]; an
	 * internal resource object (Handler) was not ready when it was supposed to be.
	 * R&D issue research required.
	 */
	ERR_00000005,

	/**
	 * An unexpected Exception was caught while executing [DispatchQueue.cleanupQueue]; an
	 * internal resource object (Handler) was not ready when it was supposed to be.
	 * R&D issue research required.
	 */
	ERR_00000006,

	/**
	 * An unexpected Exception was caught while executing [DispatchQueue.dispose]; an
	 * internal resource object (Handler) was not ready when it was supposed to be.
	 * R&D issue research required.
	 */
	ERR_00000007,

	/**
	 * An unexpected Exception was caught while executing [DispatchQueue.isCurrentThread]; an
	 * internal resource object (Handler) experienced an issue with a thread synchronization error.
	 * R&D issue research required.
	 */
	ERR_00000008,

	/**
	 * A critical internal SDK process, [InfraStateMachine.initSDK], was called with its primary
	 * Process object null, and cannot continue executing.
	 * R&D issue research required.
	 */
	ERR_00000009,

	/**
	 * A critical internal SDK process, [InfraStateMachine.shutDownSDK], was called with its primary
	 * Process object null, and cannot continue executing.
	 * R&D issue research required.
	 */
	ERR_0000000A,

	/**
	 * A critical internal SDK process, [InfraStateMachine.logoutSDK], was called with its primary
	 * Process object null, and cannot continue executing.
	 * R&D issue research required.
	 */
	ERR_0000000B,

	/**
	 * An unexpected Exception was thrown while running an SDK internal initialization process.
	 * This error was probably thrown with additional details included in the error log; please
	 * include those details when you open a ServiceNow ticket.
	 * R&D issue research required.
	 */
	ERR_0000000C,

	/**
	 * The [MonitoringRequestManager] received an empty csdsDomainMap, and could not continue
	 * without data. This could indicate a CSDS service failure, or a parsing problem in SDK code.
	 */
	ERR_0000000D,

	/**
	 * The [MonitoringRequestManager] received an error response when requesting CSDS domains.
	 * Likely causes include network failure / connection problems, or a CSDS service outage.
	 * Check other details logged with this error for additional clues, such as the HTTP result
	 * code, or any error messages returned from the CSDS service.
	 */
	ERR_0000000E,

	/**
	 * A call was made to [ConnectionParamsCache.updateCsdsDomains] with an empty HashMap;
	 * this may be due to a bad result payload from CSDS or corrupted data within the SDK.
	 */
	ERR_0000000F,

	/**
	 * The [InternetConnectionService.unRegisteredReceiver] method caught an
	 * IllegalArgumentException when attempting to unregister the BroadcastReceiver the SDK uses
	 * for tracking internet connection updates. This most likely means that, for some reason, we
	 * attempted to unregister the receiver twice, and this error is not a serious problem.
	 * If you see noticeable erroneous app behavior, contact R&D.
	 */
	ERR_00000010,

	/**
	 * An internal utility class failed to initialize Picasso, our image-loading library. This
	 * likely means that users will not be able to load many image resources, including user and
	 * brand avatars, or images sent by Agents. This is an extremely unlikely error; contact R&D.
	 */
	ERR_00000011,

	/**
	 * During a file copy operation from an app-private to a user-public directory, we caught an
	 * Exception that prevents the copy operation from occurring. The file will not be available in
	 * the user-public directory. This may be caused by a full SDCard, or restricted write
	 * permissions on the destination directory. This error was likely logged with an Exception;
	 * use the Exception details for more clues on the error source.
	 */
	ERR_00000012,

	/**
	 * The SDK failed to clean up file-writing resources. This is highly unlikely and will require
	 * investigation by R&D. Include the Exception details attached to this error log.
	 */
	ERR_00000013,

	/**
	 * The SDK failed to create a destination directory for files within app-private file space.
	 * This may be due to restrictive write permissions on the destination directory.
	 */
	ERR_00000014,

	/**
	 * An exception was thrown while attempting to parse user content for the purposes of creating
	 * a "link preview" UI element. This likely means that the parser encountered a malformatted
	 * URL, and was unable to convert it to a usable URL object. This is more likely a case of user
	 * error (mistyped URL) than SDK failure.
	 */
	ERR_00000015,

	/**
	 * [Utils.tryParse] encountered a malformatted number, that should be a latitude or longitude
	 * float, for a map element. This was most likely caused by an Agent sending Structured Content
	 * containing a MapElement that did not have its latitude and / or longitude fields filled out
	 * properly.
	 */
	ERR_00000016,

	/**
	 * [Utils.tryParse] encountered a malformatted number, that should be an Integer. Verify that
	 * all Structured Content JSON payloads were sent with well-formed integers within the Java
	 * standard MAX_INT <= val <= MIN_INT range.
	 */
	ERR_00000017,

	/**
	 * When attempting to resolve image content for a User, generally when they attempt to upload
	 * an image, the SDK encountered a Content Scheme that it was unfamiliar with, and thus failed
	 * to acquire an image from. Advise users to try different methods of selecting an image,
	 * depending on what options their device's OS gives them. Additionally, open a ServiceNow
	 * ticket to R&D and include the Scheme name listed with this error log.
	 */
	ERR_00000018,

	/**
	 * A FileNotFound Exception was thrown by [ImageUtils.saveBitmapToDisk] while writing a Bitmap
	 * to disk. This may mean that the OS failed to create the file for writing, or that restrictive
	 * write permissions exist on the destination directory. Check the Exception included with this
	 * error log for additional clues.
	 */
	ERR_00000019,

	/**
	 * An IO Exception was thrown by [ImageUtils.saveBitmapToDisk] while writing a Bitmap to disk.
	 * This means the file write operation was interrupted for a number of different reasons,
	 * including a lack of storage space on the SDCard to complete the write operation. Check the
	 * Exception included with this error log for additional clues.
	 */
	ERR_0000001A,

	/**
	 * The SDK encountered an unexpected Exception while attempting to calculate the size-on-disk
	 * (in bytes) of a Document stored on disk. This may mean that the content selected by the User
	 * for upload is not of an expected document type or format.
	 */
	ERR_0000001B,

	/**
	 * The SDK encountered an unexpected Exception while attempting to calculate the size-on-disk
	 * (in bytes) of a Document stored on disk. This may mean that the host app does not have
	 * permission to view details about that file for some reason, such as restrictive read
	 * permissions on the file or directory.
	 */
	ERR_0000001C,

	/**
	 * The SDK encountered an unexpected Exception while attempting to read the Display Name
	 * of a Document stored on disk. This may mean that the content selected by the User
	 * for upload is not of an expected document type or format.
	 */
	ERR_0000001D,

	/**
	 * The SDK encountered an unexpected Exception while attempting to read the filename
	 * of a Document stored on disk. This may mean that the host app does not have
	 * permission to view details about that file for some reason, such as restrictive read
	 * permissions on the file or directory.
	 */
	ERR_0000001E,

	/**
	 * The SDK encountered a FileNotFound Exception while attempting to write a Document to disk.
	 * This could be due to restrictive write permissions on the destination directory; check the
	 * Exception included with this error log for additional clues.
	 */
	ERR_0000001F,

	/**
	 * The SDK encountered an IO Exception while attempting to write a Document to disk. This could
	 * be due to a lack of disk space on the SDCard; check the Exception included with this error
	 * log for additional clues.
	 */
	ERR_00000020,

	/**
	 * The SDK encountered an IO Exception while attempting to clean up resources used for file
	 * writing. This is unlikely to occur, but may have caused data corruption on a single recent
	 * file write. Check the Exception included with this error log for additional clues.
	 */
	ERR_00000021,

	/**
	 * An IllegalArgumentException was thrown by [LpColorParseUtils] while attempting to convert a
	 * color string (e.g. 'aqua' or '#f0f8ff') to an Android-recognized Color Integer. This likely
	 * means it tried to parse a malformatted Color string, such as one with five digits (#12345).
	 * Verify that all color values in Structured Content payloads are well-formatted, and check
	 * the Exception included with this error log for additional clues.
	 */
	ERR_00000022,

	/**
	 * [LocalBroadcast.sendBroadcast] caught an unexpected exception while attempting to send an
	 * Android Broadcast. This error is thrown by a system call and will require R&D research.
	 * Include the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_00000023,

	/**
	 * [LocalBroadcast.sendBroadcast] caught an unexpected exception while attempting to send an
	 * Android Broadcast. This error is thrown by a system call and will require R&D research.
	 * Include the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_00000024,

	/**
	 * [LPAudioUtils.startRecording] failed to start an audio recording for an unknown reason,
	 * perhaps due to a problem with the system audio service. Will require R&D research.
	 * Include the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_00000025,

	/**
	 * [LPAudioUtils.stopRecording] failed to stop an audio recording for an unknown reason,
	 * perhaps due to a problem with the system audio service. Will require R&D research.
	 * Include the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_00000026,

	/**
	 * [LPAudioUtils.playAudio] failed to play back an audio recording for an unknown reason,
	 * perhaps due to a problem with the system audio service, but more likely due to restrictive
	 * Read permissions on the File in question. This is generally only called on internal audio
	 * files, so a full diagnosis will require R&D assistance. Include the attached Exception and
	 * Stacktrace in the ServiceNow ticket.
	 */
	ERR_00000027,

	/**
	 * [LPAudioUtils.playAudio] failed to create a storage directory for audio recordings. This may
	 * be due to restrictive folder permissions on the app's parent directory, but regardless is a
	 * system call to an app-controlled directory and *should* have no problems. A full
	 * diagnosis will require R&D assistance. Include the attached Exception and Stacktrace in the
	 * ServiceNow ticket.
	 */
	ERR_00000028,

	/**
	 * [LPAudioUtils.saveByteArrayToDisk] failed to create a file for writing an audio recording to
	 * disk. This may be due  to restrictive folder permissions on the SDK's audio file directory,
	 * which the SDK does not set, and would be a system-related failure. Additional information
	 * will require R&D assistance.  Include the attached Exception and Stacktrace in the ServiceNow
	 * ticket.
	 */
	ERR_00000029,

	/**
	 * [LPAudioUtils.saveByteArrayToDisk] failed to write an audio recording to disk. May be due to
	 * a system call failure, the device SDCard being full, or the app being killed in the middle of
	 * a file-write operation. Check the included Exception and Stacktrace for additional information.
	 */
	ERR_0000002A,

	/**
	 * [TlsUtil] experienced an unexpected Exception while attempting to set HTTPS security for the
	 * SDK to TLS 1.2, in a method specifically for enabling this security feature on KitKat
	 * devices. This is due to running the SDK on a device that is running Android 4.4 / KitKat,
	 * but for some reason this specific device is not equipped for TLS 1.2 encryption.
	 */
	ERR_0000002B,

	/**
	 * [SDKUncaughtExceptionHandler] has caught an Exception that it has determined is causing the
	 * SDK to crash-loop, and is dropping its final attempt at handling the Exception gracefully.
	 * Check the included Exception and Stacktrace for additional clues.
	 */
	ERR_0000002C,

	/**
	 * [SDKUncaughtExceptionHandler] has caught an Exception that all other catches in the SDK
	 * failed to account for, and this code is attempting a final error report before the app
	 * crashes completely. See the attached Exception and Stacktrace for information on what caused
	 * the SDK to crash and why.
	 */
	ERR_0000002D,

	/**
	 * [SDKUncaughtExceptionHandler] has, paradoxically, thrown an Exception while attempting final
	 * processing of a different Exception, and will now cease processing. Something truly
	 * unexpected has gone wrong, to the point that if the user reports experiencing strange
	 * glitches and apps crashing frequently, I recommend that they factory reset their device.
	 * Regardless, check the Exception and Stacktrace included with this error report for clues on
	 * what went wrong and why, and include these details in a ServiceNow ticket to R&D.
	 */
	ERR_0000002E,

	/**
	 * [Configuration] failed to find a Dimension resource in a branding.xml resource file. This
	 * class should not be used outside of the R&D team's internal MessagingTest and Sample App
	 * distributions; if you are seeing this error in production, the Host App is using an API they
	 * are not supposed to.
	 */
	ERR_0000002F,

	/**
	 * [Configuration] failed to find a Color resource in a branding.xml resource file. Check
	 * the included Exception for details on which resource ID was missing. Ensure that the host app
	 * has not somehow removed a branding.xml value that was defined by default in the SDK code.
	 */
	ERR_00000030,

	/**
	 * [Configuration] encountered an unexpected Exception while generating a key-value map for all
	 * Resources used by the LivePerson SDK. This is probably caused by a malformed resource file,
	 * most likely branding.xml, as a result of a failed compilation step. Recommend that client
	 * developers clean their project builds, and rebuild from scratch. If this fails, invalidate
	 * AndroidStudio's caches and restart, then clean the build and rebuild from scratch.
	 */
	ERR_00000031,

	/**
	 * [Configuration] encountered a JSONException while parsing a list of resource keys that can be
	 * configured more dynamically than most. This is unlikely to occur outside of R&D development
	 * processes; have the client devs attempt a clean build, and if that fails, invalidate Android
	 * Studio's caches and restart, then try another clean build. If the problem persists, cut a
	 * ServiceNow ticket and include the attached Exception and Stacktrace.
	 */
	ERR_00000032,

	/**
	 * [Configuration] encountered an IOException while reading a JSON file containing a list of SDK
	 * resource keys. This is most likely to occur if the client dev's build tools have failed to
	 * include one of our JSON files in its compilation. Have the client dev try a clean build, and
	 * if that fails, invalidate their caches and restart, then try another clean build. If the
	 * problem persists, cut a ticket to R&D and include the attached Exception and Stacktrace.
	 */
	ERR_00000033,

	/**
	 * [DBEncryptionService] encountered an Exception while loading the Android Keystore, an API
	 * wrapper for the device's hardware secure key storage element. Failing to load the Keystore
	 * prevents all cryptographic operations, and the SDK cannot function without it. This is a core
	 * Android system service, and failure to load it most likely indicates a system problem. Check
	 * the included Exception and Stacktrace for additional details.
	 */
	ERR_00000034,

	/**
	 * [DBEncryptionService] encountered an unexpected Exception while attempting to decrypt the SDK
	 * primary encryption key in Legacy Mode and prepare it for use. This failure will prevent all
	 * cryptographic operations, and the SDK cannot continue to function. Check the included
	 * Exception and Stacktrace for additional details.
	 */
	ERR_00000035,

	/**
	 * [DBEncryptionService] encountered an unexpected Exception while attempting to encrypt the SDK
	 * primary encryption key in Legacy Mode and store it at rest. This failure may prevent future
	 * cryptographic operations, and the SDK might not continue to function. Check the included
	 * Exception and Stacktrace for additional details.
	 */
	ERR_00000036,

	/**
	 * [DBEncryptionService] encountered an unexpected NoSuchAlgorithmException indicating that AES
	 * encryption does not exist. This is most likely due to the hardware the SDK is running on not
	 * being capable of generating AES encryption keys. This failure will prevent all cryptographic
	 * operations, and the SDK cannot continue to function. Check the included
	 * Exception and Stacktrace for additional details.
	 */
	ERR_00000037,

	/**
	 * [DBEncryptionService] encountered an unexpected Exception while attempting to generate an RSA
	 * private/public key pair for encryption in Legacy Mode. This failure generally indicates an
	 * issue with the system's ability to generate an RSA key pair. Check the included Exception and
	 * Stacktrace for additional details.
	 */
	ERR_00000038,

	/**
	 * [DBEncryptionService.encrypt] encountered an unexpected Exception while encrypting data. This
	 * probably means a problem with the SDK's encryption keys, indicating that the Keystore or
	 * Preferences files used by the SDK have been tampered with, either by the User or by the Host
	 * App. Check the included Exception and Stacktrace for additional details. This error indicates
	 * that some amount of data was stored in plaintext. The user of the device in question may wish
	 * to clear all data for the Host App in order to erase unsafely-stored data.
	 */
	ERR_00000039,

	/**
	 * [DBEncryptionService.decrypt] encountered a BadPaddingException, which we occasionally expect
	 * during this process. However, in attempting a fix for this exception, we encountered
	 * *another* BadPaddingException. This likely indicates a problem with the encrypted data;
	 * perhaps it was corrupted at rest, or tampered with by the user or host app. Check the
	 * included Exception and Stacktrace for additional details.
	 */
	ERR_0000003A,

	/**
	 * [DBEncryptionService.decrypt] encountered an unexpected Exception while decrypting data. This
	 * probably means a problem with the SDK's encryption keys, indicating that the Keystore or
	 * Preferences files used by the SDK have been tampered with, either by the User or by the Host
	 * App. Check the included Exception and Stacktrace for additional details. This error indicates
	 * that the user probably sees "empty bubbles"; chat messages that appear to have no contents.
	 */
	ERR_0000003B,

	/**
	 * [DBEncryptionService.getAppEncryptionVersion] encountered a ResourceNotFoundException while
	 * trying to look up the Encryption Version used by the SDK. This should never happen; suggest
	 * that the client devs attempt a clean build, and if that fails, invalidate Android Studio's
	 * caches and restart, then try another clean build.
	 */
	ERR_0000003C,

	/**
	 * [LPAuthenticationParams] has rejected a supplied Certificate Pinning key because the public
	 * key was an empty string. Please supply a non-empty public key.
	 */
	ERR_0000003D,

	/**
	 * [LPAuthenticationParams] has detected that the Host App has attempted to authenticate in
	 * Signup mode. Signup mode is deprecated and not recommended for use by any client for any
	 * reason. Advise the client switch to any other authentication mode immediately.
	 */
	ERR_0000003E,

	/**
	 * [LPWelcomeMessage] has rejected a set of Welcome Message Quick Replies because there are too
	 * many items in the supplied list. Check the included error message for the current maximum
	 * number of items.
	 */
	ERR_0000003F,

	/**
	 * [LPWelcomeMessage] has rejected a set of Welcome Message Quick Replies because one of the
	 * items has text that is too long. Check the included error message for the current maximum
	 * message reply item length.
	 */
	ERR_00000040,

	/**
	 * [LPWelcomeMessage] has rejected a set of Welcome Message Quick Replies because one of the
	 * items has text that is too short. Check the included error message for the current minimum
	 * message reply item length.
	 */
	ERR_00000041,

	/**
	 * [LPWelcomeMessage.getQuickReplies] has encountered a JSONException while attempting to
	 * package the supplied Welcome Message Quick Reply Options for later retrieval. This may
	 * indicate strange or unexpected data fed to the Welcome Message API. Check the included
	 * JSONException for additional details.
	 */
	ERR_00000042,

	/**
	 * [MessageOption] failed to parse JSON from a Parcel while inflating a Quick Reply Option.
	 * This is unlikely to occur without some sort of system glitch while marshalling Activities or
	 * Fragments. Check the included JSONException for additional details.
	 */
	ERR_00000043,

	/**
	 * [DataBaseCommand] encountered an unexpected Exception while attempting to execute a Database
	 * Query. This could be due to the app being killed at an inopportune time, the system MySQL
	 * instance having issues, or other system problems.
	 */
	ERR_00000044,

	/**
	 * [SocketHandler] encountered a JSONException while converting an incoming message from the UMS
	 * WebSocket. This most likely indicates an issue with the UMS Service, or some kind of data
	 * corruption in transit.
	 */
	ERR_00000045,

	/**
	 * [SocketHandler] encountered an unexpected Exception while attempting to handle a message from
	 * the UMS WebSocket. This most likely indicates that the type of response returned by UMS was
	 * not the same type of response expected by the MobileSDK. Check the included Exception and
	 * Stacktrace for additional clues, and check with the UMS team for potential service issues.
	 */
	ERR_00000046,

	/**
	 * [SocketManager] failed to obtain a Socket connection because the supplied
	 * [SocketConnectionParams] contained an empty URL. Contact R&D about this issue.
	 */
	ERR_00000047,

	/**
	 * [SocketManager.connect] has rejected a connection request because the supplied URL is empty.
	 * Contact R&D about this issue.
	 */
	ERR_00000048,

	/**
	 * [SocketManager.obtainSocket] has failed to obtain a Socket connection because the supplied
	 * URL is empty. Contact R&D about this issue.
	 */
	ERR_00000049,

	/**
	 * [SocketManager.getSocketHandler] has failed to return a valid SocketHandler because the
	 * supplied SocketRequest was null. Contact R&D about this issue.
	 */
	ERR_0000004A,

	/**
	 * [BadgeCounterRequest] encountered an Exception while attempting to request a Badge Count.
	 * Check the included Exception for additional details.
	 */
	ERR_0000004B,

	/**
	 * [SiteSettingsRequest] has failed because the result came back empty, instead of as a JSON
	 * payload. Settings were not loaded. Check for LivePerson service outages.
	 */
	ERR_0000004C,

	/**
	 * [UnregisterPushRequest] received an empty response in a success payload, which is not an
	 * accepted success message. Check with the Pusher team for service outages. This error may not
	 * indicate a failure to do what the user wants, but definitely indicates a problem somewhere.
	 */
	ERR_0000004D,

	/**
	 * [ConfigurationRequest] received a success payload that is empty, instead of the expected JSON
	 * payload. Configuration and supported version information was not loaded. Check for LivePerson
	 * service outages.
	 */
	ERR_0000004E,

	/**
	 * [Infra.setContext] was called with a null Context. Infra requires a valid Context for access
	 * to the ApplicationContext and the app's Resource files. Please ensure that the host app is
	 * supplying a valid Context object to the SDK.
	 */
	ERR_0000004F,

	/**
	 * [AcCdnRequest] received an error response while attempting to fetch the Engagement Language.
	 * This may be a network-related failure, and could occur for any number of reasons, including a
	 * poor or nonexistent data connection, LivePerson service outages, restrictive firewalls
	 * between the user and a LivePerson service, or an SDK internal Exception. Check the error for
	 * additional details, especially an Exception and Stacktrace, if included.
	 */
	ERR_00000050,

	/**
	 * [AcCdnRequest] encountered an unexpected Exception while attempting to parse the Engagement
	 * Language. This may be due to a bad payload received from the server (check for LivePerson
	 * service outages), or a Language that LocaleUtils is not familiar with. Check the included
	 * Exception and Stacktrace for additional details.
	 */
	ERR_00000051,

	/**
	 * [BaseMonitoringRequest] was handling an Error, which is generally routine as this class
	 * handles HTTP errors, but in this instance encountered an Exception, which may indicate a
	 * problem internal to the SDK. Forward this error report to R&D along with the Exception and
	 * Stacktrace of the included Exception. This may not indicate a serious error unless the user
	 * reports app instability or errors.
	 */
	ERR_00000052,

	/**
	 * [GetEngagementRequest] encountered an Exception while parsing an EngagementResponse in order
	 * to build an EngagementLanguage Request ([AcCdnRequest]). This may indicate that a request to
	 * retrieve Engagement Details returned a bad result. Check for LivePerson service outages, and
	 * check the included Exception and Stacktrace for additional details.
	 */
	ERR_00000053,

	/**
	 * [GetIsPusherRegisteredCommand] encountered an Exception while attempting to parse a
	 * theoretically-successful Authentication, in order to make an IsPusherRegistered query.
	 * However, due to this Exception, the IsPusherRegistered query could not be completed. This
	 * could be due do a LivePerson Service / IDP outage.
	 */
	ERR_00000054,

	/**
	 * [GetIsPusherRegisteredCommand] encountered an HTTP error while attempting to Authenticate in
	 * order to make an IsPusherRegistered query. However, due to this error, the IsPusherRegistered
	 * query could not be completed. This could be due do a LivePerson Service / IDP outage, poor /
	 * non-existent network connection, or bad authentication details supplied by the Host App.
	 */
	ERR_00000055,

	/**
	 * [MessagingEventNotificationHandler] encountered a JSONException while attempting to parse a
	 * messaging event JSON payload. This most likely means that the payload was malformed in some
	 * way, which can probably only happen due to a LivePerson service outage, though in rare cases
	 * may occur due to data corruption in transit.
	 */
	ERR_00000056,

	/**
	 * The [CloseReason] parser encountered an Exception while attempting to determine the reason a
	 * Conversation was closed. This error has fallback logic in place, so the end-user may see a
	 * "closed by system" message if the fallback logic failed. Regardless, the end-user is not
	 * blocked in any way and can continue to use the SDK without problems. Please forward this
	 * error alone with the attached Exception and Stacktrace to R&D.
	 */
	ERR_00000057,

	/**
	 * [AbstractRequest] encountered a JSONException while starting to build a JSON String for
	 * sending to a LivePerson service. This method is unlikely to throw errors, but calls an
	 * abstract method that may encounter issues from subclasses. Check the Stacktrace included with
	 * this error to see exactly where the Exception is coming from, and the Exception itself for
	 * additional details.
	 */
	ERR_00000058,

	/**
	 * [OriginatorMetadata] encountered a JSONException while attempting to parse Originator
	 * information, likely indicating that it is missing mandatory fields. This likely indicates a
	 * LivePerson service outage.
	 */
	ERR_00000059,

	/**
	 * [Participants] failed to match a specified Participant Role to one of its recognized roles.
	 * This could indicate a LivePerson service outage, or an old version of the SDK that doesn't
	 * know about a new Role type. This error should have included the unexpected role name; check
	 * it for additional clues.
	 */
	ERR_0000005A,

	/**
	 * [Participants] found a new Role it wasn't expecting; this could indicate a LivePerson service
	 * outage, or an old version of the SDK that doesn't know about a new Role type. This error
	 * should have included the unexpected role name; check it for additional clues.
	 */
	ERR_0000005B,

	/**
	 * [FormSubmissionPublishMessage] encountered a JSONException while building a Form Submission
	 * JSON payload. This is fairly simply code and is unlikely to fail. Check with R&D.
	 */
	ERR_0000005C,

	/**
	 * [DialogData] attempted to parse Participant details for a Dialog, but found 0 Participants.
	 * This could mean that the server is vastly out of date, or is experiencing a strange service
	 * issue (most of the app is working normally). Check LP Services for outages.
	 */
	ERR_0000005D,

	/**
	 * [DialogData] attempted to extract Dialog information from a ConversationData object, but the
	 * Conversation's Dialog array was null. The SDK will attempt a fallback by creating a Legacy
	 * dialog based on on the ConversationData. This likely indicates a LivePerson service outage.
	 */
	ERR_0000005E,

	/**
	 * [DialogData] attempted to extract Dialog information from a ConversationData object, but the
	 * Conversation's Dialog array was empty. The SDK will attempt a fallback by creating a Legacy
	 * dialog based on on the ConversationData. This likely indicates a LivePerson service outage.
	 */
	ERR_0000005F,

	/**
	 * [DialogType] attempted to establish the Type of a Dialog, but failed to parse the
	 * DialogTypeString. This error should have included the string it failed to parse; this may be
	 * a clue. Possible causes include LivePerson service outages, or an old SDK version  that does
	 * not know about a new DialogType.
	 */
	ERR_00000060,

	/**
	 * [ConversationData] has encountered a Conversation that has no Dialogs, and is attempting to
	 * inject a Legacy Dialog based on the Conversation details. This likely indicates a LivePerson
	 * service outage.
	 */
	ERR_00000061,

	/**
	 * [ConversationData] failed to retrieve the Consumer ID for a Conversation because the
	 * Participants.CONSUMER list was null or empty. This likely indicates a LivePerson service
	 * outage.
	 */
	ERR_00000062,

	/**
	 * The [Dialog] class is constructing a Legacy Dialog based on Conversation data, as a fallback
	 * for not finding a Dialog already in Conversation details. This likely indicates the SDK is
	 * talking to a very old version of UMS, or UMS is experiencing a service outage.
	 */
	ERR_00000063,

	/**
	 * [FetchConversationManager] attempted to refresh Conversation details, but failed to find its
	 * own Dialog data in the database. This may indicate that the system MySQL or local app storage
	 * was tampered with, either by the end-user or the Host App, or that the SDK is experiencing
	 * internal data loss.
	 */
	ERR_00000064,

	/**
	 * [FetchConversationManager] was attempting to fetch Conversation details, but when iterating
	 * over known Dialogs, it encountered a null one. This may indicate that the system storage
	 * was tampered with, either by the end-user or the Host App, or that the SDK is experiencing
	 * internal data loss.
	 */
	ERR_00000065,

	/**
	 * A query for the [FetchConversationManager] has timed out. This could be as benign as a poor
	 * or nonexistent data connection, but if happening frequently, could indicate an issue with a
	 * LivePerson service.
	 */
	ERR_00000066,

	/**
	 * [FetchConversationManager] was interrupted while attempting to enqueue a QueryRequest into a
	 * BlockingQueue. This should not happen; contact R&D.
	 */
	ERR_00000067,

	/**
	 * [FetchConversationManager] was interrupted while attempting to enqueue a QueryRequest response
	 * into a BlockingQueue. This should not happen; contact R&D.
	 */
	ERR_00000068,

	/**
	 * [ConversationHistoryDetails] failed to parse Participant IDs due to an unexpected Exception.
	 * This probably indicates a JSON problem, most likely indicative of a LivePerson service outage.
	 * Check the included Exception and Stacktrace for additional details.
	 */
	ERR_00000069,

	/**
	 * [ConversationHistoryDetails.parseStage] has failed to parse the 'stage' field, because the
	 * JSON it is parsing does not have a 'stage' field. Check UMS and Inca to ensure they are
	 * working correctly.
	 */
	ERR_0000006A,

	/**
	 * [ConversationHistoryDetails.parseStage] has failed to parse the 'state' field, because the
	 * JSON it is parsing does not have a 'state' field. Check UMS and Inca to ensure they are
	 * working correctly.
	 */
	ERR_0000006B,

	/**
	 * [Messaging] failed to clear acknowledged conversations while moving to the background due to
	 * an unexpected error. Check the included Exception and Stacktrace for additional details. This
	 * may have caused strange behavior with unread message counts, but otherwise probably did not
	 * cause any serious issues.
	 */
	ERR_0000006C,

	/**
	 * [Messaging] failed to parse a JSON string while attempting to re-send a Message. This is a
	 * fairly central error and could mean a number of different issues; contact R&D and include the
	 * attached Exception and Stacktrace.
	 */
	ERR_0000006D,

	/**
	 * [Messaging] failed to generate a File-, Photo- or Audio-Upload Token because there was no
	 * active Dialog. This probably indicates that the end-user attempted to upload something right
	 * as an Agent closed the Conversation that the end-user was in, but may indicate a larger issue
	 * with conversations and dialogs; check for service outages.
	 */
	ERR_0000006E,

	/**
	 * [Messaging] failed to send a FormSubmission message because the Form was not found in the
	 * local FormsManager. This could indicate data tampering by the user or host app, or an internal
	 * SDK issue.
	 */
	ERR_0000006F,

	/**
	 * [Messaging] failed to parse a message's JSON blob while attempting to re-send a failed
	 * FormSubmission request. This may be due to a malformed JSON blob from the server. Check for
	 * service outages.
	 */
	ERR_00000070,

	/**
	 * [Messaging] attempted to re-send a FormSubmission request, but found its InvitationID was
	 * null. This could indicate end-user or Host App tampering with MySQL or other app storage, or
	 * a LivePerson service outage.
	 */
	ERR_00000071,

	/**
	 * [Messaging] encountered a JSONException while constructing a JSON payload to submit a Secure
	 * Form. Check the attached Exception for details on what went wrong. This is unlikely to occur
	 * and will probably require R&D research.
	 */
	ERR_00000072,

	/**
	 * [Messaging] attempted to close the current Dialog, but it was already closed. The SDK will
	 * stop processing this close request. This likely means the agent and user tried to close the
	 * conversation at the same time, and as such the user did not notice a problem.
	 */
	ERR_00000073,

	/**
	 * [Messaging] encountered an HTTP-400 error when attempting to close a Dialog, so as a fallback
	 * it will close the entire Conversation instead. This should have the same end effect.
	 */
	ERR_00000074,

	/**
	 * [DialogUtils] failed to properly update a Participant because its userId was empty. This may
	 * cause the end-user's UI to display out-of-date information, or default agent avatars. Missing
	 * user IDs are uncommon and likely indicate a service outage.
	 */
	ERR_00000075,

	/**
	 * [AmsMessages] received a generic message timeout; other errors were probably thrown along
	 * with this one, check them for full details.
	 */
	ERR_00000076,

	/**
	 * [AmsMessages] received a generic update message timeout; other errors were probably thrown
	 * along with this one, check them for full details.
	 */
	ERR_00000077,

	/**
	 * [AmsMessages] received a ContentEventNotification with an empty Event. This probably indicates
	 * a LivePerson service outage, as all ContentEventNotifications should have Events. The SDK
	 * continued on to process other notifications, but the one with the empty Event was dropped.
	 */
	ERR_00000078,

	/**
	 * The text of a ContentEvent received by [AmsMessages] is empty, which should never happen.
	 * Check for LivePerson service outages, and if there are none, contact R&D.
	 */
	ERR_00000079,

	/**
	 * The text of a RichContentEvent received by [AmsMessages] is empty, which should never happen.
	 * Check for LivePerson service outages, and if there are none, contact R&D.
	 */
	ERR_0000007A,

	/**
	 * The MessageState of an AcceptStatusEvent received by [AmsMessages] is null, which should
	 * never happen. Check for LivePerson service outages, and if there are none, contact R&D.
	 */
	ERR_0000007B,

	/**
	 * Text received by [AmsMessages] is empty, which should never happen.
	 * Check for LivePerson service outages, and if there are none, contact R&D.
	 */
	ERR_0000007C,

	/**
	 * [AmsMessages] failed to send a 'read ack' to UMS, noting that the SDK has "seen" messages.
	 * This may cause an Agent to not see message read check marks in LiveEngage. Check for
	 * LivePerson service outages. May also be caused by a poor data connection dropping packets.
	 */
	ERR_0000007D,

	/**
	 * [AmsMessages] failed to send a 'read ack' to Pusher, noting that the SDK has "seen" messages.
	 * This may cause an Agent to not see message read check marks in LiveEngage. Check for
	 * LivePerson service outages. May also be caused by a poor data connection dropping packets.
	 */
	ERR_0000007E,

	/**
	 * [AmsMessages] failed to send a 'read ack', noting that the SDK has "seen" messages.
	 * This may cause an Agent to not see message read check marks in LiveEngage. Check for
	 * LivePerson service outages. May also be caused by a poor data connection dropping packets.
	 */
	ERR_0000007F,

	/**
	 * [AmsMessages] failed to clear the Unread Message Count for a Dialog. This may cause Unread
	 * Message Counts to report higher than reality to the Host App. This could be caused by a poor
	 * data connection dropping packets, or a LivePerson service outage.
	 */
	ERR_00000080,

	/**
	 * [AmsMessages] failed to fetch a map of Conversations, Dialogs, and Unread Message Counts,
	 * preventing it from reporting a count to the Host App. This probably indicates a poor data
	 * connection dropping packets, or a LivePerson service outage.
	 */
	ERR_00000081,

	/**
	 * [AmsMessages] experienced a generic failure in attempting to send message read
	 * acknowledgements to LivePerson services. This is most likely caused by network issues, but
	 * may indicate LivePerson service outages. Check the attached Exception for additional clues.
	 */
	ERR_00000082,

	/**
	 * [AmsMessages] encountered an Exception while loading an old Welcome Message from history.
	 * This may mean data was corrupted on disk in the MySQL database, possibly due to end-user or
	 * Host App tampering. Check the attached Exception for additional details.
	 */
	ERR_00000083,

	/**
	 * [AmsMessages] encountered an Exception while checking if the last message in history is a
	 * Welcome Message. This is most likely due to data corruption of the SDCard / MySQL instance,
	 * possibly due to tampering by the end-user or Host App. Check the attached Exception for
	 * additional details.
	 */
	ERR_00000084,

	/**
	 * [AmsMessages] experienced a generic Exception while updating the most recent Welcome Message
	 * in chat history. Check the included Exception for hints on what might have gone wrong.
	 */
	ERR_00000085,

	/**
	 * [AmsMessages] encountered an Exception while removing the most recent Welcome Message from
	 * history. This may mean the user killed the app unexpectedly, or there is a problem with the
	 * system MySQL instance.
	 */
	ERR_00000086,

	/**
	 * [AmsMessages] encountered an Exception while attempting to retrieve a database row by its
	 * EventID. This is a generic database error; check the attached Exception for details.
	 */
	ERR_00000087,

	/**
	 * [AmsMessages] attempted to update a message by its Row ID, but the message did not exist in
	 * the database. This could mean it was deleted on disk, possibly due to tampering by the
	 * end-user or Host App.
	 */
	ERR_00000088,

	/**
	 * [AmsDialogs] has detected what should be an impossible case; the active Dialog is not open.
	 * This would most likely indicate a LivePerson service outage in which the service sent garbled
	 * data, or an SDK problem.
	 */
	ERR_00000089,

	/**
	 * [AmsDialogs] encountered an Exception while reading Dialogs from the database; this could
	 * indicate the user killed the app unexpectedly, or the MySQL instance on the device
	 * experienced some kind of issue. Check the attached Exception for additional information.
	 */
	ERR_0000008A,

	/**
	 * [AmsDialogs] tried to fetch the current open Dialog, but got an empty list instead. This
	 * could indicate a LivePerson service outage, resulting in strange conversation data payloads,
	 * or an SDK data handling problem.
	 */
	ERR_0000008B,

	/**
	 * [AmsDialogs] tried to fetch the current open Dialog, but got a list that contained only
	 * closed Dialogs instead. This could indicate a LivePerson service outage, resulting in strange
	 * conversation data payloads, or an SDK data handling problem.
	 */
	ERR_0000008C,

	/**
	 * [AmsDialogs] tried to fetch the current open Dialog, but got more than one, which should never
	 * happen. This could indicate a LivePerson service outage, resulting in strange conversation
	 * data payloads, or an SDK data handling problem.
	 */
	ERR_0000008D,

	/**
	 * [ClientProperties] encountered an UnknownHostException while attempting to determine the IP
	 * Address of the device the SDK is running on. This may mean that the device is currently not
	 * connected to any networks, or is changing states.
	 */
	ERR_0000008E,

	/**
	 * [ClientProperties] encountered a JSONException while packaging up client device details for
	 * analytics purposes. This is an unlikely error; please report it to R&D.
	 */
	ERR_0000008F,

	/**
	 * The [FileSharingManager]'s event handler encountered a message type it was not expecting;
	 * contact R&D, and include the unknown message type included with this error report.
	 */
	ERR_00000090,

	/**
	 * [FileSharingManager] failed to create an UploadTask, because the file type for the upload was
	 * not recognized. Contact R&D about this error.
	 */
	ERR_00000091,

	/**
	 * [FileSharingManager] encountered an Exception while handling an upload request, and has
	 * marked the upload as failed. This occurred before the upload went to network, and indicates
	 * an SDK problem. Include the attached Exception and Stacktrace in a ServiceNow ticket to
	 * MobileSDK R&D.
	 */
	ERR_00000092,

	/**
	 * [FileSharingManager] failed to create a ReUploadTask, because the file type for the upload
	 * was not recognized. Contact R&D about this error.
	 */
	ERR_00000093,

	/**
	 * [FileSharingManager] encountered an Exception while handling a re-upload request, and has
	 * marked the re-upload as failed. This occurred before the upload went to network, and indicates
	 * an SDK problem. Include the attached Exception and Stacktrace in a ServiceNow ticket to
	 * MobileSDK R&D.
	 */
	ERR_00000094,

	/**
	 * [FileSharingManager] encountered an Exception while creating a DownloadFileTask because it
	 * could not recognize the file type of the download. Submit a ServiceNow ticket to R&D with the
	 * attached Exception and Stacktrace.
	 */
	ERR_00000095,

	/**
	 * [FileSharingManager] encountered an Exception while creating a DownloadFileTask because it
	 * could not recognize the file type of the download. Submit a ServiceNow ticket to R&D with the
	 * attached unknown type.
	 */
	ERR_00000096,

	/**
	 * [FileSharingManager] attempted to extract an Action and/or File Type from an incoming Intent;
	 * however, either the Action Type or File Type was -1, indicating a type that even the Android
	 * System does not recognize, and thus we cannot proceed. This is most likely because the
	 * end-user selected a file type that is not supported by the Android OS's Intent system, and by
	 * extension, not supported by the SDK.
	 */
	ERR_00000097,

	/**
	 * [FileSharingManager] failed to download a file because the URI pointing to the Swift service
	 * was null or empty in the incoming Intent. This is possibly due to a bad message payload.
	 * Check for LivePerson service outages.
	 */
	ERR_00000098,

	/**
	 * Generic file download error; check the attached Exception and Stacktrace for more clues, or
	 * look for other more-specific error messages in nearby logs.
	 */
	ERR_00000099,

	/**
	 * [FileSharingManager] failed to upload an image because the URI pointing to the Swift service
	 * was null or empty in the incoming Intent. This is possibly due to a bad message payload.
	 * Check for LivePerson service outages.
	 */
	ERR_0000009A,

	/**
	 * Generic file upload error; check the attached Exception and Stacktrace for more clues, or
	 * look for other more-specific error messages in nearby logs. If the Type of the file that
	 * failed to upload looks suspicious, report it to R&D.
	 */
	ERR_0000009B,

	/**
	 * Generic file re-upload error; check the attached Exception and Stacktrace for more clues, or
	 * look for other more-specific error messages in nearby logs. If the Type of the file that
	 * failed to upload looks suspicious, report it to R&D.
	 */
	ERR_0000009C,

	/**
	 * [BackgroundActionsService] received a StartCommand with a -1 (undefined) Action. The service
	 * will start, but the Intent that's starting it will otherwise be dropped.
	 */
	ERR_0000009D,

	/**
	 * An internal process returned a class it shouldn't have; please report this to R&D.
	 */
	ERR_0000009E,

	/**
	 * [MessagingChatMessage] has attempted to determine the ContentType for a message the User is
	 * sending to LivePerson, but the ContentType was returned null. This could be due to strange
	 * text entered by the user, or potentially an internal SDK problem.
	 */
	ERR_0000009F,

	/**
	 * [MessagingChatMessage] has attempted to determine the ContentType for a message the current 
	 * Agent is sending to LivePerson, but the ContentType was returned null. This would most likely
	 * be due to an old version of the SDK that doesn't know about a newer content type, or a 
	 * LivePerson service outage of some kind.
	 */
	ERR_000000A0,

	/**
	 * [MessagingChatMessage] has attempted to unpack an Agent Form from JSON, and failed to do so.
	 * This is most likely because the JSON was malformatted, which could indicate a LivePerson 
	 * service outage, or data corruption in transit or on the SDCard, which could be caused by end-
	 * user or Host App tampering.
	 */
	ERR_000000A1,

	/**
	 * [MessagingChatMessage] has attempted to unpack the Accessibility Message of an Agent Form,
	 * but failed to do so. This is most likely because the JSON was malformatted, which could 
	 * indicate a LivePerson service outage, or data corruption in transit or on the SDCard, which 
	 * could be caused by end-user or Host App tampering.
	 */
	ERR_000000A2,

	/**
	 * [Form] attempted to encode a block of CSS in UTF-8, but the Android System URLEncoder 
	 * rejected the encoding format. This may indicate a system problem, but if it did, most apps
	 * probably also be crashing on this device. Most likely there is a bug in the code. Report to
	 * R&D and include the Exception and Stacktrace attached to this error.
	 */
	ERR_000000A3,

	/**
	 * The [ConnectionStateMachine] encountered a TaskFailedEvent while attempting to perform a 
	 * Connection task, likely resulting in the user not being able to connect to LivePerson. This
	 * could be for any number of reasons, including network outage, LivePerson service outage,
	 * issues with the device's network stack, etc. Check the attached Connection Task Type that
	 * failed, along with the Exception message for additional clues.
	 */
	ERR_000000A4,

	/**
	 * While attempting to establish a connection with an Unauthenticated flow user, the UMS service
	 * has rejected the connection attempt because the Unauth user has expired. This error has
	 * has fallback logic in place, and will attempt to generate a new Unauth user (since Unauth 
	 * users are ephemeral anyway) and try again automatically.
	 */
	ERR_000000A5,

	/**
	 * A secondary connection task in the [ConnectionStateMachine] has failed, likely resulting in 
	 * the user not being able to connect to LivePerson. This could be for any number of reasons, 
	 * including network outage, LivePerson service outage, issues with the device's network stack, 
	 * etc. Check the attached Connection Task Type that failed, along with the Exception message 
	 * for additional clues.
	 */
	ERR_000000A6,

	/**
	 * During error-correction logic for "Zombie Conversations" (Conversations that are open, but
	 * have 0 open dialogs), [SendMessageCommand] experienced a failure to resolve the old Zombie
	 * Conversation, meaning that as far as the SDK can tell, that conversation is still open.
	 * However, it is unlikely that this is truly the case, as UMS should not have gotten into a
	 * state where that could be true. Regardless, the SDK has continued and tried to open a new
	 * Conversation anyway. Disregard this error, *unless* it is followed by an error reporting
	 * a failure to open a new Conversation as well.
	 */
	ERR_000000A7,

	/**
	 * [SendMessageCommand] attempted to send a Message (user pressing Send) but the Dialog that was
	 * meant to receive the Message was in a CLOSED state. This likely means that the Agent resolved
	 * the current Dialog right as the User tried to send a Message. The User's last Message was not
	 * sent.
	 */
	ERR_000000A8,

	/**
	 * [SendMessageCommand] attempted to send a Message (user pressing Send) but the Dialogs
	 * Controller could not find an open Dialog, and thus the message cannot be sent. This likely
	 * means that the Agent resolved the current Dialog right as the User tried to send a Message.
	 * The User's last Message was not sent.
	 */
	ERR_000000A9,

	/**
	 * This is a generic catch-all Exception handler for the [SendFileCommand], which has
	 * encountered an unknown problem while either adding the Message part of a File Upload to the
	 * local database, or while sending the Message. This could mean a vast number of different
	 * errors. Check the attached Exception and Stacktrace for additional clues.
	 */
	ERR_000000AA,

	/**
	 * [NewConversationRequest] attempted to create a new Conversation, but the HTTP response code
	 * for the attempt was not 200-range-OK. Check the attached HTTP response code for clues on what
	 * went wrong.
	 */
	ERR_000000AB,

	/**
	 * [NewConversationRequest] attempted to create a new Conversation, but for an unknown reason
	 * the WebSocket closed before the attempt succeeded. This is most likely due to network error,
	 * but could indicate a LivePerson service outage.
	 */
	ERR_000000AC,

	/**
	 * [NewConversationRequest] received a response in the 400 range or higher, which could indicate
	 * network error, LivePerson service outages, or in extremely rare cases, SDK message formatting
	 * problems.
	 */
	ERR_000000AD,

	/**
	 * While processing a notification of some kind of change to a Conversation, the SDK failed to
	 * parse the change details JSON payload. The SDK is therefore unaware of this change, and may
	 * have desynchronized from what UMS understands as the current Conversation state. This would
	 * most likely be due to a malformatted JSON payload, which is most likely to be caused by a
	 * LivePerson service experiencing an error.
	 */
	ERR_000000AE,

	/**
	 * [SendFileCommand] attempted execution but aborted immediately because the Dialog it was
	 * directed to upload to was null. This error should not happen in production code, and will
	 * require R&D research.
	 */
	ERR_000000AF,

	/**
	 * This is a generic catch-all error for [UploadImageTask], which could be caught either due to
	 * a problem with resizing an image before upload (to meet image upload constraints), or with
	 * saving the resized image to disk (temporary cache) before upload. Check the attached
	 * Exception and Stacktrace for additional clues.
	 */
	ERR_000000B0,

	/**
	 * [UploadImageTask] failed to save a thumbnail image to disk for an unspecified reason, but was
	 * most likely due to file writing issues. This could be caused by restrictive folder permissions
	 * on the destination directory.
	 */
	ERR_000000B1,

	/**
	 * [UploadVoiceTask] failed to read a Voice Clip's byte-array data from disk for upload. This
	 * could be due to restrictive file permissions on the clip in question, but not ones that are
	 * likely to have come from the SDK. This could also mean the file-read operation was
	 * interrupted, but for an unknown reason. Check the attached Exception for additional details.
	 */
	ERR_000000B2,

	/**
	 * [DownloadDocumentTask] encountered a FileNotFoundException while attempting to save a
	 * Document to the SDCard. This could be due to restrictive file permissions on the destination
	 * directory, but those restrictions are not likely to have come from the SDK, and we create
	 * the directory in question. Check the attached Exception and Stacktrace for additional clues.
	 */
	ERR_000000B3,

	/**
	 * [DownloadDocumentTask] encountered a generic IOException while attempting to save a
	 * Document to the SDCard. This could mean the upload was interrupted due to a system issue.
	 * Check the attached Exception and Stacktrace for additional clues on what might have went
	 * wrong.
	 */
	ERR_000000B4,

	/**
	 * [DownloadDocumentTask] failed to create a cache directory for Documents. This could be due to
	 * restrictive folder permissions on the app's root cache directory, which the SDK does not set,
	 * but the Host App could. This means the file will not be downloaded.
	 */
	ERR_000000B5,

	/**
	 * [UploadDocumentTask] failed to copy a file specified by the User for upload into an SDK cache
	 * directory, where it will be uploaded to LivePerson servers. This is a generic catch-all
	 * Exception handler; check the attached Exception and Stacktrace, or nearby error logs for
	 * additional clues.
	 */
	ERR_000000B6,

	/**
	 * [UploadDocumentTask] failed to read a Document's byte-array data into memory for upload. This
	 * most likely means the file-read operation was interrupted for an unknown reason (perhaps the
	 * User killing the app). However, it may mean the SDK failed to read the file from its own
	 * cache directory, which is unlikely unless the file or its parent folder have been tampered
	 * with by the User or Host App.
	 */
	ERR_000000B7,

	/**
	 * [FileSharingUtils] failed to read the File Type of a local file by its URI, which usually
	 * happens when the User attempts to select a File with a system File selector. The Exception
	 * thrown here means the User's requested action cannot be completed. This is a generic error
	 * handler; check the attached Exception and Stacktrace for additional clues.
	 */
	ERR_000000B8,

	/**
	 * [TokenUtils] encountered an unexpected Exception while attempting to check if a JWT is
	 * expired before attempting to use it. This may mean the JWT is malformed, and future attempts
	 * to use it will fail, but can also happen simply because the JWT is encrypted. Check the
	 * attached Exception for additional clues if desired; however, this method has a catch-all
	 * fallback that will simply attempt to use the JWT anyway, assuming that the error is due to
	 * encryption. If a future error is logged because of a failure to authenticate, this error
	 * could help diagnose that issue.
	 */
	ERR_000000B9,

	/**
	 * [TokenUtils] encountered an unexpected Exception while attempting to parse the ConsumerID
	 * from a LivePerson JWT. This is *probably* a critical failure and will prevent the User from
	 * authenticating. The most likely cause for this issue is a malformatted JWT from LivePerson
	 * IDP services, as this is attempting to retrieve our *internal* ConsumerID. Check the attached
	 * Exception and Stacktrace for additional clues.
	 */
	ERR_000000BA,

	/**
	 * [TokenUtils] encountered an unexpected Exception while attempting to parse a secondary User
	 * ID from an authentication JWT. This is likely to cause the user's profile in the chat window
	 * to not render correctly. The most likely cause for this is a malformatted JWT from LivePerson
	 * IDP services, as this is attempting to retrieve our *internal* Consumer details. Check the
	 * attached Exception and Stacktrace for additional details.
	 */
	ERR_000000BB,

	/**
	 * [GeneralMessagingResponseHandler] failed to create a Response because it it couldn't find an
	 * appropriate ResponseHandler for the Event it is trying to respond to. This most likely means
	 * the Event is of an unknown type, which could be due to an outdated SDK that doesn't know
	 * about new message types in UMS. Check the attached unknown type for additional clues.
	 */
	ERR_000000BC,

	/**
	 * An internal response handler encountered an unexpected invalid state while handling a
	 * Conversation Change Notification, where it noticed an existing open Dialog while being
	 * directed to create a *second* open Dialog. UMS should never tell the SDK to do this. This
	 * could mean the SDK missed a previous Notification telling it to close the old Dialog, which
	 * would most likely be caused by network failures.
	 */
	ERR_000000BD,

	/**
	 * An internal response handler encountered an unexpected invalid state while handling a
	 * Conversation Change Notification, where it noticed an existing open Dialog while being
	 * directed to create a *second* open Dialog. UMS should never tell the SDK to do this. This
	 * could mean the SDK missed a previous Notification telling it to close the old Dialog, which
	 * would most likely be caused by network failures.
	 */
	ERR_000000BE,

	/**
	 * An internal response handler encountered an unexpected invalid state while handling a
	 * Conversation Change Notification, where it noticed the existing dialog was not in a CLOSED
	 * state when the SDK was directed to open a new Dialog. UMS should never tell the SDK to do
	 * this. This could mean the SDK missed a previous Notification telling it to close the old
	 * Dialog, which would most likely be caused by network failures.
	 */
	ERR_000000BF,

	/**
	 * An internal response handler encountered an unexpected invalid event, wherein a Conversation
	 * has no Dialogs. This likely indicates a malformed response payload from UMS, perhaps due to a
	 * service outage.
	 */
	ERR_000000C0,

	/**
	 * An internal response handler was directed to close a Dialog that was already closed. This
	 * error alone does not indicate any particular problem, but if seen frequently or in
	 * conjunction with other errors, it may be a clue. The SDK's fallback logic in this case will
	 * simply leave the closed Dialog closed, in exactly the state it should have been in.
	 */
	ERR_000000C1,

	/**
	 * While attempting to request that UMS close the current Dialog, the SDK received a response
	 * that was not 200-range-OK. This could happen for any number of reasons, mostly network
	 * failures, but could mean a LivePerson service outage, or a malformatted SDK payload. Check
	 * the response code attached to this error for additional information.
	 */
	ERR_000000C2,

	/**
	 * While attempting to determine the Clock Drift between the SDK and LivePerson servers,
	 * [ClockRequest] encountered JSON that it could not parse, and the calculation attempt has
	 * failed.
	 */
	ERR_000000C3,

	/**
	 * Generic catch-all response handler for parsing the result of a request to Inca for historical
	 * Conversations. Check for other errors that may have more specific details about the failure,
	 * such as JSON parsing, or the Exception and Stacktrace included with this error.
	 */
	ERR_000000C4,

	/**
	 * The SDK received a failure notification for an attempt to ask Inca for historical
	 * Conversation data. This failure may be due to network error or internal Exception. Look for
	 * nearby errors that may provide additional clues, or the Exception and Stacktrace attached to
	 * this error for additional details, if present.
	 */
	ERR_000000C5,

	/**
	 * [AgentProfileRequest] encountered an unspecified Exception or Error while fetching an Agent's
	 * Profile. This is most likely due to malformatted JSON from a LivePerson service, or network
	 * failure, but the attached Exception and Stacktrace should indicate the root cause for certain.
	 */
	ERR_000000C6,

	/**
	 * [IdpRequest] attempted to authenticate a User, but both the hostAppJWT (Implicit Flow) and
	 * authKey (Code Flow) were empty or null, indicating a lack of authentication details to
	 * authenticate with. The SDK cannot continue with authentication. This is most likely caused
	 * by a Host App not passing in authentication details for their users properly.
	 */
	ERR_000000C7,

	/**
	 * An IDP task has failed, and the SDK is about to notify the Host App. This is a generic error
	 * reporter and could mean a number of different failures, including IDP service outages or
	 * network failure, but could also mean an invalid Pinning Certificate (the attached Exception
	 * will say so if this is the case), or bad authentication details.
	 */
	ERR_000000C8,

	/**
	 * While preparing a request JSON payload for Auth Code flow, the SDK encountered an unexpected
	 * JSONException. This is highly unlikely to occur, and will require R&D research. Include the
	 * attached Exception and Stacktrace in the error report.
	 */
	ERR_000000C9,

	/**
	 * While preparing a request JSON payload for Implicit flow, the SDK encountered an unexpected
	 * JSONException. This is highly unlikely to occur, and will require R&D research. Include the
	 * attached Exception and Stacktrace in the error report.
	 */
	ERR_000000CA,

	/**
	 * An unexpected JSONException was encountered while parsing a theoretically-successful request
	 * to Inca for message history. This probably means the response payload returned from INCA was
	 * malformatted, which is most likely to be due to a service outage.
	 */
	ERR_000000CB,

	/**
	 * [QueryMessagesINCACommand] attempted to fetch message history, but received an error
	 * response. This is most likely due to network failure or service outage, but could in rare
	 * cases indicate a malformed request by the SDK. Check the attached Exception and Stacktrace
	 * for additional clues.
	 */
	ERR_000000CC,

	/**
	 * [QueryMessagesINCACommand] encountered a ContentEventNotification that did not include a
	 * valid DialogID, which is required for SDK operation. This class will attempt to use the
	 * Conversation ID as the Dialog ID and hope that UMS still supports Conversations as Dialogs as
	 * a fallback / legacy-support API.
	 */
	ERR_000000CD,

	/**
	 * [QueryMessagesINCACommand] encountered an empty list of messages while parsing a response
	 * from Inca. This most likely happened due to some sort of service outage at LivePerson,
	 * specifically Inca or its related services.
	 */
	ERR_000000CE,

	/**
	 * [IncaGetFileUrlRequest] attempted to get a File URL from message history for a document that
	 * was shared in the past. However, the request resulted in an error, possibly due to network
	 * failure, but could mean a malformatted payload, or the SDK attempted to use a bad identifier
	 * sent to it by Inca in a previous message. Inspecting the attached Exception and Stacktrace
	 * should reveal additional information.
	 */
	ERR_000000CF,

	/**
	 * [UnAuthRequest] attempted to package a previous authentication attempt's id_token into JSON
	 * for a re-authentication call, but encountered a JSONException while doing so. This should
	 * never happen due to how safe this code should be; will require R&D research. Include the
	 * attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_000000D0,

	/**
	 * While parsing response data from Inca for historical conversations, the SDK encountered a
	 * JSONException, which usually means the SDK failed to parse the response JSON from Inca. This
	 * is most likely due to service outage, though in rare cases network error could garble the
	 * payload as well.
	 */
	ERR_000000D1,

	/**
	 * [AcUserData] has encountered a JSONException while attempting to parse user details for an
	 * Agent. This most likely means that the response payload was malformed, and cannot be parsed.
	 * This likely means that an Agent's profile information may not display correctly to users, and
	 * will not be reported to the Host App correctly on click events.
	 */
	ERR_000000D2,

	/**
	 * An SDK callback class failed to register for Local Broadcasts, which the SDK uses to notify
	 * itself of the internet connecting and disconnecting. This failure will probably break
	 * significant SDK functionality. R&D research will be required.
	 */
	ERR_000000D3,

	/**
	 * [SendMessageWithURLCommand] failed to package message data into a JSON String for sending to
	 * LivePerson services. This should never happen, as this code is extremely safe, and thus will
	 * require R&D research.
	 */
	ERR_000000D4,

	/**
	 * While attempting to extract the original text of a Message that previously failed to send,
	 * the SDK encountered an unexpected Exception during JSON parsing. These messages originate
	 * inside the SDK and thus this error will probably require R&D research. However, it is
	 * *possible* that this could be caused by the User entering strange data in the text box.
	 * Regardless, as always include the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_000000D5,

	/**
	 * While attempting to ask UMS for what it thinks is the number of unread messages, the SDK
	 * encountered an unexpected Exception while parsing a theoretically-successful request. This
	 * most likely means the payload from UMS is malformatted, either due to service outage, or in
	 * rare cases, perhaps network failure.
	 */
	ERR_000000D6,

	/**
	 * While attempting to ask UMS for what it thinks is the number of unread messages, the SDK
	 * encountered an error response. This is likely due to HTTP error, such as would be the case if
	 * the network connection were lost, the network dropped packets, or during a LivePerson service
	 * outage.
	 */
	ERR_000000D7,

	/**
	 * [UnAuthGetEngagementTask] attempted to execute, but the MonitoringFactory instance was not
	 * initialized, preventing further execution. This state should never occur, and will require
	 * R&D research.
	 */
	ERR_000000D8,

	/**
	 * [GetUnreadMessagesCountCommand] failed to successfully make and send a request for the
	 * current unread messages count. This could be because one of the required resources was not
	 * available when this request was made (such as an auth token), but this is unlikely during
	 * normal operation of the SDK. The most likely cause is the User or Host App clearing all
	 * SharedPreferences files while the SDK is running.
	 */
	ERR_000000D9,

	/**
	 * [GetUnreadMessagesCountCommand] encountered an unexpected Exception while sending. This could
	 * be due to failure to authenticate, which might mean the User's auth token has expired. If
	 * that is the case, the User should be re-authenticated shortly, and this request will be
	 * re-tried. However, check the attached Exception for clues on what went wrong; if it was not a
	 * simple auth failure, it could indicate more serious problems.
	 */
	ERR_000000DA,

	/**
	 * The Pusher service returned an empty response, preventing [GetUnreadMessagesCountCommand]
	 * from being able to return an unread message count. The most likely cause of this is a Pusher
	 * service outage of some kind, or in rarer cases, network failure.
	 */
	ERR_000000DB,

	/**
	 * The Pusher service returned an error to [GetUnreadMessagesCountCommand] while it was
	 * attempting to get the unread messages count. This error could be due to a number of reasons,
	 * but this particular error handler does not differentiate between them; check the attached
	 * Exception and Stacktrace, if available, along with the response code and internal code for
	 * more clues.
	 */
	ERR_000000DC,

	/**
	 * [GetUnreadMessagesCountCommand] failed to parse a result payload from the Pusher service,
	 * preventing it from returning an unread message count. The most likely reason for this is
	 * malformatted JSON from the Pusher service, indicating a service outage. However, in rarer
	 * cases, network failure could also be responsible.
	 */
	ERR_000000DD,

	/**
	 * [SendReadAcknowledgementCommand] received an empty response from the Pusher service when it
	 * attempted to notify Pusher that a User had read some messages. The most likely reason for
	 * empty responses is generally service failure, though in rarer cases it could mean network
	 * failure.
	 */
	ERR_000000DE,

	/**
	 * [SendReadAcknowledgementCommand] encountered a JSONException while attempting to parse a
	 * response from Pusher after notifying it that a User had read some messages. The most likely
	 * reason for this is malformatted JSON, which generally indicates service failure, though in
	 * rarer cases it could mean network failure.
	 */
	ERR_000000DF,

	/**
	 * The Pusher service returned an error to [SendReadAcknowledgementCommand] while it was
	 * attempting to notify Pusher that a User had read some messages. This error could be due to a
	 * number of problems, but this particular error handler does not differentiate between them;
	 * check the attached Exception and Stacktrace, if available, along with the response code and
	 * internal code for more clues.
	 */
	ERR_000000E0,

	/**
	 * [SendReadAcknowledgementCommand] encountered an unexpected Exception while attempting to
	 * parse a response from Pusher after notifying it that a User had read some messages, and the
	 * pusher had already begun to notify us of failure. This means that the Pusher request failed,
	 * additionally we failed to parse the message telling us why. The most likely reason for this
	 * is malformatted JSON, which generally indicates service failure, though in rarer cases it
	 * could mean network failure.
	 */
	ERR_000000E1,

	/**
	 * [SendReadAcknowledgementCommand] encountered an unexpected Exception while packaging Consumer
	 * and Conversation IDs for a request to Pusher. This should never happen, as the related code
	 * is relatively safe, and will require R&D research.
	 */
	ERR_000000E2,

	/**
	 * [CloseDialogCommand] detected that it was directed to close a Dialog that is not the Active
	 * Dialog, which is not something it should ever be directed to do, and is dropping the request.
	 * This could be caused by race conditions wherein the User and Agent attempted to close the
	 * same Dialog at the same time. This error thus does not indicate a problem unless there are
	 * other related errors in the logs and/or the User is experiencing symptoms of this error.
	 */
	ERR_000000E3,

	/**
	 * [CloseDialogCommand] detected that it was directed to close a Dialog, but there are no active
	 * Dialogs, and is therefore  dropping the request. This could be caused by race conditions
	 * wherein the User and Agent attempted to close the same Dialog at the same time. This error
	 * thus does not indicate a problem unless there are other related errors in the logs and/or the
	 * User is experiencing symptoms of this error.
	 */
	ERR_000000E4,

	/**
	 * [SendSetUserProfileCommand] attempted to execute, but noticed it was not given a BrandID,
	 * which is required for it to succeed. The command will therefore terminate immediately without
	 * setting the User Profile, and UMS will not be notified. Most likely this will cause the
	 * User's profile information to not appear correctly in LiveEngage.
	 */
	ERR_000000E5,

	/**
	 * [SecuredFormFragment] received a PCIMessage, indicating that the contained WebView wants the
	 * Fragment to perform some behavior. However, the JSON payload delivered by the WebView could
	 * not be parsed (JSONException). The most likely reason for this is the web page loaded by the
	 * WebView is somehow broken due to a LivePerson service outage, and generating malformed JSON.
	 */
	ERR_000000E6,

	/**
	 * [ConversationFragment] attempted to start its BackgroundService, but encountered an
	 * unexpected Exception. The precise reason is unknown to this error handler; check the attached
	 * Exception and Stacktrace for additional clues.
	 */
	ERR_000000E7,

	/**
	 * [ConversationFragment] attempted to stop its BackgroundService, but encountered an
	 * unexpected Exception. The precise reason is unknown to this error handler; check the attached
	 * Exception and Stacktrace for additional clues.
	 */
	ERR_000000E8,

	/**
	 * [ConversationFragment] received a Permission Request callback from the Android System, but
	 * was unable to determine the request state based on the data returned. This would be a very
	 * strange error to encounter in Production, and would mean a system API is returning unexpected
	 * results. It is possible the SDK has been targeted to a newer ABI than this code accounts for.
	 */
	ERR_000000E9,

	/**
	 * [ConversationFragment] received an IOException while attempting to start the Camera for
	 * eventual photo upload. This error probably came from a system call, and is going to require
	 * R&D research; please include the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_000000EA,

	/**
	 * [ConversationFragment] attempted to process an incoming Intent that claims to be a successful
	 * selection of a photo for upload to an Agent. However, when the photo data was inspected, it
	 * was empty. This is a very strange error indicating the Android System returned us a null
	 * image, and as such is likely to require R&D research.
	 */
	ERR_000000EB,

	/**
	 * [ConversationFragment] attempted to process an incoming Intent that claims to be a successful
	 * capture of a photo for upload to an Agent. However, when the photo data was inspected, the
	 * URI String was empty. The String is set by an SDK process and removed on a returning Intent,
	 * but could have been destroyed by the User or Host App clearing Preferences storage.
	 */
	ERR_000000EC,

	/**
	 * [ConversationFragment] is moving to a Background state during Unauth flow, but while
	 * attempting to clear history on exit, the Database subsystem threw an unexpected Exception and
	 * some data may not have been erased. This error is self-healing, and will fix itself the next
	 * time the ConversationFragment is shown and hidden, thus re-running this code.
	 */
	ERR_000000ED,

	/**
	 * [ConversationFragment] attempted to save a file to a public Downloads directory, but instead
	 * caught an unexpected Exception. The file was probably not saved to any public directories,
	 * and the User would see this error as a Download feature not working as expected. The root
	 * cause of the error is unknown to this error handler; check the attached Exception and
	 * Stacktrace for additional details.
	 */
	ERR_000000EE,

	/**
	 * [ConversationFragment] attempted to resolve an Open Link Intent, allowing other applications
	 * on the device to respond to the User clicking on a link from our code. Most often, this will
	 * cause either a system default web browser (Chrome, Firefox) to open and load the link, or the
	 * Host App in the case of a deep link, another app in the event of, for example, a social media
	 * link, the Dialer if a 'tel:' link, the system default email client (Gmail, Thunderbird) if a
	 * 'mailto:' link, etc. However, it instead received an unexpected Exception. This most likely
	 * means the Android System failed to resolve an app that can handle the Open Link intent,
	 * perhaps because the User cancelled the operation.
	 */
	ERR_000000EF,

	/**
	 * While attempting to show a Permission Request dialog, [ConversationFragment] encountered an
	 * unexpected Exception in UI code. This likely means the permissions dialog did not appear, and
	 * the User would see this as a button in the UI failing to respond. This will require R&D
	 * research; please include the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_000000F0,

	/**
	 * While attempting to show an Error Dialog, the [ConversationFragment] encountered an
	 * unexpected Exception while creating and displaying the dialog. This means the User will not
	 * be notified of some other failure of the SDK. This will require R&D research;
	 * please include the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_000000F1,

	/**
	 * A central Message List Adapter attempted to perform an OnFileClicked event in response to the
	 * User tapping on an Image Message. However, the handler stack for the click returned an
	 * unexpected Exception. The User would see this as the UI failing to respond to a tap event.
	 * This will require R&D research; please include the attached Exception and Stacktrace in the
	 * ServiceNow ticket.
	 */
	ERR_000000F2,

	/**
	 * [MessagesAsListAdapter] attempted to handle an onClick event for a File Message, but
	 * encountered a File Sharing type that it did not recognize, and cannot continue handling what
	 * it does not know. This could be because the User selected a file type we don't support; see
	 * the attached unknown type to check. Otherwise, This will require R&D research; please include
	 * the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_000000F3,

	/**
	 * A central Message List Adapter attempted to perform an OnFileClicked event in response to the
	 * User tapping on an Agent File Message. However, the handler stack for the click returned an
	 * unexpected Exception. The User would see this as the UI failing to respond to a tap event.
	 * This will require R&D research; please include the attached Exception and Stacktrace in the
	 * ServiceNow ticket.
	 */
	ERR_000000F4,

	/**
	 * The loaded on-foreground Scrolling Strategy was not one of the three recognized strategies
	 * (LastPosition, Bottom, or FirstUnreadMessage (case not sensitive)), and as such the SDK will
	 * not auto-scroll to any position. This is most likely due to a malformed value for branding
	 * key 'lp_scroll_when_foreground'. Check the attached strategy name for clues.
	 */
	ERR_000000F5,

	/**
	 * The loaded on-host-app-nav Scrolling Strategy was not one of the three recognized strategies
	 * (LastPosition, Bottom, or FirstUnreadMessage (case not sensitive)), and as such the SDK will
	 * not auto-scroll to any position. This is most likely due to a malformed value for branding
	 * key 'lp_scroll_show_conversation'. Check the attached strategy name for clues.
	 */
	ERR_000000F6,

	/**
	 * The loaded on-push Scrolling Strategy was not one of the three recognized strategies
	 * (LastPosition, Bottom, or FirstUnreadMessage (case not sensitive)), and as such the SDK will
	 * not auto-scroll to any position. This is most likely due to a malformed value for branding
	 * key 'lp_scroll_when_push_notification'. Check the attached strategy name for clues.
	 */
	ERR_000000F7,

	/**
	 * The loaded on-scroll-btn Scrolling Strategy was not one of the three recognized strategies
	 * (LastPosition, Bottom, or FirstUnreadMessage (case not sensitive)), and as such the SDK will
	 * not auto-scroll to any position. This is most likely due to a malformed value for branding
	 * key 'lp_scroll_when_scroll_down'. Check the attached strategy name for clues.
	 */
	ERR_000000F8,

	/**
	 * During an attempt to remove Quick Reply messages from a Dialog, [MessagesAsListLoader]
	 * noticed that there is no active Dialog, and thus cannot continue. This could have occurred
	 * due to a race condition wherein the User and Agent closed a Dialog at the same time.
	 */
	ERR_000000F9,

	/**
	 * During an attempt to remove Quick Replies messages from a Conversation, [MessagesAsListLoader]
	 * noticed that there are multiple active Dialogs for the current Conversation, which should
	 * never occur. This probably indicates some kind of service outage with UMS, such that it is
	 * sending invalid data.
	 */
	ERR_000000FA,

	/**
	 * [MessagesAsListLoader] was loading messages when it managed to attempt to access an index
	 * beyond the end of the data set size. See the attached indices for clues. This error will
	 * likely require R&D research; include the indices in the ServiceNow ticket.
	 */
	ERR_000000FB,

	/**
	 * [MessagesAsListLoader] was fetching a single item when it managed to attempt to access an
	 * index beyond the end of the data set size. See the attached indices for clues. This error
	 * will likely require R&D research; include the indices in the ServiceNow ticket.
	 */
	ERR_000000FC,

	/**
	 * [MessagesAsListLoader] was fetching the timestamp for an item when it managed to attempt to
	 * access an index beyond the end of the data set size. See the attached indices for clues. This
	 * error will likely require R&D research; include the indices in the ServiceNow ticket.
	 */
	ERR_000000FD,

	/**
	 * [MessagesAsListLoader] encountered an IndexOutOfBoundsException while attempting to merge new
	 * messages into the existing already-displayed list. The invalid index and list size are
	 * attached; please include them in a ServiceNow ticket to R&D.
	 */
	ERR_000000FE,

	/**
	 * [MessagesAsListLoader] encountered an IndexOutOfBoundsException while handling new unread
	 * messages. The invalid index and list size are attached; please include them in a ServiceNow
	 * ticket to R&D.
	 */
	ERR_000000FF,

	/**
	 * [MessagesAsListLoader] attempted to handle an unread message, but detected the conversation
	 * might be actively resolving at the time, and tried to check before potentially dropping the
	 * notification. However, it discovered that the RecyclerView's data set was empty, and thus is
	 * unable to check for sure, so it will continue on with the current operation anyway, just in
	 * case it's needed. The user probably did not notice anything; however, please alert R&D to the
	 * issue, and include the NullPointerException and its Stacktrace with the ServiceNow ticket.
	 */
	ERR_00000100,

	/**
	 * [MessagesAsListLoader] attempted to handle unread messages, but encountered an
	 * IndexOutOfBoundsException that it was able to catch and prevent from affecting the User's
	 * experience. However, this still indicates a flaw in logic and should be addressed; please
	 * include the attached array indices in a ServiceNow ticket to R&D.
	 */
	ERR_00000101,

	/**
	 * [MessagesAsListLoader], while attempting to change the Unread Message Position, encountered an
	 * IndexOutOfBoundsException, indicating that it cannot continue processing because it has made
	 * a mistake. Include the attached bad index and data set size in a ServiceNow ticket to R&D.
	 */
	ERR_00000102,

	/**
	 * While processing Unread Message Changes, [MessagesAsListLoader] encountered an
	 * IndexOutOfBoundsException, preventing it from processing further. Please include the attached
	 * bad index plus the data set size in a ServiceNow ticket to R&D.
	 */
	ERR_00000103,

	/**
	 * While updating Unread Messages, [MessagesAsListLoader] encountered an
	 * IndexOutOfBoundsException, preventing it from continuing processing. The user may not see the
	 * "unread messages" indicator appear. Please include the attached bad index plus the data set
	 * size in a ServiceNow ticket to R&D.
	 */
	ERR_00000104,

	/**
	 * While adding Unread Messages, [MessagesAsListLoader] encountered an
	 * IndexOutOfBoundsException, preventing it from continuing processing. The user may not see the
	 * "unread messages" indicator appear. Please include the attached bad index plus the data set
	 * size in a ServiceNow ticket to R&D.
	 */
	ERR_00000105,

	/**
	 * While adding Messages to the Loader Dataset, [MessagesAsListLoader] encountered an
	 * IndexOutOfBoundsException, preventing it from continuing processing. The user may not see the
	 * "unread messages" indicator appear. Please include the attached bad index plus the data set
	 * size in a ServiceNow ticket to R&D.
	 */
	ERR_00000106,

	/**
	 * While adding multiple Messages to the Loader Dataset, [MessagesAsListLoader] encountered an
	 * IndexOutOfBoundsException, preventing it from continuing processing. The user may not see the
	 * "unread messages" indicator appear. Please include the attached bad index plus the data set
	 * size in a ServiceNow ticket to R&D.
	 */
	ERR_00000107,

	/**
	 * While removing items from the Loader Dataset, [MessagesAsListLoader] encountered an
	 * IndexOutOfBoundsException, preventing it from continuing processing. The user may not see the
	 * "unread messages" indicator appear. Please include the attached bad index plus the data set
	 * size in a ServiceNow ticket to R&D.
	 */
	ERR_00000108,

	/**
	 * [ConversationInBackgroundService] attempted to clear conversation data on-exit (due to auth
	 * settings), but encountered an unexpected Exception, and had to stop. Some conversation data
	 * may still remain. This error is likely self-healing, and will clear all data on next exit,
	 * but could indicate a serious problem if seen repeatedly.
	 */
	ERR_00000109,

	/**
	 * [PushMessageParser] failed to parse a message from Pusher. This most likely means the payload
	 * was malformatted when it left the Pusher service, indicating an outage. However, it could
	 * mean an older SDK that doesn't know about a new message type from Pusher. If this looks like
	 * a bug and Pusher is working correctly, please include the attached Exception and Stacktrace
	 * in the ServiceNow ticket.
	 */
	ERR_0000010A,

	/**
	 * [PushMessageParser] failed to parse a [Bundle] to create a [PushMessage] for an unknown
	 * reason. These bundles can come from the Host App; double-check to make sure any Push Messages
	 * forwarded to the SDK by the Host App are well-formed. If this appears to be an SDK-internal
	 * Bundle, please include the attached Exception and Stacktrace in the ServiceNow ticket.
	 */
	ERR_0000010B,

	/**
	 * [MessagingUi] was told to shut down, but the ForegroundService indicated that the app is
	 * currently in the foreground, and thus MessagingUi is still needed; as such, it will abort the
	 * shutdown attempt. This probably requires investigation by R&D.
	 */
	ERR_0000010C,

	/**
	 * [AmsConsumerFormSubmissionViewHolder] attempted to parse a Form JSON payload in order to
	 * display an in-conversation preview of the Form and its title. However, it encountered an
	 * unexpected JSONException while parsing the payload. This likely means a LivePerson service is
	 * experiencing an outage and sending malformed payloads.
	 */
	ERR_0000010D,

	/**
	 * [AmsAgentURLViewHolder] has both failed to parse JSON and its own History in order to produce
	 * a valid message for display. This most likely means the JSON was empty or malformed, and was
	 * thus not stored in history, then the ViewHolder tried to parse it again here. Check for
	 * LivePerson service outages that might result in a malformed JSON payload.
	 */
	ERR_0000010E,

	/**
	 * [AmsAgentURLViewHolder] received non-null data, but what it received was not sufficient to
	 * produce a valid displayable message. This error should have been logged with the original
	 * JSON intact; check its contents for clues. Malformatted or missing JSON generally indicates a
	 * LivePerson service outage.
	 */
	ERR_0000010F,

	/**
	 * [AmsConsumerURLViewHolder] has both failed to parse JSON and its own History in order to
	 * produce a valid message for display. This most likely means the JSON was empty or malformed,
	 * and was thus not stored in history, then the ViewHolder tried to parse it again here. Check
	 * for LivePerson service outages that might result in a malformed JSON payload.
	 */
	ERR_00000110,

	/**
	 * [AmsConsumerURLViewHolder] received non-null data, but what it received was not sufficient to
	 * produce a valid displayable message. This error should have been logged with the original
	 * JSON intact; check its contents for clues. Malformatted or missing JSON generally indicates a
	 * LivePerson service outage.
	 */
	ERR_00000111,

	/**
	 * [AmsConsumerFileViewHolder] attempted to set the message image before display to the User,
	 * but encountered an unexpected Exception, resulting in an empty-looking UI. This Exception
	 * could mean the URL it received was malformed, or an internal SDK issue. Check the attached
	 * Exception for clues.
	 */
	ERR_00000112,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.showConversation], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_00000113,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.showConversation], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_00000114,

	/**
	 * The Host App has called [LivePerson.showConversation] before calling [LivePerson.initialize],
	 * preventing this method from completing. It will cease executing immediately and not show any
	 * UI.
	 */
	ERR_00000115,

	/**
	 * The Host App has called [LivePerson.hideConversation] while the SDK is not initialized,
	 * preventing this method from completing. It will cease executing immediately and not hide any
	 * UI. However, since there would be no way to show the UI without initializing the SDK, this
	 * method was probably called in error while the UI was not showing.
	 */
	ERR_00000116,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.getConversationFragment], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_00000117,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.getConversationFragment], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_00000118,

	/**
	 * The Host App has called [LivePerson.getConversationFragment] before calling initialize,
	 * preventing this method from completing. It will cease executing immediately and not return
	 * a Fragment.
	 */
	ERR_00000119,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.reconnect], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_0000011A,

	/**
	 * The Host App has called [LivePerson.reconnect] while the SDK is not initialized,
	 * preventing this method from completing. It will cease executing immediately and not reconnect.
	 * However, since there would be no way to be connected without initializing the SDK, this
	 * method was probably called in error while the messaging system was not in use.
	 */
	ERR_0000011B,

	/**
	 * The Host App has called [LivePerson.reconnect] while the SDK is not initialized,
	 * preventing this method from completing. It will cease executing immediately and not reconnect.
	 * However, since there would be no way to be connected without initializing the SDK, this
	 * method was probably called in error while the messaging system was not in use.
	 */
	ERR_0000011C,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.registerLPPusher], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_0000011D,

	/**
	 * The Host App has called [LivePerson.registerLPPusher] before calling [LivePerson.initialize],
	 * preventing this method from completing. It will cease executing immediately and not register
	 * for pushes.
	 */
	ERR_0000011E,

	/**
	 * The Host App has called [LivePerson.registerLPPusher] before calling [LivePerson.initialize],
	 * preventing this method from completing. It will cease executing immediately and not register
	 * for pushes.
	 */
	ERR_0000011F,

	/**
	 * The Host App has called [LivePerson.updateTokenInBackground] before calling initialize,
	 * preventing this method from completing. It will cease executing immediately and not update
	 * any tokens.
	 */
	ERR_00000120,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.unregisterLPPusher], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_00000121,

	/**
	 * The Host App has called [LivePerson.unregisterLPPusher] before calling initialize,
	 * preventing this method from completing. It will cease executing immediately and not unregister
	 * from pushes.
	 */
	ERR_00000122,

	/**
	 * The Host App has called [LivePerson.unregisterLPPusher] before calling initialize,
	 * preventing this method from completing. It will cease executing immediately and not unregister
	 * from pushes.
	 */
	ERR_00000123,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.handlePush], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_00000124,

	/**
	 * The Host App has called [LivePerson.handlePush] without a BrandID, preventing this method
	 * from completing. It will cease executing immediately and not handle the incoming push message.
	 */
	ERR_00000125,

	/**
	 * The Host App has called [LivePerson.handlePush] without a BrandID, preventing this method
	 * from completing. It will cease executing immediately and not handle the incoming push message.
	 */
	ERR_00000126,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.getNumUnreadMessages], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_00000127,

	/**
	 * The Host App has called [LivePerson.getNumUnreadMessages] without a BrandID, preventing this
	 * method from completing. It will cease executing immediately and return -1 instead of the
	 * count.
	 */
	ERR_00000128,

	/**
	 * The Host App has called [LivePerson.getNumUnreadMessages] before calling initialize,
	 * preventing this method from completing. It will cease executing immediately and not return
	 * any message counts.
	 */
	ERR_00000129,

	/**
	 * The Host App has called [LivePerson.getUnreadMessagesCount] before calling initialize,
	 * preventing this method from completing. It will cease executing immediately and not return
	 * any message counts.
	 */
	ERR_0000012A,

	/**
	 * The Host App has called [LivePerson.getUnreadMessagesCount] before calling initialize,
	 * preventing this method from completing. It will cease executing immediately and not return
	 * any message counts.
	 */
	ERR_0000012B,

	/**
	 * The Host App has called [LivePerson.setCallback] before calling [LivePerson.initialize],
	 * preventing this method from completing. It will cease executing immediately and not accept
	 * the incoming callback.
	 */
	ERR_0000012C,

	/**
	 * The Host App has called [LivePerson.removeCallBack] while the SDK is not initialized,
	 * preventing this method from completing. It will cease executing immediately and not remove
	 * any callbacks. However, since there would be no way to have a callback registered without
	 * initializing the SDK, this method was probably called in error while the messaging system was
	 * not in use.
	 */
	ERR_0000012D,

	/**
	 * The Host App has called a Deprecated version of [LivePerson.setUserProfile], and have
	 * thus triggered this error as a warning. This can be fixed by the client devs updating their
	 * code to use the newer version of the same API.
	 */
	ERR_0000012E,

	/**
	 * The Host App has called [LivePerson.setUserProfile] before calling [LivePerson.initialize],
	 * preventing this method from completing. It will cease executing immediately and not accept
	 * the incoming User Profile.
	 */
	ERR_0000012F,

	/**
	 * The Host App has called [LivePerson.setUserProfile] before calling [LivePerson.initialize],
	 * preventing this method from completing. It will cease executing immediately and not accept
	 * the incoming User Profile.
	 */
	ERR_00000130,

	/**
	 * The Host App has called [LivePerson.checkActiveConversation] while the SDK is not initialized,
	 * preventing this method from completing. It will cease executing immediately and not check
	 * for conversations. However, since there would be no way to have a conversation going without
	 * initializing the SDK, this method was probably called in error while the messaging system was
	 * not in use.
	 */
	ERR_00000131,

	/**
	 * The Host App has called [LivePerson.checkConversationIsMarkedAsUrgent] while the SDK is not
	 * initialized, preventing this method from completing. It will cease executing immediately and
	 * not check any conversations. However, since there would be no way to have a conversation going
	 * without initializing the SDK, this method was probably called in error while the messaging
	 * system was not in use.
	 */
	ERR_00000132,

	/**
	 * The Host App has called [LivePerson.checkAgentID] while the SDK is not initialized, preventing
	 * this method from completing. It will cease executing immediately and not return any agent
	 * information. However, since there would be no way to have a conversation going without
	 * initializing the SDK, this method was probably called in error while the messaging system was
	 * not in use.
	 */
	ERR_00000133,

	/**
	 * The Host App has called [LivePerson.markConversationAsUrgent] while the SDK is not initialized,
	 * preventing this method from completing. It will cease executing immediately and not mark any
	 * conversations as urgent. However, since there would be no way to have a conversation going
	 * without initializing the SDK, this method was probably called in error while the messaging
	 * system was not in use.
	 */
	ERR_00000134,

	/**
	 * The Host App has called [LivePerson.markConversationAsNormal] while the SDK is not initialized,
	 * preventing this method from completing. It will cease executing immediately and not mark any
	 * conversations as normal. However, since there would be no way to have a conversation going
	 * without initializing the SDK, this method was probably called in error while the messaging
	 * system was not in use.
	 */
	ERR_00000135,

	/**
	 * The Host App has called [LivePerson.resolveConversation] while the SDK is not initialized,
	 * preventing this method from completing. It will cease executing immediately and not mark any
	 * conversations as resolved. However, since there would be no way to have a conversation going
	 * without initializing the SDK, this method was probably called in error while the messaging
	 * system was not in use.
	 */
	ERR_00000136,

	/**
	 * The Host App has called [LivePerson.setUserProfile] without calling [LivePerson.initialize],
	 * preventing this method from completing. It will cease executing immediately and not clear any
	 * history.
	 */
	ERR_00000137,

	/**
	 * The Host App has called [LivePerson.shutDown] while the SDK is not initialized,
	 * preventing this method from completing. It will cease executing immediately and not shut down.
	 * However, since there would be no way to have a conversation going or be active without
	 * initializing the SDK, this method was probably called in error while the messaging system was
	 * not in use.
	 */
	ERR_00000138,

	/**
	 * The Host App has called [LivePerson.isPusherRegistered] before calling [LivePerson.initialize],
	 * preventing this method from completing. It will cease executing immediately and not check for
	 * push registrations.
	 */
	ERR_00000139,

	/**
	 * The Host App has called [LivePerson.setPushNotificationTapped] before calling initialize,
	 * preventing this method from completing. It will cease executing immediately and not react to
	 * the Push Notification tap event.
	 */
	ERR_0000013A,

	/**
	 * [AuthRequest] encountered an unknown authType (not one of UNAUTH, SIGNUP),
	 * and cannot authenticate. Check the LPAuthenticationParams supplied by the Host App, and
	 * ensure it is well-formed. If it is working, include the attached unrecognized AuthType in a
	 * ServiceNow ticket to R&D.
	 */
	ERR_0000013B,

	/**
	 * [AuthRequest] attempted to authenticate via Unauth or Signup, but failed to parse the
	 * response. This most likely means the response payload was not well-formed; check for IDP or
	 * related service outages.
	 */
	ERR_0000013C,

	/**
	 * [AuthRequest] attempted to build a request payload, but failed in constructing it. This
	 * will likely require R&D research; please include the attached Exception and Stacktrace in a
	 * ServiceNow ticket to R&D.
	 */
	ERR_0000013D,

	/**
	 * [AuthRequest] attempted to generate a Request URL to make an authentication request, but
	 * failed to do so. This could be due to a failed upstream CSDS request; check for other errors
	 * in the logs and for service outages. Otherwise, this will require R&D research; please
	 * include the attached Exception and Stacktrace in a ServiceNow ticket to R&D.
	 */
	ERR_0000013E,

	/**
	 * [AuthRequest] has encountered an error, and is returning the Auth Failure to the Host App.
	 * This error is being logged here as a record of the event, and does not mean additional
	 * failure beyond what other errors may be present in the logs. Use the attached Auth Failure
	 * Reason and Exception/Stacktrace to help determine what may have gone wrong.
	 */
	ERR_0000013F,

	/**
	 * [AuthRequest] attempted to send an error callback to the Host App, but failed to do so, and
	 * was forced to terminate processing. However, it will still notify the Host App of the
	 * failure; the reason will simply be UNKNOWN instead of something more specific. Look for other
	 * errors in the logs, and the attached Exception and Stacktrace for clues on what may have gone
	 * wrong.
	 */
	ERR_00000140,

	/**
	 * While attempting to get the ConsumerUserID from a JWT, [TokenUtils] encountered an unexpected
	 * Exception, and will be forced to return empty-string instead of a valid UserID. This will
	 * probably prevent login and subscription to a messaging WebSocket, if the UserID was not
	 * already cached and has not changed.
	 */
	ERR_00000141,

	/**
	 * [FileUtils] attempted to delete old cached files in the background while the SDK does other
	 * stuff. Unfortunately, it failed to run the faster 'rm -rf' command. This method has fallback
	 * logic; files will still be cleaned up unless this error is followed by failure to do that
	 * as well. Assuming both fail, please include both attached Exceptions and Stacktraces in a
	 * ServiceNow ticket to R&D.
	 */
	ERR_00000142,

	/**
	 * [FileUtils] attempted to use the slower DeleteRecursively strategy instead of the faster
	 * 'rm -rf' command, which previously failed. However, the path it was told to delete is null,
	 * and it cannot delete a null directory. This will probably require R&D research.
	 */
	ERR_00000143,

	/**
	 * [FileUtils] attempted to use the slower DeleteRecursively strategy instead of the faster
	 * 'rm -rf' command, which previously failed. However, when it attempted to get a list of files
	 * in a directory to delete, the file list was *null*, rather than empty. This method can
	 * therefore not delete this subtree, and will skip to the next subtree in sequence. Some files
	 * may not have been deleted.
	 */
	ERR_00000144,

	/**
	 * [AmsConnection] successfully established a WebSocket connection, but the callback it was
	 * supposed to use to notify success was null. This should be investigated by R&D. Please
	 * include as many logs with the 'LivePerson' filter as possible, as this will be difficult to
	 * diagnose.
	 */
	ERR_00000145,

	/**
	 * [ConnectionStateMachine] has received a [TaskFailedEvent], indicating that some other SDK
	 * process has failed, and thus the original task that failed will not be completed. This error
	 * is primarily for reporting purposes; check for preceding errors that may indicate what,
	 * specifically, went wrong.
	 */
	ERR_00000146,

	/**
	 * [ConnectionStateMachine] has received a [TaskTimeOutEvent], indicating that some other SDK
	 * process has timed out waiting for a response, and thus will not be completed. This error
	 * is primarily for reporting purposes; check for preceding errors that may indicate what,
	 * specifically, went wrong.
	 */
	ERR_00000147,

	/**
	 * [UnregisterPusherCommand] has failed to unregister from Pusher after multiple attempts. This
	 * probably means the consumer lost internet connection, or the Pusher service is down. Check
	 * the attached Exception and Stacktrace, if present, for more details.
	 */
	ERR_00000148,

	/**
	 * [HyperLinkUtils], while processing an incoming Message with a "Markdown Hyperlink" embedded
	 * in it, discovered that it was not able to properly parse a markdown item. This item will
	 * simply be excluded from further processing; other links, if present, will still be processed.
	 * This most likely means the link feature from LiveEngage did not send the correct text
	 * wrapping for a link, or someone tried to type out the markdown link syntax manually, and
	 * mistyped it. Check the message payloads sent to and from the SDK for clues.
	 */
	ERR_00000149,

	/**
	 * [DBEncryptionService] encountered an unexpected KeyStoreException while accessing the Android
	 * Keystore to check for existing encryption keys. This indicates a failure of a core SDK system
	 * service, which will prevent the User from encrypting history if a key has not already been
	 * generated. This will require R&D investigation; please include the attached KeyStoreException
	 * and its Stacktrace in a ServiceNow ticket.
	 */
	ERR_0000014A,

	/**
	 * [DBEncryptionService] encountered an unexpected Exception while generating an encryption key
	 * on first-run. This indicates a failure of a core SDK system service, which will prevent the
	 * User from encrypting history. This will require R&D investigation; please include the attached
	 * Exception and its Stacktrace in a ServiceNow ticket.
	 */
	ERR_0000014B,

	/**
	 * [RegisterPusherCommand] attempted to get Domain information to make a Pusher Registration request,
	 * but could not obtain the PusherDomain from either [SharedPreferences] nor the [AccountsController].
	 * Push Registration will not be successful.
	 */
	ERR_0000014C,

	/**
	 * [ConversationFragment] onSaveInstanceState is called when ConversationFragment is not initialized.
	 * The possible reason we got this issue is host app calls it before show conversation.
	 */
	ERR_0000014D,

	/**
	 * [FeedbackFragment] attempt to slide out feedback fragment that does not exists
	 */
	ERR_0000014E,

	/**
	 * [FeedbackFragment] attempt to access null parent fragment when tried to slide out feedback fragment
	 */
	ERR_0000014F,

	/**
	 * [ConversationFragment] Failed to remove ConversationFragment attached to activity
	 */
	ERR_00000150,

	/**
	 * [PushMessagePreferences] Push Message preferences is not initialized when tried to perform any read/write operation
	 */
	ERR_00000151,

	/**
	 * [AmsMessages] Failed to update dialogId
	 */
	ERR_00000152,

	/**
	 * [AmsMessages] Failed to update outbound message stored in DB
	 */
	ERR_00000153,

	/**
	 * [AmsMessages] Failed to remove last outbound message stored in DB
	 */
	ERR_00000154,

	/**
	 * [NavigationAction] Failed to resolve Activity.
	 */
	ERR_00000155,

	/**
	 * [LinkAction] Failed to resolve Activity
	 */
	ERR_00000156,

	/**
	 * [ConversationFragment] Failed to resolve Activity
	 */
	ERR_00000157,

	/*
	 * [CoBrowseManager] Failed to cancel cobrowse
	 */
	ERR_00000158,

	/**
	 * [CoBrowseManager] MainDialog is null or metadata is null
	 */
	ERR_00000159,

	/**
	 * [EventManagerService] Failed to log event of Event Manager to log preferences
	 */
	ERR_0000015A,

	/**
	 * [EventManagerService] Failed to send events to Event Manager
	 */
	ERR_0000015B,

	/**
	 * [AmsAgentStructuredContentViewHolder] Failure within lp_structured_content library.
	 */
	ERR_0000015C,

	/**
	 * [AmsAgentStructuredContentViewHolder] Failed to load Structured Content.
	 */
	ERR_0000015D,

	/**
	 * [MessagesAsListAdapter] Failed to parse date picker json object.
	 */
	ERR_0000015E,

	/**
	 * [messaging_ui -> StringUtils] Failed to use date picker dateFormat to form message
	 */
	ERR_00000160
}