package com.liveperson.infra.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.utils.ClockUtils;

/**
 * Created by shiranr on 18/01/2016.
 */
public class PushMessage implements Parcelable {
    private String mBrandId;
    private String mMessage;
    private String mFrom;
    private String mConversationId;
    private String mBackendService;
    private String mCollapseKey;
    private int mCurrentUnreadMessagesCounter = -1;
    private String id;
    private Long lookBackPeriod = -1L;
    private Long timeCreated;
    private String agentPid;
    private String transactionId; // Valid only for proactive/C2M
    private CampaignInfo campaignInfo;


    public PushMessage(String brandId, String from, String message) {

        this.mBrandId = brandId;
        this.mFrom = from;
        this.mMessage = message;
        this.timeCreated = System.currentTimeMillis();
        this.id = String.valueOf(timeCreated);
    }

    private PushMessage(Parcel in) {
        mBrandId = in.readString();
        mFrom = in.readString();
        mMessage = in.readString();
        id  = in.readString();
        timeCreated = in.readLong();
        lookBackPeriod = in.readLong();
        campaignInfo = in.readParcelable(CampaignInfo.class.getClassLoader());
    }

    public String getFrom() {
        return mFrom;
    }

    public String getMessage() {
        return mMessage;
    }

    public String getBrandId() {
        return mBrandId;
    }

    public String getConversationId() {
        return mConversationId;
    }

    public void setConversationId(String mConversationId) {
        this.mConversationId = mConversationId;
    }

    public String getBackendService() {
        return mBackendService;
    }

    public void setBackendService(String mBackendService) {
        this.mBackendService = mBackendService;
    }

    public String getCollapseKey() {
        return mCollapseKey;
    }

    public void setCollapseKey(String mCollapseKey) {
        this.mCollapseKey = mCollapseKey;
    }

    public void setCampaignInfo(CampaignInfo campaignInfo) {
        this.campaignInfo = campaignInfo;
    }

    public String getPushMessageId() {
        return id;
    }

    public void setPushMessageId(String msgId) {
        id = msgId;
    }

    public void setTimeCreated(Long time) {
        this.timeCreated = time;
    }

    public Long getTimeCreated() {
        return timeCreated;
    }

    public void setLookBackPeriod(Long period) {
        this.lookBackPeriod = period;
    }

    public Long getLookBackPeriod() {
        return this.lookBackPeriod;
    }

    public String getAgentPid() {
        return agentPid;
    }

    public void setAgentPid(String agentPid) {
        this.agentPid = agentPid;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public CampaignInfo getCampaignInfo() {
        return campaignInfo;
    }

    /**
     * Check If outbound campaign has expired
     * @return boolean
     */
    public boolean isExpired() {
        // If we have default value of look back, we should not mark notification as expired.
        if (lookBackPeriod == -1) {
            return false;
        }
        return ClockUtils.getSyncedTimestamp() - timeCreated > lookBackPeriod;
    }

    @Override
    public String toString() {
        return "mBrandId: "+mBrandId+ " from: " + mFrom + " Message: " + mMessage + " convId: "
                +mConversationId + " mCollapseKey: " + mCollapseKey  + " mBackendService: " + mBackendService;
    }

    public int getCurrentUnreadMessagesCounter() {
        return mCurrentUnreadMessagesCounter;
    }

    public void setCurrentUnreadMessagesCounter(int currentUnreadMessagesCounter) {
        this.mCurrentUnreadMessagesCounter = currentUnreadMessagesCounter;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(mBrandId);
        dest.writeString(mFrom);
        dest.writeString(mMessage);
        dest.writeString(id);
        dest.writeLong(timeCreated);
        dest.writeLong(lookBackPeriod);
        dest.writeParcelable(campaignInfo, flags);
    }

    public static final Parcelable.Creator<PushMessage> CREATOR
            = new Parcelable.Creator<PushMessage>() {
        public PushMessage createFromParcel(Parcel in) {
            return new PushMessage(in);
        }

        public PushMessage[] newArray(int size) {
            return new PushMessage[size];
        }
    };
}
