/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import java.util.ArrayList;
import java.util.List;

public class LPAuthenticationParams
implements Parcelable {
    private static final String TAG = "LPAuthenticationParams";
    private LPAuthenticationType mType;
    private String mAuthKey;
    private String mHostAppJWT;
    private String mHostAppRedirectUri;
    private List<String> mCertificatePinningKeys = new ArrayList<String>();
    public static final Parcelable.Creator<LPAuthenticationParams> CREATOR = new Parcelable.Creator<LPAuthenticationParams>(){

        public LPAuthenticationParams createFromParcel(Parcel in) {
            return new LPAuthenticationParams(in);
        }

        public LPAuthenticationParams[] newArray(int size) {
            return new LPAuthenticationParams[size];
        }
    };

    public LPAuthenticationParams() {
        this(LPAuthenticationType.SIGN_UP);
    }

    public LPAuthenticationParams(LPAuthenticationType type) {
        this.mType = type;
    }

    protected LPAuthenticationParams(Parcel in) {
        this.mAuthKey = in.readString();
        this.mHostAppJWT = in.readString();
        this.mHostAppRedirectUri = in.readString();
        this.mCertificatePinningKeys = in.createStringArrayList();
        int i = in.readInt();
        if (i != -1) {
            this.mType = LPAuthenticationType.values()[i];
        }
    }

    public LPAuthenticationParams setAuthKey(String authKey) {
        this.mAuthKey = authKey;
        if (!TextUtils.isEmpty((CharSequence)this.mAuthKey)) {
            this.mType = LPAuthenticationType.AUTH;
        }
        return this;
    }

    public LPAuthenticationParams setHostAppRedirectUri(String hostAppRedirectUri) {
        this.mHostAppRedirectUri = hostAppRedirectUri;
        if (!TextUtils.isEmpty((CharSequence)this.mHostAppRedirectUri)) {
            this.mType = LPAuthenticationType.AUTH;
        }
        return this;
    }

    public LPAuthenticationParams setHostAppJWT(String hostAppJWT) {
        this.mHostAppJWT = hostAppJWT;
        if (!TextUtils.isEmpty((CharSequence)this.mHostAppJWT)) {
            this.mType = LPAuthenticationType.AUTH;
        }
        return this;
    }

    public LPAuthenticationParams addCertificatePinningKey(String publicKey) {
        if (TextUtils.isEmpty((CharSequence)publicKey)) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000003D, "Certificate key can't be an empty string");
            return this;
        }
        if (!publicKey.startsWith("sha256/")) {
            publicKey = "sha256/" + publicKey;
        }
        this.mCertificatePinningKeys.add(publicKey);
        return this;
    }

    public static void printSignupDeprecationNotice() {
        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000003E, "\n================================================================================\nAuth Type SIGN_UP is [[ DEPRECATED ]]\n\nInstead, please use LPAuthenticationType AUTH or UN_AUTH for AuthCode, Implicit,\nor Un-Auth flows.\n\nWARNING: LPAuthenticationType SIGN_UP will reach end-of-life on 6/30/2020.\nPlease contact LivePerson through our support channels to learn how to migrate\nyour app to Authenticated or Unauthenticated messaging.\n================================================================================");
    }

    public String getHostAppJWT() {
        return this.mHostAppJWT;
    }

    public String getHostAppRedirectUri() {
        return this.mHostAppRedirectUri;
    }

    public String getAuthKey() {
        return this.mAuthKey;
    }

    public LPAuthenticationType getAuthType() {
        return this.mType;
    }

    public boolean isAuthenticated() {
        return this.mType == LPAuthenticationType.AUTH;
    }

    public List<String> getCertificatePinningKeys() {
        return this.mCertificatePinningKeys;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mAuthKey);
        dest.writeString(this.mHostAppJWT);
        dest.writeString(this.mHostAppRedirectUri);
        dest.writeStringList(this.mCertificatePinningKeys);
        dest.writeInt(this.mType.ordinal());
    }
}

