/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.eventmanager;

import android.content.Context;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.callbacks.AuthStateSubscription;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.eventmanager.Event;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.ConsumerManager;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.network.http.requests.EventManagerRequest;
import com.liveperson.infra.preferences.EventManagerPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004JF\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J&\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007J6\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\"\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010#\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/liveperson/infra/eventmanager/EventManagerService;", "", "()V", "appId", "", "brandId", "certificatePinningKeys", "", "conversationId", "domain", "eventManagerPreferences", "Lcom/liveperson/infra/preferences/EventManagerPreferences;", "isInitialized", "", "lpToken", "clearAllEvents", "", "init", "applicationContext", "Landroid/content/Context;", "logEvent", "transactionId", "isSuccess", "event", "Lcom/liveperson/infra/eventmanager/Event;", "errorCode", "errorMessage", "context", "sendCachedLogsToEventManager", "token", "sendLogsToEventManager", "logList", "", "Lorg/json/JSONObject;", "setConversationId", "setDomain", "subscribeToAuthStateChanges", "consumerManager", "Lcom/liveperson/infra/managers/ConsumerManager;", "Companion", "infra_release"})
public class EventManagerService {
    private String brandId;
    private String conversationId = "";
    private String appId = "";
    private String domain = "";
    private boolean isInitialized;
    private String lpToken = "";
    private List<String> certificatePinningKeys;
    private EventManagerPreferences eventManagerPreferences = new EventManagerPreferences();
    private static final String TAG = "EventManagerService";
    private static final String CHANNEL = "inapp";
    private static final String VERSION = "1.0";
    private static final String REPORTER = "mobile_sdk_android";
    private static final String KEY_EVENT_TYPE = "eventType";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_ACCOUNT_ID = "accountId";
    private static final String KEY_TRANSACTION_ID = "transactionId";
    private static final String KEY_OUTBOUND_NUMBER = "outboundNumber";
    private static final String KEY_CHANNEL = "channel";
    private static final String KEY_VERSION = "v";
    private static final String KEY_REPORTER = "reporter";
    private static final String KEY_VALUE = "value";
    private static final String KEY_CONVERSATION_ID = "conversationId";
    private static final String KEY_ERROR_CODE = "errCode";
    private static final String KEY_ERROR_MESSAGE = "errMsg";
    public static final Companion Companion = new Companion(null);

    public final void init(@NotNull Context applicationContext, @NotNull String brandId, @NotNull String appId) {
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        this.brandId = brandId;
        this.appId = appId;
        this.eventManagerPreferences.init(applicationContext);
        this.isInitialized = true;
    }

    public void logEvent(@NotNull String brandId, @Nullable String transactionId, boolean isSuccess, @NotNull Event event, @Nullable String errorCode, @Nullable String errorMessage, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)event), (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            boolean bl;
            if (!this.isInitialized) {
                this.eventManagerPreferences.init(context);
            }
            CharSequence charSequence = transactionId;
            boolean bl2 = false;
            boolean bl3 = false;
            if (charSequence == null || charSequence.length() == 0) {
                LPLog.INSTANCE.d(TAG, "No transactionId found. Ignore event");
                return;
            }
            JSONObject eventData = new JSONObject();
            eventData.put(KEY_EVENT_TYPE, (Object)event.getEventName());
            eventData.put(KEY_TIMESTAMP, System.currentTimeMillis());
            eventData.put(KEY_ACCOUNT_ID, (Object)brandId);
            eventData.put(KEY_TRANSACTION_ID, (Object)transactionId);
            eventData.put(KEY_CHANNEL, (Object)CHANNEL);
            eventData.put(KEY_VERSION, (Object)VERSION);
            eventData.put(KEY_REPORTER, (Object)REPORTER);
            eventData.put(KEY_VALUE, isSuccess);
            CharSequence charSequence2 = this.appId;
            bl3 = false;
            if (charSequence2.length() == 0) {
                charSequence2 = brandId;
                bl3 = false;
                if (charSequence2.length() > 0) {
                    LPLog.INSTANCE.d(TAG, "logEvent: Missing appId, trying to get it from shared preference.");
                    String string = PreferenceManager.getInstance().getStringValue("APP_ID_PREFERENCE_KEY", brandId, "");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PreferenceManager.getIns\u2026FERENCE_KEY, brandId, \"\")");
                    this.appId = string;
                    eventData.put(KEY_OUTBOUND_NUMBER, (Object)this.appId);
                }
            }
            if (event == Event.CONVERSATION) {
                charSequence2 = this.conversationId;
                bl3 = false;
                bl = false;
                if (!(charSequence2 == null || charSequence2.length() == 0)) {
                    eventData.put(KEY_CONVERSATION_ID, (Object)this.conversationId);
                }
            }
            charSequence2 = errorCode;
            bl3 = false;
            bl = false;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                eventData.put(KEY_ERROR_CODE, (Object)errorCode);
            }
            charSequence2 = errorMessage;
            bl3 = false;
            bl = false;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                eventData.put(KEY_ERROR_MESSAGE, (Object)errorMessage);
            }
            LPLog.INSTANCE.d(TAG, "Logging event '" + event.getEventName() + "' with transactionId: " + transactionId);
            String string = eventData.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"eventData.toString()");
            this.eventManagerPreferences.addEventToLogPreferences(string, brandId);
            if (event == Event.CONVERSATION) {
                charSequence2 = this.lpToken;
                bl3 = false;
                bl = false;
                if (!(charSequence2 == null || charSequence2.length() == 0)) {
                    this.sendLogsToEventManager(brandId, this.lpToken, CollectionsKt.arrayListOf((Object[])new JSONObject[]{eventData}), this.certificatePinningKeys);
                    return;
                }
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000015A, "Failed to log Event Manager event to log preferences");
        }
    }

    @NotNull
    public final EventManagerService setConversationId(@Nullable String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    public final void setDomain(@Nullable String domain) {
        CharSequence charSequence = this.domain;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)this.domain, (Object)domain) ^ true) {
            this.domain = domain;
            charSequence = this.lpToken;
            bl = false;
            bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = this.brandId;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"brandId");
                }
                this.sendCachedLogsToEventManager(string, this.lpToken, this.certificatePinningKeys);
            }
        }
    }

    public final void subscribeToAuthStateChanges(@NotNull ConsumerManager consumerManager) {
        Intrinsics.checkParameterIsNotNull((Object)consumerManager, (String)"consumerManager");
        consumerManager.subscribeToAuthStateChanges(new AuthStateSubscription(this){
            final /* synthetic */ EventManagerService this$0;

            public void onAuthStateChanged(@NotNull ConsumerManager.AuthState oldState, @NotNull ConsumerManager.AuthState newState, @Nullable Consumer oldConsumer, @Nullable Consumer newConsumer) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)oldState), (String)"oldState");
                Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
                if (newState == ConsumerManager.AuthState.AUTHENTICATED) {
                    Consumer consumer = newConsumer;
                    if ((consumer != null ? consumer.getBrandId() : null) != null && newConsumer.getLpToken() != null) {
                        EventManagerService.access$setLpToken$p(this.this$0, newConsumer.getLpToken());
                        LPAuthenticationParams lPAuthenticationParams = newConsumer.getLpAuthenticationParams();
                        EventManagerService.access$setCertificatePinningKeys$p(this.this$0, lPAuthenticationParams != null ? lPAuthenticationParams.getCertificatePinningKeys() : null);
                        this.this$0.sendCachedLogsToEventManager(newConsumer.getBrandId(), EventManagerService.access$getLpToken$p(this.this$0), EventManagerService.access$getCertificatePinningKeys$p(this.this$0));
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void sendCachedLogsToEventManager(@NotNull String brandId, @NotNull String token, @Nullable List<String> certificatePinningKeys) {
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Set<String> logs = this.eventManagerPreferences.fetchLogsFromPreferences(brandId);
        Collection collection = logs;
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            LPLog.INSTANCE.i(TAG, "sendLogsToEventManager: No logs found in cache.");
            return;
        }
        ArrayList<JSONObject> logList = new ArrayList<JSONObject>();
        for (String log : logs) {
            logList.add(new JSONObject(log));
        }
        this.sendLogsToEventManager(brandId, token, (List<? extends JSONObject>)logList, certificatePinningKeys);
    }

    private final void sendLogsToEventManager(String brandId, String token, List<? extends JSONObject> logList, List<String> certificatePinningKeys) {
        try {
            CharSequence charSequence = this.lpToken;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000015B, "sendLogsToEventManager: Failed to send logs to Event Manager. Missing Token");
                return;
            }
            charSequence = this.domain;
            bl = false;
            bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                this.domain = PreferenceManager.getInstance().getStringValue("site_settings_event_manager_domain_preference_key", "appLevelPreferences", null);
                charSequence = this.domain;
                bl = false;
                bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000015B, "sendLogsToEventManager: Failed to send logs to Event Manager. Missing domain");
                    return;
                }
            }
            LPLog.INSTANCE.d(TAG, "sendLogsToEventManager: Sending logs to event manager....");
            new EventManagerRequest(this.domain, brandId, token, logList, certificatePinningKeys, new ICallback<String, Exception>(this, brandId){
                final /* synthetic */ EventManagerService this$0;
                final /* synthetic */ String $brandId;

                public void onSuccess(@Nullable String value) {
                    LPLog.INSTANCE.i("EventManagerService", "sendLogsToEventManager: Successfully " + value + " events by event manager. Clear events from cache");
                    EventManagerService.access$getEventManagerPreferences$p(this.this$0).clearLogsFromPreferences(this.$brandId);
                }

                public void onError(@Nullable Exception exception) {
                    LPLog.INSTANCE.e("EventManagerService", ErrorCode.ERR_0000015B, "sendLogsToEventManager: Failed to send logs to event manager. {" + exception + '}');
                }
                {
                    this.this$0 = $outer;
                    this.$brandId = $captured_local_variable$1;
                }
            }).execute();
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000015B, "sendLogsToEventManager: Failed to send logs to event manager. {" + error + '}');
        }
    }

    public final void clearAllEvents() {
        this.eventManagerPreferences.clearAll();
    }

    public static final /* synthetic */ String access$getLpToken$p(EventManagerService $this) {
        return $this.lpToken;
    }

    public static final /* synthetic */ void access$setLpToken$p(EventManagerService $this, String string) {
        $this.lpToken = string;
    }

    public static final /* synthetic */ List access$getCertificatePinningKeys$p(EventManagerService $this) {
        return $this.certificatePinningKeys;
    }

    public static final /* synthetic */ void access$setCertificatePinningKeys$p(EventManagerService $this, List list) {
        $this.certificatePinningKeys = list;
    }

    public static final /* synthetic */ EventManagerPreferences access$getEventManagerPreferences$p(EventManagerService $this) {
        return $this.eventManagerPreferences;
    }

    public static final /* synthetic */ void access$setEventManagerPreferences$p(EventManagerService $this, EventManagerPreferences eventManagerPreferences) {
        $this.eventManagerPreferences = eventManagerPreferences;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/liveperson/infra/eventmanager/EventManagerService$Companion;", "", "()V", "CHANNEL", "", "KEY_ACCOUNT_ID", "KEY_CHANNEL", "KEY_CONVERSATION_ID", "KEY_ERROR_CODE", "KEY_ERROR_MESSAGE", "KEY_EVENT_TYPE", "KEY_OUTBOUND_NUMBER", "KEY_REPORTER", "KEY_TIMESTAMP", "KEY_TRANSACTION_ID", "KEY_VALUE", "KEY_VERSION", "REPORTER", "TAG", "VERSION", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

