/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.os.Build;
import android.util.SparseArray;
import com.liveperson.infra.log.LPLog;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/infra/utils/DeviceUtils;", "", "()V", "TAG", "", "getOsName", "AndroidVersion", "infra_release"})
public final class DeviceUtils {
    private static final String TAG = "DeviceUtils";
    public static final DeviceUtils INSTANCE;

    @NotNull
    public final Object getOsName() {
        try {
            AndroidVersion version = AndroidVersion.Companion.fromSdkVersionCode(Build.VERSION.SDK_INT);
            return version.getLogName();
        }
        catch (Exception exception) {
            LPLog.INSTANCE.w(TAG, "getOsName: Failed to obtain device OS name: ", exception);
            return "";
        }
    }

    private DeviceUtils() {
    }

    static {
        DeviceUtils deviceUtils;
        INSTANCE = deviceUtils = new DeviceUtils();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b'\b\u0082\u0001\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001+B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*\u00a8\u0006,"}, d2={"Lcom/liveperson/infra/utils/DeviceUtils$AndroidVersion;", "", "verCode", "", "logName", "", "(Ljava/lang/String;IILjava/lang/String;)V", "getLogName", "()Ljava/lang/String;", "getVerCode", "()I", "UNSUPPORTED", "BASE", "BASE_1_1", "CUPCAKE", "DONUT", "ECLAIR", "ECLAIR_0_1", "ECLAIR_MR1", "FROYO", "GINGERBREAD", "GINGERBREAD_MR1", "HONEYCOMB", "HONEYCOMB_MR1", "HONEYCOMB_MR2", "ICE_CREAM_SANDWICH", "ICE_CREAM_SANDWICH_MR1", "JELLY_BEAN", "JELLY_BEAN_MR1", "JELLY_BEAN_MR2", "KITKAT", "KITKAT_WATCH", "LOLLIPOP", "LOLLIPOP_MR1", "MARSHMALLOW", "NOUGAT", "NOUGAT_MR1", "OREO", "OREO_MR1", "PIE", "Q", "R", "S", "Companion", "infra_release"})
    private static final class AndroidVersion
    extends Enum<AndroidVersion> {
        public static final /* enum */ AndroidVersion UNSUPPORTED;
        public static final /* enum */ AndroidVersion BASE;
        public static final /* enum */ AndroidVersion BASE_1_1;
        public static final /* enum */ AndroidVersion CUPCAKE;
        public static final /* enum */ AndroidVersion DONUT;
        public static final /* enum */ AndroidVersion ECLAIR;
        public static final /* enum */ AndroidVersion ECLAIR_0_1;
        public static final /* enum */ AndroidVersion ECLAIR_MR1;
        public static final /* enum */ AndroidVersion FROYO;
        public static final /* enum */ AndroidVersion GINGERBREAD;
        public static final /* enum */ AndroidVersion GINGERBREAD_MR1;
        public static final /* enum */ AndroidVersion HONEYCOMB;
        public static final /* enum */ AndroidVersion HONEYCOMB_MR1;
        public static final /* enum */ AndroidVersion HONEYCOMB_MR2;
        public static final /* enum */ AndroidVersion ICE_CREAM_SANDWICH;
        public static final /* enum */ AndroidVersion ICE_CREAM_SANDWICH_MR1;
        public static final /* enum */ AndroidVersion JELLY_BEAN;
        public static final /* enum */ AndroidVersion JELLY_BEAN_MR1;
        public static final /* enum */ AndroidVersion JELLY_BEAN_MR2;
        public static final /* enum */ AndroidVersion KITKAT;
        public static final /* enum */ AndroidVersion KITKAT_WATCH;
        public static final /* enum */ AndroidVersion LOLLIPOP;
        public static final /* enum */ AndroidVersion LOLLIPOP_MR1;
        public static final /* enum */ AndroidVersion MARSHMALLOW;
        public static final /* enum */ AndroidVersion NOUGAT;
        public static final /* enum */ AndroidVersion NOUGAT_MR1;
        public static final /* enum */ AndroidVersion OREO;
        public static final /* enum */ AndroidVersion OREO_MR1;
        public static final /* enum */ AndroidVersion PIE;
        public static final /* enum */ AndroidVersion Q;
        public static final /* enum */ AndroidVersion R;
        public static final /* enum */ AndroidVersion S;
        private static final /* synthetic */ AndroidVersion[] $VALUES;
        private final int verCode;
        @NotNull
        private final String logName;
        private static final SparseArray<AndroidVersion> verCodeMap;
        public static final Companion Companion;

        static {
            AndroidVersion[] androidVersionArray = new AndroidVersion[32];
            AndroidVersion[] androidVersionArray2 = androidVersionArray;
            androidVersionArray[0] = UNSUPPORTED = new AndroidVersion(-1, "Unsupported version");
            androidVersionArray[1] = BASE = new AndroidVersion(1, "Base (1.0)");
            androidVersionArray[2] = BASE_1_1 = new AndroidVersion(2, "Base (1.1)");
            androidVersionArray[3] = CUPCAKE = new AndroidVersion(3, "Cupcake (1.5)");
            androidVersionArray[4] = DONUT = new AndroidVersion(4, "Donut (1.6)");
            androidVersionArray[5] = ECLAIR = new AndroidVersion(5, "Eclair (2.0)");
            androidVersionArray[6] = ECLAIR_0_1 = new AndroidVersion(6, "Eclair (2.0.1)");
            androidVersionArray[7] = ECLAIR_MR1 = new AndroidVersion(7, "Eclair (2.1)");
            androidVersionArray[8] = FROYO = new AndroidVersion(8, "Froyo (2.2)");
            androidVersionArray[9] = GINGERBREAD = new AndroidVersion(9, "Gingerbread (2.3)");
            androidVersionArray[10] = GINGERBREAD_MR1 = new AndroidVersion(10, "Gingerbread (2.3.3)");
            androidVersionArray[11] = HONEYCOMB = new AndroidVersion(11, "Honeycomb (3.0)");
            androidVersionArray[12] = HONEYCOMB_MR1 = new AndroidVersion(12, "Honeycomb (3.1)");
            androidVersionArray[13] = HONEYCOMB_MR2 = new AndroidVersion(13, "Honeycomb (3.2)");
            androidVersionArray[14] = ICE_CREAM_SANDWICH = new AndroidVersion(14, "Ice Cream Sandwich (4.0)");
            androidVersionArray[15] = ICE_CREAM_SANDWICH_MR1 = new AndroidVersion(15, "Ice Cream Sandwich (4.0.3)");
            androidVersionArray[16] = JELLY_BEAN = new AndroidVersion(16, "Jelly Bean (4.1)");
            androidVersionArray[17] = JELLY_BEAN_MR1 = new AndroidVersion(17, "Jelly Bean (4.2)");
            androidVersionArray[18] = JELLY_BEAN_MR2 = new AndroidVersion(18, "Jelly Bean (4.3)");
            androidVersionArray[19] = KITKAT = new AndroidVersion(19, "Kitkat (4.4)");
            androidVersionArray[20] = KITKAT_WATCH = new AndroidVersion(20, "Kitkat Watch (4.4W)");
            androidVersionArray[21] = LOLLIPOP = new AndroidVersion(21, "Lollipop (5.0)");
            androidVersionArray[22] = LOLLIPOP_MR1 = new AndroidVersion(22, "Lollipop (5.1)");
            androidVersionArray[23] = MARSHMALLOW = new AndroidVersion(23, "Marshmallow (6.0)");
            androidVersionArray[24] = NOUGAT = new AndroidVersion(24, "Nougat (7.0)");
            androidVersionArray[25] = NOUGAT_MR1 = new AndroidVersion(25, "Nougat (7.1)");
            androidVersionArray[26] = OREO = new AndroidVersion(26, "Oreo (8.0)");
            androidVersionArray[27] = OREO_MR1 = new AndroidVersion(27, "Oreo (8.1)");
            androidVersionArray[28] = PIE = new AndroidVersion(28, "Pie (9.0)");
            androidVersionArray[29] = Q = new AndroidVersion(29, "Q (10.0)");
            androidVersionArray[30] = R = new AndroidVersion(30, "R (11.0)");
            androidVersionArray[31] = S = new AndroidVersion(31, "S (12.0)");
            $VALUES = androidVersionArray;
            Companion = new Companion(null);
            verCodeMap = new SparseArray();
            for (AndroidVersion version : AndroidVersion.values()) {
                verCodeMap.put(version.verCode, (Object)version);
            }
        }

        public final int getVerCode() {
            return this.verCode;
        }

        @NotNull
        public final String getLogName() {
            return this.logName;
        }

        private AndroidVersion(int verCode, String logName) {
            this.verCode = verCode;
            this.logName = logName;
        }

        public static AndroidVersion[] values() {
            return (AndroidVersion[])$VALUES.clone();
        }

        public static AndroidVersion valueOf(String string) {
            return Enum.valueOf(AndroidVersion.class, string);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/liveperson/infra/utils/DeviceUtils$AndroidVersion$Companion;", "", "()V", "verCodeMap", "Landroid/util/SparseArray;", "Lcom/liveperson/infra/utils/DeviceUtils$AndroidVersion;", "fromSdkVersionCode", "verCode", "", "infra_release"})
        public static final class Companion {
            @NotNull
            public final AndroidVersion fromSdkVersionCode(int verCode) {
                Object object = verCodeMap.get(verCode, (Object)UNSUPPORTED);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"verCodeMap.get(verCode, UNSUPPORTED)");
                return (AndroidVersion)((Object)object);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

