/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import androidx.exifinterface.media.ExifInterface;
import com.liveperson.infra.Infra;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.FileUtils;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.infra.utils.Utils;
import com.squareup.picasso.Picasso;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class ImageUtils {
    private static final String TAG = "ImageUtils";
    public static final String PNG = "png";
    public static final String JPG = "jpg";
    private static final String SAMSUNG = "samsung";
    public static final String FILE_MIME_TYPE_GIF = "image/gif";
    public static final String FILE_MIME_TYPE_JPG = "image/jpeg";
    private static final String IMAGES_FOLDER = "images/";
    private static final String FULL_IMAGE_FOLDER = "full/";
    private static final String PREVIEW_IMAGE_FOLDER = "preview/";

    public static String bitmapToBase64(byte[] bitmapByteArray) {
        LPLog.INSTANCE.d(TAG, "bitmapToBase64: Bitmap size: " + bitmapByteArray.length / 1000 + " kb");
        return Base64.encodeToString((byte[])bitmapByteArray, (int)0);
    }

    private static byte[] base64ToByteArray(String base64) {
        if (base64 != null) {
            LPLog.INSTANCE.d(TAG, "base64ToByteArray: converting base64 to byte array");
            base64 = base64.replaceFirst("data.*base64,", "");
            return Base64.decode((String)base64, (int)0);
        }
        return null;
    }

    public static String bitmapToBase64(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        LPLog.INSTANCE.d(TAG, "bitmapToBase64: Bitmap size: " + byteArray.length / 1000 + " kb");
        return Base64.encodeToString((byte[])byteArray, (int)0);
    }

    public static Bitmap createResizedBitmap(Uri imageUri, int reqLongerSide, int orientation, boolean fromCamera) throws IOException {
        Bitmap bitmap = Picasso.get().load(imageUri).resize(reqLongerSide, reqLongerSide).onlyScaleDown().centerInside().get();
        Matrix matrix = new Matrix();
        matrix.postRotate((float)ImageUtils.decodeExifOrientation(orientation, fromCamera));
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap createBitmapFromURL(Context context, String imageUrl, int width, int height) {
        if (TextUtils.isEmpty((CharSequence)imageUrl)) {
            return null;
        }
        try {
            return PicassoUtils.get(context).load(imageUrl).resize(Math.max(width, 250), Math.max(height, 250)).onlyScaleDown().get();
        }
        catch (Exception e) {
            try {
                return PicassoUtils.get(context).load(imageUrl).get();
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    @NonNull
    public static Bitmap getBitmap(String imagePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)true);
        return bitmap;
    }

    public static int getImageRotation(String imagePath, boolean fromCamera) {
        try {
            ExifInterface exif = new ExifInterface(imagePath);
            int orientation = exif.getAttributeInt("Orientation", 1);
            return ImageUtils.decodeExifOrientation(orientation, fromCamera);
        }
        catch (IOException e) {
            LPLog.INSTANCE.i(TAG, "getImageRotation: cannot get exif information on image. Return rotation 0");
            return 0;
        }
    }

    public static String getImagePath(Context context, Uri selectedImageUri) {
        String path = null;
        String scheme = selectedImageUri.getScheme();
        if (scheme != null && scheme.equals("content")) {
            String authority = selectedImageUri.getAuthority();
            if (authority != null && authority.equals(Infra.getFileProviderAuthorityPrefix() + context.getApplicationInfo().packageName)) {
                path = new File(context.getFilesDir(), selectedImageUri.getPath()).getAbsolutePath();
            } else {
                String[] filePathColumn = new String[]{"_data"};
                Cursor cursor = context.getContentResolver().query(selectedImageUri, filePathColumn, null, null, null);
                if (cursor != null) {
                    cursor.moveToFirst();
                    int columnIndex = cursor.getColumnIndex(filePathColumn[0]);
                    path = cursor.getString(columnIndex);
                    cursor.close();
                    if (TextUtils.isEmpty((CharSequence)path)) {
                        path = selectedImageUri.toString();
                    }
                }
            }
        } else if (scheme != null && scheme.equals("file")) {
            LPLog.INSTANCE.d(TAG, "getImagePath: Uri scheme is file. We get the path of the file");
            path = selectedImageUri.getPath();
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000018, "getImagePath: Unknown scheme: " + scheme + ". Cannot get image path");
        }
        LPLog.INSTANCE.d(TAG, "getImagePath: path = " + path);
        return path;
    }

    public static byte[] getOutputStreamFromBitmap(Bitmap bitmapImage, int compression, String imageTypeExtension) {
        byte[] byteArray = null;
        try {
            LPLog.INSTANCE.d(TAG, "getOutputStreamFromBitmap: file extension: " + imageTypeExtension);
            Bitmap.CompressFormat format = Bitmap.CompressFormat.JPEG;
            if (imageTypeExtension.toLowerCase().equals(PNG)) {
                format = Bitmap.CompressFormat.PNG;
            }
            LPLog.INSTANCE.d(TAG, "getOutputStreamFromBitmap: compressing bitmap to byte array");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            bitmapImage.compress(format, compression, (OutputStream)os);
            byteArray = os.toByteArray();
            os.close();
        }
        catch (IOException e) {
            LPLog.INSTANCE.w(TAG, "getOutputStreamFromBitmap: ", e);
        }
        return byteArray;
    }

    public static String saveBase64ToDisk(Context context, String base64, String brandId) {
        byte[] byteArray;
        if (base64 != null && (byteArray = ImageUtils.base64ToByteArray(base64)) != null) {
            return ImageUtils.saveBitmapToDisk(context, byteArray, brandId, ImageFolderType.PREVIEW, null);
        }
        return null;
    }

    public static String saveBitmapToDisk(Context context, byte[] imageByteArray, String brandId, ImageFolderType imageFolderType, String fileExtension) {
        if (fileExtension == null) {
            fileExtension = JPG;
        }
        String filename = UUID.randomUUID().toString() + "." + fileExtension;
        return ImageUtils.saveBitmapToDisk(context, imageByteArray, brandId, filename, imageFolderType);
    }

    private static String saveBitmapToDisk(Context context, byte[] imageByteArray, String brandId, String filename, ImageFolderType imageFolderType) {
        String imageTypeFolder;
        switch (imageFolderType) {
            case PREVIEW: {
                imageTypeFolder = PREVIEW_IMAGE_FOLDER;
                break;
            }
            case FULL: {
                imageTypeFolder = FULL_IMAGE_FOLDER;
                break;
            }
            default: {
                imageTypeFolder = "";
            }
        }
        String path = "/images/" + brandId + "/" + imageTypeFolder;
        File filePath = FileUtils.getFilePath(context, path, filename);
        if (filePath == null) {
            return null;
        }
        return ImageUtils.saveBitmapToDisk(imageByteArray, filePath);
    }

    public static String saveBitmapToDisk(byte[] imageByteArray, File filePath) {
        LPLog.INSTANCE.d(TAG, "saveBitmapToDisk: filePath: " + filePath.getAbsolutePath());
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            fos.write(imageByteArray);
        }
        catch (FileNotFoundException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000019, "saveBitmapToDisk: File not found", e);
            return null;
        }
        catch (IOException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000001A, "saveBitmapToDisk: IOException", e);
        }
        LPLog.INSTANCE.d(TAG, "saveBitmapToDisk: file absolute path: " + filePath.getAbsolutePath());
        return filePath.getAbsolutePath();
    }

    public static Uri createImageFileForCamera(Context context, String brandId) throws IOException {
        File lp_images_folder = new File(context.getFilesDir(), IMAGES_FOLDER + brandId + "/" + FULL_IMAGE_FOLDER);
        lp_images_folder.mkdirs();
        return FileProvider.getUriForFile((Context)context, (String)(Infra.getFileProviderAuthorityPrefix() + context.getApplicationInfo().packageName), (File)File.createTempFile("image", ".jpg", lp_images_folder));
    }

    private static int decodeExifOrientation(int orientation, boolean fromCamera) {
        int degrees;
        switch (orientation) {
            case 6: {
                degrees = 90;
                break;
            }
            case 3: {
                degrees = 180;
                break;
            }
            case 8: {
                degrees = 270;
                break;
            }
            default: {
                degrees = 0;
            }
        }
        degrees = ImageUtils.handleSpecificDevices(fromCamera, degrees);
        return degrees;
    }

    private static int handleSpecificDevices(boolean fromCamera, int degrees) {
        String manufacturer = Build.MANUFACTURER;
        if (!fromCamera && manufacturer.equalsIgnoreCase(SAMSUNG)) {
            degrees = 0;
        }
        return degrees;
    }

    public static Drawable createImageOnCanvas(Context context, WindowManager windowManager, Bitmap myImage) {
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(new int[]{16843499});
        int actionBarHeight = (int)styledAttributes.getDimension(0, 0.0f);
        styledAttributes.recycle();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        int height = displayMetrics.heightPixels;
        int width = displayMetrics.widthPixels;
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)myImage, (int)width, (int)(height - actionBarHeight), (boolean)false);
        Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        canvas.drawBitmap(resizedBitmap, (float)(width - resizedBitmap.getWidth()), (float)(height - resizedBitmap.getHeight()), null);
        return new BitmapDrawable(Utils.getResources(), result);
    }

    public static enum ImageFolderType {
        PREVIEW,
        FULL;

    }
}

