/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpappointmentscheduler;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import com.liveperson.lpappointmentscheduler.R;
import com.liveperson.lpappointmentscheduler.adapters.LPAppointmentListAdapter;
import com.liveperson.lpappointmentscheduler.databinding.AppointmentSchedulerFragmentBinding;
import com.liveperson.lpappointmentscheduler.logger.LPAppointmentLog;
import com.liveperson.lpappointmentscheduler.models.AppointmentSchedulerViewModel;
import com.liveperson.lpappointmentscheduler.models.AppointmentSchedulerViewModelFactory;
import com.liveperson.lpappointmentscheduler.models.AppointmentSlot;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import com.liveperson.lpappointmentscheduler.utils.AccessibilityUtilsKt;
import com.liveperson.lpappointmentscheduler.utils.OnPageChangeListenerImpl;
import com.liveperson.lpappointmentscheduler.views.CustomTextView;
import com.liveperson.lpappointmentscheduler.views.LPAppointmentWeekView;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0012\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\b\u0010!\u001a\u00020\u0011H\u0016J\u001a\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010$\u001a\u00020\u0011H\u0002J\f\u0010%\u001a\u00020\u0011*\u00020\u0004H\u0002J\f\u0010&\u001a\u00020\r*\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/liveperson/lpappointmentscheduler/AppointmentSchedulerFragment;", "Landroidx/fragment/app/Fragment;", "()V", "_binding", "Lcom/liveperson/lpappointmentscheduler/databinding/AppointmentSchedulerFragmentBinding;", "binding", "getBinding", "()Lcom/liveperson/lpappointmentscheduler/databinding/AppointmentSchedulerFragmentBinding;", "lpAppointmentInfo", "Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;", "mOldOrientation", "", "onPageChangeListener", "Landroidx/viewpager/widget/ViewPager$OnPageChangeListener;", "viewModel", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSchedulerViewModel;", "addViewModelObservers", "", "closeScheduler", "appointmentSlot", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "holdCurrentOrientation", "initViews", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroyView", "onStart", "onViewCreated", "view", "restoreOriginalOrientation", "registerChevronListeners", "registerPageChangedListener", "Companion", "AppointmentScheduler_release"})
@SourceDebugExtension(value={"SMAP\nAppointmentSchedulerFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppointmentSchedulerFragment.kt\ncom/liveperson/lpappointmentscheduler/AppointmentSchedulerFragment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
public final class AppointmentSchedulerFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AppointmentSchedulerFragmentBinding _binding;
    @Nullable
    private ViewPager.OnPageChangeListener onPageChangeListener;
    @Nullable
    private LPAppointmentInfo lpAppointmentInfo;
    private AppointmentSchedulerViewModel viewModel;
    private int mOldOrientation = -1;
    @NotNull
    public static final String REQUEST_KEY = "appointment.request";
    @NotNull
    public static final String KEY_APPOINTMENT_SLOT = "appointment.slot";
    @NotNull
    public static final String TAG = "AppointmentSchedulerFragment";
    @NotNull
    public static final String KEY_INIT_INFO = "LPAppointmentInitInfo";

    private final AppointmentSchedulerFragmentBinding getBinding() {
        AppointmentSchedulerFragmentBinding appointmentSchedulerFragmentBinding = this._binding;
        Intrinsics.checkNotNull((Object)appointmentSchedulerFragmentBinding);
        return appointmentSchedulerFragmentBinding;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        LPAppointmentInfo lPAppointmentInfo;
        AppointmentSchedulerFragment appointmentSchedulerFragment;
        super.onCreate(savedInstanceState);
        AppointmentSchedulerFragment appointmentSchedulerFragment2 = this;
        try {
            LPAppointmentInfo lPAppointmentInfo2;
            appointmentSchedulerFragment = appointmentSchedulerFragment2;
            if (Build.VERSION.SDK_INT >= 33) {
                Bundle bundle = this.getArguments();
                lPAppointmentInfo2 = bundle != null ? (LPAppointmentInfo)bundle.getParcelable(KEY_INIT_INFO, LPAppointmentInfo.class) : null;
            } else {
                Bundle bundle = this.getArguments();
                lPAppointmentInfo2 = bundle != null ? (LPAppointmentInfo)bundle.getParcelable(KEY_INIT_INFO) : null;
            }
            lPAppointmentInfo = lPAppointmentInfo2;
        }
        catch (Throwable throwable) {
            appointmentSchedulerFragment = appointmentSchedulerFragment2;
            lPAppointmentInfo = null;
        }
        appointmentSchedulerFragment.lpAppointmentInfo = lPAppointmentInfo;
        if (this.lpAppointmentInfo == null) {
            LPAppointmentLog.INSTANCE.w(TAG, "LPAppointmentInfo is null. Closing Appointment Scheduler");
            AppointmentSchedulerFragment.closeScheduler$default(this, null, 1, null);
            return;
        }
        LPAppointmentInfo lPAppointmentInfo3 = this.lpAppointmentInfo;
        Intrinsics.checkNotNull((Object)lPAppointmentInfo3);
        AppointmentSchedulerViewModelFactory viewModelFactory = new AppointmentSchedulerViewModelFactory(lPAppointmentInfo3);
        ViewModel viewModel = new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)viewModelFactory).get(AppointmentSchedulerViewModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)viewModel, (String)"ViewModelProvider(this, \u2026lerViewModel::class.java)");
        this.viewModel = (AppointmentSchedulerViewModel)viewModel;
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        View view = inflater.inflate(R.layout.appointment_scheduler_fragment, container, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"inflater.inflate(R.layou\u2026agment, container, false)");
        return view;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this._binding = AppointmentSchedulerFragmentBinding.bind(view);
        LPAppointmentInfo lPAppointmentInfo = this.lpAppointmentInfo;
        if (lPAppointmentInfo == null) {
            return;
        }
        this.getBinding().appointmentList.setAdapter((RecyclerView.Adapter)new LPAppointmentListAdapter(lPAppointmentInfo));
        CustomTextView customTextView = this.getBinding().headerTitle;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)customTextView), (String)"binding.headerTitle");
        AccessibilityUtilsKt.markAsAccessibilityHeading((View)customTextView, true);
        this.getBinding().headerTitle.setImportantForAccessibility(1);
        CustomTextView customTextView2 = this.getBinding().headerDate;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)customTextView2), (String)"binding.headerDate");
        AccessibilityUtilsKt.markAsAccessibilityHeading((View)customTextView2, true);
        this.getBinding().headerDate.setImportantForAccessibility(1);
        this.getBinding().appointmentList.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.requireContext(), 1));
        this.addViewModelObservers();
        this.initViews();
    }

    /*
     * WARNING - void declaration
     */
    private final void initViews() {
        void $this$initViews_u24lambda_u243_u24lambda_u240;
        ViewPager.OnPageChangeListener onPageChangeListener;
        AppointmentSchedulerViewModel appointmentSchedulerViewModel;
        Context context;
        LPAppointmentWeekView lPAppointmentWeekView;
        AppointmentSchedulerFragmentBinding appointmentSchedulerFragmentBinding;
        LPAppointmentLog.INSTANCE.d(TAG, "initViews: Initializing views");
        AppointmentSchedulerFragmentBinding $this$initViews_u24lambda_u243 = appointmentSchedulerFragmentBinding = this.getBinding();
        boolean bl = false;
        if (this.getContext() != null) {
            lPAppointmentWeekView = $this$initViews_u24lambda_u243.appointmentWeekView;
            context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            appointmentSchedulerViewModel = this.viewModel;
            if (appointmentSchedulerViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                appointmentSchedulerViewModel = null;
            }
        } else {
            LPAppointmentLog.INSTANCE.e(TAG, "initViews: context is null. Closing Appointment Scheduler");
            AppointmentSchedulerFragment.closeScheduler$default(this, null, 1, null);
            return;
        }
        lPAppointmentWeekView.initViews(context, appointmentSchedulerViewModel, this.lpAppointmentInfo);
        ViewPager.OnPageChangeListener onPageChangeListener2 = onPageChangeListener = this.registerPageChangedListener($this$initViews_u24lambda_u243);
        AppointmentSchedulerFragment appointmentSchedulerFragment = this;
        boolean bl2 = false;
        $this$initViews_u24lambda_u243_u24lambda_u240.onPageSelected(0);
        appointmentSchedulerFragment.onPageChangeListener = onPageChangeListener;
        $this$initViews_u24lambda_u243.closeButton.setOnClickListener(arg_0 -> AppointmentSchedulerFragment.initViews$lambda$3$lambda$1(this, arg_0));
        $this$initViews_u24lambda_u243.buttonConfirm.setOnClickListener(arg_0 -> AppointmentSchedulerFragment.initViews$lambda$3$lambda$2(this, arg_0));
        this.registerChevronListeners($this$initViews_u24lambda_u243);
    }

    private final void addViewModelObservers() {
        LPAppointmentLog.INSTANCE.d(TAG, "addViewModelObservers: Setting LiveData observers");
        AppointmentSchedulerViewModel appointmentSchedulerViewModel = this.viewModel;
        if (appointmentSchedulerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            appointmentSchedulerViewModel = null;
        }
        appointmentSchedulerViewModel.getHeaderTitle().observe(this.getViewLifecycleOwner(), arg_0 -> AppointmentSchedulerFragment.addViewModelObservers$lambda$4(this, arg_0));
        AppointmentSchedulerViewModel appointmentSchedulerViewModel2 = this.viewModel;
        if (appointmentSchedulerViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            appointmentSchedulerViewModel2 = null;
        }
        appointmentSchedulerViewModel2.getHeaderDate().observe(this.getViewLifecycleOwner(), arg_0 -> AppointmentSchedulerFragment.addViewModelObservers$lambda$5(this, arg_0));
        AppointmentSchedulerViewModel appointmentSchedulerViewModel3 = this.viewModel;
        if (appointmentSchedulerViewModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            appointmentSchedulerViewModel3 = null;
        }
        appointmentSchedulerViewModel3.getWeekDate().observe(this.getViewLifecycleOwner(), arg_0 -> AppointmentSchedulerFragment.addViewModelObservers$lambda$6(this, arg_0));
        AppointmentSchedulerViewModel appointmentSchedulerViewModel4 = this.viewModel;
        if (appointmentSchedulerViewModel4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            appointmentSchedulerViewModel4 = null;
        }
        appointmentSchedulerViewModel4.getCurrentAppointmentSlots().observe(this.getViewLifecycleOwner(), arg_0 -> AppointmentSchedulerFragment.addViewModelObservers$lambda$8(this, arg_0));
        AppointmentSchedulerViewModel appointmentSchedulerViewModel5 = this.viewModel;
        if (appointmentSchedulerViewModel5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            appointmentSchedulerViewModel5 = null;
        }
        appointmentSchedulerViewModel5.getSelectedAppointmentSlot().observe(this.getViewLifecycleOwner(), arg_0 -> AppointmentSchedulerFragment.addViewModelObservers$lambda$9(this, arg_0));
    }

    private final void closeScheduler(AppointmentSlot appointmentSlot) {
        Bundle bundle;
        if (appointmentSlot != null) {
            LPAppointmentLog.INSTANCE.i(TAG, "Consumer confirmed appointment: " + appointmentSlot);
        }
        this.restoreOriginalOrientation();
        Bundle $this$closeScheduler_u24lambda_u2410 = bundle = new Bundle();
        boolean bl = false;
        $this$closeScheduler_u24lambda_u2410.putParcelable(KEY_APPOINTMENT_SLOT, (Parcelable)appointmentSlot);
        Bundle bundle2 = bundle;
        this.getParentFragmentManager().setFragmentResult(REQUEST_KEY, bundle2);
    }

    static /* synthetic */ void closeScheduler$default(AppointmentSchedulerFragment appointmentSchedulerFragment, AppointmentSlot appointmentSlot, int n, Object object) {
        if ((n & 1) != 0) {
            appointmentSlot = null;
        }
        appointmentSchedulerFragment.closeScheduler(appointmentSlot);
    }

    public void onStart() {
        super.onStart();
        this.holdCurrentOrientation();
    }

    private final void holdCurrentOrientation() {
        Configuration config = this.getResources().getConfiguration();
        int orientation = config.orientation;
        LPAppointmentLog.INSTANCE.d(TAG, "holdCurrentOrientation: config = " + (orientation == 1 ? "Configuration.ORIENTATION_PORTRAIT" : "Configuration.ORIENTATION_LANDSCAPE"));
        LPAppointmentLog.INSTANCE.d(TAG, "holdCurrentOrientation: old orientation = " + this.requireActivity().getRequestedOrientation());
        if (this.mOldOrientation == -1) {
            this.mOldOrientation = this.requireActivity().getRequestedOrientation();
        }
        LPAppointmentLog.INSTANCE.d(TAG, "holdCurrentOrientation: Getting old orientation: " + this.mOldOrientation);
        switch (orientation) {
            case 1: {
                this.requireActivity().setRequestedOrientation(1);
                break;
            }
            case 2: {
                this.requireActivity().setRequestedOrientation(0);
            }
        }
    }

    private final void restoreOriginalOrientation() {
        LPAppointmentLog.INSTANCE.d(TAG, "restoreOriginalOrientation: oldOrientation = " + this.mOldOrientation);
        this.requireActivity().setRequestedOrientation(this.mOldOrientation);
    }

    public void onDestroyView() {
        super.onDestroyView();
        ViewPager.OnPageChangeListener onPageChangeListener = this.onPageChangeListener;
        if (onPageChangeListener != null) {
            ViewPager.OnPageChangeListener it = onPageChangeListener;
            boolean bl = false;
            this.getBinding().appointmentWeekView.removeOnPageSelectionChangeListener(it);
        }
        this._binding = null;
    }

    private final void registerChevronListeners(AppointmentSchedulerFragmentBinding $this$registerChevronListeners) {
        $this$registerChevronListeners.nextWeekButton.setOnClickListener(arg_0 -> AppointmentSchedulerFragment.registerChevronListeners$lambda$12($this$registerChevronListeners, arg_0));
        $this$registerChevronListeners.prevWeekButton.setOnClickListener(arg_0 -> AppointmentSchedulerFragment.registerChevronListeners$lambda$13($this$registerChevronListeners, arg_0));
    }

    private final ViewPager.OnPageChangeListener registerPageChangedListener(AppointmentSchedulerFragmentBinding $this$registerPageChangedListener) {
        ImageButton imageButton = $this$registerPageChangedListener.prevWeekButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageButton, (String)"prevWeekButton");
        ImageButton imageButton2 = $this$registerPageChangedListener.nextWeekButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageButton2, (String)"nextWeekButton");
        OnPageChangeListenerImpl pageChangeListener2 = new OnPageChangeListenerImpl(imageButton, imageButton2, (Function0<Integer>)((Function0)new Function0<Integer>($this$registerPageChangedListener){
            final /* synthetic */ AppointmentSchedulerFragmentBinding $this_registerPageChangedListener;
            {
                this.$this_registerPageChangedListener = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.$this_registerPageChangedListener.appointmentWeekView.getWeeksCount();
            }
        }));
        $this$registerPageChangedListener.appointmentWeekView.addOnPageSelectionChangeListener(pageChangeListener2);
        return pageChangeListener2;
    }

    private static final void initViews$lambda$3$lambda$1(AppointmentSchedulerFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        AppointmentSchedulerFragment.closeScheduler$default(this$0, null, 1, null);
    }

    private static final void initViews$lambda$3$lambda$2(AppointmentSchedulerFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        AppointmentSchedulerViewModel appointmentSchedulerViewModel = this$0.viewModel;
        if (appointmentSchedulerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            appointmentSchedulerViewModel = null;
        }
        this$0.closeScheduler((AppointmentSlot)appointmentSchedulerViewModel.getSelectedAppointmentSlot().getValue());
    }

    private static final void addViewModelObservers$lambda$4(AppointmentSchedulerFragment this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getBinding().headerTitle.setText(it);
    }

    private static final void addViewModelObservers$lambda$5(AppointmentSchedulerFragment this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getBinding().headerDate.setText(it);
        Object[] objectArray = new Object[]{it};
        this$0.getBinding().headerDate.setContentDescription(this$0.getString(R.string.lp_accessibility_selected_day, objectArray));
    }

    private static final void addViewModelObservers$lambda$6(AppointmentSchedulerFragment this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getBinding().weekDateView.setText(it);
        Object[] objectArray = new Object[]{it};
        this$0.getBinding().weekDateView.setContentDescription(this$0.getString(R.string.lp_accessibility_current_month, objectArray));
    }

    private static final void addViewModelObservers$lambda$8(AppointmentSchedulerFragment this$0, List it) {
        block1: {
            LPAppointmentListAdapter adapter;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            List list = it;
            if (list == null) break block1;
            List it2 = list;
            boolean bl = false;
            LPAppointmentLog.INSTANCE.d(TAG, "Loaded " + it2.size() + " appointment slots into the view");
            AppointmentSchedulerFragmentBinding appointmentSchedulerFragmentBinding = this$0._binding;
            RecyclerView.Adapter adapter2 = appointmentSchedulerFragmentBinding != null && (appointmentSchedulerFragmentBinding = appointmentSchedulerFragmentBinding.appointmentList) != null ? appointmentSchedulerFragmentBinding.getAdapter() : null;
            LPAppointmentListAdapter lPAppointmentListAdapter = adapter = adapter2 instanceof LPAppointmentListAdapter ? (LPAppointmentListAdapter)adapter2 : null;
            if (lPAppointmentListAdapter != null) {
                lPAppointmentListAdapter.submitList(it2);
            }
        }
    }

    private static final void addViewModelObservers$lambda$9(AppointmentSchedulerFragment this$0, AppointmentSlot it) {
        LPAppointmentListAdapter adapter;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        AppointmentSchedulerFragmentBinding appointmentSchedulerFragmentBinding = this$0._binding;
        RecyclerView.Adapter adapter2 = appointmentSchedulerFragmentBinding != null && (appointmentSchedulerFragmentBinding = appointmentSchedulerFragmentBinding.appointmentList) != null ? appointmentSchedulerFragmentBinding.getAdapter() : null;
        LPAppointmentListAdapter lPAppointmentListAdapter = adapter = adapter2 instanceof LPAppointmentListAdapter ? (LPAppointmentListAdapter)adapter2 : null;
        if (lPAppointmentListAdapter != null) {
            lPAppointmentListAdapter.setSelectedAppointmentSlot(it);
        }
        this$0.getBinding().buttonConfirm.setEnabled(it != null);
    }

    private static final void registerChevronListeners$lambda$12(AppointmentSchedulerFragmentBinding $this_registerChevronListeners, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_registerChevronListeners, (String)"$this_registerChevronListeners");
        int nextPosition = $this_registerChevronListeners.appointmentWeekView.getCurrentPosition() + 1;
        if (nextPosition < $this_registerChevronListeners.appointmentWeekView.getWeeksCount()) {
            $this_registerChevronListeners.appointmentWeekView.scrollToPosition(nextPosition);
        }
    }

    private static final void registerChevronListeners$lambda$13(AppointmentSchedulerFragmentBinding $this_registerChevronListeners, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_registerChevronListeners, (String)"$this_registerChevronListeners");
        int prevPosition = $this_registerChevronListeners.appointmentWeekView.getCurrentPosition() - 1;
        if (prevPosition > -1) {
            $this_registerChevronListeners.appointmentWeekView.scrollToPosition(prevPosition);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/liveperson/lpappointmentscheduler/AppointmentSchedulerFragment$Companion;", "", "()V", "KEY_APPOINTMENT_SLOT", "", "KEY_INIT_INFO", "REQUEST_KEY", "TAG", "AppointmentScheduler_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

