/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpappointmentscheduler;

import android.content.Context;
import com.liveperson.lpappointmentscheduler.logger.AppointmentSchedulerLog;
import com.liveperson.lpappointmentscheduler.logger.LPAppointmentLog;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/liveperson/lpappointmentscheduler/LPAppointmentScheduler;", "", "()V", "Companion", "AppointmentScheduler_release"})
public final class LPAppointmentScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "LPAppointmentList";
    @NotNull
    private static final String KEY_TYPE = "type";
    @NotNull
    private static final String SCHEDULE_TYPE = "scheduleSlotList";

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/liveperson/lpappointmentscheduler/LPAppointmentScheduler$Companion;", "", "()V", "KEY_TYPE", "", "SCHEDULE_TYPE", "TAG", "initialize", "Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;", "context", "Landroid/content/Context;", "appointmentListJSON", "Lorg/json/JSONObject;", "subscribeToLogs", "", "appointmentSchedulerLog", "Lcom/liveperson/lpappointmentscheduler/logger/AppointmentSchedulerLog;", "unSubscribeToLogs", "AppointmentScheduler_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LPAppointmentInfo initialize(@NotNull Context context, @NotNull JSONObject appointmentListJSON) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)appointmentListJSON, (String)"appointmentListJSON");
            try {
                String type = appointmentListJSON.getString(LPAppointmentScheduler.KEY_TYPE);
                if (type.equals(LPAppointmentScheduler.SCHEDULE_TYPE)) {
                    return new LPAppointmentInfo(context, appointmentListJSON);
                }
                throw new IllegalArgumentException("Invalid JSON Type. Type should be 'scheduleSlotList'. Current type: " + type);
            }
            catch (Exception error) {
                LPAppointmentLog.INSTANCE.e(LPAppointmentScheduler.TAG, "Failed to initialize appointment scheduler. " + error);
                throw new IllegalArgumentException(error);
            }
        }

        public final void subscribeToLogs(@NotNull AppointmentSchedulerLog appointmentSchedulerLog) {
            Intrinsics.checkNotNullParameter((Object)appointmentSchedulerLog, (String)"appointmentSchedulerLog");
            LPAppointmentLog.INSTANCE.addSubscription(appointmentSchedulerLog);
        }

        public final void unSubscribeToLogs(@NotNull AppointmentSchedulerLog appointmentSchedulerLog) {
            Intrinsics.checkNotNullParameter((Object)appointmentSchedulerLog, (String)"appointmentSchedulerLog");
            LPAppointmentLog.INSTANCE.removeSubscription(appointmentSchedulerLog);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

