/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpappointmentscheduler.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.lpappointmentscheduler.AppointmentOperationsHolder;
import com.liveperson.lpappointmentscheduler.R;
import com.liveperson.lpappointmentscheduler.adapters.AppointmentSlotDiffCallback;
import com.liveperson.lpappointmentscheduler.databinding.AppointmentListItemBinding;
import com.liveperson.lpappointmentscheduler.models.AppointmentSlot;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import com.liveperson.lpappointmentscheduler.utils.AppointmentUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/liveperson/lpappointmentscheduler/adapters/LPAppointmentListAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "Lcom/liveperson/lpappointmentscheduler/adapters/LPAppointmentListAdapter$ViewHolder;", "lpAppointmentInfo", "Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;", "(Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;)V", "value", "selectedAppointmentSlot", "getSelectedAppointmentSlot", "()Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "setSelectedAppointmentSlot", "(Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;)V", "onBindViewHolder", "", "holder", "position", "", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewRecycled", "ViewHolder", "AppointmentScheduler_release"})
@SourceDebugExtension(value={"SMAP\nLPAppointmentListAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LPAppointmentListAdapter.kt\ncom/liveperson/lpappointmentscheduler/adapters/LPAppointmentListAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n350#2,7:194\n350#2,7:201\n*S KotlinDebug\n*F\n+ 1 LPAppointmentListAdapter.kt\ncom/liveperson/lpappointmentscheduler/adapters/LPAppointmentListAdapter\n*L\n25#1:194,7\n27#1:201,7\n*E\n"})
public final class LPAppointmentListAdapter
extends ListAdapter<AppointmentSlot, ViewHolder> {
    @NotNull
    private final LPAppointmentInfo lpAppointmentInfo;
    @Nullable
    private AppointmentSlot selectedAppointmentSlot;

    public LPAppointmentListAdapter(@NotNull LPAppointmentInfo lpAppointmentInfo) {
        Intrinsics.checkNotNullParameter((Object)lpAppointmentInfo, (String)"lpAppointmentInfo");
        super((DiffUtil.ItemCallback)new AppointmentSlotDiffCallback());
        this.lpAppointmentInfo = lpAppointmentInfo;
    }

    @Nullable
    public final AppointmentSlot getSelectedAppointmentSlot() {
        return this.selectedAppointmentSlot;
    }

    public final void setSelectedAppointmentSlot(@Nullable AppointmentSlot value) {
        int currentIndex;
        int prevIndex;
        block7: {
            int n;
            int n2;
            block6: {
                List list = this.getCurrentList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"currentList");
                List $this$indexOfFirst$iv = list;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    AppointmentSlot it = (AppointmentSlot)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)this.selectedAppointmentSlot, (Object)it)) {
                        n2 = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            prevIndex = n2;
            this.selectedAppointmentSlot = value;
            List list = this.getCurrentList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"currentList");
            List $this$indexOfFirst$iv = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                AppointmentSlot it = (AppointmentSlot)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)value, (Object)it)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = currentIndex = -1;
        }
        if (prevIndex > -1) {
            this.notifyItemChanged(prevIndex, new Object());
        }
        if (currentIndex > -1) {
            this.notifyItemChanged(currentIndex, new Object());
        }
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return ViewHolder.Companion.from(parent);
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        AppointmentSlot item = (AppointmentSlot)this.getItem(position);
        if (Intrinsics.areEqual((Object)this.selectedAppointmentSlot, (Object)item)) {
            holder.setSelected();
        } else {
            holder.clearSelected();
        }
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
        holder.bind(item, this.lpAppointmentInfo);
        holder.itemView.setOnClickListener(arg_0 -> LPAppointmentListAdapter.onBindViewHolder$lambda$2(this, item, arg_0));
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position, @NotNull List<Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        AppointmentSlot item = (AppointmentSlot)this.getItem(position);
        if (Intrinsics.areEqual((Object)this.selectedAppointmentSlot, (Object)item)) {
            holder.setSelected();
        } else {
            holder.clearSelected();
        }
    }

    public void onViewRecycled(@NotNull ViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        if (holder.isItemSelected()) {
            holder.clearSelected();
        }
    }

    private static final void onBindViewHolder$lambda$2(LPAppointmentListAdapter this$0, AppointmentSlot $item, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        LPAppointmentInfo lPAppointmentInfo = this$0.lpAppointmentInfo;
        Intrinsics.checkNotNullExpressionValue((Object)$item, (String)"item");
        lPAppointmentInfo.notifyAppointmentSelected($item);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\rJ\u0006\u0010\u0013\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/liveperson/lpappointmentscheduler/adapters/LPAppointmentListAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/liveperson/lpappointmentscheduler/databinding/AppointmentListItemBinding;", "(Lcom/liveperson/lpappointmentscheduler/databinding/AppointmentListItemBinding;)V", "getBinding", "()Lcom/liveperson/lpappointmentscheduler/databinding/AppointmentListItemBinding;", "isItemSelected", "", "()Z", "setItemSelected", "(Z)V", "bind", "", "item", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "lpAppointmentInfo", "Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;", "clearSelected", "setSelected", "Companion", "AppointmentScheduler_release"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final AppointmentListItemBinding binding;
        private boolean isItemSelected;

        private ViewHolder(AppointmentListItemBinding binding) {
            super((View)binding.getRoot());
            this.binding = binding;
        }

        @NotNull
        public final AppointmentListItemBinding getBinding() {
            return this.binding;
        }

        public final boolean isItemSelected() {
            return this.isItemSelected;
        }

        public final void setItemSelected(boolean bl) {
            this.isItemSelected = bl;
        }

        public final void bind(@NotNull AppointmentSlot item, @NotNull LPAppointmentInfo lpAppointmentInfo) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)lpAppointmentInfo, (String)"lpAppointmentInfo");
            if (lpAppointmentInfo.getShouldHideText()) {
                this.binding.appointmentTitle.setVisibility(8);
                this.binding.appointmentDescription.setVisibility(8);
            } else {
                this.binding.appointmentTitle.setText(String.valueOf(item.getTitle()));
                CharSequence charSequence = item.getDescription();
                if (charSequence == null || charSequence.length() == 0) {
                    this.binding.appointmentDescription.setVisibility(8);
                } else {
                    this.binding.appointmentDescription.setText(item.getDescription().toString());
                }
            }
            String string3 = this.itemView.getContext().getString(R.string.lp_appointment_time_format);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"itemView.context.getStri\u2026_appointment_time_format)");
            String timeFormat = string3;
            StringBuilder stringBuilder = new StringBuilder();
            long l = item.getStartTime();
            Context context = this.itemView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
            StringBuilder stringBuilder2 = stringBuilder.append(AppointmentUtils.INSTANCE.getTimeText(l, timeFormat, context));
            if (item.getEndTime() > 0L) {
                StringBuilder stringBuilder3 = new StringBuilder().append(" - ");
                long l2 = item.getEndTime();
                Context context2 = this.itemView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"itemView.context");
                string2 = stringBuilder3.append(AppointmentUtils.INSTANCE.getTimeText(l2, timeFormat, context2)).toString();
            } else {
                string2 = "";
            }
            String time = stringBuilder2.append(string2).toString();
            this.binding.appointmentTime.setText(time);
            if (lpAppointmentInfo.getShouldHideImages() && lpAppointmentInfo.getShouldHideText()) {
                ConstraintSet cs = new ConstraintSet();
                cs.clone(this.binding.getRoot());
                cs.setHorizontalBias(this.binding.appointmentTime.getId(), 0.5f);
                cs.applyTo(this.binding.getRoot());
            }
            if (lpAppointmentInfo.getShouldHideImages()) {
                this.binding.appointmentImage.setVisibility(8);
            } else {
                ImageView imageView = this.binding.appointmentImage;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.appointmentImage");
                AppointmentOperationsHolder.INSTANCE.startImageLoading(imageView, item.getImageURL());
            }
        }

        public final void setSelected() {
            this.isItemSelected = true;
            this.itemView.setSelected(true);
            this.itemView.setBackgroundColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_appointment_selected_background_color));
            this.binding.appointmentTitle.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_appointment_selected_title_text_color));
            this.binding.appointmentDescription.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_appointment_selected_title_text_color));
            this.binding.appointmentTime.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_appointment_selected_time_text_color));
        }

        public final void clearSelected() {
            this.isItemSelected = false;
            this.itemView.setSelected(false);
            this.itemView.setBackgroundColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_appointment_scheduler_background_color));
            this.binding.appointmentTitle.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_appointment_title_text_color));
            this.binding.appointmentDescription.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_appointment_title_text_color));
            this.binding.appointmentTime.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_appointment_time_text_color));
        }

        public /* synthetic */ ViewHolder(AppointmentListItemBinding binding, DefaultConstructorMarker $constructor_marker) {
            this(binding);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/lpappointmentscheduler/adapters/LPAppointmentListAdapter$ViewHolder$Companion;", "", "()V", "from", "Lcom/liveperson/lpappointmentscheduler/adapters/LPAppointmentListAdapter$ViewHolder;", "parent", "Landroid/view/ViewGroup;", "AppointmentScheduler_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ViewHolder from(@NotNull ViewGroup parent) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
                AppointmentListItemBinding appointmentListItemBinding = AppointmentListItemBinding.inflate(layoutInflater, parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)appointmentListItemBinding, (String)"inflate(layoutInflater, parent, false)");
                AppointmentListItemBinding binding = appointmentListItemBinding;
                return new ViewHolder(binding, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

