/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpappointmentscheduler.models;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.liveperson.lpappointmentscheduler.AppointmentSelectionListener;
import com.liveperson.lpappointmentscheduler.logger.LPAppointmentLog;
import com.liveperson.lpappointmentscheduler.models.AppointmentSlot;
import com.liveperson.lpappointmentscheduler.models.Day;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0014J&\u0010(\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0018J\b\u0010+\u001a\u00020&H\u0002J\u0010\u0010,\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010\u0006J\u0012\u0010.\u001a\u00020&2\b\u0010/\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u00100\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010\u0006R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00148F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0016R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u00148F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0016\u00a8\u00061"}, d2={"Lcom/liveperson/lpappointmentscheduler/models/AppointmentSchedulerViewModel;", "Landroidx/lifecycle/ViewModel;", "lpAppointmentInfo", "Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;", "(Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "_currentAppointmentSlots", "Landroidx/lifecycle/MutableLiveData;", "", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "_headerDate", "_headerTitle", "_selectedAppointmentSlot", "_weekDate", "appointmentSelectionListener", "Lcom/liveperson/lpappointmentscheduler/AppointmentSelectionListener;", "currentAppointmentSlots", "Landroidx/lifecycle/LiveData;", "getCurrentAppointmentSlots", "()Landroidx/lifecycle/LiveData;", "currentSelectedDay", "Lcom/liveperson/lpappointmentscheduler/models/Day;", "getCurrentSelectedDay", "()Lcom/liveperson/lpappointmentscheduler/models/Day;", "setCurrentSelectedDay", "(Lcom/liveperson/lpappointmentscheduler/models/Day;)V", "headerDate", "getHeaderDate", "headerTitle", "getHeaderTitle", "selectedAppointmentSlot", "getSelectedAppointmentSlot", "weekDate", "getWeekDate", "observeAppointmentSelection", "", "onCleared", "onDateSelected", "selectedDate", "selectedDay", "setAppointmentSelectionListener", "setHeaderDate", "date", "setSelectedAppointmentSlot", "appointment", "setWeekDate", "AppointmentScheduler_release"})
public final class AppointmentSchedulerViewModel
extends ViewModel {
    @NotNull
    private final LPAppointmentInfo lpAppointmentInfo;
    @NotNull
    private final String TAG;
    @NotNull
    private MutableLiveData<String> _headerTitle;
    @NotNull
    private final MutableLiveData<String> _headerDate;
    @NotNull
    private final MutableLiveData<String> _weekDate;
    @NotNull
    private final MutableLiveData<AppointmentSlot> _selectedAppointmentSlot;
    @NotNull
    private final MutableLiveData<List<AppointmentSlot>> _currentAppointmentSlots;
    @Nullable
    private Day currentSelectedDay;
    private AppointmentSelectionListener appointmentSelectionListener;

    public AppointmentSchedulerViewModel(@NotNull LPAppointmentInfo lpAppointmentInfo) {
        Intrinsics.checkNotNullParameter((Object)lpAppointmentInfo, (String)"lpAppointmentInfo");
        this.lpAppointmentInfo = lpAppointmentInfo;
        this.TAG = "AppointmentSchedulerViewModel";
        this._headerTitle = new MutableLiveData();
        this._headerDate = new MutableLiveData();
        this._weekDate = new MutableLiveData();
        this._selectedAppointmentSlot = new MutableLiveData();
        this._currentAppointmentSlots = new MutableLiveData();
        this._headerTitle.setValue((Object)this.lpAppointmentInfo.getTitle());
        this.setAppointmentSelectionListener();
        this.observeAppointmentSelection();
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @NotNull
    public final LiveData<String> getHeaderTitle() {
        return (LiveData)this._headerTitle;
    }

    @NotNull
    public final LiveData<String> getHeaderDate() {
        return (LiveData)this._headerDate;
    }

    @NotNull
    public final LiveData<String> getWeekDate() {
        return (LiveData)this._weekDate;
    }

    @NotNull
    public final LiveData<AppointmentSlot> getSelectedAppointmentSlot() {
        return (LiveData)this._selectedAppointmentSlot;
    }

    @NotNull
    public final LiveData<List<AppointmentSlot>> getCurrentAppointmentSlots() {
        return (LiveData)this._currentAppointmentSlots;
    }

    @Nullable
    public final Day getCurrentSelectedDay() {
        return this.currentSelectedDay;
    }

    public final void setCurrentSelectedDay(@Nullable Day day) {
        this.currentSelectedDay = day;
    }

    public final void setWeekDate(@Nullable String date) {
        this._weekDate.postValue((Object)date);
    }

    public final void setHeaderDate(@Nullable String date) {
        this._headerDate.postValue((Object)date);
    }

    private final void setSelectedAppointmentSlot(AppointmentSlot appointment) {
        this._selectedAppointmentSlot.setValue((Object)appointment);
    }

    private final void observeAppointmentSelection() {
        LPAppointmentLog.INSTANCE.d(this.TAG, "observeAppointmentSelection: Subscribe to appointment selection");
        AppointmentSelectionListener appointmentSelectionListener = this.appointmentSelectionListener;
        if (appointmentSelectionListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appointmentSelectionListener");
            appointmentSelectionListener = null;
        }
        this.lpAppointmentInfo.subscribeToAppointmentSelectionChange(appointmentSelectionListener);
    }

    private final void setAppointmentSelectionListener() {
        this.appointmentSelectionListener = new AppointmentSelectionListener(this){
            final /* synthetic */ AppointmentSchedulerViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAppointmentSelected(@NotNull AppointmentSlot appointment) {
                Intrinsics.checkNotNullParameter((Object)appointment, (String)"appointment");
                AppointmentSchedulerViewModel.access$setSelectedAppointmentSlot(this.this$0, appointment);
            }
        };
    }

    public final void onDateSelected(@NotNull String headerDate, @NotNull String weekDate, @NotNull String selectedDate, @NotNull Day selectedDay) {
        Intrinsics.checkNotNullParameter((Object)headerDate, (String)"headerDate");
        Intrinsics.checkNotNullParameter((Object)weekDate, (String)"weekDate");
        Intrinsics.checkNotNullParameter((Object)selectedDate, (String)"selectedDate");
        Intrinsics.checkNotNullParameter((Object)selectedDay, (String)"selectedDay");
        this.setHeaderDate(headerDate);
        this.setWeekDate(weekDate);
        if (!Intrinsics.areEqual((Object)this.currentSelectedDay, (Object)selectedDay)) {
            this.setSelectedAppointmentSlot(null);
            this._currentAppointmentSlots.setValue(this.lpAppointmentInfo.getAppointmentSlots().get(selectedDate));
            this.currentSelectedDay = selectedDay;
        }
    }

    protected void onCleared() {
        super.onCleared();
        LPAppointmentLog.INSTANCE.d(this.TAG, "onCleared: Clear appointment selection subscription");
        AppointmentSelectionListener appointmentSelectionListener = this.appointmentSelectionListener;
        if (appointmentSelectionListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appointmentSelectionListener");
            appointmentSelectionListener = null;
        }
        this.lpAppointmentInfo.unsubscribeFromAppointmentSelectionChange(appointmentSelectionListener);
    }

    public static final /* synthetic */ void access$setSelectedAppointmentSlot(AppointmentSchedulerViewModel $this, AppointmentSlot appointment) {
        $this.setSelectedAppointmentSlot(appointment);
    }
}

