/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpappointmentscheduler.models;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.liveperson.lpappointmentscheduler.AppointmentSelectionListener;
import com.liveperson.lpappointmentscheduler.R;
import com.liveperson.lpappointmentscheduler.logger.LPAppointmentLog;
import com.liveperson.lpappointmentscheduler.models.AppointmentSlot;
import com.liveperson.lpappointmentscheduler.models.Week;
import com.liveperson.lpappointmentscheduler.utils.AppointmentUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u0000 K2\u00020\u0001:\u0001KB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020$H\u0002J\u000e\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020\u001bJ\u0018\u0010@\u001a\u00020<2\u0006\u0010=\u001a\u00020$2\u0006\u0010A\u001a\u00020$H\u0002J \u0010B\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020!H\u0002J\u000e\u0010E\u001a\u00020<2\u0006\u0010F\u001a\u00020\u0017J\u000e\u0010G\u001a\u00020)2\u0006\u0010F\u001a\u00020\u0017J\u0018\u0010H\u001a\u00020<2\u0006\u0010I\u001a\u00020\b2\u0006\u0010J\u001a\u00020:H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001e\u0010-\u001a\u00020)2\u0006\u0010(\u001a\u00020)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010,R\u001e\u0010/\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R>\u00105\u001a\u0012\u0012\u0004\u0012\u00020302j\b\u0012\u0004\u0012\u000203`42\u0016\u0010(\u001a\u0012\u0012\u0004\u0012\u00020302j\b\u0012\u0004\u0012\u000203`4@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006L"}, d2={"Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;", "Landroid/os/Parcelable;", "context", "Landroid/content/Context;", "appointmentListJSON", "Lorg/json/JSONObject;", "(Landroid/content/Context;Lorg/json/JSONObject;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "KEY_DESCRIPTION", "", "KEY_END_TIME", "KEY_FIRST_DAY_OF_WEEK", "KEY_ID", "KEY_IMAGE_URL", "KEY_SLOTS", "KEY_START_TIME", "KEY_TITLE", "KEY_TYPE", "TAG", "appointmentSelectionSubscriptions", "", "Lcom/liveperson/lpappointmentscheduler/AppointmentSelectionListener;", "appointmentSlots", "", "", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "getAppointmentSlots", "()Ljava/util/Map;", "setAppointmentSlots", "(Ljava/util/Map;)V", "calendarEndTime", "Ljava/util/Calendar;", "calendarStartTime", "currentSystemTime", "", "firstDayOfTheWeek", "maxStartTime", "minStartTime", "<set-?>", "", "shouldHideImages", "getShouldHideImages", "()Z", "shouldHideText", "getShouldHideText", "title", "getTitle", "()Ljava/lang/String;", "Ljava/util/ArrayList;", "Lcom/liveperson/lpappointmentscheduler/models/Week;", "Lkotlin/collections/ArrayList;", "visibleWeeks", "getVisibleWeeks", "()Ljava/util/ArrayList;", "buildParcelableMap", "describeContents", "", "findStartAndEndTime", "", "startTime", "notifyAppointmentSelected", "slot", "setStartAndEndTime", "endTime", "setVisibleWeeks", "startDate", "endDate", "subscribeToAppointmentSelectionChange", "subscription", "unsubscribeFromAppointmentSelectionChange", "writeToParcel", "dest", "flags", "CREATOR", "AppointmentScheduler_release"})
@SourceDebugExtension(value={"SMAP\nLPAppointmentInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LPAppointmentInfo.kt\ncom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n361#2,7:242\n1002#3,2:249\n*S KotlinDebug\n*F\n+ 1 LPAppointmentInfo.kt\ncom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo\n*L\n111#1:242,7\n116#1:249,2\n*E\n"})
public final class LPAppointmentInfo
implements Parcelable {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @NotNull
    private final String TAG;
    @NotNull
    private final String KEY_TITLE;
    @NotNull
    private final String KEY_FIRST_DAY_OF_WEEK;
    @NotNull
    private final String KEY_SLOTS;
    @NotNull
    private final String KEY_TYPE;
    @NotNull
    private final String KEY_ID;
    @NotNull
    private final String KEY_START_TIME;
    @NotNull
    private final String KEY_END_TIME;
    @NotNull
    private final String KEY_DESCRIPTION;
    @NotNull
    private final String KEY_IMAGE_URL;
    private long currentSystemTime;
    @NotNull
    private final Set<AppointmentSelectionListener> appointmentSelectionSubscriptions;
    private long minStartTime;
    private long maxStartTime;
    private Calendar calendarStartTime;
    private Calendar calendarEndTime;
    private Context context;
    @NotNull
    private String firstDayOfTheWeek;
    @NotNull
    private String title;
    @NotNull
    private Map<String, List<AppointmentSlot>> appointmentSlots;
    @NotNull
    private ArrayList<Week> visibleWeeks;
    private boolean shouldHideImages;
    private boolean shouldHideText;

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Map<String, List<AppointmentSlot>> getAppointmentSlots() {
        return this.appointmentSlots;
    }

    public final void setAppointmentSlots(@NotNull Map<String, List<AppointmentSlot>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.appointmentSlots = map;
    }

    @NotNull
    public final ArrayList<Week> getVisibleWeeks() {
        return this.visibleWeeks;
    }

    public final boolean getShouldHideImages() {
        return this.shouldHideImages;
    }

    public final boolean getShouldHideText() {
        return this.shouldHideText;
    }

    public LPAppointmentInfo(@NotNull Context context, @NotNull JSONObject appointmentListJSON) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appointmentListJSON, (String)"appointmentListJSON");
        this.TAG = "LPAppointmentInfo";
        this.KEY_TITLE = "title";
        this.KEY_FIRST_DAY_OF_WEEK = "firstDayOfTheWeek";
        this.KEY_SLOTS = "slots";
        this.KEY_TYPE = "type";
        this.KEY_ID = "id";
        this.KEY_START_TIME = "start";
        this.KEY_END_TIME = "end";
        this.KEY_DESCRIPTION = "description";
        this.KEY_IMAGE_URL = "imageUrl";
        this.currentSystemTime = -1L;
        this.appointmentSelectionSubscriptions = new HashSet();
        this.minStartTime = -1L;
        this.maxStartTime = -1L;
        this.firstDayOfTheWeek = "mon";
        this.title = "";
        this.appointmentSlots = new LinkedHashMap();
        this.visibleWeeks = new ArrayList();
        this.shouldHideImages = true;
        this.shouldHideText = true;
        try {
            Calendar calendar;
            this.context = context;
            this.currentSystemTime = System.currentTimeMillis();
            JSONArray slots = appointmentListJSON.getJSONArray(this.KEY_SLOTS);
            String currentDate = null;
            LPAppointmentLog.INSTANCE.i(this.TAG, "Total appointment slots received: " + slots.length());
            int n = slots.length();
            for (int i = 0; i < n; ++i) {
                List list;
                JSONObject appointment = slots.getJSONObject(i);
                String type = "";
                String id2 = "";
                long startTime = 0L;
                long endTime = 0L;
                String title = "";
                String description = "";
                String imageUrl = "";
                if (appointment.has(this.KEY_TYPE)) {
                    String string2 = appointment.getString(this.KEY_TYPE);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"appointment.getString(KEY_TYPE)");
                    type = string2;
                }
                if (appointment.has(this.KEY_ID)) {
                    String string3 = appointment.getString(this.KEY_ID);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"appointment.getString(KEY_ID)");
                    id2 = string3;
                }
                if (appointment.has(this.KEY_START_TIME)) {
                    startTime = appointment.getLong(this.KEY_START_TIME) * (long)1000;
                    if (startTime < this.currentSystemTime) {
                        LPAppointmentLog.INSTANCE.w(this.TAG, "Found appointment start time in the past. Do not add it in the list. Id: " + id2);
                        continue;
                    }
                } else {
                    throw new IllegalArgumentException("Missing start time of an appointment. Id: " + id2);
                }
                if (appointment.has(this.KEY_END_TIME)) {
                    endTime = appointment.getLong(this.KEY_END_TIME) * (long)1000;
                }
                if (appointment.has(this.KEY_TITLE)) {
                    String string4 = appointment.getString(this.KEY_TITLE);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"appointment.getString(KEY_TITLE)");
                    title = string4;
                }
                if (appointment.has(this.KEY_DESCRIPTION)) {
                    String string5 = appointment.getString(this.KEY_DESCRIPTION);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"appointment.getString(KEY_DESCRIPTION)");
                    description = string5;
                }
                if (appointment.has(this.KEY_IMAGE_URL)) {
                    String string6 = appointment.getString(this.KEY_IMAGE_URL);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"appointment.getString(KEY_IMAGE_URL)");
                    imageUrl = string6;
                }
                if (this.shouldHideText && ((CharSequence)title).length() > 0 || ((CharSequence)description).length() > 0) {
                    this.shouldHideText = false;
                }
                if (this.shouldHideImages && ((CharSequence)imageUrl).length() > 0) {
                    this.shouldHideImages = false;
                }
                Calendar calendar2 = AppointmentUtils.INSTANCE.getCalendarDate(startTime);
                String string7 = context.getResources().getString(R.string.lp_appointment_available_date_format);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"context.resources.getStr\u2026nt_available_date_format)");
                currentDate = AppointmentUtils.INSTANCE.getDateText(calendar2, string7, context);
                Map<String, List<AppointmentSlot>> $this$getOrPut$iv = this.appointmentSlots;
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(currentDate);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(currentDate, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                list.add(new AppointmentSlot(type, id2, startTime, endTime, title, description, imageUrl));
                this.findStartAndEndTime(startTime);
            }
            Iterator<Map.Entry<String, List<AppointmentSlot>>> iterator = this.appointmentSlots.entrySet().iterator();
            while (iterator.hasNext()) {
                List<AppointmentSlot> value;
                List<AppointmentSlot> $this$sortBy$iv = value = iterator.next().getValue();
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() <= 1) continue;
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        AppointmentSlot it = (AppointmentSlot)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getStartTime());
                        it = (AppointmentSlot)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStartTime()));
                    }
                });
            }
            if (appointmentListJSON.has(this.KEY_TITLE)) {
                String string8 = appointmentListJSON.getString(this.KEY_TITLE);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"appointmentListJSON.getString(KEY_TITLE)");
                this.title = string8;
            }
            if (appointmentListJSON.has(this.KEY_FIRST_DAY_OF_WEEK)) {
                String string9 = appointmentListJSON.getString(this.KEY_FIRST_DAY_OF_WEEK);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"appointmentListJSON.getS\u2026ng(KEY_FIRST_DAY_OF_WEEK)");
                this.firstDayOfTheWeek = string9;
            }
            if (Intrinsics.areEqual((Object)this.firstDayOfTheWeek, (Object)"sun")) {
                AppointmentUtils.INSTANCE.setWeekOffset(0);
            } else {
                AppointmentUtils.INSTANCE.setWeekOffset(1);
            }
            LPAppointmentLog.INSTANCE.i(this.TAG, "First day of week is " + this.firstDayOfTheWeek);
            this.setStartAndEndTime(this.minStartTime, this.maxStartTime);
            Calendar calendar3 = this.calendarStartTime;
            if (calendar3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStartTime");
                calendar3 = null;
            }
            if ((calendar = this.calendarEndTime) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarEndTime");
                calendar = null;
            }
            this.setVisibleWeeks(context, calendar3, calendar);
        }
        catch (Exception error) {
            LPAppointmentLog.INSTANCE.e(this.TAG, "LPAppointmentInfo(): Failed to parse appointment data. " + error);
            throw new IllegalArgumentException(error);
        }
    }

    private final void findStartAndEndTime(long startTime) {
        if (this.minStartTime == -1L) {
            this.minStartTime = startTime;
        } else if (startTime < this.minStartTime) {
            this.minStartTime = startTime;
        }
        if (startTime > this.maxStartTime) {
            this.maxStartTime = startTime;
        }
    }

    private final void setStartAndEndTime(long startTime, long endTime) {
        long appointmentStartTime = this.currentSystemTime;
        if (startTime > appointmentStartTime) {
            appointmentStartTime = startTime;
        }
        this.calendarStartTime = AppointmentUtils.INSTANCE.getCalendarDate(appointmentStartTime);
        this.calendarEndTime = AppointmentUtils.INSTANCE.getCalendarDate(endTime);
    }

    private final void setVisibleWeeks(Context context, Calendar startDate, Calendar endDate) {
        LPAppointmentLog.INSTANCE.d(this.TAG, "setVisibleWeeks: Calculating weeks to show");
        this.visibleWeeks = AppointmentUtils.INSTANCE.calculateVisibleWeeks(context, startDate, endDate, this.firstDayOfTheWeek, this.appointmentSlots);
        LPAppointmentLog.INSTANCE.d(this.TAG, "setVisibleWeeks: Total visible weeks to display: " + this.visibleWeeks.size());
    }

    public final void notifyAppointmentSelected(@NotNull AppointmentSlot slot) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        LPAppointmentLog.INSTANCE.d(this.TAG, "notifyAppointmentSelected: " + slot);
        for (AppointmentSelectionListener subscription : this.appointmentSelectionSubscriptions) {
            subscription.onAppointmentSelected(slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void subscribeToAppointmentSelectionChange(@NotNull AppointmentSelectionListener subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        LPAppointmentInfo lPAppointmentInfo = this;
        synchronized (lPAppointmentInfo) {
            boolean bl = false;
            boolean bl2 = this.appointmentSelectionSubscriptions.add(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unsubscribeFromAppointmentSelectionChange(@NotNull AppointmentSelectionListener subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        LPAppointmentInfo lPAppointmentInfo = this;
        synchronized (lPAppointmentInfo) {
            boolean bl = false;
            boolean bl2 = this.appointmentSelectionSubscriptions.remove(subscription);
            return bl2;
        }
    }

    private final Map<String, List<AppointmentSlot>> buildParcelableMap(Parcel parcel) {
        int size = parcel.readInt();
        Map map = new LinkedHashMap();
        int t = 1;
        if (t <= size) {
            while (true) {
                List list;
                String key = String.valueOf(parcel.readString());
                List $this$buildParcelableMap_u24lambda_u244 = list = (List)new ArrayList();
                boolean bl = false;
                parcel.readList($this$buildParcelableMap_u24lambda_u244, AppointmentSlot.class.getClassLoader());
                List value = list;
                map.put(key, value);
                if (t == size) break;
                ++t;
            }
        }
        return map;
    }

    private LPAppointmentInfo(Parcel parcel) {
        ArrayList arrayList;
        String string2;
        this.TAG = "LPAppointmentInfo";
        this.KEY_TITLE = "title";
        this.KEY_FIRST_DAY_OF_WEEK = "firstDayOfTheWeek";
        this.KEY_SLOTS = "slots";
        this.KEY_TYPE = "type";
        this.KEY_ID = "id";
        this.KEY_START_TIME = "start";
        this.KEY_END_TIME = "end";
        this.KEY_DESCRIPTION = "description";
        this.KEY_IMAGE_URL = "imageUrl";
        this.currentSystemTime = -1L;
        this.appointmentSelectionSubscriptions = new HashSet();
        this.minStartTime = -1L;
        this.maxStartTime = -1L;
        this.firstDayOfTheWeek = "mon";
        this.title = "";
        this.appointmentSlots = new LinkedHashMap();
        this.visibleWeeks = new ArrayList();
        this.shouldHideImages = true;
        this.shouldHideText = true;
        String string3 = parcel.readString();
        if (string3 == null) {
            string3 = this.title = "";
        }
        if ((string2 = parcel.readString()) == null) {
            string2 = "";
        }
        this.firstDayOfTheWeek = string2;
        ArrayList $this$_init__u24lambda_u245 = arrayList = new ArrayList();
        boolean bl = false;
        parcel.readList((List)$this$_init__u24lambda_u245, Week.class.getClassLoader());
        this.appointmentSlots = this.buildParcelableMap(parcel);
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.title);
        dest.writeString(this.firstDayOfTheWeek);
        dest.writeList((List)this.visibleWeeks);
        dest.writeMap(this.appointmentSlots);
    }

    public int describeContents() {
        return 0;
    }

    public /* synthetic */ LPAppointmentInfo(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
        this(parcel);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;", "AppointmentScheduler_release"})
    public static final class CREATOR
    implements Parcelable.Creator<LPAppointmentInfo> {
        private CREATOR() {
        }

        @NotNull
        public LPAppointmentInfo createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return new LPAppointmentInfo(parcel, null);
        }

        @NotNull
        public LPAppointmentInfo[] newArray(int size) {
            return new LPAppointmentInfo[size];
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

