/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpappointmentscheduler.utils;

import android.content.Context;
import android.os.Build;
import com.liveperson.lpappointmentscheduler.R;
import com.liveperson.lpappointmentscheduler.models.AppointmentSlot;
import com.liveperson.lpappointmentscheduler.models.Day;
import com.liveperson.lpappointmentscheduler.models.Week;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00042\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010#\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013J\u0016\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013J2\u0010)\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00132\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"Lcom/liveperson/lpappointmentscheduler/utils/AppointmentUtils;", "", "()V", "DAY_OF_WEEK_TITLE_FORMAT", "", "MONTH_NAME_FORMAT", "weekOffset", "", "getWeekOffset", "()I", "setWeekOffset", "(I)V", "calculateVisibleWeeks", "Ljava/util/ArrayList;", "Lcom/liveperson/lpappointmentscheduler/models/Week;", "Lkotlin/collections/ArrayList;", "context", "Landroid/content/Context;", "startDate", "Ljava/util/Calendar;", "endDate", "firstDayOfTheWeek", "visibleAppointmentDays", "", "", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "getCalendarDate", "time", "", "getDateText", "calendar", "format", "getDayOfTitlesList", "getLocale", "Ljava/util/Locale;", "getTimeText", "hasSameDate", "", "one", "second", "hasSameMonth", "isVisibleDay", "currentDay", "setToMidnight", "AppointmentScheduler_release"})
public final class AppointmentUtils {
    @NotNull
    public static final AppointmentUtils INSTANCE = new AppointmentUtils();
    @NotNull
    public static final String DAY_OF_WEEK_TITLE_FORMAT = "EEEEE";
    @NotNull
    private static final String MONTH_NAME_FORMAT = "MMMM";
    private static int weekOffset = 1;

    private AppointmentUtils() {
    }

    public final int getWeekOffset() {
        return weekOffset;
    }

    public final void setWeekOffset(int n) {
        weekOffset = n;
    }

    @NotNull
    public final String getDateText(@NotNull Calendar calendar, @NotNull String format, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, this.getLocale(context));
        String string2 = dateFormat.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(calendar.time)");
        return string2;
    }

    @NotNull
    public final String getTimeText(long calendar, @NotNull String format, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, this.getLocale(context));
        String string2 = dateFormat.format(calendar);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(calendar)");
        String string3 = string2;
        String string4 = string3.toLowerCase(this.getLocale(context));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
        return string4;
    }

    @NotNull
    public final Calendar getCalendarDate(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"calendar");
        return calendar;
    }

    private final Calendar setToMidnight(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    @NotNull
    public final ArrayList<Week> calculateVisibleWeeks(@NotNull Context context, @NotNull Calendar startDate, @NotNull Calendar endDate, @NotNull String firstDayOfTheWeek, @NotNull Map<String, ? extends List<AppointmentSlot>> visibleAppointmentDays) {
        int startDay;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)firstDayOfTheWeek, (String)"firstDayOfTheWeek");
        Intrinsics.checkNotNullParameter(visibleAppointmentDays, (String)"visibleAppointmentDays");
        int n = startDay = Intrinsics.areEqual((Object)firstDayOfTheWeek, (Object)"mon") ? 2 : 1;
        while (startDate.get(7) != startDay) {
            startDate.add(5, -1);
        }
        Object object = startDate.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
        Calendar tempStartDate = (Calendar)object;
        Object object2 = tempStartDate.clone();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.Calendar");
        Calendar tempDate = this.setToMidnight((Calendar)object2);
        ArrayList<Week> allWeeks = new ArrayList<Week>();
        while (!tempStartDate.after(endDate)) {
            ArrayList<Day> days = new ArrayList<Day>();
            for (int i = 0; i < 7; ++i) {
                Object object3 = tempDate.clone();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.util.Calendar");
                Calendar dayToAdd = (Calendar)object3;
                boolean isCurrentDayVisible = this.isVisibleDay(context, dayToAdd, visibleAppointmentDays);
                days.add(new Day(dayToAdd, isCurrentDayVisible));
                tempDate.add(5, 1);
                if (!tempDate.after(endDate)) continue;
                while (tempDate.get(7) != startDay) {
                    Object object4 = tempDate.clone();
                    Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type java.util.Calendar");
                    Calendar day = (Calendar)object4;
                    days.add(new Day(day, false));
                    tempDate.add(5, 1);
                }
                allWeeks.add(new Week(days));
                return allWeeks;
            }
            allWeeks.add(new Week(days));
            Object object5 = tempDate.clone();
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type java.util.Calendar");
            tempStartDate = (Calendar)object5;
        }
        return allWeeks;
    }

    private final boolean isVisibleDay(Context context, Calendar currentDay, Map<String, ? extends List<AppointmentSlot>> visibleAppointmentDays) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(context.getResources().getString(R.string.lp_appointment_available_date_format), this.getLocale(context));
        return visibleAppointmentDays.containsKey(dateFormat.format(currentDay.getTime()));
    }

    @NotNull
    public final List<String> getDayOfTitlesList(@NotNull Context context, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        List dayOfWeekNameList = new ArrayList();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, this.getLocale(context));
        Integer[] integerArray = new Integer[]{1, 2, 3, 4, 5, 6, 7};
        Integer[] dayOfWeeks = integerArray;
        Calendar calendar = Calendar.getInstance();
        int n = dayOfWeeks.length;
        for (int i = 0; i < n; ++i) {
            int i2 = dayOfWeeks[i];
            calendar.set(7, i2);
            String string2 = dateFormat.format(calendar.getTime());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(calendar.time)");
            dayOfWeekNameList.add(string2);
        }
        return dayOfWeekNameList;
    }

    @NotNull
    public final Locale getLocale(@NotNull Context context) {
        Locale locale;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 24) {
            Locale locale2 = context.getResources().getConfiguration().getLocales().get(0);
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"{\n\t\t\tcontext.resources.c\u2026ration.locales.get(0)\n\t\t}");
        } else {
            Locale locale3 = context.getResources().getConfiguration().locale;
            locale = locale3;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"{\n\t\t\t@Suppress(\"DEPRECAT\u2026.configuration.locale\n\t\t}");
        }
        return locale;
    }

    public final boolean hasSameMonth(@NotNull Calendar one, @NotNull Calendar second) {
        Intrinsics.checkNotNullParameter((Object)one, (String)"one");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return one.get(1) == second.get(1) && one.get(2) == second.get(2);
    }

    public final boolean hasSameDate(@NotNull Calendar one, @NotNull Calendar second) {
        Intrinsics.checkNotNullParameter((Object)one, (String)"one");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return this.hasSameMonth(one, second) && one.get(5) == second.get(5);
    }
}

