/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpappointmentscheduler.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.liveperson.lpappointmentscheduler.R;
import com.liveperson.lpappointmentscheduler.databinding.LpAppointmentWeekDayLayoutBinding;
import com.liveperson.lpappointmentscheduler.models.Day;
import com.liveperson.lpappointmentscheduler.utils.AppointmentUtils;
import com.liveperson.lpappointmentscheduler.views.CustomTextView;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\nR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/liveperson/lpappointmentscheduler/views/LPAppointmentDateView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentDay", "Lcom/liveperson/lpappointmentscheduler/models/Day;", "dayText", "Landroidx/appcompat/widget/AppCompatTextView;", "disableDate", "", "equals", "", "other", "", "hashCode", "setActive", "isActive", "setClickListener", "listener", "Landroid/view/View$OnClickListener;", "setDate", "day", "Companion", "AppointmentScheduler_release"})
public final class LPAppointmentDateView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppCompatTextView dayText;
    private Day currentDay;
    @NotNull
    private static final String DAY_DESCRIPTION_FORMAT = "EEEE MMM d, yyyy";

    @JvmOverloads
    public LPAppointmentDateView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Object object = context.getSystemService("layout_inflater");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.LayoutInflater");
        LayoutInflater inflater = (LayoutInflater)object;
        LpAppointmentWeekDayLayoutBinding lpAppointmentWeekDayLayoutBinding = LpAppointmentWeekDayLayoutBinding.inflate(inflater, (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)lpAppointmentWeekDayLayoutBinding, (String)"inflate(inflater, this, true)");
        LpAppointmentWeekDayLayoutBinding binding = lpAppointmentWeekDayLayoutBinding;
        CustomTextView customTextView = binding.dayOfMonthText;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)customTextView), (String)"binding.dayOfMonthText");
        this.dayText = customTextView;
    }

    public /* synthetic */ LPAppointmentDateView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setDate(@NotNull Day day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        this.currentDay = day;
        this.dayText.setImportantForAccessibility(1);
        this.dayText.setText((CharSequence)String.valueOf(day.getCalendarDay().get(5)));
        Calendar calendar = day.getCalendarDay();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.dayText.setContentDescription((CharSequence)AppointmentUtils.INSTANCE.getDateText(calendar, DAY_DESCRIPTION_FORMAT, context));
    }

    public final void disableDate() {
        this.setEnabled(false);
        this.dayText.setEnabled(false);
        this.dayText.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_appointment_week_day_inactive_text_color));
    }

    public final void setClickListener(@NotNull View.OnClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.dayText.setOnClickListener(listener);
    }

    public final void setActive(boolean isActive) {
        this.setSelected(isActive);
        this.dayText.setSelected(isActive);
        this.dayText.setBackground(isActive ? this.getContext().getDrawable(R.drawable.lp_selected_appointment_date_bg) : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (other == null) return false;
        if (other.getClass() != LPAppointmentDateView.class) return false;
        Day day = this.currentDay;
        if (day == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDay");
            day = null;
        }
        Calendar calendar = day.getCalendarDay();
        Day day2 = ((LPAppointmentDateView)((Object)other)).currentDay;
        if (day2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDay");
            day2 = null;
        }
        if (!AppointmentUtils.INSTANCE.hasSameDate(calendar, day2.getCalendarDay())) return false;
        return true;
    }

    public int hashCode() {
        int result = this.dayText.hashCode();
        Day day = this.currentDay;
        if (day == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDay");
            day = null;
        }
        result = 31 * result + day.hashCode();
        return result;
    }

    @JvmOverloads
    public LPAppointmentDateView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public LPAppointmentDateView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/lpappointmentscheduler/views/LPAppointmentDateView$Companion;", "", "()V", "DAY_DESCRIPTION_FORMAT", "", "AppointmentScheduler_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

