/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpappointmentscheduler.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.appcompat.widget.AppCompatTextView;
import com.liveperson.lpappointmentscheduler.R;
import com.liveperson.lpappointmentscheduler.logger.LPAppointmentLog;
import com.liveperson.lpappointmentscheduler.utils.AppointmentUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/liveperson/lpappointmentscheduler/views/LPAppointmentWeekDayView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isRightToLeft", "", "initViews", "", "AppointmentScheduler_release"})
public final class LPAppointmentWeekDayView
extends LinearLayout {
    private final boolean isRightToLeft;

    public LPAppointmentWeekDayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.isRightToLeft = this.getResources().getBoolean(R.bool.lp_appointment_is_right_to_left);
        this.initViews(context, null);
    }

    public LPAppointmentWeekDayView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.isRightToLeft = this.getResources().getBoolean(R.bool.lp_appointment_is_right_to_left);
        this.initViews(context, attrs);
    }

    public LPAppointmentWeekDayView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.isRightToLeft = this.getResources().getBoolean(R.bool.lp_appointment_is_right_to_left);
        this.initViews(context, attrs);
    }

    private final void initViews(Context context, AttributeSet attrs) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        View view = layoutInflater.inflate(R.layout.lp_appointment_calendar_week_days_layout, (ViewGroup)this, true);
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.LinearLayout");
        LinearLayout parentView = (LinearLayout)view;
        LinearLayout titleWeekContainer = (LinearLayout)parentView.findViewById(R.id.llTitleWeekContainer);
        List<String> weekDayTitles = AppointmentUtils.INSTANCE.getDayOfTitlesList(context, "EEEEE");
        LPAppointmentLog.INSTANCE.d("LPAppointmentWeekDayView", "Setting week day titles (S, M, T....");
        for (int i = 0; i < 7; ++i) {
            View textView = titleWeekContainer.getChildAt(i);
            int index = (i + AppointmentUtils.INSTANCE.getWeekOffset()) % 7;
            if (textView instanceof AppCompatTextView) {
                ((AppCompatTextView)textView).setText((CharSequence)weekDayTitles.get(index));
                ((AppCompatTextView)textView).setImportantForAccessibility(2);
                continue;
            }
            LPAppointmentLog.INSTANCE.e("LPAppointmentWeekDayView", "Failed to set week day title.Child element is not of type AppCompatTextView");
        }
    }
}

