/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpappointmentscheduler.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.liveperson.lpappointmentscheduler.R;
import com.liveperson.lpappointmentscheduler.adapters.LPAppointmentWeekViewAdapter;
import com.liveperson.lpappointmentscheduler.logger.LPAppointmentLog;
import com.liveperson.lpappointmentscheduler.models.AppointmentSchedulerViewModel;
import com.liveperson.lpappointmentscheduler.models.Day;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import com.liveperson.lpappointmentscheduler.models.Week;
import com.liveperson.lpappointmentscheduler.utils.AppointmentUtils;
import com.liveperson.lpappointmentscheduler.views.LPAppointmentDateView;
import com.liveperson.lpappointmentscheduler.views.LPAppointmentWeekInterface;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B/\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J \u0010!\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\bJ\b\u0010*\u001a\u00020\u001eH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011\u00a8\u0006,"}, d2={"Lcom/liveperson/lpappointmentscheduler/views/LPAppointmentWeekView;", "Landroid/widget/LinearLayout;", "Lcom/liveperson/lpappointmentscheduler/views/LPAppointmentWeekInterface;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "TAG", "", "appointmentWeekViewAdapter", "Lcom/liveperson/lpappointmentscheduler/adapters/LPAppointmentWeekViewAdapter;", "currentPosition", "getCurrentPosition", "()I", "isRightToLeft", "", "lpAppointmentInfo", "Lcom/liveperson/lpappointmentscheduler/models/LPAppointmentInfo;", "scrollState", "viewModel", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSchedulerViewModel;", "weekDaysViewPager", "Landroidx/viewpager/widget/ViewPager;", "weeksCount", "getWeeksCount", "addOnPageSelectionChangeListener", "", "listener", "Landroidx/viewpager/widget/ViewPager$OnPageChangeListener;", "initViews", "onDateSelected", "day", "Lcom/liveperson/lpappointmentscheduler/models/Day;", "dateView", "Lcom/liveperson/lpappointmentscheduler/views/LPAppointmentDateView;", "removeOnPageSelectionChangeListener", "scrollToPosition", "position", "setPageChangeListener", "Companion", "AppointmentScheduler_release"})
public final class LPAppointmentWeekView
extends LinearLayout
implements LPAppointmentWeekInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String TAG;
    private ViewPager weekDaysViewPager;
    private LPAppointmentWeekViewAdapter appointmentWeekViewAdapter;
    private LPAppointmentInfo lpAppointmentInfo;
    private AppointmentSchedulerViewModel viewModel;
    private final boolean isRightToLeft;
    private int scrollState;
    @NotNull
    private static final String WEEK_DESCRIPTION_FORMAT = "MMM d, yyyy";

    @JvmOverloads
    public LPAppointmentWeekView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.TAG = "LPAppointmentWeekView";
        this.isRightToLeft = this.getResources().getBoolean(R.bool.lp_appointment_is_right_to_left);
        this.scrollState = -1;
    }

    public /* synthetic */ LPAppointmentWeekView(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    public final void initViews(@NotNull Context context, @NotNull AppointmentSchedulerViewModel viewModel, @Nullable LPAppointmentInfo lpAppointmentInfo) {
        LPAppointmentWeekViewAdapter lPAppointmentWeekViewAdapter;
        LPAppointmentInfo lPAppointmentInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        if (lpAppointmentInfo != null) {
            this.lpAppointmentInfo = lpAppointmentInfo;
        }
        this.viewModel = viewModel;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        layoutInflater.inflate(R.layout.lp_appointment_week_days_container_layout, (ViewGroup)this, true);
        View view = this.findViewById(R.id.weekDaysViewPager);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.weekDaysViewPager)");
        this.weekDaysViewPager = (ViewPager)view;
        if (this.isRightToLeft) {
            ViewPager viewPager = this.weekDaysViewPager;
            if (viewPager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"weekDaysViewPager");
                viewPager = null;
            }
            viewPager.setRotationY(180.0f);
        }
        if ((lPAppointmentInfo = this.lpAppointmentInfo) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lpAppointmentInfo");
            lPAppointmentInfo = null;
        }
        this.appointmentWeekViewAdapter = new LPAppointmentWeekViewAdapter(context, lPAppointmentInfo, this);
        ViewPager viewPager = this.weekDaysViewPager;
        if (viewPager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"weekDaysViewPager");
            viewPager = null;
        }
        if ((lPAppointmentWeekViewAdapter = this.appointmentWeekViewAdapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appointmentWeekViewAdapter");
            lPAppointmentWeekViewAdapter = null;
        }
        viewPager.setAdapter((PagerAdapter)lPAppointmentWeekViewAdapter);
        this.setPageChangeListener();
    }

    public final void scrollToPosition(int position) {
        ViewPager viewPager = this.weekDaysViewPager;
        if (viewPager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"weekDaysViewPager");
            viewPager = null;
        }
        viewPager.setCurrentItem(position);
    }

    public final int getCurrentPosition() {
        ViewPager viewPager = this.weekDaysViewPager;
        if (viewPager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"weekDaysViewPager");
            viewPager = null;
        }
        return viewPager.getCurrentItem();
    }

    public final int getWeeksCount() {
        ViewPager viewPager = this.weekDaysViewPager;
        if (viewPager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"weekDaysViewPager");
            viewPager = null;
        }
        PagerAdapter pagerAdapter = viewPager.getAdapter();
        return pagerAdapter != null ? pagerAdapter.getCount() : 0;
    }

    public final void addOnPageSelectionChangeListener(@NotNull ViewPager.OnPageChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ViewPager viewPager = this.weekDaysViewPager;
        if (viewPager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"weekDaysViewPager");
            viewPager = null;
        }
        viewPager.addOnPageChangeListener(listener);
    }

    public final void removeOnPageSelectionChangeListener(@NotNull ViewPager.OnPageChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ViewPager viewPager = this.weekDaysViewPager;
        if (viewPager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"weekDaysViewPager");
            viewPager = null;
        }
        viewPager.removeOnPageChangeListener(listener);
    }

    private final void setPageChangeListener() {
        ViewPager viewPager = this.weekDaysViewPager;
        if (viewPager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"weekDaysViewPager");
            viewPager = null;
        }
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(this){
            final /* synthetic */ LPAppointmentWeekView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (LPAppointmentWeekView.access$getScrollState$p(this.this$0) == 2) {
                    AppointmentSchedulerViewModel appointmentSchedulerViewModel;
                    LPAppointmentInfo lPAppointmentInfo = LPAppointmentWeekView.access$getLpAppointmentInfo$p(this.this$0);
                    if (lPAppointmentInfo == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lpAppointmentInfo");
                        lPAppointmentInfo = null;
                    }
                    Week week = lPAppointmentInfo.getVisibleWeeks().get(position);
                    Intrinsics.checkNotNullExpressionValue((Object)week, (String)"lpAppointmentInfo.visibleWeeks[position]");
                    Week currentWeek = week;
                    AppointmentSchedulerViewModel appointmentSchedulerViewModel2 = LPAppointmentWeekView.access$getViewModel$p(this.this$0);
                    if (appointmentSchedulerViewModel2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                        appointmentSchedulerViewModel2 = null;
                    }
                    Day currentSelectedDay = appointmentSchedulerViewModel2.getCurrentSelectedDay();
                    Calendar weekDate = null;
                    weekDate = currentWeek.getDays().get(0).getCalendarDay();
                    Day day = currentSelectedDay;
                    if (day != null) {
                        Day it = day;
                        boolean bl = false;
                        if (currentWeek.getDays().contains(it)) {
                            weekDate = it.getCalendarDay();
                        }
                    }
                    if ((appointmentSchedulerViewModel = LPAppointmentWeekView.access$getViewModel$p(this.this$0)) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                        appointmentSchedulerViewModel = null;
                    }
                    String string2 = this.this$0.getContext().getResources().getString(R.string.lp_appointment_week_date_format);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.resources.getStr\u2026intment_week_date_format)");
                    Context context = this.this$0.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    appointmentSchedulerViewModel.setWeekDate(AppointmentUtils.INSTANCE.getDateText(weekDate, string2, context));
                }
            }

            public void onPageSelected(int position) {
                Calendar calendar;
                Object[] objectArray;
                Object object;
                Week week;
                LPAppointmentInfo lPAppointmentInfo = LPAppointmentWeekView.access$getLpAppointmentInfo$p(this.this$0);
                if (lPAppointmentInfo == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lpAppointmentInfo");
                    lPAppointmentInfo = null;
                }
                if ((week = (Week)CollectionsKt.getOrNull((List)lPAppointmentInfo.getVisibleWeeks(), (int)position)) == null || (object = week.getDays()) == null || (objectArray = (Object[])CollectionsKt.firstOrNull((List)((List)object))) == null || (calendar = objectArray.getCalendarDay()) == null) {
                    return;
                }
                Calendar beginning = calendar;
                Context context = this.this$0.getContext();
                objectArray = new Object[1];
                Context context2 = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                objectArray[0] = AppointmentUtils.INSTANCE.getDateText(beginning, "MMM d, yyyy", context2);
                object = context.getString(R.string.lp_accessibility_week_starting, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getString(\n     \u2026ontext)\n                )");
                Object announcement = object;
                this.this$0.announceForAccessibility((CharSequence)announcement);
            }

            public void onPageScrollStateChanged(int state) {
                LPAppointmentWeekView.access$setScrollState$p(this.this$0, state);
            }
        });
    }

    @Override
    public void onDateSelected(@NotNull Day day, @NotNull LPAppointmentDateView dateView) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        Intrinsics.checkNotNullParameter((Object)((Object)dateView), (String)"dateView");
        Calendar calendar = day.getCalendarDay();
        String string2 = this.getContext().getResources().getString(R.string.lp_appointment_header_date_format);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.resources.getStr\u2026tment_header_date_format)");
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        String headerDate = AppointmentUtils.INSTANCE.getDateText(calendar, string2, context);
        Calendar calendar2 = day.getCalendarDay();
        String string3 = this.getContext().getResources().getString(R.string.lp_appointment_week_date_format);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.resources.getStr\u2026intment_week_date_format)");
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        String weekDate = AppointmentUtils.INSTANCE.getDateText(calendar2, string3, context2);
        Calendar calendar3 = day.getCalendarDay();
        String string4 = this.getContext().getResources().getString(R.string.lp_appointment_available_date_format);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.resources.getStr\u2026nt_available_date_format)");
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
        String selectedDate = AppointmentUtils.INSTANCE.getDateText(calendar3, string4, context3);
        AppointmentSchedulerViewModel appointmentSchedulerViewModel = this.viewModel;
        if (appointmentSchedulerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            appointmentSchedulerViewModel = null;
        }
        appointmentSchedulerViewModel.onDateSelected(headerDate, weekDate, selectedDate, day);
        LPAppointmentLog.INSTANCE.i(this.TAG, "onDateSelected: " + headerDate);
    }

    @JvmOverloads
    public LPAppointmentWeekView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public LPAppointmentWeekView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public LPAppointmentWeekView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 0, 14, null);
    }

    public static final /* synthetic */ int access$getScrollState$p(LPAppointmentWeekView $this) {
        return $this.scrollState;
    }

    public static final /* synthetic */ LPAppointmentInfo access$getLpAppointmentInfo$p(LPAppointmentWeekView $this) {
        return $this.lpAppointmentInfo;
    }

    public static final /* synthetic */ AppointmentSchedulerViewModel access$getViewModel$p(LPAppointmentWeekView $this) {
        return $this.viewModel;
    }

    public static final /* synthetic */ void access$setScrollState$p(LPAppointmentWeekView $this, int n) {
        $this.scrollState = n;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/lpappointmentscheduler/views/LPAppointmentWeekView$Companion;", "", "()V", "WEEK_DESCRIPTION_FORMAT", "", "AppointmentScheduler_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

