package com.liveperson.lpdatepicker.ui

import android.content.Context
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatButton
import com.liveperson.lpdatepicker.R

class CustomButton : AppCompatButton {

	constructor(context: Context) : super(context)

	constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
		applyCustomFont(context, attrs)
	}

	constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
		context,
		attrs,
		defStyleAttr
	) {
		applyCustomFont(context, attrs)
	}

	private fun applyCustomFont(context: Context, attrs: AttributeSet?) {
		UIUtils.changeCustomTextViewFont(
			this,
			context,
			attrs,
			R.styleable.CustomTextView,
			R.styleable.CustomTextView_font_name
		)
	}
}
