package com.liveperson.lpdatepicker

import android.os.Build
import android.view.View
import androidx.core.view.ViewCompat
import com.liveperson.lpdatepicker.calendar.views.LPCustomDateView
import com.liveperson.lpdatepicker.calendar.views.LPIDateView
import java.text.SimpleDateFormat
import java.util.Locale

private const val DATE_PICKER_DAY_DESCRIPTION_FORMAT = "EEEE MMM d, yyyy"


/**
 * Method used to create day's content description date formatter
 * based on device's locale.
 *
 * @param locale actual locale.
 */
internal fun createDayFormatter(locale: Locale): SimpleDateFormat {
    return SimpleDateFormat(DATE_PICKER_DAY_DESCRIPTION_FORMAT, locale)
}

/**
 * Extension function for [LPCustomDateView] to apply isSelected/isEnabled flags
 * according to state.
 *
 * @param state actual state of day.
 */
internal fun LPCustomDateView.applyDateState(
    state: LPIDateView.DateState
) {
    when (state) {
        LPIDateView.DateState.START -> {
            isSelected = true
        }
        LPIDateView.DateState.START_END_SAME -> {
            isSelected = true
        }
        LPIDateView.DateState.END -> {
            isSelected = true
        }
        LPIDateView.DateState.MIDDLE -> {
            isSelected = true
        }
        LPIDateView.DateState.SELECTABLE -> {
            isSelected = false
        }
        LPIDateView.DateState.DISABLE -> {
            isEnabled = false
        }
        LPIDateView.DateState.HIDDEN -> {
            isSelected = false
            isEnabled = false
            importantForAccessibility = View.IMPORTANT_FOR_ACCESSIBILITY_NO
        }
    }

}

/**
 * Method used to mark any view as accessibility heading.
 * @param isHeading flag to enable/disable accessibility heading prefix.
 */
internal fun View.markAsAccessibilityHeading(isHeading: Boolean = true) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
        isAccessibilityHeading = isHeading
    } else {
        ViewCompat.setAccessibilityHeading(this, isHeading)
    }
}
