package com.liveperson.lpdatepicker

import android.os.Parcel
import android.os.Parcelable

class CalendarInitInfo : Parcelable {
	// 150 years
	private val DEFAULT_RANGE : Long = (150L * 365 * 24 * 60 * 60 * 1000)

	val type: Type
	val title: String
	val minDate: Long
	val maxDate: Long
	val dateFormat: String

	constructor(
		type: String,
		title: String,
		minDateInMilliSeconds: Long,
		maxDateInMilliSeconds: Long,
		dateFormat: String
	) {
		this.type = when (type) {
			"range" -> Type.RANGE
			else -> Type.SINGLE
		}
		this.title = title
		this.minDate = minDateInMilliSeconds
		// Add default range 150 years if max < min
		if (maxDateInMilliSeconds < minDateInMilliSeconds) {
			this.maxDate = minDateInMilliSeconds + DEFAULT_RANGE
		} else {
			this.maxDate = maxDateInMilliSeconds
		}
		this.dateFormat = dateFormat
	}

	private constructor(parcel: Parcel) {
		this.type = Type.values()[parcel.readInt()]
		this.title = parcel.readString() ?: ""
		this.minDate = parcel.readLong()
		this.maxDate = parcel.readLong()
		this.dateFormat = parcel.readString()!!
	}

	override fun writeToParcel(parcel: Parcel, flags: Int) {
		parcel.writeInt(type.ordinal)
		parcel.writeString(title)
		parcel.writeLong(minDate)
		parcel.writeLong(maxDate)
		parcel.writeString(dateFormat)
	}

	override fun describeContents(): Int {
		return 0
	}

	companion object CREATOR : Parcelable.Creator<CalendarInitInfo> {
		override fun createFromParcel(parcel: Parcel): CalendarInitInfo {
			return CalendarInitInfo(parcel)
		}

		override fun newArray(size: Int): Array<CalendarInitInfo?> {
			return arrayOfNulls(size)
		}
	}
}

enum class Type {
	RANGE, SINGLE
}
