package com.liveperson.lpdatepicker.calendar.models

import android.content.Context
import android.graphics.Typeface
import android.graphics.drawable.Drawable
import androidx.core.content.ContextCompat
import android.util.AttributeSet
import com.liveperson.lpdatepicker.R
import com.liveperson.lpdatepicker.calendar.models.LPICalendarStyleAttributes.Companion.DEFAULT_FIXED_DAYS_SELECTION
import com.liveperson.lpdatepicker.calendar.models.LPICalendarStyleAttributes.DateSelectionMode

class LPCalendarStyleAttrImpl(context: Context, attributeSet: AttributeSet? = null) : LPICalendarStyleAttributes {
    override var fonts: Typeface? = null
    override var headerBg: Drawable? = null
    override var weekColor = ContextCompat.getColor(context, R.color.lp_datepicker_weekday_title_color)
        private set
    override var rangeStripColor = ContextCompat.getColor(context, R.color.lp_datepicker_range_bg_color)
        private set
    override var selectedDateCircleColor = ContextCompat.getColor(context, R.color.lp_datepicker_selected_date_circle_color)
        private set
    override var selectedDateColor = ContextCompat.getColor(context, R.color.lp_datepicker_selected_date_color)
        private set
    override var defaultDateColor = ContextCompat.getColor(context, R.color.lp_datepicker_default_date_color)
        private set
    override var disableDateColor = ContextCompat.getColor(context, R.color.lp_datepicker_disable_date_color)
        private set
    override var rangeDateColor = ContextCompat.getColor(context, R.color.lp_datepicker_ranged_date_color)
        private set
    override var textSizeWeek = context.resources.getDimension(R.dimen.text_size_week)
        private set
    override var textSizeDate = context.resources.getDimension(R.dimen.text_size_date)
        private set
    override var isShouldEnabledTime = false

    /**
     * To set week offset
     *
     * @param weekOffset
     */
    override var weekOffset = 0
        set(weekOffset) {
            if (weekOffset < 0 || weekOffset > 6) {
                throw InvalidCalendarAttributeException("Week offset can only be between 0 to 6. 0->Sun, 1->Mon, 2->Tue, 3->Wed, 4->Thu, 5->Fri, 6->Sat")
            }
            field = weekOffset
        }
    override var isEditable = true
    override var dateSelectionMode = DateSelectionMode.FREE_RANGE
    override var fixedDaysSelectionNumber: Int = DEFAULT_FIXED_DAYS_SELECTION
        set(value) {
            if (dateSelectionMode !== DateSelectionMode.FIXED_RANGE) {
                throw InvalidCalendarAttributeException("Selected date selection mode is not `fixed_range` for `date_selection_mode` " +
                        "attribute in layout.")
            }
            if (value < 0 || value > 365) {
                throw InvalidCalendarAttributeException("Fixed days can be between 0 to 365.")
            }
            field = value
        }

    init {
        attributeSet?.apply { setAttributes(context, this) }
    }

    private fun setAttributes(context: Context, attributeSet: AttributeSet?) {
        if (attributeSet != null) {
            val ta = context.obtainStyledAttributes(attributeSet, R.styleable.DateRangeMonthView, 0, 0)
            try {
                headerBg = ta.getDrawable(R.styleable.DateRangeMonthView_header_bg)
                weekColor = ta.getColor(R.styleable.DateRangeMonthView_week_color, weekColor)
                rangeStripColor = ta.getColor(R.styleable.DateRangeMonthView_range_color, rangeStripColor)
                selectedDateCircleColor = ta.getColor(R.styleable.DateRangeMonthView_selected_date_circle_color, selectedDateCircleColor)
                isEditable = ta.getBoolean(R.styleable.DateRangeMonthView_editable, true)
                textSizeWeek = ta.getDimension(R.styleable.DateRangeMonthView_text_size_week, textSizeWeek)
                textSizeDate = ta.getDimension(R.styleable.DateRangeMonthView_text_size_date, textSizeDate)
                selectedDateColor = ta.getColor(R.styleable.DateRangeMonthView_selected_date_color, selectedDateColor)
                defaultDateColor = ta.getColor(R.styleable.DateRangeMonthView_default_date_color, defaultDateColor)
                rangeDateColor = ta.getColor(R.styleable.DateRangeMonthView_range_date_color, rangeDateColor)
                disableDateColor = ta.getColor(R.styleable.DateRangeMonthView_disable_date_color, disableDateColor)
                weekOffset = ta.getColor(R.styleable.DateRangeMonthView_week_offset, 0)
                dateSelectionMode = DateSelectionMode.values()[ta.getInt(R.styleable.DateRangeMonthView_date_selection_mode, 0)]
            } finally {
                ta.recycle()
            }
        }
    }

    companion object {
        /**
         * To parse attributes from xml layout to configure calendar views.
         */
        fun getDefAttributes(context: Context): LPCalendarStyleAttrImpl {
            val calendarStyleAttr = LPCalendarStyleAttrImpl(context)
            calendarStyleAttr.textSizeWeek = context.resources.getDimension(R.dimen.text_size_week)
            calendarStyleAttr.textSizeDate = context.resources.getDimension(R.dimen.text_size_date)
            calendarStyleAttr.weekColor = ContextCompat.getColor(context, R.color.lp_datepicker_weekday_title_color)
            calendarStyleAttr.rangeStripColor = ContextCompat.getColor(context, R.color.lp_datepicker_range_bg_color)
            calendarStyleAttr.selectedDateCircleColor = ContextCompat.getColor(context, R.color.lp_datepicker_selected_date_circle_color)
            calendarStyleAttr.selectedDateColor = ContextCompat.getColor(context, R.color.lp_datepicker_selected_date_color)
            calendarStyleAttr.defaultDateColor = ContextCompat.getColor(context, R.color.lp_datepicker_default_date_color)
            calendarStyleAttr.rangeDateColor = ContextCompat.getColor(context, R.color.lp_datepicker_ranged_date_color)
            calendarStyleAttr.disableDateColor = ContextCompat.getColor(context, R.color.lp_datepicker_disable_date_color)
            return calendarStyleAttr
        }
    }
}