package com.liveperson.lpdatepicker.ui

import android.content.Context
import android.graphics.Typeface
import android.text.TextUtils
import android.util.AttributeSet
import android.widget.TextView
import com.liveperson.lpdatepicker.CalendarUtils
import java.util.*

object UIUtils {

	fun changeCustomTextViewFont(
		textView: TextView,
		context: Context,
		attrs: AttributeSet?,
		customViewResId: IntArray,
		customViewFontAttributeResId: Int
	) {
		val fontName: String?
		val typedArray = context.theme.obtainStyledAttributes(attrs, customViewResId, 0, 0)
		try {
			fontName = typedArray.getString(customViewFontAttributeResId)
		} finally {
			typedArray.recycle()
		}

		textView.apply {
			if (!isInEditMode && !TextUtils.isEmpty(fontName)) {
				try {
					val typeface: Typeface =
						if (fontName!!.toLowerCase(CalendarUtils.getLocale(context)).contains(".")) {
							Typeface.createFromAsset(context.assets, fontName)
						} else {
							Typeface.create(fontName, typeface.style)
						}
					setTypeface(typeface, getTypeface().style)
				} catch (e: Exception) {

				}
			}
		}
	}
}
