/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u001d\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00152\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/liveperson/lpdatepicker/CalendarUtils;", "", "()V", "DAY_OF_WEEK_FORMAT", "", "DAY_OF_WEEK_TITLE_FORMAT", "MONTH_NAME_FORMAT", "getCalendarDate", "Ljava/util/Calendar;", "time", "", "getDateText", "calendar", "format", "context", "Landroid/content/Context;", "getDayOfWeek", "getDayOfWeekFullNameList", "", "(Landroid/content/Context;)[Ljava/lang/String;", "getDayOfWeekNameList", "", "getLocale", "Ljava/util/Locale;", "getMonthNameList", "getMonthRange", "minDate", "maxDate", "currentDate", "getMonthText", "getYearRange", "", "datepicker_release"})
public final class CalendarUtils {
    private static final String DAY_OF_WEEK_FORMAT = "EEEE";
    private static final String DAY_OF_WEEK_TITLE_FORMAT = "EEEEE";
    private static final String MONTH_NAME_FORMAT = "MMMM";
    public static final CalendarUtils INSTANCE;

    @NotNull
    public final String getDayOfWeek(@NotNull Calendar calendar, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SimpleDateFormat dateFormat = new SimpleDateFormat(DAY_OF_WEEK_FORMAT, this.getLocale(context));
        String string2 = dateFormat.format(calendar.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateFormat.format(calendar.time)");
        return string2;
    }

    @NotNull
    public final String getDateText(@NotNull Calendar calendar, @NotNull String format, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, this.getLocale(context));
        String string2 = dateFormat.format(calendar.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateFormat.format(calendar.time)");
        return string2;
    }

    @NotNull
    public final String getMonthText(@NotNull Calendar calendar, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SimpleDateFormat dateFormat = new SimpleDateFormat(MONTH_NAME_FORMAT, this.getLocale(context));
        String string2 = dateFormat.format(calendar.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateFormat.format(calendar.time)");
        return string2;
    }

    @NotNull
    public final Calendar getCalendarDate(long time) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
        calendar2.setTimeInMillis(time);
        return calendar;
    }

    @NotNull
    public final List<String> getMonthRange(@NotNull Calendar minDate, @NotNull Calendar maxDate, @NotNull Calendar currentDate, @NotNull Context context) {
        int month;
        Intrinsics.checkParameterIsNotNull((Object)minDate, (String)"minDate");
        Intrinsics.checkParameterIsNotNull((Object)maxDate, (String)"maxDate");
        Intrinsics.checkParameterIsNotNull((Object)currentDate, (String)"currentDate");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ArrayList<Integer> monthRange = new ArrayList<Integer>();
        if (minDate.get(1) == maxDate.get(1)) {
            for (month = minDate.get(2); month <= maxDate.get(2); ++month) {
                Integer n = month;
                monthRange.add(n);
            }
        } else if (minDate.get(1) == currentDate.get(1)) {
            for (month = minDate.get(2); month <= 11; ++month) {
                Integer n = month;
                monthRange.add(n);
            }
        } else if (maxDate.get(1) == currentDate.get(1)) {
            for (month = 0; month <= maxDate.get(2); ++month) {
                Integer n = month;
                monthRange.add(n);
            }
        } else {
            return this.getMonthNameList(context);
        }
        ArrayList<String> monthNameRange = new ArrayList<String>();
        List<String> monthNames = this.getMonthNameList(context);
        Iterator iterator = monthRange.iterator();
        while (iterator.hasNext()) {
            Integer i;
            Integer n = i = (Integer)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"i");
            monthNameRange.add(monthNames.get(n));
        }
        return monthNameRange;
    }

    @NotNull
    public final List<Integer> getYearRange(@NotNull Calendar minDate, @NotNull Calendar maxDate) {
        Intrinsics.checkParameterIsNotNull((Object)minDate, (String)"minDate");
        Intrinsics.checkParameterIsNotNull((Object)maxDate, (String)"maxDate");
        ArrayList<Integer> yearRange = new ArrayList<Integer>();
        for (int year = minDate.get(1); year <= maxDate.get(1); ++year) {
            Integer n = year;
            yearRange.add(n);
        }
        return yearRange;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getMonthNameList(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        List monthNames = new ArrayList();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 0);
        int n = 0;
        int n2 = 11;
        while (n <= n2) {
            void i;
            Calendar calendar2 = calendar;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
            monthNames.add(this.getMonthText(calendar2, context));
            calendar.add(2, 1);
            ++i;
        }
        return monthNames;
    }

    @NotNull
    public final List<String> getDayOfWeekNameList(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        List dayOfWeekNameList = new ArrayList();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DAY_OF_WEEK_TITLE_FORMAT, this.getLocale(context));
        Integer[] dayOfWeeks = new Integer[]{1, 2, 3, 4, 5, 6, 7};
        Calendar calendar = Calendar.getInstance();
        Integer[] integerArray = dayOfWeeks;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            calendar.set(7, i2);
            Calendar calendar2 = calendar;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
            String string2 = dateFormat.format(calendar2.getTime());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateFormat.format(calendar.time)");
            dayOfWeekNameList.add(string2);
        }
        return dayOfWeekNameList;
    }

    @NotNull
    public final String[] getDayOfWeekFullNameList(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(this.getLocale(context));
        Intrinsics.checkExpressionValueIsNotNull((Object)dateFormatSymbols, (String)"DateFormatSymbols.getInstance(getLocale(context))");
        String[] stringArray = dateFormatSymbols.getWeekdays();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"DateFormatSymbols.getIns\u2026Locale(context)).weekdays");
        return stringArray;
    }

    @NotNull
    public final Locale getLocale(@NotNull Context context) {
        Locale locale;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 24) {
            Resources resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            Configuration configuration = resources.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"context.resources.configuration");
            Locale locale2 = configuration.getLocales().get(0);
            locale = locale2;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"context.resources.configuration.locales.get(0)");
        } else {
            Resources resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            Locale locale3 = resources.getConfiguration().locale;
            locale = locale3;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"context.resources.configuration.locale");
        }
        return locale;
    }

    private CalendarUtils() {
    }

    static {
        CalendarUtils calendarUtils;
        INSTANCE = calendarUtils = new CalendarUtils();
    }
}

