/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import com.liveperson.lpdatepicker.AccessibilityUtilsKt;
import com.liveperson.lpdatepicker.CalendarInitInfo;
import com.liveperson.lpdatepicker.CalendarUtils;
import com.liveperson.lpdatepicker.DatePickerActivity$WhenMappings;
import com.liveperson.lpdatepicker.R;
import com.liveperson.lpdatepicker.Type;
import com.liveperson.lpdatepicker.calendar.models.LPICalendarStyleAttributes;
import com.liveperson.lpdatepicker.calendar.views.LPDateRangeCalendarView;
import com.liveperson.lpdatepicker.calendar.views.LPICalendarListener;
import com.liveperson.lpdatepicker.calendar.views.LPICalendarPageChangedListener;
import com.liveperson.lpdatepicker.databinding.ActivityDatePickerBinding;
import com.liveperson.lpdatepicker.ui.CustomTextView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0012\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/liveperson/lpdatepicker/DatePickerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "binding", "Lcom/liveperson/lpdatepicker/databinding/ActivityDatePickerBinding;", "currentDate", "Ljava/util/Calendar;", "dateFormat", "", "monthList", "", "selectedEndDate", "", "Ljava/lang/Long;", "selectedStartDate", "yearList", "", "closeDatePicker", "", "initViews", "initInfo", "Lcom/liveperson/lpdatepicker/CalendarInitInfo;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "Companion", "datepicker_release"})
public final class DatePickerActivity
extends AppCompatActivity {
    private ActivityDatePickerBinding binding;
    private final List<Integer> yearList = new ArrayList();
    private final List<String> monthList = new ArrayList();
    private Calendar currentDate;
    private Long selectedStartDate;
    private Long selectedEndDate;
    private String dateFormat = "";
    @NotNull
    public static final String CALENDAR_INIT_INFO = "CALENDAR_INIT_INFO";
    @NotNull
    public static final String RESULT_START_DATE_IN_SECONDS = "RESULT_START_DATE_IN_SECONDS";
    @NotNull
    public static final String RESULT_END_DATE_IN_SECONDS = "RESULT_END_DATE_IN_SECONDS";
    public static final Companion Companion = new Companion(null);

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ActivityDatePickerBinding activityDatePickerBinding = ActivityDatePickerBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkExpressionValueIsNotNull((Object)activityDatePickerBinding, (String)"ActivityDatePickerBinding.inflate(layoutInflater)");
        ActivityDatePickerBinding activityDatePickerBinding2 = this.binding = activityDatePickerBinding;
        if (activityDatePickerBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        this.setContentView((View)activityDatePickerBinding2.getRoot());
        if (this.getIntent().hasExtra(CALENDAR_INIT_INFO)) {
            CalendarInitInfo initInfo = (CalendarInitInfo)this.getIntent().getParcelableExtra(CALENDAR_INIT_INFO);
            if (initInfo == null) {
                this.closeDatePicker();
            }
            CalendarInitInfo calendarInitInfo = initInfo;
            if (calendarInitInfo == null) {
                Intrinsics.throwNpe();
            }
            this.initViews(calendarInitInfo);
        } else {
            this.closeDatePicker();
        }
    }

    private final void initViews(CalendarInitInfo initInfo) {
        LPICalendarStyleAttributes.DateSelectionMode dateSelectionMode;
        this.dateFormat = initInfo.getDateFormat();
        ActivityDatePickerBinding activityDatePickerBinding = this.binding;
        if (activityDatePickerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        ActivityDatePickerBinding activityDatePickerBinding2 = activityDatePickerBinding;
        boolean bl = false;
        boolean bl2 = false;
        ActivityDatePickerBinding $this$apply = activityDatePickerBinding2;
        boolean bl3 = false;
        CustomTextView customTextView = $this$apply.tvHeader;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView), (String)"tvHeader");
        AccessibilityUtilsKt.markAsAccessibilityHeading((View)customTextView, true);
        CustomTextView customTextView2 = $this$apply.tvHeader;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView2), (String)"tvHeader");
        customTextView2.setText(initInfo.getTitle());
        Calendar minDate = CalendarUtils.INSTANCE.getCalendarDate(initInfo.getMinDate());
        Calendar maxDate = CalendarUtils.INSTANCE.getCalendarDate(initInfo.getMaxDate());
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        long now = calendar.getTimeInMillis();
        if (now >= initInfo.getMinDate() && now <= initInfo.getMaxDate()) {
            this.currentDate = CalendarUtils.INSTANCE.getCalendarDate(now);
        } else if (now < initInfo.getMinDate()) {
            this.currentDate = CalendarUtils.INSTANCE.getCalendarDate(initInfo.getMinDate());
        } else if (now > initInfo.getMaxDate()) {
            this.currentDate = CalendarUtils.INSTANCE.getCalendarDate(initInfo.getMaxDate());
        }
        List<String> allMonthNames = CalendarUtils.INSTANCE.getMonthNameList((Context)this);
        Calendar calendar2 = this.currentDate;
        if (calendar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDate");
        }
        this.monthList.addAll((Collection<String>)CalendarUtils.INSTANCE.getMonthRange(minDate, maxDate, calendar2, (Context)this));
        ArrayAdapter monthAdapter = new ArrayAdapter((Context)this, R.layout.lp_spinner_item, this.monthList);
        Spinner spinner = $this$apply.spMonth;
        Intrinsics.checkExpressionValueIsNotNull((Object)spinner, (String)"spMonth");
        spinner.setAdapter((SpinnerAdapter)monthAdapter);
        Spinner spinner2 = $this$apply.spMonth;
        Intrinsics.checkExpressionValueIsNotNull((Object)spinner2, (String)"spMonth");
        spinner2.setSelected(false);
        Calendar calendar3 = this.currentDate;
        if (calendar3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDate");
        }
        String monthName = allMonthNames.get(calendar3.get(2));
        int currentMonthPosition = this.monthList.indexOf(monthName);
        $this$apply.spMonth.setSelection(currentMonthPosition, true);
        Spinner spinner3 = $this$apply.spMonth;
        Intrinsics.checkExpressionValueIsNotNull((Object)spinner3, (String)"spMonth");
        spinner3.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener($this$apply, allMonthNames, this, initInfo){
            final /* synthetic */ ActivityDatePickerBinding $this_apply;
            final /* synthetic */ List $allMonthNames;
            final /* synthetic */ DatePickerActivity this$0;
            final /* synthetic */ CalendarInitInfo $initInfo$inlined;
            {
                this.$this_apply = $receiver;
                this.$allMonthNames = $captured_local_variable$2;
                this.this$0 = datePickerActivity;
                this.$initInfo$inlined = calendarInitInfo;
            }

            public void onItemSelected(@Nullable AdapterView<?> parent, @Nullable View view, int position, long id2) {
                int selectedMonth = this.$allMonthNames.indexOf(DatePickerActivity.access$getMonthList$p(this.this$0).get(position));
                DatePickerActivity.access$getCurrentDate$p(this.this$0).set(2, selectedMonth);
                this.$this_apply.calendar.setCurrentMonth(DatePickerActivity.access$getCurrentDate$p(this.this$0));
                Spinner spinner = this.$this_apply.spMonth;
                Intrinsics.checkExpressionValueIsNotNull((Object)spinner, (String)"spMonth");
                spinner.setContentDescription((CharSequence)this.this$0.getString(R.string.lp_datepicker_month_spinner_description, new Object[]{DatePickerActivity.access$getMonthList$p(this.this$0).get(position)}));
            }

            public void onNothingSelected(@Nullable AdapterView<?> parent) {
            }
        });
        Spinner spinner4 = $this$apply.spMonth;
        Intrinsics.checkExpressionValueIsNotNull((Object)spinner4, (String)"spMonth");
        spinner4.setContentDescription((CharSequence)this.getString(R.string.lp_datepicker_month_spinner_description, new Object[]{monthName}));
        this.yearList.addAll((Collection<Integer>)CalendarUtils.INSTANCE.getYearRange(minDate, maxDate));
        ArrayAdapter yearAdapter = new ArrayAdapter((Context)this, R.layout.lp_spinner_item, this.yearList);
        Spinner spinner5 = $this$apply.spYear;
        Intrinsics.checkExpressionValueIsNotNull((Object)spinner5, (String)"spYear");
        spinner5.setAdapter((SpinnerAdapter)yearAdapter);
        Spinner spinner6 = $this$apply.spYear;
        Intrinsics.checkExpressionValueIsNotNull((Object)spinner6, (String)"spYear");
        spinner6.setSelected(false);
        Calendar calendar4 = this.currentDate;
        if (calendar4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDate");
        }
        int yearPos = this.yearList.indexOf(calendar4.get(1));
        $this$apply.spYear.setSelection(yearPos, true);
        Spinner spinner7 = $this$apply.spYear;
        Intrinsics.checkExpressionValueIsNotNull((Object)spinner7, (String)"spYear");
        spinner7.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener($this$apply, minDate, maxDate, monthAdapter, this, initInfo){
            final /* synthetic */ ActivityDatePickerBinding $this_apply;
            final /* synthetic */ Calendar $minDate;
            final /* synthetic */ Calendar $maxDate;
            final /* synthetic */ ArrayAdapter $monthAdapter;
            final /* synthetic */ DatePickerActivity this$0;
            final /* synthetic */ CalendarInitInfo $initInfo$inlined;
            {
                this.$this_apply = $receiver;
                this.$minDate = $captured_local_variable$2;
                this.$maxDate = $captured_local_variable$3;
                this.$monthAdapter = $captured_local_variable$4;
                this.this$0 = datePickerActivity;
                this.$initInfo$inlined = calendarInitInfo;
            }

            public void onItemSelected(@Nullable AdapterView<?> parent, @Nullable View view, int position, long id2) {
                DatePickerActivity.access$getCurrentDate$p(this.this$0).set(1, ((Number)DatePickerActivity.access$getYearList$p(this.this$0).get(position)).intValue());
                Spinner spinner = this.$this_apply.spYear;
                Intrinsics.checkExpressionValueIsNotNull((Object)spinner, (String)"spYear");
                spinner.setContentDescription((CharSequence)this.this$0.getString(R.string.lp_datepicker_year_spinner_description, new Object[]{DatePickerActivity.access$getYearList$p(this.this$0).get(position)}));
                int scrollTo = 0;
                if (DatePickerActivity.access$getCurrentDate$p(this.this$0).before(this.$minDate)) {
                    Object object = this.$minDate.clone();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Calendar");
                    }
                    DatePickerActivity.access$setCurrentDate$p(this.this$0, (Calendar)object);
                    scrollTo = 1;
                } else if (DatePickerActivity.access$getCurrentDate$p(this.this$0).after(this.$maxDate)) {
                    Object object = this.$maxDate.clone();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Calendar");
                    }
                    DatePickerActivity.access$setCurrentDate$p(this.this$0, (Calendar)object);
                    scrollTo = 2;
                }
                DatePickerActivity.access$getMonthList$p(this.this$0).clear();
                DatePickerActivity.access$getMonthList$p(this.this$0).addAll((Collection)CalendarUtils.INSTANCE.getMonthRange(this.$minDate, this.$maxDate, DatePickerActivity.access$getCurrentDate$p(this.this$0), (Context)this.this$0));
                this.$this_apply.calendar.setCurrentMonth(DatePickerActivity.access$getCurrentDate$p(this.this$0));
                switch (scrollTo) {
                    case 1: {
                        this.$this_apply.spMonth.setSelection(0);
                        break;
                    }
                    case 2: {
                        this.$this_apply.spMonth.setSelection(CollectionsKt.getLastIndex((List)DatePickerActivity.access$getMonthList$p(this.this$0)));
                        break;
                    }
                    default: {
                        this.$this_apply.spMonth.setSelection(DatePickerActivity.access$getMonthList$p(this.this$0).indexOf(CalendarUtils.INSTANCE.getMonthText(DatePickerActivity.access$getCurrentDate$p(this.this$0), (Context)this.this$0)));
                    }
                }
                this.$monthAdapter.notifyDataSetChanged();
            }

            public void onNothingSelected(@Nullable AdapterView<?> parent) {
            }
        });
        Spinner spinner8 = $this$apply.spYear;
        Intrinsics.checkExpressionValueIsNotNull((Object)spinner8, (String)"spYear");
        Object[] objectArray = new Object[1];
        Spinner spinner9 = $this$apply.spYear;
        Intrinsics.checkExpressionValueIsNotNull((Object)spinner9, (String)"spYear");
        objectArray[0] = this.yearList.get(spinner9.getSelectedItemPosition());
        spinner8.setContentDescription((CharSequence)this.getString(R.string.lp_datepicker_year_spinner_description, objectArray));
        LPDateRangeCalendarView lPDateRangeCalendarView = $this$apply.calendar;
        boolean bl4 = false;
        boolean bl5 = false;
        LPDateRangeCalendarView $this$apply2 = lPDateRangeCalendarView;
        boolean bl6 = false;
        $this$apply2.setVisibleMonthRange(minDate, maxDate);
        $this$apply2.setSelectableDateRange(minDate, maxDate);
        LPDateRangeCalendarView lPDateRangeCalendarView2 = $this$apply.calendar;
        Calendar calendar5 = this.currentDate;
        if (calendar5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDate");
        }
        lPDateRangeCalendarView2.setCurrentMonth(calendar5);
        $this$apply.calendar.setSelectMode(LPICalendarStyleAttributes.DateSelectionMode.FREE_RANGE);
        LPDateRangeCalendarView lPDateRangeCalendarView3 = $this$apply.calendar;
        switch (DatePickerActivity$WhenMappings.$EnumSwitchMapping$0[initInfo.getType().ordinal()]) {
            case 1: {
                dateSelectionMode = LPICalendarStyleAttributes.DateSelectionMode.FREE_RANGE;
                break;
            }
            default: {
                dateSelectionMode = LPICalendarStyleAttributes.DateSelectionMode.SINGLE;
            }
        }
        lPDateRangeCalendarView3.setSelectMode(dateSelectionMode);
        $this$apply2.setCalendarListener(new LPICalendarListener($this$apply, minDate, maxDate, monthAdapter, yearAdapter, this, initInfo){
            final /* synthetic */ ActivityDatePickerBinding $this_apply$inlined;
            final /* synthetic */ Calendar $minDate$inlined;
            final /* synthetic */ Calendar $maxDate$inlined;
            final /* synthetic */ ArrayAdapter $monthAdapter$inlined;
            final /* synthetic */ ArrayAdapter $yearAdapter$inlined;
            final /* synthetic */ DatePickerActivity this$0;
            final /* synthetic */ CalendarInitInfo $initInfo$inlined;
            {
                this.$this_apply$inlined = activityDatePickerBinding;
                this.$minDate$inlined = calendar;
                this.$maxDate$inlined = calendar2;
                this.$monthAdapter$inlined = arrayAdapter;
                this.$yearAdapter$inlined = arrayAdapter2;
                this.this$0 = datePickerActivity;
                this.$initInfo$inlined = calendarInitInfo;
            }

            public void onFirstDateSelected(@NotNull Calendar startDate) {
                Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
            }

            public void onDateRangeSelected(@NotNull Calendar startDate, @NotNull Calendar endDate) {
                Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
                Intrinsics.checkParameterIsNotNull((Object)endDate, (String)"endDate");
                ConstraintLayout constraintLayout = this.$this_apply$inlined.bottomWrapper;
                Intrinsics.checkExpressionValueIsNotNull((Object)constraintLayout, (String)"bottomWrapper");
                constraintLayout.setVisibility(0);
                DatePickerActivity.access$setSelectedStartDate$p(this.this$0, startDate.getTimeInMillis() / (long)1000);
                DatePickerActivity.access$setSelectedEndDate$p(this.this$0, endDate.getTimeInMillis() / (long)1000);
                if (this.$initInfo$inlined.getType() == Type.RANGE) {
                    CustomTextView customTextView = this.$this_apply$inlined.tvEndDate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView), (String)"tvEndDate");
                    customTextView.setVisibility(0);
                    CustomTextView customTextView2 = this.$this_apply$inlined.tvEndDayOfWeek;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView2), (String)"tvEndDayOfWeek");
                    customTextView2.setVisibility(0);
                    ImageView imageView = this.$this_apply$inlined.imgArrow;
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"imgArrow");
                    imageView.setVisibility(0);
                    CustomTextView customTextView3 = this.$this_apply$inlined.tvStartDate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView3), (String)"tvStartDate");
                    String string2 = this.this$0.getString(R.string.lp_datepicker_date_text_format);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(R.string.lp_datepicker_date_text_format)");
                    customTextView3.setText(CalendarUtils.INSTANCE.getDateText(startDate, string2, (Context)this.this$0));
                    CustomTextView customTextView4 = this.$this_apply$inlined.tvStartDayOfWeek;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView4), (String)"tvStartDayOfWeek");
                    customTextView4.setText(CalendarUtils.INSTANCE.getDayOfWeek(startDate, (Context)this.this$0));
                    LinearLayout linearLayout = this.$this_apply$inlined.startDateLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"startDateLayout");
                    Object[] objectArray = new Object[2];
                    CustomTextView customTextView5 = this.$this_apply$inlined.tvStartDate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView5), (String)"tvStartDate");
                    objectArray[0] = customTextView5.getText();
                    CustomTextView customTextView6 = this.$this_apply$inlined.tvStartDayOfWeek;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView6), (String)"tvStartDayOfWeek");
                    objectArray[1] = customTextView6.getText();
                    linearLayout.setContentDescription((CharSequence)this.this$0.getString(R.string.lp_datepicker_from, objectArray));
                    CustomTextView customTextView7 = this.$this_apply$inlined.tvEndDate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView7), (String)"tvEndDate");
                    String string3 = this.this$0.getString(R.string.lp_datepicker_date_text_format);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"getString(R.string.lp_datepicker_date_text_format)");
                    customTextView7.setText(CalendarUtils.INSTANCE.getDateText(endDate, string3, (Context)this.this$0));
                    CustomTextView customTextView8 = this.$this_apply$inlined.tvEndDayOfWeek;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView8), (String)"tvEndDayOfWeek");
                    customTextView8.setText(CalendarUtils.INSTANCE.getDayOfWeek(endDate, (Context)this.this$0));
                    LinearLayout linearLayout2 = this.$this_apply$inlined.endDateLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout2, (String)"endDateLayout");
                    Object[] objectArray2 = new Object[2];
                    CustomTextView customTextView9 = this.$this_apply$inlined.tvEndDate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView9), (String)"tvEndDate");
                    objectArray2[0] = customTextView9.getText();
                    CustomTextView customTextView10 = this.$this_apply$inlined.tvEndDayOfWeek;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView10), (String)"tvEndDayOfWeek");
                    objectArray2[1] = customTextView10.getText();
                    linearLayout2.setContentDescription((CharSequence)this.this$0.getString(R.string.lp_datepicker_to, objectArray2));
                    ConstraintLayout constraintLayout2 = this.$this_apply$inlined.bottomWrapper;
                    Intrinsics.checkExpressionValueIsNotNull((Object)constraintLayout2, (String)"bottomWrapper");
                    StringBuilder stringBuilder = new StringBuilder();
                    LinearLayout linearLayout3 = this.$this_apply$inlined.startDateLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout3, (String)"startDateLayout");
                    StringBuilder stringBuilder2 = stringBuilder.append(linearLayout3.getContentDescription()).append(' ');
                    LinearLayout linearLayout4 = this.$this_apply$inlined.endDateLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout4, (String)"endDateLayout");
                    constraintLayout2.setContentDescription((CharSequence)stringBuilder2.append(linearLayout4.getContentDescription()).toString());
                } else {
                    CustomTextView customTextView = this.$this_apply$inlined.tvStartDate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView), (String)"tvStartDate");
                    customTextView.setGravity(1);
                    CustomTextView customTextView11 = this.$this_apply$inlined.tvStartDayOfWeek;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView11), (String)"tvStartDayOfWeek");
                    customTextView11.setGravity(1);
                    CustomTextView customTextView12 = this.$this_apply$inlined.tvStartDate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView12), (String)"tvStartDate");
                    String string4 = this.this$0.getString(R.string.lp_datepicker_date_text_format);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"getString(R.string.lp_datepicker_date_text_format)");
                    customTextView12.setText(CalendarUtils.INSTANCE.getDateText(startDate, string4, (Context)this.this$0));
                    CustomTextView customTextView13 = this.$this_apply$inlined.tvStartDayOfWeek;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView13), (String)"tvStartDayOfWeek");
                    customTextView13.setText(CalendarUtils.INSTANCE.getDayOfWeek(startDate, (Context)this.this$0));
                    ConstraintSet constraintSet = new ConstraintSet();
                    boolean bl = false;
                    boolean bl2 = false;
                    ConstraintSet $this$apply = constraintSet;
                    boolean bl3 = false;
                    $this$apply.clone(this.$this_apply$inlined.datesWrapper);
                    ConstraintSet constaints = constraintSet;
                    LinearLayout linearLayout = this.$this_apply$inlined.startDateLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"startDateLayout");
                    constaints.connect(linearLayout.getId(), 7, 0, 7);
                    constaints.applyTo(this.$this_apply$inlined.datesWrapper);
                    LinearLayout linearLayout5 = this.$this_apply$inlined.startDateLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout5, (String)"startDateLayout");
                    linearLayout5.setImportantForAccessibility(2);
                    LinearLayout linearLayout6 = this.$this_apply$inlined.startDateLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout6, (String)"startDateLayout");
                    Object[] objectArray = new Object[2];
                    CustomTextView customTextView14 = this.$this_apply$inlined.tvStartDate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView14), (String)"tvStartDate");
                    objectArray[0] = customTextView14.getText();
                    CustomTextView customTextView15 = this.$this_apply$inlined.tvStartDayOfWeek;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)customTextView15), (String)"tvStartDayOfWeek");
                    objectArray[1] = customTextView15.getText();
                    linearLayout6.setContentDescription((CharSequence)this.this$0.getString(R.string.lp_datepicker_selected_date, objectArray));
                    ConstraintLayout constraintLayout3 = this.$this_apply$inlined.bottomWrapper;
                    Intrinsics.checkExpressionValueIsNotNull((Object)constraintLayout3, (String)"bottomWrapper");
                    LinearLayout linearLayout7 = this.$this_apply$inlined.startDateLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout7, (String)"startDateLayout");
                    constraintLayout3.setContentDescription((CharSequence)String.valueOf(linearLayout7.getContentDescription()));
                }
            }
        });
        $this$apply2.setOnPageChangeListener(new LPICalendarPageChangedListener($this$apply, minDate, maxDate, monthAdapter, yearAdapter, this, initInfo){
            final /* synthetic */ ActivityDatePickerBinding $this_apply$inlined;
            final /* synthetic */ Calendar $minDate$inlined;
            final /* synthetic */ Calendar $maxDate$inlined;
            final /* synthetic */ ArrayAdapter $monthAdapter$inlined;
            final /* synthetic */ ArrayAdapter $yearAdapter$inlined;
            final /* synthetic */ DatePickerActivity this$0;
            final /* synthetic */ CalendarInitInfo $initInfo$inlined;
            {
                this.$this_apply$inlined = activityDatePickerBinding;
                this.$minDate$inlined = calendar;
                this.$maxDate$inlined = calendar2;
                this.$monthAdapter$inlined = arrayAdapter;
                this.$yearAdapter$inlined = arrayAdapter2;
                this.this$0 = datePickerActivity;
                this.$initInfo$inlined = calendarInitInfo;
            }

            public void onCalendarChanged(@NotNull Calendar calendar) {
                Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
                boolean yearChanged = calendar.get(1) != DatePickerActivity.access$getCurrentDate$p(this.this$0).get(1);
                Object object = calendar.clone();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Calendar");
                }
                DatePickerActivity.access$setCurrentDate$p(this.this$0, (Calendar)object);
                if (yearChanged) {
                    DatePickerActivity.access$getMonthList$p(this.this$0).clear();
                    DatePickerActivity.access$getMonthList$p(this.this$0).addAll((Collection)CalendarUtils.INSTANCE.getMonthRange(this.$minDate$inlined, this.$maxDate$inlined, DatePickerActivity.access$getCurrentDate$p(this.this$0), (Context)this.this$0));
                }
                this.$this_apply$inlined.spMonth.setSelection(DatePickerActivity.access$getMonthList$p(this.this$0).indexOf(CalendarUtils.INSTANCE.getMonthText(DatePickerActivity.access$getCurrentDate$p(this.this$0), (Context)this.this$0)));
                this.$monthAdapter$inlined.notifyDataSetChanged();
                this.$this_apply$inlined.spYear.setSelection(DatePickerActivity.access$getYearList$p(this.this$0).indexOf(DatePickerActivity.access$getCurrentDate$p(this.this$0).get(1)));
                this.$yearAdapter$inlined.notifyDataSetChanged();
            }
        });
        $this$apply.imgClose.setOnClickListener(new View.OnClickListener(this, initInfo){
            final /* synthetic */ DatePickerActivity this$0;
            final /* synthetic */ CalendarInitInfo $initInfo$inlined;
            {
                this.this$0 = datePickerActivity;
                this.$initInfo$inlined = calendarInitInfo;
            }

            public final void onClick(View it) {
                DatePickerActivity.access$closeDatePicker(this.this$0);
            }
        });
        $this$apply.btnConfirm.setOnClickListener(new View.OnClickListener($this$apply, this, initInfo){
            final /* synthetic */ ActivityDatePickerBinding $this_apply;
            final /* synthetic */ DatePickerActivity this$0;
            final /* synthetic */ CalendarInitInfo $initInfo$inlined;
            {
                this.$this_apply = activityDatePickerBinding;
                this.this$0 = datePickerActivity;
                this.$initInfo$inlined = calendarInitInfo;
            }

            public final void onClick(View it) {
                if (this.$this_apply.calendar.getStartDate() == null || this.$this_apply.calendar.getEndDate() == null) {
                    this.this$0.setResult(0);
                } else {
                    this.this$0.getIntent().putExtra("RESULT_START_DATE_IN_SECONDS", (Serializable)DatePickerActivity.access$getSelectedStartDate$p(this.this$0));
                    this.this$0.getIntent().putExtra("RESULT_END_DATE_IN_SECONDS", (Serializable)DatePickerActivity.access$getSelectedEndDate$p(this.this$0));
                    this.this$0.setResult(-1, this.this$0.getIntent());
                }
                this.this$0.finish();
            }
        });
    }

    private final void closeDatePicker() {
        this.setResult(0);
        this.finish();
    }

    public static final /* synthetic */ List access$getMonthList$p(DatePickerActivity $this) {
        return $this.monthList;
    }

    public static final /* synthetic */ Calendar access$getCurrentDate$p(DatePickerActivity $this) {
        Calendar calendar = $this.currentDate;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDate");
        }
        return calendar;
    }

    public static final /* synthetic */ void access$setCurrentDate$p(DatePickerActivity $this, Calendar calendar) {
        $this.currentDate = calendar;
    }

    public static final /* synthetic */ List access$getYearList$p(DatePickerActivity $this) {
        return $this.yearList;
    }

    public static final /* synthetic */ Long access$getSelectedStartDate$p(DatePickerActivity $this) {
        return $this.selectedStartDate;
    }

    public static final /* synthetic */ void access$setSelectedStartDate$p(DatePickerActivity $this, Long l) {
        $this.selectedStartDate = l;
    }

    public static final /* synthetic */ Long access$getSelectedEndDate$p(DatePickerActivity $this) {
        return $this.selectedEndDate;
    }

    public static final /* synthetic */ void access$setSelectedEndDate$p(DatePickerActivity $this, Long l) {
        $this.selectedEndDate = l;
    }

    public static final /* synthetic */ void access$closeDatePicker(DatePickerActivity $this) {
        $this.closeDatePicker();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/lpdatepicker/DatePickerActivity$Companion;", "", "()V", "CALENDAR_INIT_INFO", "", "RESULT_END_DATE_IN_SECONDS", "RESULT_START_DATE_IN_SECONDS", "datepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

