/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker.calendar.views;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.appcompat.widget.AppCompatTextView;
import com.liveperson.lpdatepicker.AccessibilityUtilsKt;
import com.liveperson.lpdatepicker.CalendarUtils;
import com.liveperson.lpdatepicker.R;
import com.liveperson.lpdatepicker.calendar.models.LPICalendarStyleAttributes;
import com.liveperson.lpdatepicker.calendar.views.DateTiming;
import com.liveperson.lpdatepicker.calendar.views.LPCalendarRangeUtilsKt;
import com.liveperson.lpdatepicker.calendar.views.LPCustomDateView;
import com.liveperson.lpdatepicker.calendar.views.LPDateRangeMonthView$WhenMappings;
import com.liveperson.lpdatepicker.calendar.views.LPICalendarDateRangeManager;
import com.liveperson.lpdatepicker.calendar.views.LPICalendarListener;
import com.liveperson.lpdatepicker.calendar.views.LPIDateView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J \u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010$\u001a\u00020\u001aJ\u0010\u0010%\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010&\u001a\u00020\u001aH\u0002J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020\u001aH\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/liveperson/lpdatepicker/calendar/views/LPDateRangeMonthView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "calendarListener", "Lcom/liveperson/lpdatepicker/calendar/views/LPICalendarListener;", "calendarStyleAttr", "Lcom/liveperson/lpdatepicker/calendar/models/LPICalendarStyleAttributes;", "currentCalendarMonth", "Ljava/util/Calendar;", "dateRangeCalendarManager", "Lcom/liveperson/lpdatepicker/calendar/views/LPICalendarDateRangeManager;", "llDaysContainer", "llTitleWeekContainer", "mOnDateClickListener", "Lcom/liveperson/lpdatepicker/calendar/views/LPIDateView$OnDateClickListener;", "drawCalendarForMonth", "", "month", "drawDayContainer", "customDateView", "Lcom/liveperson/lpdatepicker/calendar/views/LPCustomDateView;", "date", "formatter", "Ljava/text/SimpleDateFormat;", "initView", "attributeSet", "resetAllSelectedViews", "setCalendarListener", "setListeners", "setSelectedDate", "selectedDate", "setWeekTextAttributes", "datepicker_release"})
public final class LPDateRangeMonthView
extends LinearLayout {
    private LinearLayout llDaysContainer;
    private LinearLayout llTitleWeekContainer;
    private Calendar currentCalendarMonth;
    private LPICalendarStyleAttributes calendarStyleAttr;
    private LPICalendarListener calendarListener;
    private LPICalendarDateRangeManager dateRangeCalendarManager;
    private final LPIDateView.OnDateClickListener mOnDateClickListener;

    public final void setCalendarListener(@Nullable LPICalendarListener calendarListener) {
        this.calendarListener = calendarListener;
    }

    private final void initView(Context context, AttributeSet attributeSet) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        View view = layoutInflater.inflate(R.layout.lp_layout_calendar_month, (ViewGroup)this, true);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
        }
        LinearLayout mainView = (LinearLayout)view;
        View view2 = mainView.findViewById(R.id.llDaysContainer);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"mainView.findViewById(R.id.llDaysContainer)");
        this.llDaysContainer = (LinearLayout)view2;
        View view3 = mainView.findViewById(R.id.llTitleWeekContainer);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"mainView.findViewById(R.id.llTitleWeekContainer)");
        this.llTitleWeekContainer = (LinearLayout)view3;
        this.setListeners();
    }

    private final void setListeners() {
    }

    private final void setSelectedDate(Calendar selectedDate) {
        LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
        if (lPICalendarStyleAttributes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
        }
        LPICalendarStyleAttributes.DateSelectionMode selectionMode = lPICalendarStyleAttributes.getDateSelectionMode();
        LPICalendarDateRangeManager lPICalendarDateRangeManager = this.dateRangeCalendarManager;
        if (lPICalendarDateRangeManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
        }
        Calendar minSelectedDate = lPICalendarDateRangeManager.getMinSelectedDate();
        LPICalendarDateRangeManager lPICalendarDateRangeManager2 = this.dateRangeCalendarManager;
        if (lPICalendarDateRangeManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
        }
        Calendar maxSelectedDate = lPICalendarDateRangeManager2.getMaxSelectedDate();
        switch (LPDateRangeMonthView$WhenMappings.$EnumSwitchMapping$0[selectionMode.ordinal()]) {
            case 1: {
                if ((minSelectedDate == null || maxSelectedDate == null) && (Intrinsics.areEqual((Object)selectedDate, (Object)minSelectedDate) || Intrinsics.areEqual((Object)selectedDate, (Object)maxSelectedDate))) {
                    return;
                }
                if (minSelectedDate != null && maxSelectedDate == null) {
                    long lastDateKey;
                    maxSelectedDate = selectedDate;
                    long startDateKey = LPIDateView.Companion.getContainerKey(minSelectedDate);
                    if (startDateKey == (lastDateKey = LPIDateView.Companion.getContainerKey(maxSelectedDate))) {
                        minSelectedDate = maxSelectedDate;
                        break;
                    }
                    if (startDateKey <= lastDateKey) break;
                    Object object = minSelectedDate.clone();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Calendar");
                    }
                    Calendar temp = (Calendar)object;
                    minSelectedDate = maxSelectedDate;
                    maxSelectedDate = temp;
                    break;
                }
                if (maxSelectedDate == null) {
                    minSelectedDate = selectedDate;
                    break;
                }
                minSelectedDate = selectedDate;
                maxSelectedDate = null;
                break;
            }
            case 2: {
                minSelectedDate = selectedDate;
                maxSelectedDate = selectedDate;
                break;
            }
            case 3: {
                minSelectedDate = selectedDate;
                Object object = selectedDate.clone();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Calendar");
                }
                maxSelectedDate = (Calendar)object;
                LPICalendarStyleAttributes lPICalendarStyleAttributes2 = this.calendarStyleAttr;
                if (lPICalendarStyleAttributes2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
                }
                maxSelectedDate.add(5, lPICalendarStyleAttributes2.getFixedDaysSelectionNumber());
                break;
            }
        }
        LPICalendarDateRangeManager lPICalendarDateRangeManager3 = this.dateRangeCalendarManager;
        if (lPICalendarDateRangeManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
        }
        lPICalendarDateRangeManager3.setSelectedDateRange(minSelectedDate, maxSelectedDate);
        Calendar calendar = this.currentCalendarMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
        }
        this.drawCalendarForMonth(calendar);
        if (maxSelectedDate != null) {
            LPICalendarListener lPICalendarListener = this.calendarListener;
            if (lPICalendarListener == null) {
                Intrinsics.throwNpe();
            }
            lPICalendarListener.onDateRangeSelected(minSelectedDate, maxSelectedDate);
        } else {
            LPICalendarListener lPICalendarListener = this.calendarListener;
            if (lPICalendarListener == null) {
                Intrinsics.throwNpe();
            }
            lPICalendarListener.onFirstDateSelected(minSelectedDate);
        }
    }

    public final void drawCalendarForMonth(@NotNull LPICalendarStyleAttributes calendarStyleAttr, @NotNull Calendar month, @NotNull LPICalendarDateRangeManager dateRangeCalendarManager) {
        Intrinsics.checkParameterIsNotNull((Object)calendarStyleAttr, (String)"calendarStyleAttr");
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        Intrinsics.checkParameterIsNotNull((Object)dateRangeCalendarManager, (String)"dateRangeCalendarManager");
        this.calendarStyleAttr = calendarStyleAttr;
        Object object = month.clone();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Calendar");
        }
        this.currentCalendarMonth = (Calendar)object;
        this.dateRangeCalendarManager = dateRangeCalendarManager;
        Calendar calendar = this.currentCalendarMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
        }
        this.drawCalendarForMonth(calendar);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawCalendarForMonth(Calendar month) {
        int startDay;
        this.setWeekTextAttributes();
        Object object = month.clone();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Calendar");
        }
        Calendar calendar = this.currentCalendarMonth = (Calendar)object;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
        }
        calendar.set(5, 1);
        Calendar calendar2 = this.currentCalendarMonth;
        if (calendar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
        }
        LPCalendarRangeUtilsKt.resetTime(calendar2, DateTiming.NONE);
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        List<String> weekTitle = CalendarUtils.INSTANCE.getDayOfWeekNameList(context);
        int n = 0;
        int n2 = 6;
        while (n <= n2) {
            void i;
            LinearLayout linearLayout = this.llTitleWeekContainer;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"llTitleWeekContainer");
            }
            View view = linearLayout.getChildAt((int)i);
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type androidx.appcompat.widget.AppCompatTextView");
            }
            AppCompatTextView textView = (AppCompatTextView)view;
            LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
            if (lPICalendarStyleAttributes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
            }
            void index = (i + lPICalendarStyleAttributes.getWeekOffset()) % 7;
            String weekStr = weekTitle.get((int)index);
            textView.setText((CharSequence)weekStr);
            textView.setImportantForAccessibility(2);
            ++i;
        }
        int n3 = month.get(7);
        LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
        if (lPICalendarStyleAttributes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
        }
        if ((startDay = n3 - lPICalendarStyleAttributes.getWeekOffset()) < 1) {
            startDay += 7;
        }
        month.add(5, -startDay + 1);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        SimpleDateFormat formatter = AccessibilityUtilsKt.createDayFormatter(CalendarUtils.INSTANCE.getLocale(context2));
        int textView = 0;
        LinearLayout linearLayout = this.llDaysContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"llDaysContainer");
        }
        int n4 = linearLayout.getChildCount();
        while (textView < n4) {
            void i;
            LinearLayout linearLayout2 = this.llDaysContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"llDaysContainer");
            }
            View view = linearLayout2.getChildAt((int)i);
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
            }
            LinearLayout weekRow = (LinearLayout)view;
            int n5 = 0;
            int n6 = 6;
            while (n5 <= n6) {
                void j;
                View view2 = weekRow.getChildAt((int)j);
                if (view2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.liveperson.lpdatepicker.calendar.views.LPCustomDateView");
                }
                LPCustomDateView customDateView = (LPCustomDateView)view2;
                this.drawDayContainer(customDateView, month, formatter);
                month.add(5, 1);
                ++j;
            }
            ++i;
        }
    }

    private final void drawDayContainer(LPCustomDateView customDateView, Calendar date, SimpleDateFormat formatter) {
        LPIDateView.DateState dateState;
        String formattedDate = formatter.format(date.getTime());
        customDateView.setDateText(String.valueOf(date.get(5)));
        LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
        if (lPICalendarStyleAttributes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
        }
        customDateView.setDateStyleAttributes(lPICalendarStyleAttributes);
        customDateView.setDateClickListener(this.mOnDateClickListener);
        LPICalendarStyleAttributes lPICalendarStyleAttributes2 = this.calendarStyleAttr;
        if (lPICalendarStyleAttributes2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
        }
        Typeface typeface = lPICalendarStyleAttributes2.getFonts();
        if (typeface != null) {
            Typeface typeface2 = typeface;
            boolean bl = false;
            boolean bl2 = false;
            Typeface it = typeface2;
            boolean bl3 = false;
            customDateView.setTypeface(it);
        }
        Calendar calendar = this.currentCalendarMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
        }
        if (calendar.get(2) != date.get(2)) {
            dateState = LPIDateView.DateState.HIDDEN;
        } else {
            LPICalendarDateRangeManager.DateSelectionState type;
            LPICalendarDateRangeManager lPICalendarDateRangeManager = this.dateRangeCalendarManager;
            if (lPICalendarDateRangeManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
            }
            if ((type = lPICalendarDateRangeManager.checkDateRange(date)) == LPICalendarDateRangeManager.DateSelectionState.START_DATE) {
                dateState = LPIDateView.DateState.START;
            } else if (type == LPICalendarDateRangeManager.DateSelectionState.LAST_DATE) {
                dateState = LPIDateView.DateState.END;
            } else if (type == LPICalendarDateRangeManager.DateSelectionState.START_END_SAME) {
                dateState = LPIDateView.DateState.START_END_SAME;
            } else if (type == LPICalendarDateRangeManager.DateSelectionState.IN_SELECTED_RANGE) {
                dateState = LPIDateView.DateState.MIDDLE;
            } else {
                LPICalendarDateRangeManager lPICalendarDateRangeManager2 = this.dateRangeCalendarManager;
                if (lPICalendarDateRangeManager2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
                }
                dateState = lPICalendarDateRangeManager2.isSelectableDate(date) ? LPIDateView.DateState.SELECTABLE : LPIDateView.DateState.DISABLE;
            }
        }
        LPIDateView.DateState dateState2 = dateState;
        customDateView.updateDateBackground(dateState2);
        customDateView.setTag(LPIDateView.Companion.getContainerKey(date));
        String string2 = formattedDate;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"formattedDate");
        customDateView.setContentDescription(string2);
        AccessibilityUtilsKt.applyDateState(customDateView, dateState2);
    }

    public final void resetAllSelectedViews() {
        LPICalendarDateRangeManager lPICalendarDateRangeManager = this.dateRangeCalendarManager;
        if (lPICalendarDateRangeManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
        }
        lPICalendarDateRangeManager.resetSelectedDateRange();
        Calendar calendar = this.currentCalendarMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
        }
        this.drawCalendarForMonth(calendar);
    }

    /*
     * WARNING - void declaration
     */
    private final void setWeekTextAttributes() {
        int n = 0;
        LinearLayout linearLayout = this.llTitleWeekContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"llTitleWeekContainer");
        }
        int n2 = linearLayout.getChildCount();
        while (n < n2) {
            void i;
            LinearLayout linearLayout2 = this.llTitleWeekContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"llTitleWeekContainer");
            }
            View view = linearLayout2.getChildAt((int)i);
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type androidx.appcompat.widget.AppCompatTextView");
            }
            AppCompatTextView textView = (AppCompatTextView)view;
            LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
            if (lPICalendarStyleAttributes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
            }
            textView.setTypeface(lPICalendarStyleAttributes.getFonts());
            LPICalendarStyleAttributes lPICalendarStyleAttributes2 = this.calendarStyleAttr;
            if (lPICalendarStyleAttributes2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
            }
            textView.setTextSize(0, lPICalendarStyleAttributes2.getTextSizeWeek());
            LPICalendarStyleAttributes lPICalendarStyleAttributes3 = this.calendarStyleAttr;
            if (lPICalendarStyleAttributes3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
            }
            textView.setTextColor(lPICalendarStyleAttributes3.getWeekColor());
            ++i;
        }
    }

    public LPDateRangeMonthView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mOnDateClickListener = new LPIDateView.OnDateClickListener(this){
            final /* synthetic */ LPDateRangeMonthView this$0;

            public void onDateClicked(@NotNull View view, @NotNull Calendar selectedDate) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)selectedDate, (String)"selectedDate");
                if (LPDateRangeMonthView.access$getCalendarStyleAttr$p(this.this$0).isEditable()) {
                    LPDateRangeMonthView.access$setSelectedDate(this.this$0, selectedDate);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.initView(context, null);
    }

    public LPDateRangeMonthView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.mOnDateClickListener = new /* invalid duplicate definition of identical inner class */;
        this.initView(context, attrs);
    }

    public LPDateRangeMonthView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mOnDateClickListener = new /* invalid duplicate definition of identical inner class */;
        this.initView(context, attrs);
    }

    @TargetApi(value=21)
    public LPDateRangeMonthView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mOnDateClickListener = new /* invalid duplicate definition of identical inner class */;
        this.initView(context, attrs);
    }

    public static final /* synthetic */ LPICalendarStyleAttributes access$getCalendarStyleAttr$p(LPDateRangeMonthView $this) {
        LPICalendarStyleAttributes lPICalendarStyleAttributes = $this.calendarStyleAttr;
        if (lPICalendarStyleAttributes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
        }
        return lPICalendarStyleAttributes;
    }

    public static final /* synthetic */ void access$setCalendarStyleAttr$p(LPDateRangeMonthView $this, LPICalendarStyleAttributes lPICalendarStyleAttributes) {
        $this.calendarStyleAttr = lPICalendarStyleAttributes;
    }

    public static final /* synthetic */ void access$setSelectedDate(LPDateRangeMonthView $this, Calendar selectedDate) {
        $this.setSelectedDate(selectedDate);
    }
}

