/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import androidx.fragment.app.Fragment;
import com.liveperson.lpdatepicker.R;
import com.liveperson.lpdatepicker.calendar.models.LPICalendarStyleAttributes;
import com.liveperson.lpdatepicker.calendar.views.LPDateRangeCalendarView;
import com.liveperson.lpdatepicker.callbacks.LPICalendarListenerImpl;
import com.liveperson.lpdatepicker.callbacks.LPICalendarPageChangedListener;
import com.liveperson.lpdatepicker.databinding.FragmentDatePickerBinding;
import com.liveperson.lpdatepicker.model.DatePickerParams;
import com.liveperson.lpdatepicker.model.DatePickerResult;
import com.liveperson.lpdatepicker.ui.CustomTextView;
import com.liveperson.lpdatepicker.utils.AccessibilityUtilsKt;
import com.liveperson.lpdatepicker.utils.BundleUtils;
import com.liveperson.lpdatepicker.utils.CalendarUtilsKt;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u0011\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0015\u001a\u00020\u000e*\u00020\u0004H\u0002J$\u0010\u0016\u001a\u00020\u000e*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J$\u0010\u001c\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J$\u0010\u001d\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/liveperson/lpdatepicker/DatePickerFragment;", "Landroidx/fragment/app/Fragment;", "()V", "binding", "Lcom/liveperson/lpdatepicker/databinding/FragmentDatePickerBinding;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroyView", "", "onViewCreated", "view", "bind", "pickerInfo", "Lcom/liveperson/lpdatepicker/model/DatePickerParams;", "bindSelectionRange", "release", "setup", "Lcom/liveperson/lpdatepicker/calendar/views/LPDateRangeCalendarView;", "current", "Ljava/util/Calendar;", "min", "max", "setupMonthSpinner", "setupYearSelection", "Companion", "datepicker_release"})
@SourceDebugExtension(value={"SMAP\nDatePickerFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatePickerFragment.kt\ncom/liveperson/lpdatepicker/DatePickerFragment\n+ 2 SpinnerUtils.kt\ncom/liveperson/lpdatepicker/utils/SpinnerUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n11#2:224\n24#2,2:225\n11#2:227\n24#2,2:228\n1#3:230\n*S KotlinDebug\n*F\n+ 1 DatePickerFragment.kt\ncom/liveperson/lpdatepicker/DatePickerFragment\n*L\n135#1:224\n135#1:225,2\n167#1:227\n167#1:228,2\n*E\n"})
public final class DatePickerFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FragmentDatePickerBinding binding;
    @NotNull
    public static final String TAG = "DatePickerFragment";
    @NotNull
    public static final String REQUEST_KEY = "DatePickerKey";

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_date_picker, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super.onViewCreated(view, savedInstanceState);
            FragmentDatePickerBinding fragmentDatePickerBinding = this.binding = FragmentDatePickerBinding.bind(view);
            if (fragmentDatePickerBinding == null) break block1;
            Object object = this.getArguments();
            if (object == null || (object = BundleUtils.getDatePickerParams(object)) == null) {
                return;
            }
            this.bind(fragmentDatePickerBinding, (DatePickerParams)object);
        }
    }

    public void onDestroyView() {
        FragmentDatePickerBinding fragmentDatePickerBinding = this.binding;
        if (fragmentDatePickerBinding != null) {
            this.release(fragmentDatePickerBinding);
        }
        this.binding = null;
        super.onDestroyView();
    }

    private final void bind(FragmentDatePickerBinding $this$bind, DatePickerParams pickerInfo) {
        CustomTextView customTextView = $this$bind.tvHeader;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)customTextView), (String)"tvHeader");
        AccessibilityUtilsKt.markAsAccessibilityHeading((View)customTextView, true);
        $this$bind.tvHeader.setText(pickerInfo.getTitle());
        this.bindSelectionRange($this$bind, pickerInfo);
        $this$bind.imgClose.setOnClickListener(arg_0 -> DatePickerFragment.bind$lambda$0(this, arg_0));
        $this$bind.btnConfirm.setOnClickListener(arg_0 -> DatePickerFragment.bind$lambda$2($this$bind, this, arg_0));
    }

    private final void bindSelectionRange(FragmentDatePickerBinding $this$bindSelectionRange, DatePickerParams pickerInfo) {
        LPICalendarStyleAttributes.DateSelectionMode dateSelectionMode;
        Calendar calendar;
        Calendar now = Calendar.getInstance();
        Calendar minDate = CalendarUtilsKt.getCalendarDate(pickerInfo.getMinDate());
        Calendar maxDate = CalendarUtilsKt.getCalendarDate(pickerInfo.getMaxDate());
        if (now.after(minDate) && now.before(maxDate)) {
            calendar = now;
        } else if (now.getTimeInMillis() < pickerInfo.getMinDate()) {
            Object object = minDate.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
            calendar = (Calendar)object;
        } else {
            Object object = maxDate.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
            calendar = (Calendar)object;
        }
        Calendar currentDate = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)currentDate, (String)"currentDate");
        this.setupMonthSpinner($this$bindSelectionRange, currentDate, minDate, maxDate);
        this.setupYearSelection($this$bindSelectionRange, currentDate, minDate, maxDate);
        LPDateRangeCalendarView lPDateRangeCalendarView = $this$bindSelectionRange.calendar;
        Intrinsics.checkNotNullExpressionValue((Object)lPDateRangeCalendarView, (String)"calendar");
        this.setup(lPDateRangeCalendarView, currentDate, minDate, maxDate);
        switch (WhenMappings.$EnumSwitchMapping$0[pickerInfo.getType().ordinal()]) {
            case 1: {
                dateSelectionMode = LPICalendarStyleAttributes.DateSelectionMode.FREE_RANGE;
                break;
            }
            case 2: {
                dateSelectionMode = LPICalendarStyleAttributes.DateSelectionMode.SINGLE;
                break;
            }
            default: {
                dateSelectionMode = LPICalendarStyleAttributes.DateSelectionMode.FIXED_RANGE;
            }
        }
        LPICalendarStyleAttributes.DateSelectionMode mode = dateSelectionMode;
        $this$bindSelectionRange.calendar.setSelectMode(mode);
        $this$bindSelectionRange.calendar.setCalendarListener(new LPICalendarListenerImpl($this$bindSelectionRange, pickerInfo.getType()));
        LPICalendarPageChangedListener pageChangedListener = new LPICalendarPageChangedListener(currentDate, minDate, maxDate, $this$bindSelectionRange);
        $this$bindSelectionRange.calendar.addOnPageChangeListener(pageChangedListener);
    }

    private final void setupMonthSpinner(FragmentDatePickerBinding $this$setupMonthSpinner, Calendar current, Calendar min, Calendar max) {
        Spinner spinner;
        Context context = $this$setupMonthSpinner.getRoot().getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        List<String> allMonthNames = CalendarUtilsKt.getMonthNameList(context);
        List<String> months = CalendarUtilsKt.getMonthRange(min, max, current, context);
        String monthName = allMonthNames.get(current.get(2));
        Spinner $this$setupMonthSpinner_u24lambda_u243 = spinner = $this$setupMonthSpinner.spMonth;
        boolean bl = false;
        $this$setupMonthSpinner_u24lambda_u243.setSelected(false);
        $this$setupMonthSpinner_u24lambda_u243.setAdapter((SpinnerAdapter)new ArrayAdapter(context, R.layout.lp_spinner_item, months));
        $this$setupMonthSpinner_u24lambda_u243.setSelection(months.indexOf(monthName), true);
        Object[] objectArray = new Object[]{monthName};
        $this$setupMonthSpinner_u24lambda_u243.setContentDescription((CharSequence)this.getString(R.string.lp_datepicker_month_spinner_description, objectArray));
        Spinner spinner2 = $this$setupMonthSpinner.spMonth;
        Intrinsics.checkNotNullExpressionValue((Object)spinner2, (String)"spMonth");
        Spinner $this$onItemSelected$iv = spinner2;
        boolean $i$f$onItemSelected = false;
        AdapterView.OnItemSelectedListener listener$iv = new AdapterView.OnItemSelectedListener(allMonthNames, months, current, $this$setupMonthSpinner, this){
            final /* synthetic */ List $allMonthNames$inlined;
            final /* synthetic */ List $months$inlined;
            final /* synthetic */ Calendar $current$inlined;
            final /* synthetic */ FragmentDatePickerBinding $this_setupMonthSpinner$inlined;
            final /* synthetic */ DatePickerFragment this$0;
            {
                this.$allMonthNames$inlined = list;
                this.$months$inlined = list2;
                this.$current$inlined = calendar;
                this.$this_setupMonthSpinner$inlined = fragmentDatePickerBinding;
                this.this$0 = datePickerFragment;
            }

            public void onItemSelected(@Nullable AdapterView<?> parent, @Nullable View view, int position, long id2) {
                int position2 = position;
                boolean bl = false;
                int selectedMonth = this.$allMonthNames$inlined.indexOf(this.$months$inlined.get(position2));
                this.$current$inlined.set(2, selectedMonth);
                this.$this_setupMonthSpinner$inlined.calendar.setCurrentMonth(this.$current$inlined);
                Object[] objectArray = new Object[]{this.$months$inlined.get(position2)};
                this.$this_setupMonthSpinner$inlined.spMonth.setContentDescription((CharSequence)this.this$0.getString(R.string.lp_datepicker_month_spinner_description, objectArray));
            }

            public void onNothingSelected(@Nullable AdapterView<?> parent) {
            }
        };
        $this$onItemSelected$iv.setOnItemSelectedListener(listener$iv);
    }

    private final void setupYearSelection(FragmentDatePickerBinding $this$setupYearSelection, Calendar current, Calendar min, Calendar max) {
        Spinner spinner;
        Context context = $this$setupYearSelection.getRoot().getContext();
        List<Integer> yearList = CalendarUtilsKt.getYearRange(min, max);
        ArrayAdapter yearAdapter = new ArrayAdapter(context, R.layout.lp_spinner_item, yearList);
        Spinner $this$setupYearSelection_u24lambda_u245 = spinner = $this$setupYearSelection.spYear;
        boolean bl = false;
        $this$setupYearSelection_u24lambda_u245.setAdapter((SpinnerAdapter)yearAdapter);
        $this$setupYearSelection_u24lambda_u245.setSelected(false);
        int yearPos = yearList.indexOf(current.get(1));
        $this$setupYearSelection_u24lambda_u245.setSelection(yearPos, true);
        Object[] objectArray = new Object[]{yearList.get($this$setupYearSelection_u24lambda_u245.getSelectedItemPosition())};
        $this$setupYearSelection_u24lambda_u245.setContentDescription((CharSequence)this.getString(R.string.lp_datepicker_year_spinner_description, objectArray));
        Spinner spinner2 = $this$setupYearSelection.spYear;
        Intrinsics.checkNotNullExpressionValue((Object)spinner2, (String)"spYear");
        Spinner $this$onItemSelected$iv = spinner2;
        boolean $i$f$onItemSelected = false;
        AdapterView.OnItemSelectedListener listener$iv = new AdapterView.OnItemSelectedListener(current, yearList, $this$setupYearSelection, this, min, max, context){
            final /* synthetic */ Calendar $current$inlined;
            final /* synthetic */ List $yearList$inlined;
            final /* synthetic */ FragmentDatePickerBinding $this_setupYearSelection$inlined;
            final /* synthetic */ DatePickerFragment this$0;
            final /* synthetic */ Calendar $min$inlined;
            final /* synthetic */ Calendar $max$inlined;
            final /* synthetic */ Context $context$inlined;
            {
                this.$current$inlined = calendar;
                this.$yearList$inlined = list;
                this.$this_setupYearSelection$inlined = fragmentDatePickerBinding;
                this.this$0 = datePickerFragment;
                this.$min$inlined = calendar2;
                this.$max$inlined = calendar3;
                this.$context$inlined = context;
            }

            public void onItemSelected(@Nullable AdapterView<?> parent, @Nullable View view, int position, long id2) {
                block9: {
                    ArrayAdapter monthsAdapter;
                    int position2 = position;
                    boolean bl = false;
                    this.$current$inlined.set(1, ((Number)this.$yearList$inlined.get(position2)).intValue());
                    Object[] objectArray = new Object[]{this.$yearList$inlined.get(position2)};
                    this.$this_setupYearSelection$inlined.spYear.setContentDescription((CharSequence)this.this$0.getString(R.string.lp_datepicker_year_spinner_description, objectArray));
                    int scrollTo = 0;
                    if (this.$current$inlined.getTime().before(this.$min$inlined.getTime())) {
                        this.$current$inlined.setTime(this.$min$inlined.getTime());
                        scrollTo = 1;
                    } else if (this.$current$inlined.getTime().after(this.$max$inlined.getTime())) {
                        this.$current$inlined.setTime(this.$max$inlined.getTime());
                        scrollTo = 2;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)this.$context$inlined, (String)"context");
                    List<String> months = CalendarUtilsKt.getMonthRange(this.$min$inlined, this.$max$inlined, this.$current$inlined, this.$context$inlined);
                    SpinnerAdapter spinnerAdapter = this.$this_setupYearSelection$inlined.spMonth.getAdapter();
                    ArrayAdapter arrayAdapter = monthsAdapter = spinnerAdapter instanceof ArrayAdapter ? (ArrayAdapter)spinnerAdapter : null;
                    if (arrayAdapter != null) {
                        arrayAdapter.clear();
                    }
                    ArrayAdapter arrayAdapter2 = monthsAdapter;
                    if (arrayAdapter2 != null) {
                        arrayAdapter2.addAll((Collection)months);
                    }
                    this.$this_setupYearSelection$inlined.calendar.setCurrentMonth(this.$current$inlined);
                    switch (scrollTo) {
                        case 1: {
                            this.$this_setupYearSelection$inlined.spMonth.setSelection(0);
                            break;
                        }
                        case 2: {
                            this.$this_setupYearSelection$inlined.spMonth.setSelection(CollectionsKt.getLastIndex(months));
                            break;
                        }
                        default: {
                            Intrinsics.checkNotNullExpressionValue((Object)this.$context$inlined, (String)"context");
                            String monthText = CalendarUtilsKt.getMonthText(this.$current$inlined, this.$context$inlined);
                            int monthIndex = months.indexOf(monthText);
                            this.$this_setupYearSelection$inlined.spMonth.setSelection(monthIndex);
                        }
                    }
                    ArrayAdapter arrayAdapter3 = monthsAdapter;
                    if (arrayAdapter3 == null) break block9;
                    arrayAdapter3.notifyDataSetChanged();
                }
            }

            public void onNothingSelected(@Nullable AdapterView<?> parent) {
            }
        };
        $this$onItemSelected$iv.setOnItemSelectedListener(listener$iv);
    }

    private final void setup(LPDateRangeCalendarView $this$setup, Calendar current, Calendar min, Calendar max) {
        $this$setup.setVisibleMonthRange(min, max);
        $this$setup.setSelectableDateRange(min, max);
        $this$setup.setCurrentMonth(current);
    }

    private final void release(FragmentDatePickerBinding $this$release) {
        $this$release.spMonth.setOnItemSelectedListener(null);
        $this$release.spYear.setOnItemSelectedListener(null);
        $this$release.calendar.setCalendarListener(null);
        $this$release.calendar.clearPageChangeListeners();
        $this$release.imgClose.setOnClickListener(null);
        $this$release.btnConfirm.setOnClickListener(null);
    }

    private static final void bind$lambda$0(DatePickerFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getParentFragmentManager().setFragmentResult(REQUEST_KEY, new Bundle());
    }

    private static final void bind$lambda$2(FragmentDatePickerBinding $this_bind, DatePickerFragment this$0, View it) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)$this_bind, (String)"$this_bind");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Calendar calendar = $this_bind.calendar.getStartDate();
        Long startDate = calendar != null ? Long.valueOf(calendar.getTimeInMillis()) : null;
        Calendar calendar2 = $this_bind.calendar.getEndDate();
        Long endDate = calendar2 != null ? Long.valueOf(calendar2.getTimeInMillis()) : null;
        Bundle bundle2 = this$0.getArguments();
        DatePickerParams params = bundle2 != null ? BundleUtils.getDatePickerParams(bundle2) : null;
        DatePickerResult result = params != null && startDate != null && endDate != null ? new DatePickerResult(params, startDate / (long)1000, endDate / (long)1000) : null;
        Bundle it2 = bundle = new Bundle();
        boolean bl = false;
        BundleUtils.setDatePickerResult(it2, result);
        Bundle bundle3 = bundle;
        this$0.getParentFragmentManager().setFragmentResult(REQUEST_KEY, bundle3);
    }

    @JvmStatic
    @NotNull
    public static final Fragment newInstance(@NotNull DatePickerParams args) {
        return Companion.newInstance(args);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/liveperson/lpdatepicker/DatePickerFragment$Companion;", "", "()V", "REQUEST_KEY", "", "TAG", "newInstance", "Landroidx/fragment/app/Fragment;", "args", "Lcom/liveperson/lpdatepicker/model/DatePickerParams;", "datepicker_release"})
    @SourceDebugExtension(value={"SMAP\nDatePickerFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatePickerFragment.kt\ncom/liveperson/lpdatepicker/DatePickerFragment$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Fragment newInstance(@NotNull DatePickerParams args) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Bundle $this$newInstance_u24lambda_u240 = object = new Bundle();
            boolean bl = false;
            BundleUtils.setDatePickerParams($this$newInstance_u24lambda_u240, args);
            Bundle arguments = object;
            Object it = object = new DatePickerFragment();
            boolean bl2 = false;
            it.setArguments(arguments);
            return (Fragment)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatePickerParams.Type.values().length];
            try {
                nArray[DatePickerParams.Type.RANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatePickerParams.Type.SINGLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

