/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker.calendar.models;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.core.content.ContextCompat;
import com.liveperson.lpdatepicker.R;
import com.liveperson.lpdatepicker.calendar.models.InvalidCalendarAttributeException;
import com.liveperson.lpdatepicker.calendar.models.LPICalendarStyleAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 A2\u00020\u0001:\u0001AB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010?\u001a\u00020@2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R$\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010'\"\u0004\b+\u0010)R\u001e\u0010,\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0011R\u001e\u0010.\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0011R\u001e\u00100\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0011R\u001e\u00102\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0011R\u001e\u00105\u001a\u0002042\u0006\u0010\r\u001a\u000204@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001e\u00108\u001a\u0002042\u0006\u0010\r\u001a\u000204@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107R\u001e\u0010:\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0011R$\u0010<\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000e@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0011\"\u0004\b>\u0010\u0018\u00a8\u0006B"}, d2={"Lcom/liveperson/lpdatepicker/calendar/models/LPCalendarStyleAttrImpl;", "Lcom/liveperson/lpdatepicker/calendar/models/LPICalendarStyleAttributes;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "dateSelectionMode", "Lcom/liveperson/lpdatepicker/calendar/models/LPICalendarStyleAttributes$DateSelectionMode;", "getDateSelectionMode", "()Lcom/liveperson/lpdatepicker/calendar/models/LPICalendarStyleAttributes$DateSelectionMode;", "setDateSelectionMode", "(Lcom/liveperson/lpdatepicker/calendar/models/LPICalendarStyleAttributes$DateSelectionMode;)V", "<set-?>", "", "defaultDateColor", "getDefaultDateColor", "()I", "disableDateColor", "getDisableDateColor", "value", "fixedDaysSelectionNumber", "getFixedDaysSelectionNumber", "setFixedDaysSelectionNumber", "(I)V", "fonts", "Landroid/graphics/Typeface;", "getFonts", "()Landroid/graphics/Typeface;", "setFonts", "(Landroid/graphics/Typeface;)V", "headerBg", "Landroid/graphics/drawable/Drawable;", "getHeaderBg", "()Landroid/graphics/drawable/Drawable;", "setHeaderBg", "(Landroid/graphics/drawable/Drawable;)V", "isEditable", "", "()Z", "setEditable", "(Z)V", "isShouldEnabledTime", "setShouldEnabledTime", "rangeDateColor", "getRangeDateColor", "rangeStripColor", "getRangeStripColor", "selectedDateCircleColor", "getSelectedDateCircleColor", "selectedDateColor", "getSelectedDateColor", "", "textSizeDate", "getTextSizeDate", "()F", "textSizeWeek", "getTextSizeWeek", "weekColor", "getWeekColor", "weekOffset", "getWeekOffset", "setWeekOffset", "setAttributes", "", "Companion", "datepicker_release"})
@SourceDebugExtension(value={"SMAP\nLPCalendarStyleAttrImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LPCalendarStyleAttrImpl.kt\ncom/liveperson/lpdatepicker/calendar/models/LPCalendarStyleAttrImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class LPCalendarStyleAttrImpl
implements LPICalendarStyleAttributes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Typeface fonts;
    @Nullable
    private Drawable headerBg;
    private int weekColor;
    private int rangeStripColor;
    private int selectedDateCircleColor;
    private int selectedDateColor;
    private int defaultDateColor;
    private int disableDateColor;
    private int rangeDateColor;
    private float textSizeWeek;
    private float textSizeDate;
    private boolean isShouldEnabledTime;
    private int weekOffset;
    private boolean isEditable;
    @NotNull
    private LPICalendarStyleAttributes.DateSelectionMode dateSelectionMode;
    private int fixedDaysSelectionNumber;

    public LPCalendarStyleAttrImpl(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        block0: {
            AttributeSet attributeSet2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.weekColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_weekday_title_color);
            this.rangeStripColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_range_bg_color);
            this.selectedDateCircleColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_selected_date_circle_color);
            this.selectedDateColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_selected_date_color);
            this.defaultDateColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_default_date_color);
            this.disableDateColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_disable_date_color);
            this.rangeDateColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_ranged_date_color);
            this.textSizeWeek = context.getResources().getDimension(R.dimen.text_size_week);
            this.textSizeDate = context.getResources().getDimension(R.dimen.text_size_date);
            this.isEditable = true;
            this.dateSelectionMode = LPICalendarStyleAttributes.DateSelectionMode.FREE_RANGE;
            this.fixedDaysSelectionNumber = 7;
            AttributeSet attributeSet3 = attributeSet;
            if (attributeSet3 == null) break block0;
            AttributeSet $this$_init__u24lambda_u240 = attributeSet2 = attributeSet3;
            boolean bl = false;
            this.setAttributes(context, $this$_init__u24lambda_u240);
        }
    }

    public /* synthetic */ LPCalendarStyleAttrImpl(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @Override
    @Nullable
    public Typeface getFonts() {
        return this.fonts;
    }

    @Override
    public void setFonts(@Nullable Typeface typeface) {
        this.fonts = typeface;
    }

    @Override
    @Nullable
    public Drawable getHeaderBg() {
        return this.headerBg;
    }

    @Override
    public void setHeaderBg(@Nullable Drawable drawable) {
        this.headerBg = drawable;
    }

    @Override
    public int getWeekColor() {
        return this.weekColor;
    }

    @Override
    public int getRangeStripColor() {
        return this.rangeStripColor;
    }

    @Override
    public int getSelectedDateCircleColor() {
        return this.selectedDateCircleColor;
    }

    @Override
    public int getSelectedDateColor() {
        return this.selectedDateColor;
    }

    @Override
    public int getDefaultDateColor() {
        return this.defaultDateColor;
    }

    @Override
    public int getDisableDateColor() {
        return this.disableDateColor;
    }

    @Override
    public int getRangeDateColor() {
        return this.rangeDateColor;
    }

    @Override
    public float getTextSizeWeek() {
        return this.textSizeWeek;
    }

    @Override
    public float getTextSizeDate() {
        return this.textSizeDate;
    }

    @Override
    public boolean isShouldEnabledTime() {
        return this.isShouldEnabledTime;
    }

    public void setShouldEnabledTime(boolean bl) {
        this.isShouldEnabledTime = bl;
    }

    @Override
    public int getWeekOffset() {
        return this.weekOffset;
    }

    @Override
    public void setWeekOffset(int weekOffset) {
        if (weekOffset < 0 || weekOffset > 6) {
            throw new InvalidCalendarAttributeException("Week offset can only be between 0 to 6. 0->Sun, 1->Mon, 2->Tue, 3->Wed, 4->Thu, 5->Fri, 6->Sat");
        }
        this.weekOffset = weekOffset;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    @Override
    @NotNull
    public LPICalendarStyleAttributes.DateSelectionMode getDateSelectionMode() {
        return this.dateSelectionMode;
    }

    @Override
    public void setDateSelectionMode(@NotNull LPICalendarStyleAttributes.DateSelectionMode dateSelectionMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)dateSelectionMode), (String)"<set-?>");
        this.dateSelectionMode = dateSelectionMode;
    }

    @Override
    public int getFixedDaysSelectionNumber() {
        return this.fixedDaysSelectionNumber;
    }

    @Override
    public void setFixedDaysSelectionNumber(int value) {
        if (this.getDateSelectionMode() != LPICalendarStyleAttributes.DateSelectionMode.FIXED_RANGE) {
            throw new InvalidCalendarAttributeException("Selected date selection mode is not `fixed_range` for `date_selection_mode` attribute in layout.");
        }
        if (value < 0 || value > 365) {
            throw new InvalidCalendarAttributeException("Fixed days can be between 0 to 365.");
        }
        this.fixedDaysSelectionNumber = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.DateRangeMonthView, 0, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026DateRangeMonthView, 0, 0)");
            TypedArray ta = typedArray;
            try {
                this.setHeaderBg(ta.getDrawable(R.styleable.DateRangeMonthView_header_bg));
                this.weekColor = ta.getColor(R.styleable.DateRangeMonthView_week_color, this.getWeekColor());
                this.rangeStripColor = ta.getColor(R.styleable.DateRangeMonthView_range_color, this.getRangeStripColor());
                this.selectedDateCircleColor = ta.getColor(R.styleable.DateRangeMonthView_selected_date_circle_color, this.getSelectedDateCircleColor());
                this.setEditable(ta.getBoolean(R.styleable.DateRangeMonthView_editable, true));
                this.textSizeWeek = ta.getDimension(R.styleable.DateRangeMonthView_text_size_week, this.getTextSizeWeek());
                this.textSizeDate = ta.getDimension(R.styleable.DateRangeMonthView_text_size_date, this.getTextSizeDate());
                this.selectedDateColor = ta.getColor(R.styleable.DateRangeMonthView_selected_date_color, this.getSelectedDateColor());
                this.defaultDateColor = ta.getColor(R.styleable.DateRangeMonthView_default_date_color, this.getDefaultDateColor());
                this.rangeDateColor = ta.getColor(R.styleable.DateRangeMonthView_range_date_color, this.getRangeDateColor());
                this.disableDateColor = ta.getColor(R.styleable.DateRangeMonthView_disable_date_color, this.getDisableDateColor());
                this.setWeekOffset(ta.getColor(R.styleable.DateRangeMonthView_week_offset, 0));
                this.setDateSelectionMode(LPICalendarStyleAttributes.DateSelectionMode.values()[ta.getInt(R.styleable.DateRangeMonthView_date_selection_mode, 0)]);
            }
            finally {
                ta.recycle();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/lpdatepicker/calendar/models/LPCalendarStyleAttrImpl$Companion;", "", "()V", "getDefAttributes", "Lcom/liveperson/lpdatepicker/calendar/models/LPCalendarStyleAttrImpl;", "context", "Landroid/content/Context;", "datepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LPCalendarStyleAttrImpl getDefAttributes(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            LPCalendarStyleAttrImpl calendarStyleAttr = new LPCalendarStyleAttrImpl(context, null, 2, null);
            calendarStyleAttr.textSizeWeek = context.getResources().getDimension(R.dimen.text_size_week);
            calendarStyleAttr.textSizeDate = context.getResources().getDimension(R.dimen.text_size_date);
            calendarStyleAttr.weekColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_weekday_title_color);
            calendarStyleAttr.rangeStripColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_range_bg_color);
            calendarStyleAttr.selectedDateCircleColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_selected_date_circle_color);
            calendarStyleAttr.selectedDateColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_selected_date_color);
            calendarStyleAttr.defaultDateColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_default_date_color);
            calendarStyleAttr.rangeDateColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_ranged_date_color);
            calendarStyleAttr.disableDateColor = ContextCompat.getColor((Context)context, (int)R.color.lp_datepicker_disable_date_color);
            return calendarStyleAttr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

