/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker.calendar.views;

import com.liveperson.lpdatepicker.calendar.models.LPICalendarStyleAttributes;
import com.liveperson.lpdatepicker.calendar.views.DateTiming;
import com.liveperson.lpdatepicker.calendar.views.LPCalendarRangeUtilsKt;
import com.liveperson.lpdatepicker.calendar.views.LPICalendarDateRangeManager;
import com.liveperson.lpdatepicker.calendar.views.LPIDateView;
import com.liveperson.lpdatepicker.calendar.views.LPInvalidDateException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0016J\u001a\u0010$\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0016J\u001a\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/liveperson/lpdatepicker/calendar/views/LPCalendarDateRangeManagerImpl;", "Lcom/liveperson/lpdatepicker/calendar/views/LPICalendarDateRangeManager;", "startMonthDate", "Ljava/util/Calendar;", "endMonthDate", "calendarStyleAttributes", "Lcom/liveperson/lpdatepicker/calendar/models/LPICalendarStyleAttributes;", "(Ljava/util/Calendar;Ljava/util/Calendar;Lcom/liveperson/lpdatepicker/calendar/models/LPICalendarStyleAttributes;)V", "mEndSelectableDate", "mEndVisibleMonth", "mMaxSelectedDate", "mMinSelectedDate", "mStartSelectableDate", "mStartVisibleMonth", "mVisibleMonths", "", "checkDateRange", "Lcom/liveperson/lpdatepicker/calendar/views/LPICalendarDateRangeManager$DateSelectionState;", "selectedDate", "getEndVisibleMonth", "getMaxSelectedDate", "getMinSelectedDate", "getMonthIndex", "", "month", "getStartVisibleMonth", "getVisibleMonthDataList", "", "isSelectableDate", "", "date", "resetSelectedDateRange", "", "setSelectableDateRange", "startDate", "endDate", "setSelectedDateRange", "setVisibleMonths", "startMonth", "endMonth", "validateDatesOrder", "start", "end", "Companion", "datepicker_release"})
public final class LPCalendarDateRangeManagerImpl
implements LPICalendarDateRangeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LPICalendarStyleAttributes calendarStyleAttributes;
    private Calendar mStartVisibleMonth;
    private Calendar mEndVisibleMonth;
    private Calendar mStartSelectableDate;
    private Calendar mEndSelectableDate;
    @Nullable
    private Calendar mMinSelectedDate;
    @Nullable
    private Calendar mMaxSelectedDate;
    @NotNull
    private final List<Calendar> mVisibleMonths;
    @NotNull
    private static final String TAG = "CDRManagerImpl";

    public LPCalendarDateRangeManagerImpl(@NotNull Calendar startMonthDate, @NotNull Calendar endMonthDate, @NotNull LPICalendarStyleAttributes calendarStyleAttributes) {
        Intrinsics.checkNotNullParameter((Object)startMonthDate, (String)"startMonthDate");
        Intrinsics.checkNotNullParameter((Object)endMonthDate, (String)"endMonthDate");
        Intrinsics.checkNotNullParameter((Object)calendarStyleAttributes, (String)"calendarStyleAttributes");
        this.calendarStyleAttributes = calendarStyleAttributes;
        this.mVisibleMonths = new ArrayList();
        this.setVisibleMonths(startMonthDate, endMonthDate);
    }

    @Override
    @Nullable
    public Calendar getMaxSelectedDate() {
        return this.mMaxSelectedDate;
    }

    @Override
    @Nullable
    public Calendar getMinSelectedDate() {
        return this.mMinSelectedDate;
    }

    @Override
    @NotNull
    public List<Calendar> getVisibleMonthDataList() {
        return this.mVisibleMonths;
    }

    @Override
    public int getMonthIndex(@NotNull Calendar month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        int n = this.mVisibleMonths.size();
        for (int i = 0; i < n; ++i) {
            Calendar item = this.mVisibleMonths.get(i);
            if (month.get(1) != item.get(1) || month.get(2) != item.get(2)) continue;
            return i;
        }
        throw new RuntimeException("Month(" + month.getTime() + ") is not available in the given month range.");
    }

    @Override
    public void setVisibleMonths(@NotNull Calendar startMonth, @NotNull Calendar endMonth) {
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)endMonth, (String)"endMonth");
        this.validateDatesOrder(startMonth, endMonth);
        Object object = startMonth.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
        Calendar startMonthDate = (Calendar)object;
        Object object2 = endMonth.clone();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.Calendar");
        Calendar endMonthDate = (Calendar)object2;
        startMonthDate.set(5, 1);
        LPCalendarRangeUtilsKt.resetTime(startMonthDate, DateTiming.START);
        endMonthDate.set(5, endMonthDate.getActualMaximum(5));
        LPCalendarRangeUtilsKt.resetTime(endMonthDate, DateTiming.END);
        Object object3 = startMonthDate.clone();
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.util.Calendar");
        this.mStartVisibleMonth = (Calendar)object3;
        Calendar calendar2 = this.mStartVisibleMonth;
        if (calendar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartVisibleMonth");
            calendar2 = null;
        }
        LPCalendarRangeUtilsKt.resetTime(calendar2, DateTiming.START);
        Object object4 = endMonthDate.clone();
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type java.util.Calendar");
        this.mEndVisibleMonth = (Calendar)object4;
        Calendar calendar3 = this.mEndVisibleMonth;
        if (calendar3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mEndVisibleMonth");
            calendar3 = null;
        }
        LPCalendarRangeUtilsKt.resetTime(calendar3, DateTiming.END);
        this.mVisibleMonths.clear();
        Calendar calendar4 = this.mStartVisibleMonth;
        if (calendar4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartVisibleMonth");
            calendar4 = null;
        }
        Object object5 = calendar4.clone();
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type java.util.Calendar");
        Calendar temp = (Calendar)object5;
        while (true) {
            Calendar calendar5;
            if ((calendar5 = this.mEndVisibleMonth) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mEndVisibleMonth");
                calendar5 = null;
            }
            if (LPCalendarRangeUtilsKt.isMonthSame(temp, calendar5)) break;
            Object object6 = temp.clone();
            Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type java.util.Calendar");
            this.mVisibleMonths.add((Calendar)object6);
            temp.add(2, 1);
        }
        Object object7 = temp.clone();
        Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type java.util.Calendar");
        this.mVisibleMonths.add((Calendar)object7);
        Calendar calendar6 = this.mStartVisibleMonth;
        if (calendar6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartVisibleMonth");
            calendar6 = null;
        }
        if ((calendar = this.mEndVisibleMonth) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mEndVisibleMonth");
            calendar = null;
        }
        this.setSelectableDateRange(calendar6, calendar);
    }

    @Override
    @NotNull
    public Calendar getStartVisibleMonth() {
        Calendar calendar = this.mStartVisibleMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartVisibleMonth");
            calendar = null;
        }
        return calendar;
    }

    @Override
    @NotNull
    public Calendar getEndVisibleMonth() {
        Calendar calendar = this.mEndVisibleMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mEndVisibleMonth");
            calendar = null;
        }
        return calendar;
    }

    @Override
    public void setSelectableDateRange(@NotNull Calendar startDate, @NotNull Calendar endDate) {
        Calendar calendar;
        Calendar calendar2;
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        this.validateDatesOrder(startDate, endDate);
        Object object = startDate.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
        this.mStartSelectableDate = (Calendar)object;
        Calendar calendar3 = this.mStartSelectableDate;
        if (calendar3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartSelectableDate");
            calendar3 = null;
        }
        LPCalendarRangeUtilsKt.resetTime(calendar3, DateTiming.START);
        Object object2 = endDate.clone();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.Calendar");
        this.mEndSelectableDate = (Calendar)object2;
        Calendar calendar4 = this.mEndSelectableDate;
        if (calendar4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mEndSelectableDate");
            calendar4 = null;
        }
        LPCalendarRangeUtilsKt.resetTime(calendar4, DateTiming.END);
        Calendar calendar5 = this.mStartSelectableDate;
        if (calendar5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartSelectableDate");
            calendar5 = null;
        }
        if ((calendar2 = this.mStartVisibleMonth) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartVisibleMonth");
            calendar2 = null;
        }
        if (calendar5.before(calendar2)) {
            StringBuilder stringBuilder = new StringBuilder().append("Selectable start date ").append(LPCalendarRangeUtilsKt.printDate(startDate)).append(" is out of visible months(");
            Calendar calendar6 = this.mStartVisibleMonth;
            if (calendar6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mStartVisibleMonth");
                calendar6 = null;
            }
            StringBuilder stringBuilder2 = stringBuilder.append(LPCalendarRangeUtilsKt.printDate(calendar6)).append(" - ");
            Calendar calendar7 = this.mEndVisibleMonth;
            if (calendar7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mEndVisibleMonth");
                calendar7 = null;
            }
            throw new LPInvalidDateException(stringBuilder2.append(LPCalendarRangeUtilsKt.printDate(calendar7)).append(").").toString());
        }
        Calendar calendar8 = this.mEndSelectableDate;
        if (calendar8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mEndSelectableDate");
            calendar8 = null;
        }
        if ((calendar = this.mEndVisibleMonth) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mEndVisibleMonth");
            calendar = null;
        }
        if (calendar8.after(calendar)) {
            StringBuilder stringBuilder = new StringBuilder().append("Selectable end date ").append(LPCalendarRangeUtilsKt.printDate(endDate)).append(" is out of visible months(");
            Calendar calendar9 = this.mStartVisibleMonth;
            if (calendar9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mStartVisibleMonth");
                calendar9 = null;
            }
            StringBuilder stringBuilder3 = stringBuilder.append(LPCalendarRangeUtilsKt.printDate(calendar9)).append(" - ");
            Calendar calendar10 = this.mEndVisibleMonth;
            if (calendar10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mEndVisibleMonth");
                calendar10 = null;
            }
            throw new LPInvalidDateException(stringBuilder3.append(LPCalendarRangeUtilsKt.printDate(calendar10)).append(").").toString());
        }
        this.resetSelectedDateRange();
    }

    @Override
    public void resetSelectedDateRange() {
        this.mMinSelectedDate = null;
        this.mMaxSelectedDate = null;
    }

    @Override
    public void setSelectedDateRange(@NotNull Calendar startDate, @Nullable Calendar endDate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        this.validateDatesOrder(startDate, endDate);
        Calendar calendar = this.mStartSelectableDate;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartSelectableDate");
            calendar = null;
        }
        if (startDate.before(calendar)) {
            throw new LPInvalidDateException("Start date(" + LPCalendarRangeUtilsKt.printDate(startDate) + ") is out of selectable date range.");
        }
        Calendar calendar2 = endDate;
        if (calendar2 != null) {
            Calendar calendar3 = this.mEndSelectableDate;
            if (calendar3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mEndSelectableDate");
                calendar3 = null;
            }
            bl = calendar2.after(calendar3);
        } else {
            bl = false;
        }
        if (bl) {
            throw new LPInvalidDateException("End date(" + LPCalendarRangeUtilsKt.printDate(endDate) + ") is out of selectable date range.");
        }
        LPICalendarStyleAttributes.DateSelectionMode selectionMode = this.calendarStyleAttributes.getDateSelectionMode();
        Calendar finalEndDate = null;
        switch (WhenMappings.$EnumSwitchMapping$0[selectionMode.ordinal()]) {
            case 1: {
                Object object = startDate.clone();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
                finalEndDate = (Calendar)object;
                break;
            }
            case 2: {
                Object object = startDate.clone();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
                finalEndDate = (Calendar)object;
                finalEndDate.add(5, this.calendarStyleAttributes.getFixedDaysSelectionNumber());
                break;
            }
            case 3: {
                finalEndDate = endDate;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object object = startDate.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
        this.mMinSelectedDate = (Calendar)object;
        Calendar calendar4 = finalEndDate;
        this.mMaxSelectedDate = (Calendar)(calendar4 != null ? calendar4.clone() : null);
    }

    @Override
    @NotNull
    public LPICalendarDateRangeManager.DateSelectionState checkDateRange(@NotNull Calendar selectedDate) {
        Intrinsics.checkNotNullParameter((Object)selectedDate, (String)"selectedDate");
        if (this.mMinSelectedDate != null && this.mMaxSelectedDate != null) {
            long selectedDateVal = LPIDateView.Companion.getContainerKey(selectedDate);
            Calendar calendar = this.mMinSelectedDate;
            Intrinsics.checkNotNull((Object)calendar);
            long minDateVal = LPIDateView.Companion.getContainerKey(calendar);
            Calendar calendar2 = this.mMaxSelectedDate;
            Intrinsics.checkNotNull((Object)calendar2);
            long maxDateVal = LPIDateView.Companion.getContainerKey(calendar2);
            Calendar calendar3 = this.mMinSelectedDate;
            Intrinsics.checkNotNull((Object)calendar3);
            if (LPCalendarRangeUtilsKt.isDateSame(selectedDate, calendar3)) {
                Calendar calendar4 = this.mMaxSelectedDate;
                Intrinsics.checkNotNull((Object)calendar4);
                if (LPCalendarRangeUtilsKt.isDateSame(selectedDate, calendar4)) {
                    return LPICalendarDateRangeManager.DateSelectionState.START_END_SAME;
                }
            }
            Calendar calendar5 = this.mMinSelectedDate;
            Intrinsics.checkNotNull((Object)calendar5);
            if (LPCalendarRangeUtilsKt.isDateSame(selectedDate, calendar5)) {
                return LPICalendarDateRangeManager.DateSelectionState.START_DATE;
            }
            Calendar calendar6 = this.mMaxSelectedDate;
            Intrinsics.checkNotNull((Object)calendar6);
            if (LPCalendarRangeUtilsKt.isDateSame(selectedDate, calendar6)) {
                return LPICalendarDateRangeManager.DateSelectionState.LAST_DATE;
            }
            boolean bl = minDateVal <= selectedDateVal ? selectedDateVal < maxDateVal : false;
            if (bl) {
                return LPICalendarDateRangeManager.DateSelectionState.IN_SELECTED_RANGE;
            }
        } else if (this.mMinSelectedDate != null) {
            Calendar calendar = this.mMinSelectedDate;
            Intrinsics.checkNotNull((Object)calendar);
            if (LPCalendarRangeUtilsKt.isDateSame(selectedDate, calendar)) {
                return LPICalendarDateRangeManager.DateSelectionState.START_END_SAME;
            }
        }
        return LPICalendarDateRangeManager.DateSelectionState.UNKNOWN;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isSelectableDate(@NotNull Calendar date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        v0 = this.mStartSelectableDate;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartSelectableDate");
            v0 = null;
        }
        if (date.before(v0)) ** GOTO lbl-1000
        v1 = this.mEndSelectableDate;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mEndSelectableDate");
            v1 = null;
        }
        if (!date.after(v1)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = isSelectable = false;
        }
        if (isSelectable || this.checkDateRange(date) == LPICalendarDateRangeManager.DateSelectionState.UNKNOWN) {
            "Selected date can not be out of Selectable Date range. Date: " + LPCalendarRangeUtilsKt.printDate(date) + " Min: " + LPCalendarRangeUtilsKt.printDate(this.mMinSelectedDate) + " Max: " + LPCalendarRangeUtilsKt.printDate(this.mMaxSelectedDate);
        }
        return isSelectable;
    }

    private final void validateDatesOrder(Calendar start, Calendar end) {
        if (start.after(end)) {
            throw new LPInvalidDateException("Start date(" + LPCalendarRangeUtilsKt.printDate(start) + ") can not be after end date(" + LPCalendarRangeUtilsKt.printDate(end) + ").");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/lpdatepicker/calendar/views/LPCalendarDateRangeManagerImpl$Companion;", "", "()V", "TAG", "", "datepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LPICalendarStyleAttributes.DateSelectionMode.values().length];
            try {
                nArray[LPICalendarStyleAttributes.DateSelectionMode.SINGLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPICalendarStyleAttributes.DateSelectionMode.FIXED_RANGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPICalendarStyleAttributes.DateSelectionMode.FREE_RANGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

