/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker.calendar.views;

import com.liveperson.lpdatepicker.calendar.views.DateTiming;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"isDateSame", "", "one", "Ljava/util/Calendar;", "second", "isMonthSame", "printDate", "", "calendar", "resetTime", "", "date", "dateTiming", "Lcom/liveperson/lpdatepicker/calendar/views/DateTiming;", "datepicker_release"})
public final class LPCalendarRangeUtilsKt {
    public static final void resetTime(@NotNull Calendar date, @NotNull DateTiming dateTiming) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTiming), (String)"dateTiming");
        switch (WhenMappings.$EnumSwitchMapping$0[dateTiming.ordinal()]) {
            case 1: {
                date.set(11, 0);
                date.set(12, 0);
                date.set(13, 0);
                date.set(14, 0);
                break;
            }
            case 2: {
                date.set(11, 23);
                date.set(12, 59);
                date.set(13, 59);
                date.set(14, 999);
                break;
            }
            default: {
                date.set(11, 0);
                date.set(12, 0);
                date.set(13, 0);
                date.set(14, 0);
            }
        }
    }

    @NotNull
    public static final String printDate(@Nullable Calendar calendar) {
        if (calendar != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm", Locale.getDefault());
            String string2 = simpleDateFormat.format(calendar.getTime());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"simpleDateFormat.format(calendar.time)");
            return string2;
        }
        return "null";
    }

    public static final boolean isMonthSame(@NotNull Calendar one, @NotNull Calendar second) {
        Intrinsics.checkNotNullParameter((Object)one, (String)"one");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return one.get(1) == second.get(1) && one.get(2) == second.get(2);
    }

    public static final boolean isDateSame(@NotNull Calendar one, @NotNull Calendar second) {
        Intrinsics.checkNotNullParameter((Object)one, (String)"one");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return LPCalendarRangeUtilsKt.isMonthSame(one, second) && one.get(5) == second.get(5);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DateTiming.values().length];
            try {
                nArray[DateTiming.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateTiming.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

