/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker.calendar.views;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.liveperson.lpdatepicker.R;
import com.liveperson.lpdatepicker.calendar.models.LPCalendarStyleAttrImpl;
import com.liveperson.lpdatepicker.calendar.models.LPICalendarStyleAttributes;
import com.liveperson.lpdatepicker.calendar.views.LPIDateView;
import com.liveperson.lpdatepicker.utils.CalendarUtilsKt;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0002J\b\u00107\u001a\u000205H\u0002J\b\u00108\u001a\u000205H\u0002J\u0010\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020\u001dH\u0002J\b\u0010;\u001a\u000205H\u0016J\u000e\u0010<\u001a\u0002052\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u0002052\u0006\u0010@\u001a\u00020!H\u0016J\u0010\u0010A\u001a\u0002052\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u0002052\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u0002052\u0006\u0010E\u001a\u00020>H\u0016J\b\u0010H\u001a\u000205H\u0002J\b\u0010I\u001a\u000205H\u0002J\u0010\u0010J\u001a\u0002052\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u0002052\u0006\u0010N\u001a\u00020\u001dH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u0016R\u001a\u0010%\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010\u0016R\u001a\u0010(\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010\u0016R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0014\"\u0004\b1\u0010\u0016R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/liveperson/lpdatepicker/calendar/views/LPCustomDateView;", "Landroid/widget/FrameLayout;", "Lcom/liveperson/lpdatepicker/calendar/views/LPIDateView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dateTextSize", "", "getDateTextSize", "()F", "setDateTextSize", "(F)V", "defCalendarStyleAttr", "Lcom/liveperson/lpdatepicker/calendar/models/LPCalendarStyleAttrImpl;", "defaultDateColor", "getDefaultDateColor", "()I", "setDefaultDateColor", "(I)V", "disableDateColor", "getDisableDateColor", "setDisableDateColor", "isRightToLeft", "", "mDateState", "Lcom/liveperson/lpdatepicker/calendar/views/LPIDateView$DateState;", "mViewClickListener", "Landroid/view/View$OnClickListener;", "onDateClickListener", "Lcom/liveperson/lpdatepicker/calendar/views/LPIDateView$OnDateClickListener;", "rangeDateColor", "getRangeDateColor", "setRangeDateColor", "selectedDateCircleColor", "getSelectedDateCircleColor", "setSelectedDateCircleColor", "selectedDateColor", "getSelectedDateColor", "setSelectedDateColor", "simpleDateFormat", "Ljava/text/SimpleDateFormat;", "strip", "Landroid/view/View;", "stripColor", "getStripColor", "setStripColor", "tvDate", "Landroidx/appcompat/widget/AppCompatTextView;", "disableDayContainer", "", "enabledDayContainer", "hideDayContainer", "makeAsRangeDate", "makeAsSelectedDate", "state", "refreshLayout", "setContentDescription", "description", "", "setDateClickListener", "listener", "setDateStyleAttributes", "attr", "Lcom/liveperson/lpdatepicker/calendar/models/LPICalendarStyleAttributes;", "setDateTag", "date", "Ljava/util/Calendar;", "setDateText", "setLeftFacedSelectedDate", "setRightFacedSelectedDate", "setTypeface", "typeface", "Landroid/graphics/Typeface;", "updateDateBackground", "dateState", "datepicker_release"})
public final class LPCustomDateView
extends FrameLayout
implements LPIDateView {
    @NotNull
    private final AppCompatTextView tvDate;
    @NotNull
    private final View strip;
    @NotNull
    private final SimpleDateFormat simpleDateFormat;
    @Nullable
    private LPIDateView.OnDateClickListener onDateClickListener;
    @NotNull
    private LPIDateView.DateState mDateState;
    private final boolean isRightToLeft;
    @NotNull
    private final LPCalendarStyleAttrImpl defCalendarStyleAttr;
    private float dateTextSize;
    private int defaultDateColor;
    private int disableDateColor;
    private int selectedDateCircleColor;
    private int selectedDateColor;
    private int rangeDateColor;
    private int stripColor;
    @NotNull
    private final View.OnClickListener mViewClickListener;

    @JvmOverloads
    public LPCustomDateView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm", CalendarUtilsKt.getLocale(context));
        this.isRightToLeft = this.getResources().getBoolean(R.bool.lp_datepicker_is_right_to_left);
        Object object = context.getSystemService("layout_inflater");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.LayoutInflater");
        LayoutInflater inflater = (LayoutInflater)object;
        inflater.inflate(R.layout.lp_layout_calendar_day, (ViewGroup)this, true);
        View view = this.findViewById(R.id.dayOfMonthText);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.dayOfMonthText)");
        this.tvDate = (AppCompatTextView)view;
        View view2 = this.findViewById(R.id.viewStrip);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.viewStrip)");
        this.strip = view2;
        this.mDateState = LPIDateView.DateState.SELECTABLE;
        if (!this.isInEditMode()) {
            this.setDateStyleAttributes(LPCalendarStyleAttrImpl.Companion.getDefAttributes(context));
            this.updateDateBackground(this.mDateState);
        }
        this.defCalendarStyleAttr = LPCalendarStyleAttrImpl.Companion.getDefAttributes(context);
        this.dateTextSize = this.defCalendarStyleAttr.getTextSizeDate();
        this.defaultDateColor = this.defCalendarStyleAttr.getDefaultDateColor();
        this.disableDateColor = this.defCalendarStyleAttr.getDisableDateColor();
        this.selectedDateCircleColor = this.defCalendarStyleAttr.getSelectedDateCircleColor();
        this.selectedDateColor = this.defCalendarStyleAttr.getSelectedDateColor();
        this.rangeDateColor = this.defCalendarStyleAttr.getRangeDateColor();
        this.stripColor = this.defCalendarStyleAttr.getRangeStripColor();
        this.mViewClickListener = arg_0 -> LPCustomDateView.mViewClickListener$lambda$0(this, arg_0);
    }

    public /* synthetic */ LPCustomDateView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Override
    public float getDateTextSize() {
        return this.dateTextSize;
    }

    @Override
    public void setDateTextSize(float f) {
        this.dateTextSize = f;
    }

    @Override
    public int getDefaultDateColor() {
        return this.defaultDateColor;
    }

    @Override
    public void setDefaultDateColor(int n) {
        this.defaultDateColor = n;
    }

    @Override
    public int getDisableDateColor() {
        return this.disableDateColor;
    }

    @Override
    public void setDisableDateColor(int n) {
        this.disableDateColor = n;
    }

    @Override
    public int getSelectedDateCircleColor() {
        return this.selectedDateCircleColor;
    }

    @Override
    public void setSelectedDateCircleColor(int n) {
        this.selectedDateCircleColor = n;
    }

    @Override
    public int getSelectedDateColor() {
        return this.selectedDateColor;
    }

    @Override
    public void setSelectedDateColor(int n) {
        this.selectedDateColor = n;
    }

    @Override
    public int getRangeDateColor() {
        return this.rangeDateColor;
    }

    @Override
    public void setRangeDateColor(int n) {
        this.rangeDateColor = n;
    }

    @Override
    public int getStripColor() {
        return this.stripColor;
    }

    @Override
    public void setStripColor(int n) {
        this.stripColor = n;
    }

    @Override
    public void setDateText(@NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.tvDate.setText((CharSequence)date);
    }

    public final void setContentDescription(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.tvDate.setContentDescription((CharSequence)description);
    }

    @Override
    public void setDateStyleAttributes(@NotNull LPICalendarStyleAttributes attr2) {
        Intrinsics.checkNotNullParameter((Object)attr2, (String)"attr");
        this.setDisableDateColor(attr2.getDisableDateColor());
        this.setDefaultDateColor(attr2.getDefaultDateColor());
        this.setSelectedDateCircleColor(attr2.getSelectedDateCircleColor());
        this.setSelectedDateColor(attr2.getSelectedDateColor());
        this.setStripColor(attr2.getRangeStripColor());
        this.setRangeDateColor(attr2.getRangeDateColor());
        this.tvDate.setTextSize(attr2.getTextSizeDate());
        this.refreshLayout();
    }

    @Override
    public void setTypeface(@NotNull Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        this.tvDate.setTypeface(typeface);
    }

    @Override
    public void setDateTag(@NotNull Calendar date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.setTag(LPIDateView.Companion.getContainerKey(date));
    }

    @Override
    public void updateDateBackground(@NotNull LPIDateView.DateState dateState) {
        Intrinsics.checkNotNullParameter((Object)((Object)dateState), (String)"dateState");
        this.mDateState = dateState;
        switch (WhenMappings.$EnumSwitchMapping$0[dateState.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.makeAsSelectedDate(dateState);
                break;
            }
            case 4: {
                this.hideDayContainer();
                break;
            }
            case 5: {
                this.enabledDayContainer();
                break;
            }
            case 6: {
                this.disableDayContainer();
                break;
            }
            case 7: {
                this.makeAsRangeDate();
            }
        }
    }

    @Override
    public void refreshLayout() {
        this.tvDate.setTextSize(0, this.getDateTextSize());
    }

    @Override
    public void setDateClickListener(@NotNull LPIDateView.OnDateClickListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.onDateClickListener = listener2;
    }

    private final void hideDayContainer() {
        this.tvDate.setText((CharSequence)"");
        this.tvDate.setBackgroundColor(0);
        this.strip.setBackgroundColor(0);
        this.setBackgroundColor(0);
        this.setVisibility(4);
        this.setOnClickListener(null);
    }

    private final void disableDayContainer() {
        this.tvDate.setBackgroundColor(0);
        this.strip.setBackgroundColor(0);
        this.setBackgroundColor(0);
        this.tvDate.setTextColor(this.getDisableDateColor());
        this.setVisibility(0);
        this.setOnClickListener(null);
    }

    private final void enabledDayContainer() {
        this.tvDate.setBackgroundColor(0);
        this.strip.setBackgroundColor(0);
        this.setBackgroundColor(0);
        this.tvDate.setTextColor(this.getDefaultDateColor());
        this.setVisibility(0);
        this.setOnClickListener(this.mViewClickListener);
    }

    private final void makeAsSelectedDate(LPIDateView.DateState state) {
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 3: {
                ViewGroup.LayoutParams layoutParams = this.strip.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
                this.strip.setBackgroundColor(0);
                layoutParams2.setMargins(0, 0, 0, 0);
                this.strip.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                break;
            }
            case 1: {
                if (this.isRightToLeft) {
                    this.setRightFacedSelectedDate();
                    break;
                }
                this.setLeftFacedSelectedDate();
                break;
            }
            case 2: {
                if (this.isRightToLeft) {
                    this.setLeftFacedSelectedDate();
                    break;
                }
                this.setRightFacedSelectedDate();
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)state) + " is an invalid state.");
            }
        }
        Drawable mDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.lp_selected_date_bg);
        this.tvDate.setBackground(mDrawable);
        this.setBackgroundColor(0);
        this.tvDate.setTextColor(this.getSelectedDateColor());
        this.setVisibility(0);
        this.setOnClickListener(this.mViewClickListener);
    }

    private final void setLeftFacedSelectedDate() {
        ViewGroup.LayoutParams layoutParams = this.strip.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.lp_range_bg_left);
        this.strip.setBackground(drawable2);
        layoutParams2.setMargins(70, 0, 0, 0);
        this.strip.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
    }

    private final void setRightFacedSelectedDate() {
        ViewGroup.LayoutParams layoutParams = this.strip.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.lp_range_bg_right);
        this.strip.setBackground(drawable2);
        layoutParams2.setMargins(0, 0, 70, 0);
        this.strip.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
    }

    private final void makeAsRangeDate() {
        this.tvDate.setBackgroundColor(0);
        Drawable mDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.lp_range_bg);
        this.strip.setBackground(mDrawable);
        this.setBackgroundColor(0);
        this.tvDate.setTextColor(this.getRangeDateColor());
        this.setVisibility(0);
        ViewGroup.LayoutParams layoutParams = this.strip.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
        layoutParams2.setMargins(0, 0, 0, 0);
        this.strip.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.setOnClickListener(this.mViewClickListener);
    }

    @JvmOverloads
    public LPCustomDateView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public LPCustomDateView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void mViewClickListener$lambda$0(LPCustomDateView this$0, View it) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Object object = it.getTag();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            long key = (Long)object;
            if (this$0.onDateClickListener == null) break block3;
            Calendar selectedCal = Calendar.getInstance();
            Date date = new Date();
            try {
                Date date2 = this$0.simpleDateFormat.parse(String.valueOf(key));
                Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"simpleDateFormat.parse(key.toString())");
                date = date2;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            selectedCal.setTime(date);
            LPIDateView.OnDateClickListener onDateClickListener = this$0.onDateClickListener;
            if (onDateClickListener != null) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)selectedCal, (String)"selectedCal");
                onDateClickListener.onDateClicked(it, selectedCal);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LPIDateView.DateState.values().length];
            try {
                nArray[LPIDateView.DateState.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPIDateView.DateState.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPIDateView.DateState.START_END_SAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPIDateView.DateState.HIDDEN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPIDateView.DateState.SELECTABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPIDateView.DateState.DISABLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPIDateView.DateState.MIDDLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

