/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker.calendar.views;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.appcompat.widget.AppCompatTextView;
import com.liveperson.lpdatepicker.R;
import com.liveperson.lpdatepicker.calendar.models.LPICalendarStyleAttributes;
import com.liveperson.lpdatepicker.calendar.views.DateTiming;
import com.liveperson.lpdatepicker.calendar.views.LPCalendarRangeUtilsKt;
import com.liveperson.lpdatepicker.calendar.views.LPCustomDateView;
import com.liveperson.lpdatepicker.calendar.views.LPICalendarDateRangeManager;
import com.liveperson.lpdatepicker.calendar.views.LPICalendarListener;
import com.liveperson.lpdatepicker.calendar.views.LPIDateView;
import com.liveperson.lpdatepicker.utils.AccessibilityUtilsKt;
import com.liveperson.lpdatepicker.utils.CalendarUtilsKt;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J \u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010$\u001a\u00020\u001aJ\u0010\u0010%\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010&\u001a\u00020\u001aH\u0002J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020\u001aH\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/liveperson/lpdatepicker/calendar/views/LPDateRangeMonthView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "calendarListener", "Lcom/liveperson/lpdatepicker/calendar/views/LPICalendarListener;", "calendarStyleAttr", "Lcom/liveperson/lpdatepicker/calendar/models/LPICalendarStyleAttributes;", "currentCalendarMonth", "Ljava/util/Calendar;", "dateRangeCalendarManager", "Lcom/liveperson/lpdatepicker/calendar/views/LPICalendarDateRangeManager;", "llDaysContainer", "llTitleWeekContainer", "mOnDateClickListener", "Lcom/liveperson/lpdatepicker/calendar/views/LPIDateView$OnDateClickListener;", "drawCalendarForMonth", "", "month", "drawDayContainer", "customDateView", "Lcom/liveperson/lpdatepicker/calendar/views/LPCustomDateView;", "date", "formatter", "Ljava/text/SimpleDateFormat;", "initView", "attributeSet", "resetAllSelectedViews", "setCalendarListener", "setListeners", "setSelectedDate", "selectedDate", "setWeekTextAttributes", "datepicker_release"})
@SourceDebugExtension(value={"SMAP\nLPDateRangeMonthView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LPDateRangeMonthView.kt\ncom/liveperson/lpdatepicker/calendar/views/LPDateRangeMonthView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class LPDateRangeMonthView
extends LinearLayout {
    private LinearLayout llDaysContainer;
    private LinearLayout llTitleWeekContainer;
    private Calendar currentCalendarMonth;
    private LPICalendarStyleAttributes calendarStyleAttr;
    @Nullable
    private LPICalendarListener calendarListener;
    private LPICalendarDateRangeManager dateRangeCalendarManager;
    @NotNull
    private final LPIDateView.OnDateClickListener mOnDateClickListener;

    public final void setCalendarListener(@Nullable LPICalendarListener calendarListener) {
        this.calendarListener = calendarListener;
    }

    public LPDateRangeMonthView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mOnDateClickListener = new LPIDateView.OnDateClickListener(this){
            final /* synthetic */ LPDateRangeMonthView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onDateClicked(@NotNull View view, @NotNull Calendar selectedDate) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)selectedDate, (String)"selectedDate");
                LPICalendarStyleAttributes lPICalendarStyleAttributes = LPDateRangeMonthView.access$getCalendarStyleAttr$p(this.this$0);
                if (lPICalendarStyleAttributes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
                    lPICalendarStyleAttributes = null;
                }
                if (lPICalendarStyleAttributes.isEditable()) {
                    LPDateRangeMonthView.access$setSelectedDate(this.this$0, selectedDate);
                }
            }
        };
        this.initView(context, null);
    }

    public LPDateRangeMonthView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mOnDateClickListener = new /* invalid duplicate definition of identical inner class */;
        this.initView(context, attrs);
    }

    public LPDateRangeMonthView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mOnDateClickListener = new /* invalid duplicate definition of identical inner class */;
        this.initView(context, attrs);
    }

    @TargetApi(value=21)
    public LPDateRangeMonthView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mOnDateClickListener = new /* invalid duplicate definition of identical inner class */;
        this.initView(context, attrs);
    }

    private final void initView(Context context, AttributeSet attributeSet) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        View view = layoutInflater.inflate(R.layout.lp_layout_calendar_month, (ViewGroup)this, true);
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.LinearLayout");
        LinearLayout mainView = (LinearLayout)view;
        View view2 = mainView.findViewById(R.id.llDaysContainer);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"mainView.findViewById(R.id.llDaysContainer)");
        this.llDaysContainer = (LinearLayout)view2;
        View view3 = mainView.findViewById(R.id.llTitleWeekContainer);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"mainView.findViewById(R.id.llTitleWeekContainer)");
        this.llTitleWeekContainer = (LinearLayout)view3;
        this.setListeners();
    }

    private final void setListeners() {
    }

    private final void setSelectedDate(Calendar selectedDate) {
        LPICalendarDateRangeManager lPICalendarDateRangeManager;
        LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
        if (lPICalendarStyleAttributes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
            lPICalendarStyleAttributes = null;
        }
        LPICalendarStyleAttributes.DateSelectionMode selectionMode = lPICalendarStyleAttributes.getDateSelectionMode();
        LPICalendarDateRangeManager lPICalendarDateRangeManager2 = this.dateRangeCalendarManager;
        if (lPICalendarDateRangeManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
            lPICalendarDateRangeManager2 = null;
        }
        Calendar minSelectedDate = lPICalendarDateRangeManager2.getMinSelectedDate();
        LPICalendarDateRangeManager lPICalendarDateRangeManager3 = this.dateRangeCalendarManager;
        if (lPICalendarDateRangeManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
            lPICalendarDateRangeManager3 = null;
        }
        Calendar maxSelectedDate = lPICalendarDateRangeManager3.getMaxSelectedDate();
        switch (WhenMappings.$EnumSwitchMapping$0[selectionMode.ordinal()]) {
            case 1: {
                if ((minSelectedDate == null || maxSelectedDate == null) && (Intrinsics.areEqual((Object)selectedDate, (Object)minSelectedDate) || Intrinsics.areEqual((Object)selectedDate, (Object)maxSelectedDate))) {
                    return;
                }
                if (minSelectedDate != null && maxSelectedDate == null) {
                    long lastDateKey;
                    maxSelectedDate = selectedDate;
                    long startDateKey = LPIDateView.Companion.getContainerKey(minSelectedDate);
                    if (startDateKey == (lastDateKey = LPIDateView.Companion.getContainerKey(maxSelectedDate))) {
                        minSelectedDate = maxSelectedDate;
                        break;
                    }
                    if (startDateKey <= lastDateKey) break;
                    Object object = minSelectedDate.clone();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
                    Calendar temp = (Calendar)object;
                    minSelectedDate = maxSelectedDate;
                    maxSelectedDate = temp;
                    break;
                }
                if (maxSelectedDate == null) {
                    minSelectedDate = selectedDate;
                    break;
                }
                minSelectedDate = selectedDate;
                maxSelectedDate = null;
                break;
            }
            case 2: {
                minSelectedDate = selectedDate;
                maxSelectedDate = selectedDate;
                break;
            }
            case 3: {
                minSelectedDate = selectedDate;
                Object object = selectedDate.clone();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
                maxSelectedDate = (Calendar)object;
                LPICalendarStyleAttributes lPICalendarStyleAttributes2 = this.calendarStyleAttr;
                if (lPICalendarStyleAttributes2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
                    lPICalendarStyleAttributes2 = null;
                }
                maxSelectedDate.add(5, lPICalendarStyleAttributes2.getFixedDaysSelectionNumber());
            }
        }
        if ((lPICalendarDateRangeManager = this.dateRangeCalendarManager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
            lPICalendarDateRangeManager = null;
        }
        lPICalendarDateRangeManager.setSelectedDateRange(minSelectedDate, maxSelectedDate);
        Calendar calendar = this.currentCalendarMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
            calendar = null;
        }
        this.drawCalendarForMonth(calendar);
        if (maxSelectedDate != null) {
            LPICalendarListener lPICalendarListener = this.calendarListener;
            Intrinsics.checkNotNull((Object)lPICalendarListener);
            lPICalendarListener.onDateRangeSelected(minSelectedDate, maxSelectedDate);
        } else {
            LPICalendarListener lPICalendarListener = this.calendarListener;
            Intrinsics.checkNotNull((Object)lPICalendarListener);
            lPICalendarListener.onFirstDateSelected(minSelectedDate);
        }
    }

    public final void drawCalendarForMonth(@NotNull LPICalendarStyleAttributes calendarStyleAttr, @NotNull Calendar month, @NotNull LPICalendarDateRangeManager dateRangeCalendarManager) {
        Intrinsics.checkNotNullParameter((Object)calendarStyleAttr, (String)"calendarStyleAttr");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)dateRangeCalendarManager, (String)"dateRangeCalendarManager");
        this.calendarStyleAttr = calendarStyleAttr;
        Object object = month.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
        this.currentCalendarMonth = (Calendar)object;
        this.dateRangeCalendarManager = dateRangeCalendarManager;
        Calendar calendar = this.currentCalendarMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
            calendar = null;
        }
        this.drawCalendarForMonth(calendar);
    }

    private final void drawCalendarForMonth(Calendar month) {
        int startDay;
        this.setWeekTextAttributes();
        Object object = month.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
        this.currentCalendarMonth = (Calendar)object;
        Calendar calendar = this.currentCalendarMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
            calendar = null;
        }
        calendar.set(5, 1);
        Calendar calendar2 = this.currentCalendarMonth;
        if (calendar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
            calendar2 = null;
        }
        LPCalendarRangeUtilsKt.resetTime(calendar2, DateTiming.NONE);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        List<String> weekTitle = CalendarUtilsKt.getDayOfWeekNameList(context);
        for (int i = 0; i < 7; ++i) {
            LinearLayout linearLayout = this.llTitleWeekContainer;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"llTitleWeekContainer");
                linearLayout = null;
            }
            View view = linearLayout.getChildAt(i);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type androidx.appcompat.widget.AppCompatTextView");
            AppCompatTextView textView = (AppCompatTextView)view;
            LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
            if (lPICalendarStyleAttributes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
                lPICalendarStyleAttributes = null;
            }
            int index = (i + lPICalendarStyleAttributes.getWeekOffset()) % 7;
            String weekStr = weekTitle.get(index);
            textView.setText((CharSequence)weekStr);
            textView.setImportantForAccessibility(2);
        }
        int n = month.get(7);
        LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
        if (lPICalendarStyleAttributes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
            lPICalendarStyleAttributes = null;
        }
        if ((startDay = n - lPICalendarStyleAttributes.getWeekOffset()) < 1) {
            startDay += 7;
        }
        month.add(5, -startDay + 1);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        SimpleDateFormat formatter = AccessibilityUtilsKt.createDayFormatter(CalendarUtilsKt.getLocale(context2));
        int i = 0;
        LinearLayout linearLayout = this.llDaysContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"llDaysContainer");
            linearLayout = null;
        }
        int n2 = linearLayout.getChildCount();
        while (i < n2) {
            LinearLayout linearLayout2 = this.llDaysContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"llDaysContainer");
                linearLayout2 = null;
            }
            View view = linearLayout2.getChildAt(i);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.LinearLayout");
            LinearLayout weekRow = (LinearLayout)view;
            for (int j = 0; j < 7; ++j) {
                View view2 = weekRow.getChildAt(j);
                Intrinsics.checkNotNull((Object)view2, (String)"null cannot be cast to non-null type com.liveperson.lpdatepicker.calendar.views.LPCustomDateView");
                LPCustomDateView customDateView = (LPCustomDateView)view2;
                this.drawDayContainer(customDateView, month, formatter);
                month.add(5, 1);
            }
            ++i;
        }
    }

    private final void drawDayContainer(LPCustomDateView customDateView, Calendar date, SimpleDateFormat formatter) {
        LPIDateView.DateState dateState;
        Calendar calendar;
        String formattedDate = formatter.format(date.getTime());
        customDateView.setDateText(String.valueOf(date.get(5)));
        LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
        if (lPICalendarStyleAttributes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
            lPICalendarStyleAttributes = null;
        }
        customDateView.setDateStyleAttributes(lPICalendarStyleAttributes);
        customDateView.setDateClickListener(this.mOnDateClickListener);
        LPICalendarStyleAttributes lPICalendarStyleAttributes2 = this.calendarStyleAttr;
        if (lPICalendarStyleAttributes2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
            lPICalendarStyleAttributes2 = null;
        }
        Typeface typeface = lPICalendarStyleAttributes2.getFonts();
        if (typeface != null) {
            Typeface it = typeface;
            boolean bl = false;
            customDateView.setTypeface(it);
        }
        if ((calendar = this.currentCalendarMonth) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
            calendar = null;
        }
        if (calendar.get(2) != date.get(2)) {
            dateState = LPIDateView.DateState.HIDDEN;
        } else {
            LPICalendarDateRangeManager.DateSelectionState type;
            LPICalendarDateRangeManager lPICalendarDateRangeManager = this.dateRangeCalendarManager;
            if (lPICalendarDateRangeManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
                lPICalendarDateRangeManager = null;
            }
            if ((type = lPICalendarDateRangeManager.checkDateRange(date)) == LPICalendarDateRangeManager.DateSelectionState.START_DATE) {
                dateState = LPIDateView.DateState.START;
            } else if (type == LPICalendarDateRangeManager.DateSelectionState.LAST_DATE) {
                dateState = LPIDateView.DateState.END;
            } else if (type == LPICalendarDateRangeManager.DateSelectionState.START_END_SAME) {
                dateState = LPIDateView.DateState.START_END_SAME;
            } else if (type == LPICalendarDateRangeManager.DateSelectionState.IN_SELECTED_RANGE) {
                dateState = LPIDateView.DateState.MIDDLE;
            } else {
                LPICalendarDateRangeManager lPICalendarDateRangeManager2 = this.dateRangeCalendarManager;
                if (lPICalendarDateRangeManager2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
                    lPICalendarDateRangeManager2 = null;
                }
                dateState = lPICalendarDateRangeManager2.isSelectableDate(date) ? LPIDateView.DateState.SELECTABLE : LPIDateView.DateState.DISABLE;
            }
        }
        LPIDateView.DateState dateState2 = dateState;
        customDateView.updateDateBackground(dateState2);
        customDateView.setTag(LPIDateView.Companion.getContainerKey(date));
        Intrinsics.checkNotNullExpressionValue((Object)formattedDate, (String)"formattedDate");
        customDateView.setContentDescription(formattedDate);
        AccessibilityUtilsKt.applyDateState(customDateView, dateState2);
    }

    public final void resetAllSelectedViews() {
        LPICalendarDateRangeManager lPICalendarDateRangeManager = this.dateRangeCalendarManager;
        if (lPICalendarDateRangeManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateRangeCalendarManager");
            lPICalendarDateRangeManager = null;
        }
        lPICalendarDateRangeManager.resetSelectedDateRange();
        Calendar calendar = this.currentCalendarMonth;
        if (calendar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentCalendarMonth");
            calendar = null;
        }
        this.drawCalendarForMonth(calendar);
    }

    private final void setWeekTextAttributes() {
        int i = 0;
        LinearLayout linearLayout = this.llTitleWeekContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"llTitleWeekContainer");
            linearLayout = null;
        }
        int n = linearLayout.getChildCount();
        while (i < n) {
            LinearLayout linearLayout2 = this.llTitleWeekContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"llTitleWeekContainer");
                linearLayout2 = null;
            }
            View view = linearLayout2.getChildAt(i);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type androidx.appcompat.widget.AppCompatTextView");
            AppCompatTextView textView = (AppCompatTextView)view;
            LPICalendarStyleAttributes lPICalendarStyleAttributes = this.calendarStyleAttr;
            if (lPICalendarStyleAttributes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
                lPICalendarStyleAttributes = null;
            }
            textView.setTypeface(lPICalendarStyleAttributes.getFonts());
            LPICalendarStyleAttributes lPICalendarStyleAttributes2 = this.calendarStyleAttr;
            if (lPICalendarStyleAttributes2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
                lPICalendarStyleAttributes2 = null;
            }
            textView.setTextSize(0, lPICalendarStyleAttributes2.getTextSizeWeek());
            LPICalendarStyleAttributes lPICalendarStyleAttributes3 = this.calendarStyleAttr;
            if (lPICalendarStyleAttributes3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarStyleAttr");
                lPICalendarStyleAttributes3 = null;
            }
            textView.setTextColor(lPICalendarStyleAttributes3.getWeekColor());
            ++i;
        }
    }

    public static final /* synthetic */ LPICalendarStyleAttributes access$getCalendarStyleAttr$p(LPDateRangeMonthView $this) {
        return $this.calendarStyleAttr;
    }

    public static final /* synthetic */ void access$setSelectedDate(LPDateRangeMonthView $this, Calendar selectedDate) {
        $this.setSelectedDate(selectedDate);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LPICalendarStyleAttributes.DateSelectionMode.values().length];
            try {
                nArray[LPICalendarStyleAttributes.DateSelectionMode.FREE_RANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPICalendarStyleAttributes.DateSelectionMode.SINGLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPICalendarStyleAttributes.DateSelectionMode.FIXED_RANGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

