/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker.callbacks;

import android.content.Context;
import androidx.constraintlayout.widget.ConstraintSet;
import com.liveperson.lpdatepicker.R;
import com.liveperson.lpdatepicker.calendar.views.LPICalendarListener;
import com.liveperson.lpdatepicker.databinding.FragmentDatePickerBinding;
import com.liveperson.lpdatepicker.model.DatePickerParams;
import com.liveperson.lpdatepicker.ui.CustomTextView;
import com.liveperson.lpdatepicker.utils.CalendarUtilsKt;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/liveperson/lpdatepicker/callbacks/LPICalendarListenerImpl;", "Lcom/liveperson/lpdatepicker/calendar/views/LPICalendarListener;", "binding", "Lcom/liveperson/lpdatepicker/databinding/FragmentDatePickerBinding;", "type", "Lcom/liveperson/lpdatepicker/model/DatePickerParams$Type;", "(Lcom/liveperson/lpdatepicker/databinding/FragmentDatePickerBinding;Lcom/liveperson/lpdatepicker/model/DatePickerParams$Type;)V", "onDateRangeSelected", "", "startDate", "Ljava/util/Calendar;", "endDate", "onFirstDateSelected", "datepicker_release"})
@SourceDebugExtension(value={"SMAP\nLPICalendarListenerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LPICalendarListenerImpl.kt\ncom/liveperson/lpdatepicker/callbacks/LPICalendarListenerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class LPICalendarListenerImpl
implements LPICalendarListener {
    @NotNull
    private final FragmentDatePickerBinding binding;
    @NotNull
    private final DatePickerParams.Type type;

    public LPICalendarListenerImpl(@NotNull FragmentDatePickerBinding binding, @NotNull DatePickerParams.Type type) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.binding = binding;
        this.type = type;
    }

    @Override
    public void onFirstDateSelected(@NotNull Calendar startDate) {
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
    }

    @Override
    public void onDateRangeSelected(@NotNull Calendar startDate, @NotNull Calendar endDate) {
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        FragmentDatePickerBinding $this$onDateRangeSelected_u24lambda_u241 = this.binding;
        boolean bl = false;
        Context context = this.binding.getRoot().getContext();
        String string2 = context.getString(R.string.lp_datepicker_date_text_format);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026epicker_date_text_format)");
        String dateFormat = string2;
        $this$onDateRangeSelected_u24lambda_u241.bottomWrapper.setVisibility(0);
        if (this.type == DatePickerParams.Type.RANGE) {
            $this$onDateRangeSelected_u24lambda_u241.tvEndDate.setVisibility(0);
            $this$onDateRangeSelected_u24lambda_u241.tvEndDayOfWeek.setVisibility(0);
            $this$onDateRangeSelected_u24lambda_u241.imgArrow.setVisibility(0);
            CustomTextView customTextView = $this$onDateRangeSelected_u24lambda_u241.tvStartDate;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            customTextView.setText(CalendarUtilsKt.getDateText(startDate, dateFormat, context));
            $this$onDateRangeSelected_u24lambda_u241.tvStartDayOfWeek.setText(CalendarUtilsKt.getDayOfWeek(startDate, context));
            Object[] objectArray = new Object[]{$this$onDateRangeSelected_u24lambda_u241.tvStartDate.getText(), $this$onDateRangeSelected_u24lambda_u241.tvStartDayOfWeek.getText()};
            $this$onDateRangeSelected_u24lambda_u241.startDateLayout.setContentDescription((CharSequence)context.getString(R.string.lp_datepicker_from, objectArray));
            $this$onDateRangeSelected_u24lambda_u241.tvEndDate.setText(CalendarUtilsKt.getDateText(endDate, dateFormat, context));
            $this$onDateRangeSelected_u24lambda_u241.tvEndDayOfWeek.setText(CalendarUtilsKt.getDayOfWeek(endDate, context));
            objectArray = new Object[]{$this$onDateRangeSelected_u24lambda_u241.tvEndDate.getText(), $this$onDateRangeSelected_u24lambda_u241.tvEndDayOfWeek.getText()};
            $this$onDateRangeSelected_u24lambda_u241.endDateLayout.setContentDescription((CharSequence)context.getString(R.string.lp_datepicker_to, objectArray));
            $this$onDateRangeSelected_u24lambda_u241.bottomWrapper.setContentDescription((CharSequence)("" + $this$onDateRangeSelected_u24lambda_u241.startDateLayout.getContentDescription() + ' ' + $this$onDateRangeSelected_u24lambda_u241.endDateLayout.getContentDescription()));
        } else {
            Object[] objectArray;
            $this$onDateRangeSelected_u24lambda_u241.tvStartDate.setGravity(1);
            $this$onDateRangeSelected_u24lambda_u241.tvStartDayOfWeek.setGravity(1);
            CustomTextView customTextView = $this$onDateRangeSelected_u24lambda_u241.tvStartDate;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            customTextView.setText(CalendarUtilsKt.getDateText(startDate, dateFormat, context));
            $this$onDateRangeSelected_u24lambda_u241.tvStartDayOfWeek.setText(CalendarUtilsKt.getDayOfWeek(startDate, context));
            Object[] $this$onDateRangeSelected_u24lambda_u241_u24lambda_u240 = objectArray = new ConstraintSet();
            boolean bl2 = false;
            $this$onDateRangeSelected_u24lambda_u241_u24lambda_u240.clone($this$onDateRangeSelected_u24lambda_u241.datesWrapper);
            Object[] constaints = objectArray;
            constaints.connect($this$onDateRangeSelected_u24lambda_u241.startDateLayout.getId(), 7, 0, 7);
            constaints.applyTo($this$onDateRangeSelected_u24lambda_u241.datesWrapper);
            $this$onDateRangeSelected_u24lambda_u241.startDateLayout.setImportantForAccessibility(2);
            objectArray = new Object[]{$this$onDateRangeSelected_u24lambda_u241.tvStartDate.getText(), $this$onDateRangeSelected_u24lambda_u241.tvStartDayOfWeek.getText()};
            $this$onDateRangeSelected_u24lambda_u241.startDateLayout.setContentDescription((CharSequence)context.getString(R.string.lp_datepicker_selected_date, objectArray));
            $this$onDateRangeSelected_u24lambda_u241.bottomWrapper.setContentDescription((CharSequence)String.valueOf($this$onDateRangeSelected_u24lambda_u241.startDateLayout.getContentDescription()));
        }
    }
}

