/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.lpdatepicker.utils;

import android.content.Context;
import android.os.Build;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\u0010\u0010\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\u001a\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"DAY_OF_WEEK_FORMAT", "", "DAY_OF_WEEK_TITLE_FORMAT", "MONTH_NAME_FORMAT", "getCalendarDate", "Ljava/util/Calendar;", "time", "", "getDateText", "calendar", "format", "context", "Landroid/content/Context;", "getDayOfWeek", "getDayOfWeekFullNameList", "", "(Landroid/content/Context;)[Ljava/lang/String;", "getDayOfWeekNameList", "", "getLocale", "Ljava/util/Locale;", "getMonthNameList", "getMonthRange", "minDate", "maxDate", "currentDate", "getMonthText", "getYearRange", "", "datepicker_release"})
public final class CalendarUtilsKt {
    @NotNull
    private static final String DAY_OF_WEEK_FORMAT = "EEEE";
    @NotNull
    private static final String DAY_OF_WEEK_TITLE_FORMAT = "EEEEE";
    @NotNull
    private static final String MONTH_NAME_FORMAT = "MMMM";

    @NotNull
    public static final String getDayOfWeek(@NotNull Calendar calendar, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SimpleDateFormat dateFormat = new SimpleDateFormat(DAY_OF_WEEK_FORMAT, CalendarUtilsKt.getLocale(context));
        String string2 = dateFormat.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(calendar.time)");
        return string2;
    }

    @NotNull
    public static final String getDateText(@NotNull Calendar calendar, @NotNull String format, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, CalendarUtilsKt.getLocale(context));
        String string2 = dateFormat.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(calendar.time)");
        return string2;
    }

    @NotNull
    public static final String getMonthText(@NotNull Calendar calendar, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SimpleDateFormat dateFormat = new SimpleDateFormat(MONTH_NAME_FORMAT, CalendarUtilsKt.getLocale(context));
        String string2 = dateFormat.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(calendar.time)");
        return string2;
    }

    @NotNull
    public static final Calendar getCalendarDate(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"calendar");
        return calendar;
    }

    @NotNull
    public static final List<String> getMonthRange(@NotNull Calendar minDate, @NotNull Calendar maxDate, @NotNull Calendar currentDate, @NotNull Context context) {
        int month;
        Intrinsics.checkNotNullParameter((Object)minDate, (String)"minDate");
        Intrinsics.checkNotNullParameter((Object)maxDate, (String)"maxDate");
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList<Integer> monthRange = new ArrayList<Integer>();
        if (minDate.get(1) == maxDate.get(1)) {
            month = minDate.get(2);
            while (month <= maxDate.get(2)) {
                monthRange.add(month++);
            }
        } else if (minDate.get(1) == currentDate.get(1)) {
            month = minDate.get(2);
            while (month <= 11) {
                monthRange.add(month++);
            }
        } else if (maxDate.get(1) == currentDate.get(1)) {
            month = 0;
            while (month <= maxDate.get(2)) {
                monthRange.add(month++);
            }
        } else {
            return CalendarUtilsKt.getMonthNameList(context);
        }
        ArrayList<String> monthNameRange = new ArrayList<String>();
        List<String> monthNames = CalendarUtilsKt.getMonthNameList(context);
        for (Integer i : monthRange) {
            Intrinsics.checkNotNullExpressionValue((Object)i, (String)"i");
            monthNameRange.add(monthNames.get(i));
        }
        return monthNameRange;
    }

    @NotNull
    public static final List<Integer> getYearRange(@NotNull Calendar minDate, @NotNull Calendar maxDate) {
        Intrinsics.checkNotNullParameter((Object)minDate, (String)"minDate");
        Intrinsics.checkNotNullParameter((Object)maxDate, (String)"maxDate");
        ArrayList<Integer> yearRange = new ArrayList<Integer>();
        int year = minDate.get(1);
        while (year <= maxDate.get(1)) {
            yearRange.add(year++);
        }
        return yearRange;
    }

    @NotNull
    public static final List<String> getMonthNameList(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List monthNames = new ArrayList();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 0);
        for (int i = 0; i < 12; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"calendar");
            monthNames.add(CalendarUtilsKt.getMonthText(calendar, context));
            calendar.add(2, 1);
        }
        return monthNames;
    }

    @NotNull
    public static final List<String> getDayOfWeekNameList(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List dayOfWeekNameList = new ArrayList();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DAY_OF_WEEK_TITLE_FORMAT, CalendarUtilsKt.getLocale(context));
        Integer[] integerArray = new Integer[]{1, 2, 3, 4, 5, 6, 7};
        Integer[] dayOfWeeks = integerArray;
        Calendar calendar = Calendar.getInstance();
        int n = dayOfWeeks.length;
        for (int i = 0; i < n; ++i) {
            int i2 = dayOfWeeks[i];
            calendar.set(7, i2);
            String string2 = dateFormat.format(calendar.getTime());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(calendar.time)");
            dayOfWeekNameList.add(string2);
        }
        return dayOfWeekNameList;
    }

    @NotNull
    public static final String[] getDayOfWeekFullNameList(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] stringArray = DateFormatSymbols.getInstance(CalendarUtilsKt.getLocale(context)).getWeekdays();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getInstance(getLocale(context)).weekdays");
        return stringArray;
    }

    @NotNull
    public static final Locale getLocale(@NotNull Context context) {
        Locale locale;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 24) {
            Locale locale2 = context.getResources().getConfiguration().getLocales().get(0);
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"{\n        context.resour\u2026tion.locales.get(0)\n    }");
        } else {
            Locale locale3 = context.getResources().getConfiguration().locale;
            locale = locale3;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"{\n        context.resour\u2026onfiguration.locale\n    }");
        }
        return locale;
    }
}

