package com.liveperson.api;

import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.api.sdk.LPConversationData;
import com.liveperson.infra.utils.LPDeprecated;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.model.AgentData;

/**
 * Created by shiranr on 09/09/2015.
 */
public interface LivePersonCallback {

    void onError(TaskType type, String message);
    void onTokenExpired();
    void onUnauthenticatedUserExpired();
    void onConversationStarted(LPConversationData convData);
    @Deprecated
    @LPDeprecated(since = 1493164800) // 26/04/2017
    void onConversationStarted();
    void onConversationResolved(LPConversationData convData);
    @Deprecated
    @LPDeprecated(since = 1486944000) // 13/02/2017
    void onConversationResolved();
    @Deprecated
    @LPDeprecated(since = 1493164800) // 26/04/2017
    void onConversationResolved(CloseReason reason);
    void onConversationFragmentClosed();
    void onConnectionChanged(boolean isConnected);
    void onAgentTyping(boolean isTyping);
    void onAgentDetailsChanged(AgentData agentData);
    void onCsatLaunched();
    void onCsatDismissed();
    void onCsatSubmitted(String conversationId);
	void onCsatSkipped();
	void onConversationMarkedAsUrgent();
    void onConversationMarkedAsNormal();
    void onOfflineHoursChanges(boolean isOfflineHoursOn);
    void onAgentAvatarTapped(AgentData agentData);
	void onUserDeniedPermission(PermissionType permissionType, boolean doNotShowAgainMarked);
	void onUserActionOnPreventedPermission(PermissionType permissionType);
	void onStructuredContentLinkClicked(String uri);

	class NullLivePersonCallback implements LivePersonCallback {

        @Override
        public void onError(TaskType type, String message) {}

        @Override
        public void onTokenExpired() {}

        @Override
        public void onUnauthenticatedUserExpired() {

        }

        @Override
        public void onConversationStarted(LPConversationData convData) {}

        @Override
        public void onConversationStarted() {}

        @Override
        public void onConversationResolved(LPConversationData convData) {}

        @Override
        public void onConversationResolved() {}

        @Override
        public void onConversationResolved(CloseReason reason) {}

        @Override
        public void onConversationFragmentClosed() {}

        @Override
        public void onConnectionChanged(boolean isConnected) {}

        @Override
        public void onAgentTyping(boolean isTyping) {}

        @Override
        public void onAgentDetailsChanged(AgentData agentData) {}

		@Override
		public void onCsatLaunched() {}

		@Override
        public void onCsatDismissed() {}

        @Override
        public void onCsatSubmitted(String conversationId) {}

		@Override
		public void onCsatSkipped() {}

		@Override
        public void onConversationMarkedAsUrgent() {}

        @Override
        public void onConversationMarkedAsNormal() {}

        @Override
        public void onOfflineHoursChanges(boolean isOfflineHoursOn) {}

        @Override
        public void onAgentAvatarTapped(AgentData agentData) {}

		@Override
		public void onUserDeniedPermission(PermissionType permissionType, boolean doNotShowAgainMarked) {}

		@Override
		public void onUserActionOnPreventedPermission(PermissionType permissionType) {}

		@Override
		public void onStructuredContentLinkClicked(String uri) {}
	}
}