package com.liveperson.api.request.message;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Maayan on 03/02/2017.
 */
public class FormSubmissionPublishMessage extends BasePublishMessage {
	public static final String INVITATION_ID = "invitationId";
	public static final String SUBMISSION_ID = "submissionId";

	private String mInvitationId;
	private String mSubmissionId;
	private JSONObject mJSONObject;

	public FormSubmissionPublishMessage(String invitationId, String submissionId) {
		mInvitationId = invitationId;
		mSubmissionId = submissionId;

		mJSONObject = new JSONObject();
		try {
			mJSONObject.put(INVITATION_ID, mInvitationId);
			mJSONObject.put(SUBMISSION_ID, mSubmissionId);
		} catch (JSONException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Build a PublishMessage from a JSONObject
	 *
	 * @param jsonObject
	 */
	public FormSubmissionPublishMessage(JSONObject jsonObject) {
		if (jsonObject != null) {
			mInvitationId = jsonObject.optString(INVITATION_ID);
			mSubmissionId = jsonObject.optString(SUBMISSION_ID);
			mJSONObject = jsonObject;
		}
	}

	@Override
	public JSONObject getMessage() {
		return mJSONObject;
	}

	public String getInvitationId() {return mInvitationId;}

	public String getmSubmissionId() {return mSubmissionId;}


	@Override
	public PublishMessageType getType() {
		return PublishMessageType.FORM_SUBMISSION;
	}

	public String getMessageText() {
		return getMessageTextWithoutSpecialChars(mJSONObject.toString());
	}
}
