package com.liveperson.api.response.model;

import android.text.TextUtils;

import com.liveperson.infra.log.LPMobileLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * Created by oferd on 8/10/15.
 */
public class Participants {
    public String[] CONSUMER = new String[]{};
    public String[] ASSIGNED_AGENT = new String[]{};
    public String[] MANAGER = new String[]{};
    public String[] READER = new String[]{};
    public String[] CONTROLLER = new String[]{};
    public String[] AGENTS = new String[]{};
    public String[] ALL_AGENTS = new String[]{};
    private String[] OTHER_AGENTS = new String[]{};

    public enum ParticipantRole {
        CONSUMER("CONSUMER"), ASSIGNED_AGENT("ASSIGNED_AGENT"), AGENT("AGENT"), MANAGER("MANAGER"), READER("READER"), CONTROLLER("CONTROLLER");
        private static final String TAG = ParticipantRole.class.getSimpleName();
        String participantType;
        ParticipantRole(String type){
            participantType = type;
        }

        public static ParticipantRole getParticipantRole(String role) {
            for (ParticipantRole pr: values()){
                if (pr.participantType.equalsIgnoreCase(role)){
                    return pr;
                }
            }

            LPMobileLog.e(TAG, "Unknown 'ParticipantRole' named: " + role);
            return null;
        }

        public static ParticipantRole parse(String participantRoleString) {
            ParticipantRole result = null;
            try {
                result = valueOf(participantRoleString);
            } catch (IllegalArgumentException e) {
                ParticipantRole[] values = values();
                for (ParticipantRole value : values) {
                    if (value.name().equalsIgnoreCase(participantRoleString)) {
                        result = value;
                        break;
                    }
                }
            }

            return result;
        }
    }

    public Participants(){}

    public void add(ArrayList<String> id, ParticipantRole role) {
        add(id.toArray(new String[]{}), role);
    }

    public void add(String[] id, ParticipantRole role) {
        switch (role){
            case READER:
                READER = id;
                break;
            case MANAGER:
                MANAGER = id;
                break;
            case CONSUMER:
                CONSUMER = id;
                break;
            case CONTROLLER:
                CONTROLLER = id;
                break;
            case ASSIGNED_AGENT:
                ASSIGNED_AGENT = id;
                break;
            case AGENT:
                AGENTS = id;
                break;
        }
        mergeAgents();
    }

    private void mergeAgents() {
        OTHER_AGENTS = new String[MANAGER.length + AGENTS.length + READER.length + CONTROLLER.length];
        System.arraycopy(MANAGER, 0, OTHER_AGENTS, 0, MANAGER.length);
        System.arraycopy(AGENTS, 0, OTHER_AGENTS, MANAGER.length, AGENTS.length);
        System.arraycopy(READER, 0, OTHER_AGENTS, MANAGER.length + AGENTS.length, READER.length);
        System.arraycopy(CONTROLLER, 0, OTHER_AGENTS, MANAGER.length + AGENTS.length + READER.length, CONTROLLER.length);

        ALL_AGENTS = new String[ASSIGNED_AGENT.length + OTHER_AGENTS.length];
        System.arraycopy(ASSIGNED_AGENT, 0, ALL_AGENTS, 0, ASSIGNED_AGENT.length);
        System.arraycopy(OTHER_AGENTS, 0, ALL_AGENTS, ASSIGNED_AGENT.length, OTHER_AGENTS.length);
    }

    /**
     * Extracts and returns all the participants IDs from all the IDs arrays
     * @return An array of strings that contains only IDsm without roles/
     */
    public String[] extractAllParticipantsIds() {
        HashSet<String> result = new HashSet<>();
        ArrayList<String[]> idsHolders = new ArrayList<>();
        idsHolders.add(CONSUMER);
        idsHolders.add(ASSIGNED_AGENT);
        idsHolders.add(AGENTS);
        idsHolders.add(MANAGER);
        idsHolders.add(READER);
        idsHolders.add(CONTROLLER);
        idsHolders.add(ALL_AGENTS);
        idsHolders.add(OTHER_AGENTS);

        for (String[] idsHolder : idsHolders) {
            for (String id : idsHolder) {
                if (!TextUtils.isEmpty(id)) {
                    result.add(id);
                }
            }
        }

        return result.toArray(new String[0]);
    }
}