package com.liveperson.messaging;

import com.liveperson.api.LivePersonCallback;
import com.liveperson.api.LivePersonIntents;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.api.sdk.LPConversationData;
import com.liveperson.infra.Infra;
import com.liveperson.messaging.model.AgentData;

/**
 * Created by shiranr on 6/28/17.
 */

public class LivePersonEventsProxy implements LivePersonCallback {

    private LivePersonCallback mCallback;

    LivePersonEventsProxy(){
        mCallback = new LivePersonCallback.NullLivePersonCallback();
    }


    public void setCallback(LivePersonCallback mCallback) {
        this.mCallback = mCallback;
    }

    public void removeCallback() {
        mCallback = new LivePersonCallback.NullLivePersonCallback();
    }

    ///////// EVENTS ////////////
    @Override
    public void onError(final TaskType type, final String message) {
        Infra.instance.getApplicationHandler().post(new Runnable() {
            @Override
            public void run() {
                mCallback.onError(type, message);
                LivePersonIntents.sendOnErrorIntent(Infra.instance.getApplicationContext(), type, message);
            }
        });
    }

    @Override
    public void onTokenExpired() {
        Infra.instance.postOnMainThread(new Runnable() {
            @Override
            public void run() {
                mCallback.onTokenExpired();
                LivePersonIntents.sendOnTokenExpired(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onUnauthenticatedUserExpired() {
        Infra.instance.postOnMainThread(new Runnable() {
            @Override
            public void run() {
                mCallback.onUnauthenticatedUserExpired();
                LivePersonIntents.sendOnUserExpired(Infra.instance.getApplicationContext());

            }
        });
    }

    @Override
    public void onConversationStarted(final LPConversationData convData) {

        Infra.instance.getApplicationHandler().post(new Runnable() {
            @Override
            public void run() {
                // Update the mCallback on new conversation
                mCallback.onConversationStarted();
                mCallback.onConversationStarted(convData);
                LivePersonIntents.sendOnConversationStarted(Infra.instance.getApplicationContext(), convData);
            }
        });
    }

    @Deprecated
    @Override
    public void onConversationStarted() {
        mCallback.onConversationStarted();
    }
    @Override
    public void onConversationResolved(final LPConversationData convData) {

        Infra.instance.postOnMainThread(new Runnable() {
            @Override
            public void run() {
                mCallback.onConversationResolved();
                mCallback.onConversationResolved(convData.getCloseReason());
                mCallback.onConversationResolved(convData);
                LivePersonIntents.sendOnConversationResolved(Infra.instance.getApplicationContext(), convData);
            }
        });

    }

    @Deprecated
    @Override
    public void onConversationResolved() {
        mCallback.onConversationResolved();
    }

    @Deprecated
    @Override
    public void onConversationResolved(CloseReason reason) {
        mCallback.onConversationResolved(reason);

    }

    @Override
    public void onConversationFragmentClosed() {
        Infra.instance.postOnMainThread(new Runnable() {
            @Override
            public void run() {
                mCallback.onConversationFragmentClosed();
                LivePersonIntents.sendOnConversationFragmentClosed(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onConnectionChanged(final boolean isConnected) {
        Infra.instance.postOnMainThread(new Runnable() {
            @Override
            public void run() {
                mCallback.onConnectionChanged(isConnected);
                LivePersonIntents.sendOnConnectionChanged(Infra.instance.getApplicationContext(), isConnected);
            }
        });
    }

    @Override
    public void onAgentTyping(final boolean isTyping) {
        Infra.instance.postOnMainThread(new Runnable() {
            @Override
            public void run() {
                mCallback.onAgentTyping(isTyping);
                LivePersonIntents.sendOnAgentTyping(Infra.instance.getApplicationContext(), isTyping);
            }
        });
    }

    @Override
    public void onAgentDetailsChanged(final AgentData agentData) {
        Infra.instance.postOnMainThread(
                new Runnable() {
                    @Override
                    public void run() {
                        mCallback.onAgentDetailsChanged(agentData);
                        LivePersonIntents.sendOnAgentDetailsChanged(Infra.instance.getApplicationContext(), agentData);

                    }
                });
    }

	@Override
	public void onCsatLaunched() {
		Infra.instance.postOnMainThread(
				new Runnable() {
					@Override
					public void run() {
						mCallback.onCsatLaunched();
						LivePersonIntents.sendOnCsatLaunched(Infra.instance.getApplicationContext());
					}
				});
	}

	@Override
    public void onCsatDismissed() {
        Infra.instance.postOnMainThread(
                new Runnable() {
                    @Override
                    public void run() {
                        mCallback.onCsatDismissed();
                        LivePersonIntents.sendOnCsatDismissed(Infra.instance.getApplicationContext());
                    }
                });
    }

    @Override
    public void onCsatSubmitted(final String conversationId) {
        Infra.instance.postOnMainThread(
                new Runnable() {
                    @Override
                    public void run() {
                        mCallback.onCsatSubmitted(conversationId);
                        LivePersonIntents.sendOnCsatSubmitted(Infra.instance.getApplicationContext(), conversationId);

                    }
                });
    }

	@Override
	public void onCsatSkipped() {
		Infra.instance.postOnMainThread(
				new Runnable() {
					@Override
					public void run() {
						mCallback.onCsatSkipped();
						LivePersonIntents.sendOnCsatSkipped(Infra.instance.getApplicationContext());
					}
				});
	}

	@Override
    public void onConversationMarkedAsUrgent() {
        Infra.instance.postOnMainThread(
                new Runnable() {
                    @Override
                    public void run() {
                        mCallback.onConversationMarkedAsUrgent();
                        LivePersonIntents.sendOnConversationMarkedAsUrgent(Infra.instance.getApplicationContext());

                    }
                });
    }

    @Override
    public void onConversationMarkedAsNormal() {
        Infra.instance.postOnMainThread(
                new Runnable() {
                    @Override
                    public void run() {
                        mCallback.onConversationMarkedAsNormal();
                        LivePersonIntents.sendOnConversationMarkedAsNormal(Infra.instance.getApplicationContext());

                    }
                });
    }

    @Override
    public void onOfflineHoursChanges(final boolean isOfflineHoursOn) {
        Infra.instance.postOnMainThread(new Runnable() {
            @Override
            public void run() {
                mCallback.onOfflineHoursChanges(isOfflineHoursOn);
                LivePersonIntents.sendOnOfflineHoursChanges(Infra.instance.getApplicationContext(), isOfflineHoursOn);
            }
        });
    }

    @Override
    public void onAgentAvatarTapped(final AgentData agentData) {
        Infra.instance.postOnMainThread(new Runnable() {
            @Override
            public void run() {
                mCallback.onAgentAvatarTapped(agentData);
                LivePersonIntents.sendOnAgentAvatarTapped(Infra.instance.getApplicationContext(), agentData);
            }
        });
    }

	@Override
	public void onUserDeniedPermission(final PermissionType permissionType, final boolean doNotShowAgainMarked) {
		Infra.instance.postOnMainThread(new Runnable() {
			@Override
			public void run() {
				mCallback.onUserDeniedPermission(permissionType, doNotShowAgainMarked);
				LivePersonIntents.sendOnUserDeniedPermission(Infra.instance.getApplicationContext(), permissionType, doNotShowAgainMarked);
			}
		});
	}

	@Override
	public void onUserActionOnPreventedPermission(final PermissionType permissionType) {
		Infra.instance.postOnMainThread(new Runnable() {
			@Override
			public void run() {
				mCallback.onUserActionOnPreventedPermission(permissionType);
				LivePersonIntents.sendOnUserActionOnPreventedPermission(Infra.instance.getApplicationContext(), permissionType);
			}
		});
	}

	@Override
	public void onStructuredContentLinkClicked(final String uri) {
		Infra.instance.postOnMainThread(new Runnable() {
			@Override
			public void run() {
				mCallback.onStructuredContentLinkClicked(uri);
				LivePersonIntents.sendOnStructuredContentLinkClicked(Infra.instance.getApplicationContext(), uri);
			}
		});
	}
}
