package com.liveperson.messaging.background.filesharing.voice;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.ReUploadFileTaskBundle;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.background.filesharing.image.ReUploadImageTaskBundle;
import com.liveperson.messaging.commands.ReSendImageCommand;
import com.liveperson.messaging.commands.ReSendVoiceCommand;
import com.liveperson.messaging.exception.FileSharingException;

public class ReUploadVoiceTask extends UploadVoiceTask {

	public static final String TAG = "ReUploadVoiceTask";

	public ReUploadVoiceTask(ReUploadFileTaskBundle params, Integer uploadTimeout) throws FileSharingException {

		super(params, uploadTimeout);

		mFileRowId = params.getFileRowId();

	}

	protected void createSendMessageCommand(String thumbnailPath, String filePath)  {

		sendMessageCommand = new ReSendVoiceCommand(MessagingFactory.getInstance().getController(),
				mUploadFileTaskBundle.getTargetId(),
				mUploadFileTaskBundle.getBrandId(),
				mUploadFileTaskBundle.getFileContentType(),
				thumbnailPath,
				filePath,
				mUploadFileTaskBundle.getFileTypeExtension(),
				mUploadFileTaskBundle.getMessage(),
				((ReUploadFileTaskBundle) mUploadFileTaskBundle).getFileRowId(),
				((ReUploadFileTaskBundle) mUploadFileTaskBundle).getOriginalMessageTime(),
				mPreviewContentType,
				((ReUploadFileTaskBundle) mUploadFileTaskBundle).getEventId());

		setSendMessageCommandCallback();
	}

}
