package com.liveperson.messaging.background.filesharing.voice;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.LPAudioUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.BaseUploadTask;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.commands.SendVoiceCommand;
import com.liveperson.messaging.exception.FileSharingException;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import static com.liveperson.infra.utils.Utils.getResources;

public class UploadVoiceTask extends BaseUploadTask{

	public static final String TAG = "UploadVoiceTask";

	protected UploadFileTaskBundle mUploadFileTaskBundle;

	private String mPreviewBasee64;
	protected String mPreviewContentType;

	public UploadVoiceTask(UploadFileTaskBundle params, Integer uploadTimeout) throws FileSharingException{

		super(uploadTimeout);

		if(params == null){
			throw new FileSharingException("Params is null");
		}

		mUploadFileTaskBundle = params;

		// Get byte array of the voice file
		File file = new File(mUploadFileTaskBundle.getFilePath());
		if (file == null) {
			throw new FileSharingException("File path is null");
		}
		int size = (int) file.length();
		byte[] bytes = new byte[size];

		try {
			BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
			buf.read(bytes, 0, bytes.length);
			buf.close();
			mOriginalFileByteArray = bytes;
		} catch (IOException e) {
			LPMobileLog.e(TAG, "UploadVoiceTask: cannot extract file byteArray. Aborting upload file");
			return;
		}

		generatePreviewImage();

		createSendMessageCommand(createThumbnail(), params.getFilePath());
	}

/* Getting the duration of the file was canceled for this version. This code is left here for reference and future use

	public void sendPublishFile(final boolean sendViaRest) {
		LPMobileLog.d(TAG + Thread.currentThread(), "sending PublishFile request..");

		// Before sending the message, we get the duration of the voice file and add it as the message caption.
		// If failed to get the duration we set 0 duration as the caption
		LPAudioUtils.getDuration(mUploadFileTaskBundle.getFilePath(), new ICallback<Integer, Exception>() {
			@Override
			public void onSuccess(Integer durationMs) {

				LPMobileLog.d(TAG, "onSuccess: set duration " + durationMs + " ms in the message caption");
				((SendVoiceCommand)sendMessageCommand).setDurationAsCaption(durationMs);
				sendMessageCommand.setFileDetails(mRelativePath, getUploadTaskBundle().getFileTypeExtension(), getThumbnailBase64());
				sendMessageCommand.setSendViaRest(sendViaRest, getUploadTaskBundle().getRestParams());
				sendMessageCommand.execute();

			}

			@Override
			public void onError(Exception exception) {
				LPMobileLog.d(TAG, "onError: failed to get voice file duration. Set 0.");
				((SendVoiceCommand)sendMessageCommand).setDurationAsCaption(0);
				sendMessageCommand.setFileDetails(mRelativePath, getUploadTaskBundle().getFileTypeExtension(), getThumbnailBase64());
				sendMessageCommand.setSendViaRest(sendViaRest, getUploadTaskBundle().getRestParams());
				sendMessageCommand.execute();

			}
		});
	}
*/


	protected void createSendMessageCommand(String thumbnailPath, String filePath) {
		sendMessageCommand = new SendVoiceCommand(MessagingFactory.getInstance().getController(), mUploadFileTaskBundle.getTargetId(), mUploadFileTaskBundle.getBrandId(),
				mUploadFileTaskBundle.getFileContentType(), thumbnailPath, filePath, mUploadFileTaskBundle.getFileTypeExtension(), mUploadFileTaskBundle.getMessage(), mPreviewContentType);

		setSendMessageCommandCallback();
	}

	private void generatePreviewImage() {

		Bitmap bitmap = BitmapFactory.decodeResource(getResources(), R.drawable.lp_messaging_dummy_file_thumbnal);
		mPreviewBasee64 = ImageUtils.bitmapToBase64(bitmap);

		mPreviewContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension("png");
	}

	private String createThumbnail() {
		// No need for thumbnail in voice. Only base64
		return null;
	}

	@Override
	protected UploadFileTaskBundle getUploadTaskBundle() {

		return mUploadFileTaskBundle;
	}

	@Override
	protected byte[] getFileByteArray() {
		return mOriginalFileByteArray;
	}

	@Override
	public int getTaskId() {
		return mUploadFileTaskBundle.getTaskId();
	}

	@Override
	public String getThumbnailBase64() {

		return mPreviewBasee64;
	}
}
