package com.liveperson.messaging.commands;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;

/**
 * Created by nirni on 12/28/15.
 * <p/>
 * This command derives from SendMessageRequest and implement the sendMessage() method.
 * It differs from the SendMessageRequest by that it will not set the message to the amsMessage but
 * update the existing message state to PENDING
 */
public class ResendMessageCommand extends SendMessageCommand {

    private static final String TAG = "ResendMessageCommand";

    public ResendMessageCommand(Messaging controller, String eventId, String targetId, String brandId, MaskedMessage message) {
        super(controller, targetId, brandId, message);
        mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, final MaskedMessage message) {
        sendMessageIfDialogIsOpen();
    }
}
