package com.liveperson.messaging.commands;

import com.liveperson.infra.Command;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.network.socket.requests.CsatRequest;

/**
 * Created by shiranr on 18/11/2015.
 */
public class SendCsatCommand implements Command {

    private static final String TAG = SendCsatCommand.class.getSimpleName();
    private String mConversationID;
    private int mRate;
    private int mYesNoValue;
    private String mSocketUrl;

    public SendCsatCommand(String socketUrl, String conversationID, int rate, int yesNoValue) {
        mSocketUrl = socketUrl;
        mConversationID = conversationID;
        mRate = rate;
        mYesNoValue = yesNoValue;
    }

    @Override
    public void execute() {
        CsatRequest baseSocketRequest = new CsatRequest(mSocketUrl, mConversationID, mRate, mYesNoValue);
        SocketManager.getInstance().send(baseSocketRequest);
    }
}
