package com.liveperson.messaging.commands.tasks;

import android.content.Context;

import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.AmsConnectionAnalytics;

/**
 * Created by nirni on 12/15/16.
 * A task to remove older images from storage
 */

public class RemoveOlderImagesTask extends BaseAmsAccountConnectionTask {

	public static final String TAG = "RemoveOlderImagesTask";

	private Context mContext;
	private String mTargetId;
	private String mBrandId;

	public RemoveOlderImagesTask(Context context, String targetId, String brandId) {
		mContext = context;
		mTargetId = targetId;
		mBrandId = brandId;
	}

	@Override
	public void execute() {

		AmsConnectionAnalytics.removeOlderImagesTaskStart();
		MessagingFactory.getInstance().getController().removeMultipleOlderImages(mContext, mTargetId, mBrandId);

		AmsConnectionAnalytics.removeOlderImagesTaskEnd();
		mCallback.onTaskSuccess();
	}

	@Override
	public String getName() {
		return TAG;
	}
}
