package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;

import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.BaseGenerateURL;
import com.liveperson.api.response.IOnUrlReady;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * A request to generate url
 */
public abstract class BaseGetUrlRequest extends BaseAMSSocketRequest<BaseGenerateURL.Response, BaseGetUrlRequest> {

    private static final String TAG = BaseGetUrlRequest.class.getSimpleName();
    private IOnUrlReady mListener;

    /**
     * This constructor creates a SendMessageRequest with the next requestID (auto incremented)
     *
     * @param brandId
     */
    public BaseGetUrlRequest(Messaging controller, String brandId, IOnUrlReady listener) {
        super(controller.mAccountsController.getConnectionUrl(brandId));

        mListener = listener;
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler<BaseGenerateURL.Response, BaseGetUrlRequest> getResponseHandler() {
        return new BaseResponseHandler<BaseGenerateURL.Response, BaseGetUrlRequest>() {
            @Override
            protected BaseGenerateURL.Response parse(JSONObject jsonObject) throws JSONException {
                return new BaseGenerateURL.Response(jsonObject);
            }

            @Override
            public BaseResponseHandler getResponseByExpectedType(String expectedType) {
                BaseResponseHandler supportedResponseHandler = getSupportedResponseHandler(expectedType);
                if (supportedResponseHandler != null){
                    return supportedResponseHandler;
                }
                return this;
            }

            @Override
            protected BaseResponseHandler getSupportedResponseHandler(String messageType) {
                if (TextUtils.equals(messageType, ReqBody.StringResp.REQ_BODY_RESPONSE_TYPE)){
                    return new BaseResponseHandler<ReqBody.StringResp, NewConversationRequest>() {

                        @Override
                        public String getAPIResponseType() {
                            return ReqBody.StringResp.REQ_BODY_RESPONSE_TYPE;
                        }

                        @Override
                        protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                            return new ReqBody.StringResp(jsonObject);
                        }

                        @Override
                        protected boolean handle(ReqBody.StringResp response) {
                            LPMobileLog.d(TAG, "Received String response (" + response.code + ").");
                            mListener.onUrlError("response code: " + response.code + " error: " + response.getBody());
                            return true;

                        }
                    };
                }
                return super.getSupportedResponseHandler(messageType);
            }

            @Override
            protected boolean handle(BaseGenerateURL.Response response) {
                if (response.getBody().relativePath == null){
                    mListener.onUrlError("No relative path returned!!");
                }else {
                    mListener.onUrlReady(response.getBody());
                }
                return true;
            }

			@Override
			public String getAPIResponseType() {
				return BaseGenerateURL.Response.BASE_GENERATE_URL_RESPONSE_TYPE;
			}

			@Override
            protected void giveUp() {
                super.giveUp();
                String errorMessage = getRequestId() + ": Request lost (socket closed) for get url.";
                mListener.onUrlError(errorMessage);
                LPMobileLog.i(TAG, errorMessage);
            }
        };
    }
}