/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class UserProfile {
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String NICKNAME = "nickname";
    public static final String USER_ID = "userId";
    public static final String AVATAR_URL = "avatarUrl";
    public static final String ROLE = "role";
    public static final String BACKGND_IMG_URI = "backgndImgUri";
    public static final String DESCRIPTION = "description";
    public static final String PRIVATE_DATA = "privateData";
    public static final String SERVICE_NAME = "serviceName";
    public static final String CERT_NAME = "certName";
    public static final String TOKEN = "token";
    public static final String MAIL = "mail";
    public static final String PUSH_NOTIFICATION_DATA = "pushNotificationData";
    public static final String MOBILE_NUM = "mobileNum";
    private String firstName;
    private String lastName;
    private String nickname;
    private UserType userType;
    private long localId;
    private String originatorId;
    private String avatarUrl;
    private String role;
    private String backgndImgUri;
    private String description;
    private long requestId;
    private PrivateData privateData;

    public UserProfile(String firstName, String lastName, UserType type) {
        this.setFirstName(firstName);
        this.setLastName(lastName);
        this.setUserType(type);
        this.setPrivateData(new PrivateData("", ""));
    }

    public UserProfile(JSONObject src) throws JSONException {
        this.setOriginatorID(src.getString(USER_ID));
        if (TextUtils.isEmpty((CharSequence)this.originatorId)) {
            throw new JSONException("no originator id");
        }
        this.setFirstName(src.getString(FIRST_NAME));
        this.setLastName(src.getString(LAST_NAME));
        this.setAvatarUrl(src.getString(AVATAR_URL));
        this.setRole(src.getString(ROLE));
        this.setBackgndImgUri(src.getString(BACKGND_IMG_URI));
        this.setDescription(src.getString(DESCRIPTION));
        if (!src.isNull(PRIVATE_DATA)) {
            this.setPrivateData(new PrivateData(src.getJSONObject(PRIVATE_DATA)));
        }
    }

    public void addToJson(JSONObject json) throws JSONException {
        json.put(FIRST_NAME, (Object)this.firstName);
        json.put(LAST_NAME, (Object)this.lastName);
        json.put(USER_ID, (Object)this.originatorId);
        json.put(AVATAR_URL, (Object)this.avatarUrl);
        json.put(ROLE, (Object)this.role);
        json.put(BACKGND_IMG_URI, (Object)this.backgndImgUri);
        json.put(DESCRIPTION, (Object)this.description);
        JSONObject privateDataJson = new JSONObject();
        this.privateData.addToJson(privateDataJson);
        json.put(PRIVATE_DATA, (Object)privateDataJson);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getOriginatorId() {
        return this.originatorId;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        if (TextUtils.isEmpty((CharSequence)avatarUrl) || avatarUrl.equalsIgnoreCase("null")) {
            avatarUrl = "";
        }
        this.avatarUrl = avatarUrl;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getBackgndImgUri() {
        return this.backgndImgUri;
    }

    public void setBackgndImgUri(String backgndImgUri) {
        if (TextUtils.isEmpty((CharSequence)backgndImgUri) || backgndImgUri.equalsIgnoreCase("null")) {
            backgndImgUri = "";
        }
        this.backgndImgUri = backgndImgUri;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PrivateData getPrivateData() {
        return this.privateData;
    }

    public void setPrivateData(PrivateData privateData) {
        this.privateData = privateData;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType type) {
        this.userType = type;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    public long getLocalId() {
        return this.localId;
    }

    public void setLocalId(long id) {
        this.localId = id;
    }

    public String getFullName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    public String getEmail() {
        return this.privateData.mail;
    }

    public void setEmail(String email) {
        this.privateData.mail = email;
    }

    public void setMobileNumber(String mobileNumber) {
        this.privateData.mobileNum = mobileNumber;
    }

    public void setOriginatorID(String originatorId) {
        this.originatorId = originatorId;
    }

    public static class PrivateData {
        public String mobileNum = "";
        public String mail = "";

        public PrivateData(String mobileNum, String mail) {
            this.mobileNum = mobileNum;
            this.mail = mail;
        }

        public PrivateData(JSONObject src) throws JSONException {
            this.mobileNum = src.getString(UserProfile.MOBILE_NUM);
            this.mail = src.getString(UserProfile.MAIL);
        }

        public void addToJson(JSONObject json) throws JSONException {
            json.put(UserProfile.MOBILE_NUM, TextUtils.isEmpty((CharSequence)this.mobileNum) ? JSONObject.NULL : this.mobileNum);
            json.put(UserProfile.MAIL, TextUtils.isEmpty((CharSequence)this.mail) ? JSONObject.NULL : this.mail);
            json.put(UserProfile.PUSH_NOTIFICATION_DATA, JSONObject.NULL);
        }
    }

    public static class PushNotificationData {
        public String serviceName = "";
        public String certName = "";
        public String token = "";

        public PushNotificationData(String serviceName, String certName, String token) {
            this.serviceName = serviceName;
            this.certName = certName;
            this.token = token;
        }

        public PushNotificationData(JSONObject src) throws JSONException {
            this.serviceName = src.getString(UserProfile.SERVICE_NAME);
            this.certName = src.getString(UserProfile.CERT_NAME);
            this.token = src.getString(UserProfile.TOKEN);
        }

        public void addToJson(JSONObject json) throws JSONException {
            json.put(UserProfile.SERVICE_NAME, (Object)this.serviceName);
            json.put(UserProfile.CERT_NAME, (Object)this.certName);
            json.put(UserProfile.TOKEN, (Object)this.token);
        }
    }

    public static enum UserType {
        CONSUMER,
        AGENT,
        CONTROLLER;

    }
}

