/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing.voice;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.Utils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.BaseUploadTask;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.commands.SendVoiceCommand;
import com.liveperson.messaging.exception.FileSharingException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class UploadVoiceTask
extends BaseUploadTask {
    public static final String TAG = "UploadVoiceTask";
    protected UploadFileTaskBundle mUploadFileTaskBundle;
    private String mPreviewBasee64;
    protected String mPreviewContentType;

    public UploadVoiceTask(UploadFileTaskBundle params, Integer uploadTimeout) throws FileSharingException {
        super(uploadTimeout);
        if (params == null) {
            throw new FileSharingException("Params is null");
        }
        this.mUploadFileTaskBundle = params;
        File file = new File(this.mUploadFileTaskBundle.getFilePath());
        if (file == null) {
            throw new FileSharingException("File path is null");
        }
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        try {
            BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
            buf.read(bytes, 0, bytes.length);
            buf.close();
            this.mOriginalFileByteArray = bytes;
        }
        catch (IOException e) {
            LPMobileLog.e((String)TAG, (String)"UploadVoiceTask: cannot extract file byteArray. Aborting upload file");
            return;
        }
        this.generatePreviewImage();
        this.createSendMessageCommand(this.createThumbnail(), params.getFilePath());
    }

    protected void createSendMessageCommand(String thumbnailPath, String filePath) {
        this.sendMessageCommand = new SendVoiceCommand(MessagingFactory.getInstance().getController(), this.mUploadFileTaskBundle.getTargetId(), this.mUploadFileTaskBundle.getBrandId(), this.mUploadFileTaskBundle.getFileContentType(), thumbnailPath, filePath, this.mUploadFileTaskBundle.getFileTypeExtension(), this.mUploadFileTaskBundle.getMessage(), this.mPreviewContentType);
        this.setSendMessageCommandCallback();
    }

    private void generatePreviewImage() {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)Utils.getResources(), (int)R.drawable.lp_messaging_dummy_file_thumbnal);
        this.mPreviewBasee64 = ImageUtils.bitmapToBase64((Bitmap)bitmap);
        this.mPreviewContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension("png");
    }

    private String createThumbnail() {
        return null;
    }

    @Override
    protected UploadFileTaskBundle getUploadTaskBundle() {
        return this.mUploadFileTaskBundle;
    }

    @Override
    protected byte[] getFileByteArray() {
        return this.mOriginalFileByteArray;
    }

    @Override
    public int getTaskId() {
        return this.mUploadFileTaskBundle.getTaskId();
    }

    @Override
    public String getThumbnailBase64() {
        return this.mPreviewBasee64;
    }
}

